package software.amazon.awscdk.services.ec2;
/**
 * Specify configuration parameters for a VPC to be built
 */
public interface SubnetConfiguration extends software.amazon.jsii.JsiiSerializable {
    /**
     * The CIDR Mask or the number of leading 1 bits in the routing mask
     * 
     * Valid values are 16 - 28
     */
    java.lang.Number getCidrMask();
    /**
     * The CIDR Mask or the number of leading 1 bits in the routing mask
     * 
     * Valid values are 16 - 28
     */
    void setCidrMask(final java.lang.Number value);
    /**
     * The type of Subnet to configure.
     * 
     * The Subnet type will control the ability to route and connect to the
     * Internet.
     */
    software.amazon.awscdk.services.ec2.SubnetType getSubnetType();
    /**
     * The type of Subnet to configure.
     * 
     * The Subnet type will control the ability to route and connect to the
     * Internet.
     */
    void setSubnetType(final software.amazon.awscdk.services.ec2.SubnetType value);
    /**
     * The common Logical Name for the `VpcSubnet`
     * 
     * Thi name will be suffixed with an integer correlating to a specific
     * availability zone.
     */
    java.lang.String getName();
    /**
     * The common Logical Name for the `VpcSubnet`
     * 
     * Thi name will be suffixed with an integer correlating to a specific
     * availability zone.
     */
    void setName(final java.lang.String value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link SubnetConfiguration}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * The type of Subnet to configure.
         * 
         * The Subnet type will control the ability to route and connect to the
         * Internet.
         */
        public NameStep withSubnetType(final software.amazon.awscdk.services.ec2.SubnetType value) {
            return new FullBuilder().withSubnetType(value);
        }

        public interface NameStep {
            /**
             * The common Logical Name for the `VpcSubnet`
             * 
             * Thi name will be suffixed with an integer correlating to a specific
             * availability zone.
             */
            Build withName(final java.lang.String value);
        }

        public interface Build {
            /**
             * @return a new {@link SubnetConfiguration} object, initialized with the values set on this builder.
             */
            SubnetConfiguration build();
            /**
             * The CIDR Mask or the number of leading 1 bits in the routing mask
             * 
             * Valid values are 16 - 28
             */
            Build withCidrMask(final java.lang.Number value);
        }

        final class FullBuilder implements NameStep, Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * The CIDR Mask or the number of leading 1 bits in the routing mask
             * 
             * Valid values are 16 - 28
             */
            public Build withCidrMask(final java.lang.Number value) {
                this.instance._cidrMask = value;
                return this;
            }
            /**
             * The type of Subnet to configure.
             * 
             * The Subnet type will control the ability to route and connect to the
             * Internet.
             */
            public NameStep withSubnetType(final software.amazon.awscdk.services.ec2.SubnetType value) {
                java.util.Objects.requireNonNull(value, "SubnetConfiguration#subnetType is required");
                this.instance._subnetType = value;
                return this;
            }
            /**
             * The common Logical Name for the `VpcSubnet`
             * 
             * Thi name will be suffixed with an integer correlating to a specific
             * availability zone.
             */
            public Build withName(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "SubnetConfiguration#name is required");
                this.instance._name = value;
                return this;
            }
            public SubnetConfiguration build() {
                SubnetConfiguration result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link SubnetConfiguration}.
     */
    final class Jsii$Pojo implements SubnetConfiguration {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Number _cidrMask;

        public java.lang.Number getCidrMask() {
            return this._cidrMask;
        }
        public void setCidrMask(final java.lang.Number value) {
            this._cidrMask = value;
        }

        protected software.amazon.awscdk.services.ec2.SubnetType _subnetType;

        public software.amazon.awscdk.services.ec2.SubnetType getSubnetType() {
            return this._subnetType;
        }
        public void setSubnetType(final software.amazon.awscdk.services.ec2.SubnetType value) {
            this._subnetType = value;
        }

        protected java.lang.String _name;

        public java.lang.String getName() {
            return this._name;
        }
        public void setName(final java.lang.String value) {
            this._name = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.SubnetConfiguration {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * The CIDR Mask or the number of leading 1 bits in the routing mask
         * 
         * Valid values are 16 - 28
         */
        @javax.annotation.Nullable
        public java.lang.Number getCidrMask() {
            return this.jsiiGet("cidrMask", java.lang.Number.class);
        }
        /**
         * The CIDR Mask or the number of leading 1 bits in the routing mask
         * 
         * Valid values are 16 - 28
         */
        public void setCidrMask(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("cidrMask", value);
        }
        /**
         * The type of Subnet to configure.
         * 
         * The Subnet type will control the ability to route and connect to the
         * Internet.
         */
        public software.amazon.awscdk.services.ec2.SubnetType getSubnetType() {
            return this.jsiiGet("subnetType", software.amazon.awscdk.services.ec2.SubnetType.class);
        }
        /**
         * The type of Subnet to configure.
         * 
         * The Subnet type will control the ability to route and connect to the
         * Internet.
         */
        public void setSubnetType(final software.amazon.awscdk.services.ec2.SubnetType value) {
            this.jsiiSet("subnetType", java.util.Objects.requireNonNull(value, "subnetType is required"));
        }
        /**
         * The common Logical Name for the `VpcSubnet`
         * 
         * Thi name will be suffixed with an integer correlating to a specific
         * availability zone.
         */
        public java.lang.String getName() {
            return this.jsiiGet("name", java.lang.String.class);
        }
        /**
         * The common Logical Name for the `VpcSubnet`
         * 
         * Thi name will be suffixed with an integer correlating to a specific
         * availability zone.
         */
        public void setName(final java.lang.String value) {
            this.jsiiSet("name", java.util.Objects.requireNonNull(value, "name is required"));
        }
    }
}
