package software.amazon.awscdk.services.ec2;
/**
 * Customize how instances are placed inside a VPC
 * 
 * Constructs that allow customization of VPC placement use parameters of this
 * type to provide placement settings.
 */
public interface VpcPlacementStrategy extends software.amazon.jsii.JsiiSerializable {
    /**
     * Whether to use the VPC's public subnets to start instances
     * 
     * If false, the instances are started in the private subnets.
     * @default false
     */
    java.lang.Boolean getUsePublicSubnets();
    /**
     * Whether to use the VPC's public subnets to start instances
     * 
     * If false, the instances are started in the private subnets.
     * @default false
     */
    void setUsePublicSubnets(final java.lang.Boolean value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }

    /**
     * A fluent builder class for {@link VpcPlacementStrategy}.
     */
    public static final class Builder {
        private Jsii$Pojo instance = new Jsii$Pojo();

        /**
         * Whether to use the VPC's public subnets to start instances
         * 
         * If false, the instances are started in the private subnets.
         * @default false
         */
        public Builder withUsePublicSubnets(final java.lang.Boolean value) {
            this.instance._usePublicSubnets = value;
            return this;
        }
        public VpcPlacementStrategy build() {
            VpcPlacementStrategy result = this.instance;
            this.instance = new Jsii$Pojo();
            return result;
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link VpcPlacementStrategy}.
     */
    final class Jsii$Pojo implements VpcPlacementStrategy {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Boolean _usePublicSubnets;

        public java.lang.Boolean getUsePublicSubnets() {
            return this._usePublicSubnets;
        }
        public void setUsePublicSubnets(final java.lang.Boolean value) {
            this._usePublicSubnets = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.VpcPlacementStrategy {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * Whether to use the VPC's public subnets to start instances
         * 
         * If false, the instances are started in the private subnets.
         * @default false
         */
        @javax.annotation.Nullable
        public java.lang.Boolean getUsePublicSubnets() {
            return this.jsiiGet("usePublicSubnets", java.lang.Boolean.class);
        }
        /**
         * Whether to use the VPC's public subnets to start instances
         * 
         * If false, the instances are started in the private subnets.
         * @default false
         */
        public void setUsePublicSubnets(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("usePublicSubnets", value);
        }
    }
}
