package software.amazon.awscdk.services.ec2;
/**
 * Specify configuration parameters for a VPC subnet
 */
public interface VpcSubnetProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The availability zone for the subnet
     */
    java.lang.String getAvailabilityZone();
    /**
     * The availability zone for the subnet
     */
    void setAvailabilityZone(final java.lang.String value);
    /**
     * The VPC which this subnet is part of
     */
    software.amazon.awscdk.Token getVpcId();
    /**
     * The VPC which this subnet is part of
     */
    void setVpcId(final software.amazon.awscdk.Token value);
    /**
     * The CIDR notation for this subnet
     */
    java.lang.String getCidrBlock();
    /**
     * The CIDR notation for this subnet
     */
    void setCidrBlock(final java.lang.String value);
    /**
     * Controls if a public IP is associated to an instance at launch
     * 
     * Defaults to true in Subnet.Public, false in Subnet.Private or Subnet.Isolated.
     */
    java.lang.Boolean getMapPublicIpOnLaunch();
    /**
     * Controls if a public IP is associated to an instance at launch
     * 
     * Defaults to true in Subnet.Public, false in Subnet.Private or Subnet.Isolated.
     */
    void setMapPublicIpOnLaunch(final java.lang.Boolean value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link VpcSubnetProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * The availability zone for the subnet
         */
        public VpcIdStep withAvailabilityZone(final java.lang.String value) {
            return new FullBuilder().withAvailabilityZone(value);
        }

        public interface VpcIdStep {
            /**
             * The VPC which this subnet is part of
             */
            CidrBlockStep withVpcId(final software.amazon.awscdk.Token value);
        }

        public interface CidrBlockStep {
            /**
             * The CIDR notation for this subnet
             */
            Build withCidrBlock(final java.lang.String value);
        }

        public interface Build {
            /**
             * @return a new {@link VpcSubnetProps} object, initialized with the values set on this builder.
             */
            VpcSubnetProps build();
            /**
             * Controls if a public IP is associated to an instance at launch
             * 
             * Defaults to true in Subnet.Public, false in Subnet.Private or Subnet.Isolated.
             */
            Build withMapPublicIpOnLaunch(final java.lang.Boolean value);
        }

        final class FullBuilder implements VpcIdStep, CidrBlockStep, Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * The availability zone for the subnet
             */
            public VpcIdStep withAvailabilityZone(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "VpcSubnetProps#availabilityZone is required");
                this.instance._availabilityZone = value;
                return this;
            }
            /**
             * The VPC which this subnet is part of
             */
            public CidrBlockStep withVpcId(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "VpcSubnetProps#vpcId is required");
                this.instance._vpcId = value;
                return this;
            }
            /**
             * The CIDR notation for this subnet
             */
            public Build withCidrBlock(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "VpcSubnetProps#cidrBlock is required");
                this.instance._cidrBlock = value;
                return this;
            }
            /**
             * Controls if a public IP is associated to an instance at launch
             * 
             * Defaults to true in Subnet.Public, false in Subnet.Private or Subnet.Isolated.
             */
            public Build withMapPublicIpOnLaunch(final java.lang.Boolean value) {
                this.instance._mapPublicIpOnLaunch = value;
                return this;
            }
            public VpcSubnetProps build() {
                VpcSubnetProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link VpcSubnetProps}.
     */
    final class Jsii$Pojo implements VpcSubnetProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.String _availabilityZone;

        public java.lang.String getAvailabilityZone() {
            return this._availabilityZone;
        }
        public void setAvailabilityZone(final java.lang.String value) {
            this._availabilityZone = value;
        }

        protected software.amazon.awscdk.Token _vpcId;

        public software.amazon.awscdk.Token getVpcId() {
            return this._vpcId;
        }
        public void setVpcId(final software.amazon.awscdk.Token value) {
            this._vpcId = value;
        }

        protected java.lang.String _cidrBlock;

        public java.lang.String getCidrBlock() {
            return this._cidrBlock;
        }
        public void setCidrBlock(final java.lang.String value) {
            this._cidrBlock = value;
        }

        protected java.lang.Boolean _mapPublicIpOnLaunch;

        public java.lang.Boolean getMapPublicIpOnLaunch() {
            return this._mapPublicIpOnLaunch;
        }
        public void setMapPublicIpOnLaunch(final java.lang.Boolean value) {
            this._mapPublicIpOnLaunch = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.VpcSubnetProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * The availability zone for the subnet
         */
        public java.lang.String getAvailabilityZone() {
            return this.jsiiGet("availabilityZone", java.lang.String.class);
        }
        /**
         * The availability zone for the subnet
         */
        public void setAvailabilityZone(final java.lang.String value) {
            this.jsiiSet("availabilityZone", java.util.Objects.requireNonNull(value, "availabilityZone is required"));
        }
        /**
         * The VPC which this subnet is part of
         */
        public software.amazon.awscdk.Token getVpcId() {
            return this.jsiiGet("vpcId", software.amazon.awscdk.Token.class);
        }
        /**
         * The VPC which this subnet is part of
         */
        public void setVpcId(final software.amazon.awscdk.Token value) {
            this.jsiiSet("vpcId", java.util.Objects.requireNonNull(value, "vpcId is required"));
        }
        /**
         * The CIDR notation for this subnet
         */
        public java.lang.String getCidrBlock() {
            return this.jsiiGet("cidrBlock", java.lang.String.class);
        }
        /**
         * The CIDR notation for this subnet
         */
        public void setCidrBlock(final java.lang.String value) {
            this.jsiiSet("cidrBlock", java.util.Objects.requireNonNull(value, "cidrBlock is required"));
        }
        /**
         * Controls if a public IP is associated to an instance at launch
         * 
         * Defaults to true in Subnet.Public, false in Subnet.Private or Subnet.Isolated.
         */
        @javax.annotation.Nullable
        public java.lang.Boolean getMapPublicIpOnLaunch() {
            return this.jsiiGet("mapPublicIpOnLaunch", java.lang.Boolean.class);
        }
        /**
         * Controls if a public IP is associated to an instance at launch
         * 
         * Defaults to true in Subnet.Public, false in Subnet.Private or Subnet.Isolated.
         */
        public void setMapPublicIpOnLaunch(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("mapPublicIpOnLaunch", value);
        }
    }
}
