package software.amazon.awscdk.services.ec2;
public interface VpcSubnetRefProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The Availability Zone the subnet is located in
     */
    java.lang.String getAvailabilityZone();
    /**
     * The Availability Zone the subnet is located in
     */
    void setAvailabilityZone(final java.lang.String value);
    /**
     * The subnetId for this particular subnet
     */
    software.amazon.awscdk.services.ec2.VpcSubnetId getSubnetId();
    /**
     * The subnetId for this particular subnet
     */
    void setSubnetId(final software.amazon.awscdk.services.ec2.VpcSubnetId value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link VpcSubnetRefProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * The Availability Zone the subnet is located in
         */
        public SubnetIdStep withAvailabilityZone(final java.lang.String value) {
            return new FullBuilder().withAvailabilityZone(value);
        }

        public interface SubnetIdStep {
            /**
             * The subnetId for this particular subnet
             */
            Build withSubnetId(final software.amazon.awscdk.services.ec2.VpcSubnetId value);
        }

        public interface Build {
            /**
             * @return a new {@link VpcSubnetRefProps} object, initialized with the values set on this builder.
             */
            VpcSubnetRefProps build();
        }

        final class FullBuilder implements SubnetIdStep, Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * The Availability Zone the subnet is located in
             */
            public SubnetIdStep withAvailabilityZone(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "VpcSubnetRefProps#availabilityZone is required");
                this.instance._availabilityZone = value;
                return this;
            }
            /**
             * The subnetId for this particular subnet
             */
            public Build withSubnetId(final software.amazon.awscdk.services.ec2.VpcSubnetId value) {
                java.util.Objects.requireNonNull(value, "VpcSubnetRefProps#subnetId is required");
                this.instance._subnetId = value;
                return this;
            }
            public VpcSubnetRefProps build() {
                VpcSubnetRefProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link VpcSubnetRefProps}.
     */
    final class Jsii$Pojo implements VpcSubnetRefProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.String _availabilityZone;

        public java.lang.String getAvailabilityZone() {
            return this._availabilityZone;
        }
        public void setAvailabilityZone(final java.lang.String value) {
            this._availabilityZone = value;
        }

        protected software.amazon.awscdk.services.ec2.VpcSubnetId _subnetId;

        public software.amazon.awscdk.services.ec2.VpcSubnetId getSubnetId() {
            return this._subnetId;
        }
        public void setSubnetId(final software.amazon.awscdk.services.ec2.VpcSubnetId value) {
            this._subnetId = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.VpcSubnetRefProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * The Availability Zone the subnet is located in
         */
        public java.lang.String getAvailabilityZone() {
            return this.jsiiGet("availabilityZone", java.lang.String.class);
        }
        /**
         * The Availability Zone the subnet is located in
         */
        public void setAvailabilityZone(final java.lang.String value) {
            this.jsiiSet("availabilityZone", java.util.Objects.requireNonNull(value, "availabilityZone is required"));
        }
        /**
         * The subnetId for this particular subnet
         */
        public software.amazon.awscdk.services.ec2.VpcSubnetId getSubnetId() {
            return this.jsiiGet("subnetId", software.amazon.awscdk.services.ec2.VpcSubnetId.class);
        }
        /**
         * The subnetId for this particular subnet
         */
        public void setSubnetId(final software.amazon.awscdk.services.ec2.VpcSubnetId value) {
            this.jsiiSet("subnetId", java.util.Objects.requireNonNull(value, "subnetId is required"));
        }
    }
}
