package software.amazon.awscdk.services.ec2.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.cloudformation.InstanceResource")
public class InstanceResource extends software.amazon.awscdk.Resource {
    protected InstanceResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::EC2::Instance``.
     * @param parent the ``cdk.Construct`` this ``InstanceResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``InstanceResource``
     */
    public InstanceResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.InstanceResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(properties)).toArray());
    }
    /**
     * Creates a new ``AWS::EC2::Instance``.
     * @param parent the ``cdk.Construct`` this ``InstanceResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     */
    public InstanceResource(final software.amazon.awscdk.Construct parent, final java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @cloudformation_attribute AvailabilityZone
     */
    public software.amazon.awscdk.services.ec2.InstanceAvailabilityZone getInstanceAvailabilityZone() {
        return this.jsiiGet("instanceAvailabilityZone", software.amazon.awscdk.services.ec2.InstanceAvailabilityZone.class);
    }
    /**
     * @cloudformation_attribute PrivateDnsName
     */
    public software.amazon.awscdk.services.ec2.InstancePrivateDnsName getInstancePrivateDnsName() {
        return this.jsiiGet("instancePrivateDnsName", software.amazon.awscdk.services.ec2.InstancePrivateDnsName.class);
    }
    /**
     * @cloudformation_attribute PrivateIp
     */
    public software.amazon.awscdk.services.ec2.InstancePrivateIp getInstancePrivateIp() {
        return this.jsiiGet("instancePrivateIp", software.amazon.awscdk.services.ec2.InstancePrivateIp.class);
    }
    /**
     * @cloudformation_attribute PublicDnsName
     */
    public software.amazon.awscdk.services.ec2.InstancePublicDnsName getInstancePublicDnsName() {
        return this.jsiiGet("instancePublicDnsName", software.amazon.awscdk.services.ec2.InstancePublicDnsName.class);
    }
    /**
     * @cloudformation_attribute PublicIp
     */
    public software.amazon.awscdk.services.ec2.InstancePublicIp getInstancePublicIp() {
        return this.jsiiGet("instancePublicIp", software.amazon.awscdk.services.ec2.InstancePublicIp.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html
     */
    public static interface AssociationParameterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``InstanceResource.AssociationParameterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-key
         */
        java.lang.Object getKey();
        /**
         * ``InstanceResource.AssociationParameterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-key
         */
        void setKey(final java.lang.String value);
        /**
         * ``InstanceResource.AssociationParameterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-key
         */
        void setKey(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.AssociationParameterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-value
         */
        java.lang.Object getValue();
        /**
         * ``InstanceResource.AssociationParameterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-value
         */
        void setValue(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.AssociationParameterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-value
         */
        void setValue(final java.util.List<java.lang.Object> value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link AssociationParameterProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``InstanceResource.AssociationParameterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-key
             */
            public ValueStep withKey(final java.lang.String value) {
                return new FullBuilder().withKey(value);
            }
            /**
             * ``InstanceResource.AssociationParameterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-key
             */
            public ValueStep withKey(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withKey(value);
            }

            public interface ValueStep {
                /**
                 * ``InstanceResource.AssociationParameterProperty.Value``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-value
                 */
                Build withValue(final software.amazon.awscdk.Token value);
                /**
                 * ``InstanceResource.AssociationParameterProperty.Value``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-value
                 */
                Build withValue(final java.util.List<java.lang.Object> value);
            }

            public interface Build {
                /**
                 * @return a new {@link AssociationParameterProperty} object, initialized with the values set on this builder.
                 */
                AssociationParameterProperty build();
            }

            final class FullBuilder implements ValueStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``InstanceResource.AssociationParameterProperty.Key``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-key
                 */
                public ValueStep withKey(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "AssociationParameterProperty#key is required");
                    this.instance._key = value;
                    return this;
                }
                /**
                 * ``InstanceResource.AssociationParameterProperty.Key``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-key
                 */
                public ValueStep withKey(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "AssociationParameterProperty#key is required");
                    this.instance._key = value;
                    return this;
                }
                /**
                 * ``InstanceResource.AssociationParameterProperty.Value``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-value
                 */
                public Build withValue(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "AssociationParameterProperty#value is required");
                    this.instance._value = value;
                    return this;
                }
                /**
                 * ``InstanceResource.AssociationParameterProperty.Value``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-value
                 */
                public Build withValue(final java.util.List<java.lang.Object> value) {
                    java.util.Objects.requireNonNull(value, "AssociationParameterProperty#value is required");
                    this.instance._value = value;
                    return this;
                }
                public AssociationParameterProperty build() {
                    AssociationParameterProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link AssociationParameterProperty}.
         */
        final class Jsii$Pojo implements AssociationParameterProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _key;

            public java.lang.Object getKey() {
                return this._key;
            }
            public void setKey(final java.lang.String value) {
                this._key = value;
            }
            public void setKey(final software.amazon.awscdk.Token value) {
                this._key = value;
            }

            protected java.lang.Object _value;

            public java.lang.Object getValue() {
                return this._value;
            }
            public void setValue(final software.amazon.awscdk.Token value) {
                this._value = value;
            }
            public void setValue(final java.util.List<java.lang.Object> value) {
                this._value = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.AssociationParameterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``InstanceResource.AssociationParameterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-key
             */
            public java.lang.Object getKey() {
                return this.jsiiGet("key", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.AssociationParameterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-key
             */
            public void setKey(final java.lang.String value) {
                this.jsiiSet("key", java.util.Objects.requireNonNull(value, "key is required"));
            }
            /**
             * ``InstanceResource.AssociationParameterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-key
             */
            public void setKey(final software.amazon.awscdk.Token value) {
                this.jsiiSet("key", java.util.Objects.requireNonNull(value, "key is required"));
            }
            /**
             * ``InstanceResource.AssociationParameterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-value
             */
            public java.lang.Object getValue() {
                return this.jsiiGet("value", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.AssociationParameterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-value
             */
            public void setValue(final software.amazon.awscdk.Token value) {
                this.jsiiSet("value", java.util.Objects.requireNonNull(value, "value is required"));
            }
            /**
             * ``InstanceResource.AssociationParameterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-value
             */
            public void setValue(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("value", java.util.Objects.requireNonNull(value, "value is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html
     */
    public static interface BlockDeviceMappingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``InstanceResource.BlockDeviceMappingProperty.DeviceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-devicename
         */
        java.lang.Object getDeviceName();
        /**
         * ``InstanceResource.BlockDeviceMappingProperty.DeviceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-devicename
         */
        void setDeviceName(final java.lang.String value);
        /**
         * ``InstanceResource.BlockDeviceMappingProperty.DeviceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-devicename
         */
        void setDeviceName(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.BlockDeviceMappingProperty.Ebs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-ebs
         */
        java.lang.Object getEbs();
        /**
         * ``InstanceResource.BlockDeviceMappingProperty.Ebs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-ebs
         */
        void setEbs(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.BlockDeviceMappingProperty.Ebs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-ebs
         */
        void setEbs(final software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.EbsProperty value);
        /**
         * ``InstanceResource.BlockDeviceMappingProperty.NoDevice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-nodevice
         */
        java.lang.Object getNoDevice();
        /**
         * ``InstanceResource.BlockDeviceMappingProperty.NoDevice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-nodevice
         */
        void setNoDevice(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.BlockDeviceMappingProperty.NoDevice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-nodevice
         */
        void setNoDevice(final software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.NoDeviceProperty value);
        /**
         * ``InstanceResource.BlockDeviceMappingProperty.VirtualName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-virtualname
         */
        java.lang.Object getVirtualName();
        /**
         * ``InstanceResource.BlockDeviceMappingProperty.VirtualName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-virtualname
         */
        void setVirtualName(final java.lang.String value);
        /**
         * ``InstanceResource.BlockDeviceMappingProperty.VirtualName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-virtualname
         */
        void setVirtualName(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link BlockDeviceMappingProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``InstanceResource.BlockDeviceMappingProperty.DeviceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-devicename
             */
            public Build withDeviceName(final java.lang.String value) {
                return new FullBuilder().withDeviceName(value);
            }
            /**
             * ``InstanceResource.BlockDeviceMappingProperty.DeviceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-devicename
             */
            public Build withDeviceName(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withDeviceName(value);
            }

            public interface Build {
                /**
                 * @return a new {@link BlockDeviceMappingProperty} object, initialized with the values set on this builder.
                 */
                BlockDeviceMappingProperty build();
                /**
                 * ``InstanceResource.BlockDeviceMappingProperty.Ebs``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-ebs
                 */
                Build withEbs(final software.amazon.awscdk.Token value);
                /**
                 * ``InstanceResource.BlockDeviceMappingProperty.Ebs``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-ebs
                 */
                Build withEbs(final software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.EbsProperty value);
                /**
                 * ``InstanceResource.BlockDeviceMappingProperty.NoDevice``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-nodevice
                 */
                Build withNoDevice(final software.amazon.awscdk.Token value);
                /**
                 * ``InstanceResource.BlockDeviceMappingProperty.NoDevice``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-nodevice
                 */
                Build withNoDevice(final software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.NoDeviceProperty value);
                /**
                 * ``InstanceResource.BlockDeviceMappingProperty.VirtualName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-virtualname
                 */
                Build withVirtualName(final java.lang.String value);
                /**
                 * ``InstanceResource.BlockDeviceMappingProperty.VirtualName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-virtualname
                 */
                Build withVirtualName(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``InstanceResource.BlockDeviceMappingProperty.DeviceName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-devicename
                 */
                public Build withDeviceName(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "BlockDeviceMappingProperty#deviceName is required");
                    this.instance._deviceName = value;
                    return this;
                }
                /**
                 * ``InstanceResource.BlockDeviceMappingProperty.DeviceName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-devicename
                 */
                public Build withDeviceName(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "BlockDeviceMappingProperty#deviceName is required");
                    this.instance._deviceName = value;
                    return this;
                }
                /**
                 * ``InstanceResource.BlockDeviceMappingProperty.Ebs``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-ebs
                 */
                public Build withEbs(final software.amazon.awscdk.Token value) {
                    this.instance._ebs = value;
                    return this;
                }
                /**
                 * ``InstanceResource.BlockDeviceMappingProperty.Ebs``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-ebs
                 */
                public Build withEbs(final software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.EbsProperty value) {
                    this.instance._ebs = value;
                    return this;
                }
                /**
                 * ``InstanceResource.BlockDeviceMappingProperty.NoDevice``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-nodevice
                 */
                public Build withNoDevice(final software.amazon.awscdk.Token value) {
                    this.instance._noDevice = value;
                    return this;
                }
                /**
                 * ``InstanceResource.BlockDeviceMappingProperty.NoDevice``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-nodevice
                 */
                public Build withNoDevice(final software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.NoDeviceProperty value) {
                    this.instance._noDevice = value;
                    return this;
                }
                /**
                 * ``InstanceResource.BlockDeviceMappingProperty.VirtualName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-virtualname
                 */
                public Build withVirtualName(final java.lang.String value) {
                    this.instance._virtualName = value;
                    return this;
                }
                /**
                 * ``InstanceResource.BlockDeviceMappingProperty.VirtualName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-virtualname
                 */
                public Build withVirtualName(final software.amazon.awscdk.Token value) {
                    this.instance._virtualName = value;
                    return this;
                }
                public BlockDeviceMappingProperty build() {
                    BlockDeviceMappingProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link BlockDeviceMappingProperty}.
         */
        final class Jsii$Pojo implements BlockDeviceMappingProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _deviceName;

            public java.lang.Object getDeviceName() {
                return this._deviceName;
            }
            public void setDeviceName(final java.lang.String value) {
                this._deviceName = value;
            }
            public void setDeviceName(final software.amazon.awscdk.Token value) {
                this._deviceName = value;
            }

            protected java.lang.Object _ebs;

            public java.lang.Object getEbs() {
                return this._ebs;
            }
            public void setEbs(final software.amazon.awscdk.Token value) {
                this._ebs = value;
            }
            public void setEbs(final software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.EbsProperty value) {
                this._ebs = value;
            }

            protected java.lang.Object _noDevice;

            public java.lang.Object getNoDevice() {
                return this._noDevice;
            }
            public void setNoDevice(final software.amazon.awscdk.Token value) {
                this._noDevice = value;
            }
            public void setNoDevice(final software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.NoDeviceProperty value) {
                this._noDevice = value;
            }

            protected java.lang.Object _virtualName;

            public java.lang.Object getVirtualName() {
                return this._virtualName;
            }
            public void setVirtualName(final java.lang.String value) {
                this._virtualName = value;
            }
            public void setVirtualName(final software.amazon.awscdk.Token value) {
                this._virtualName = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.BlockDeviceMappingProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``InstanceResource.BlockDeviceMappingProperty.DeviceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-devicename
             */
            public java.lang.Object getDeviceName() {
                return this.jsiiGet("deviceName", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.BlockDeviceMappingProperty.DeviceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-devicename
             */
            public void setDeviceName(final java.lang.String value) {
                this.jsiiSet("deviceName", java.util.Objects.requireNonNull(value, "deviceName is required"));
            }
            /**
             * ``InstanceResource.BlockDeviceMappingProperty.DeviceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-devicename
             */
            public void setDeviceName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("deviceName", java.util.Objects.requireNonNull(value, "deviceName is required"));
            }
            /**
             * ``InstanceResource.BlockDeviceMappingProperty.Ebs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-ebs
             */
            @javax.annotation.Nullable
            public java.lang.Object getEbs() {
                return this.jsiiGet("ebs", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.BlockDeviceMappingProperty.Ebs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-ebs
             */
            public void setEbs(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ebs", value);
            }
            /**
             * ``InstanceResource.BlockDeviceMappingProperty.Ebs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-ebs
             */
            public void setEbs(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.EbsProperty value) {
                this.jsiiSet("ebs", value);
            }
            /**
             * ``InstanceResource.BlockDeviceMappingProperty.NoDevice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-nodevice
             */
            @javax.annotation.Nullable
            public java.lang.Object getNoDevice() {
                return this.jsiiGet("noDevice", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.BlockDeviceMappingProperty.NoDevice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-nodevice
             */
            public void setNoDevice(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("noDevice", value);
            }
            /**
             * ``InstanceResource.BlockDeviceMappingProperty.NoDevice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-nodevice
             */
            public void setNoDevice(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.NoDeviceProperty value) {
                this.jsiiSet("noDevice", value);
            }
            /**
             * ``InstanceResource.BlockDeviceMappingProperty.VirtualName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-virtualname
             */
            @javax.annotation.Nullable
            public java.lang.Object getVirtualName() {
                return this.jsiiGet("virtualName", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.BlockDeviceMappingProperty.VirtualName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-virtualname
             */
            public void setVirtualName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("virtualName", value);
            }
            /**
             * ``InstanceResource.BlockDeviceMappingProperty.VirtualName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-virtualname
             */
            public void setVirtualName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("virtualName", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html
     */
    public static interface CreditSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``InstanceResource.CreditSpecificationProperty.CPUCredits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html#cfn-ec2-instance-creditspecification-cpucredits
         */
        java.lang.Object getCpuCredits();
        /**
         * ``InstanceResource.CreditSpecificationProperty.CPUCredits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html#cfn-ec2-instance-creditspecification-cpucredits
         */
        void setCpuCredits(final java.lang.String value);
        /**
         * ``InstanceResource.CreditSpecificationProperty.CPUCredits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html#cfn-ec2-instance-creditspecification-cpucredits
         */
        void setCpuCredits(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link CreditSpecificationProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``InstanceResource.CreditSpecificationProperty.CPUCredits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html#cfn-ec2-instance-creditspecification-cpucredits
             */
            public Builder withCpuCredits(final java.lang.String value) {
                this.instance._cpuCredits = value;
                return this;
            }
            /**
             * ``InstanceResource.CreditSpecificationProperty.CPUCredits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html#cfn-ec2-instance-creditspecification-cpucredits
             */
            public Builder withCpuCredits(final software.amazon.awscdk.Token value) {
                this.instance._cpuCredits = value;
                return this;
            }
            public CreditSpecificationProperty build() {
                CreditSpecificationProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link CreditSpecificationProperty}.
         */
        final class Jsii$Pojo implements CreditSpecificationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _cpuCredits;

            public java.lang.Object getCpuCredits() {
                return this._cpuCredits;
            }
            public void setCpuCredits(final java.lang.String value) {
                this._cpuCredits = value;
            }
            public void setCpuCredits(final software.amazon.awscdk.Token value) {
                this._cpuCredits = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.CreditSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``InstanceResource.CreditSpecificationProperty.CPUCredits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html#cfn-ec2-instance-creditspecification-cpucredits
             */
            @javax.annotation.Nullable
            public java.lang.Object getCpuCredits() {
                return this.jsiiGet("cpuCredits", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.CreditSpecificationProperty.CPUCredits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html#cfn-ec2-instance-creditspecification-cpucredits
             */
            public void setCpuCredits(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("cpuCredits", value);
            }
            /**
             * ``InstanceResource.CreditSpecificationProperty.CPUCredits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html#cfn-ec2-instance-creditspecification-cpucredits
             */
            public void setCpuCredits(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cpuCredits", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html
     */
    public static interface EbsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``InstanceResource.EbsProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-deleteontermination
         */
        java.lang.Object getDeleteOnTermination();
        /**
         * ``InstanceResource.EbsProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-deleteontermination
         */
        void setDeleteOnTermination(final java.lang.Boolean value);
        /**
         * ``InstanceResource.EbsProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-deleteontermination
         */
        void setDeleteOnTermination(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.EbsProperty.Encrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-encrypted
         */
        java.lang.Object getEncrypted();
        /**
         * ``InstanceResource.EbsProperty.Encrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-encrypted
         */
        void setEncrypted(final java.lang.Boolean value);
        /**
         * ``InstanceResource.EbsProperty.Encrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-encrypted
         */
        void setEncrypted(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.EbsProperty.Iops``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-iops
         */
        java.lang.Object getIops();
        /**
         * ``InstanceResource.EbsProperty.Iops``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-iops
         */
        void setIops(final java.lang.Number value);
        /**
         * ``InstanceResource.EbsProperty.Iops``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-iops
         */
        void setIops(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.EbsProperty.SnapshotId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-snapshotid
         */
        java.lang.Object getSnapshotId();
        /**
         * ``InstanceResource.EbsProperty.SnapshotId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-snapshotid
         */
        void setSnapshotId(final java.lang.String value);
        /**
         * ``InstanceResource.EbsProperty.SnapshotId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-snapshotid
         */
        void setSnapshotId(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.EbsProperty.VolumeSize``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumesize
         */
        java.lang.Object getVolumeSize();
        /**
         * ``InstanceResource.EbsProperty.VolumeSize``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumesize
         */
        void setVolumeSize(final java.lang.Number value);
        /**
         * ``InstanceResource.EbsProperty.VolumeSize``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumesize
         */
        void setVolumeSize(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.EbsProperty.VolumeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumetype
         */
        java.lang.Object getVolumeType();
        /**
         * ``InstanceResource.EbsProperty.VolumeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumetype
         */
        void setVolumeType(final java.lang.String value);
        /**
         * ``InstanceResource.EbsProperty.VolumeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumetype
         */
        void setVolumeType(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link EbsProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``InstanceResource.EbsProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-deleteontermination
             */
            public Builder withDeleteOnTermination(final java.lang.Boolean value) {
                this.instance._deleteOnTermination = value;
                return this;
            }
            /**
             * ``InstanceResource.EbsProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-deleteontermination
             */
            public Builder withDeleteOnTermination(final software.amazon.awscdk.Token value) {
                this.instance._deleteOnTermination = value;
                return this;
            }
            /**
             * ``InstanceResource.EbsProperty.Encrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-encrypted
             */
            public Builder withEncrypted(final java.lang.Boolean value) {
                this.instance._encrypted = value;
                return this;
            }
            /**
             * ``InstanceResource.EbsProperty.Encrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-encrypted
             */
            public Builder withEncrypted(final software.amazon.awscdk.Token value) {
                this.instance._encrypted = value;
                return this;
            }
            /**
             * ``InstanceResource.EbsProperty.Iops``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-iops
             */
            public Builder withIops(final java.lang.Number value) {
                this.instance._iops = value;
                return this;
            }
            /**
             * ``InstanceResource.EbsProperty.Iops``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-iops
             */
            public Builder withIops(final software.amazon.awscdk.Token value) {
                this.instance._iops = value;
                return this;
            }
            /**
             * ``InstanceResource.EbsProperty.SnapshotId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-snapshotid
             */
            public Builder withSnapshotId(final java.lang.String value) {
                this.instance._snapshotId = value;
                return this;
            }
            /**
             * ``InstanceResource.EbsProperty.SnapshotId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-snapshotid
             */
            public Builder withSnapshotId(final software.amazon.awscdk.Token value) {
                this.instance._snapshotId = value;
                return this;
            }
            /**
             * ``InstanceResource.EbsProperty.VolumeSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumesize
             */
            public Builder withVolumeSize(final java.lang.Number value) {
                this.instance._volumeSize = value;
                return this;
            }
            /**
             * ``InstanceResource.EbsProperty.VolumeSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumesize
             */
            public Builder withVolumeSize(final software.amazon.awscdk.Token value) {
                this.instance._volumeSize = value;
                return this;
            }
            /**
             * ``InstanceResource.EbsProperty.VolumeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumetype
             */
            public Builder withVolumeType(final java.lang.String value) {
                this.instance._volumeType = value;
                return this;
            }
            /**
             * ``InstanceResource.EbsProperty.VolumeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumetype
             */
            public Builder withVolumeType(final software.amazon.awscdk.Token value) {
                this.instance._volumeType = value;
                return this;
            }
            public EbsProperty build() {
                EbsProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link EbsProperty}.
         */
        final class Jsii$Pojo implements EbsProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _deleteOnTermination;

            public java.lang.Object getDeleteOnTermination() {
                return this._deleteOnTermination;
            }
            public void setDeleteOnTermination(final java.lang.Boolean value) {
                this._deleteOnTermination = value;
            }
            public void setDeleteOnTermination(final software.amazon.awscdk.Token value) {
                this._deleteOnTermination = value;
            }

            protected java.lang.Object _encrypted;

            public java.lang.Object getEncrypted() {
                return this._encrypted;
            }
            public void setEncrypted(final java.lang.Boolean value) {
                this._encrypted = value;
            }
            public void setEncrypted(final software.amazon.awscdk.Token value) {
                this._encrypted = value;
            }

            protected java.lang.Object _iops;

            public java.lang.Object getIops() {
                return this._iops;
            }
            public void setIops(final java.lang.Number value) {
                this._iops = value;
            }
            public void setIops(final software.amazon.awscdk.Token value) {
                this._iops = value;
            }

            protected java.lang.Object _snapshotId;

            public java.lang.Object getSnapshotId() {
                return this._snapshotId;
            }
            public void setSnapshotId(final java.lang.String value) {
                this._snapshotId = value;
            }
            public void setSnapshotId(final software.amazon.awscdk.Token value) {
                this._snapshotId = value;
            }

            protected java.lang.Object _volumeSize;

            public java.lang.Object getVolumeSize() {
                return this._volumeSize;
            }
            public void setVolumeSize(final java.lang.Number value) {
                this._volumeSize = value;
            }
            public void setVolumeSize(final software.amazon.awscdk.Token value) {
                this._volumeSize = value;
            }

            protected java.lang.Object _volumeType;

            public java.lang.Object getVolumeType() {
                return this._volumeType;
            }
            public void setVolumeType(final java.lang.String value) {
                this._volumeType = value;
            }
            public void setVolumeType(final software.amazon.awscdk.Token value) {
                this._volumeType = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.EbsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``InstanceResource.EbsProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-deleteontermination
             */
            @javax.annotation.Nullable
            public java.lang.Object getDeleteOnTermination() {
                return this.jsiiGet("deleteOnTermination", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.EbsProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-deleteontermination
             */
            public void setDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("deleteOnTermination", value);
            }
            /**
             * ``InstanceResource.EbsProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-deleteontermination
             */
            public void setDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("deleteOnTermination", value);
            }
            /**
             * ``InstanceResource.EbsProperty.Encrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-encrypted
             */
            @javax.annotation.Nullable
            public java.lang.Object getEncrypted() {
                return this.jsiiGet("encrypted", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.EbsProperty.Encrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-encrypted
             */
            public void setEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("encrypted", value);
            }
            /**
             * ``InstanceResource.EbsProperty.Encrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-encrypted
             */
            public void setEncrypted(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("encrypted", value);
            }
            /**
             * ``InstanceResource.EbsProperty.Iops``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-iops
             */
            @javax.annotation.Nullable
            public java.lang.Object getIops() {
                return this.jsiiGet("iops", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.EbsProperty.Iops``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-iops
             */
            public void setIops(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("iops", value);
            }
            /**
             * ``InstanceResource.EbsProperty.Iops``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-iops
             */
            public void setIops(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("iops", value);
            }
            /**
             * ``InstanceResource.EbsProperty.SnapshotId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-snapshotid
             */
            @javax.annotation.Nullable
            public java.lang.Object getSnapshotId() {
                return this.jsiiGet("snapshotId", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.EbsProperty.SnapshotId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-snapshotid
             */
            public void setSnapshotId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("snapshotId", value);
            }
            /**
             * ``InstanceResource.EbsProperty.SnapshotId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-snapshotid
             */
            public void setSnapshotId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("snapshotId", value);
            }
            /**
             * ``InstanceResource.EbsProperty.VolumeSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumesize
             */
            @javax.annotation.Nullable
            public java.lang.Object getVolumeSize() {
                return this.jsiiGet("volumeSize", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.EbsProperty.VolumeSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumesize
             */
            public void setVolumeSize(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("volumeSize", value);
            }
            /**
             * ``InstanceResource.EbsProperty.VolumeSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumesize
             */
            public void setVolumeSize(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("volumeSize", value);
            }
            /**
             * ``InstanceResource.EbsProperty.VolumeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumetype
             */
            @javax.annotation.Nullable
            public java.lang.Object getVolumeType() {
                return this.jsiiGet("volumeType", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.EbsProperty.VolumeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumetype
             */
            public void setVolumeType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("volumeType", value);
            }
            /**
             * ``InstanceResource.EbsProperty.VolumeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumetype
             */
            public void setVolumeType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("volumeType", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html
     */
    public static interface ElasticGpuSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``InstanceResource.ElasticGpuSpecificationProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html#cfn-ec2-instance-elasticgpuspecification-type
         */
        java.lang.Object getType();
        /**
         * ``InstanceResource.ElasticGpuSpecificationProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html#cfn-ec2-instance-elasticgpuspecification-type
         */
        void setType(final java.lang.String value);
        /**
         * ``InstanceResource.ElasticGpuSpecificationProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html#cfn-ec2-instance-elasticgpuspecification-type
         */
        void setType(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link ElasticGpuSpecificationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``InstanceResource.ElasticGpuSpecificationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html#cfn-ec2-instance-elasticgpuspecification-type
             */
            public Build withType(final java.lang.String value) {
                return new FullBuilder().withType(value);
            }
            /**
             * ``InstanceResource.ElasticGpuSpecificationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html#cfn-ec2-instance-elasticgpuspecification-type
             */
            public Build withType(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withType(value);
            }

            public interface Build {
                /**
                 * @return a new {@link ElasticGpuSpecificationProperty} object, initialized with the values set on this builder.
                 */
                ElasticGpuSpecificationProperty build();
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``InstanceResource.ElasticGpuSpecificationProperty.Type``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html#cfn-ec2-instance-elasticgpuspecification-type
                 */
                public Build withType(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "ElasticGpuSpecificationProperty#type is required");
                    this.instance._type = value;
                    return this;
                }
                /**
                 * ``InstanceResource.ElasticGpuSpecificationProperty.Type``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html#cfn-ec2-instance-elasticgpuspecification-type
                 */
                public Build withType(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "ElasticGpuSpecificationProperty#type is required");
                    this.instance._type = value;
                    return this;
                }
                public ElasticGpuSpecificationProperty build() {
                    ElasticGpuSpecificationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link ElasticGpuSpecificationProperty}.
         */
        final class Jsii$Pojo implements ElasticGpuSpecificationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _type;

            public java.lang.Object getType() {
                return this._type;
            }
            public void setType(final java.lang.String value) {
                this._type = value;
            }
            public void setType(final software.amazon.awscdk.Token value) {
                this._type = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.ElasticGpuSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``InstanceResource.ElasticGpuSpecificationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html#cfn-ec2-instance-elasticgpuspecification-type
             */
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.ElasticGpuSpecificationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html#cfn-ec2-instance-elasticgpuspecification-type
             */
            public void setType(final java.lang.String value) {
                this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
            }
            /**
             * ``InstanceResource.ElasticGpuSpecificationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html#cfn-ec2-instance-elasticgpuspecification-type
             */
            public void setType(final software.amazon.awscdk.Token value) {
                this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html
     */
    public static interface InstanceIpv6AddressProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``InstanceResource.InstanceIpv6AddressProperty.Ipv6Address``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html#cfn-ec2-instance-instanceipv6address-ipv6address
         */
        java.lang.Object getIpv6Address();
        /**
         * ``InstanceResource.InstanceIpv6AddressProperty.Ipv6Address``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html#cfn-ec2-instance-instanceipv6address-ipv6address
         */
        void setIpv6Address(final java.lang.String value);
        /**
         * ``InstanceResource.InstanceIpv6AddressProperty.Ipv6Address``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html#cfn-ec2-instance-instanceipv6address-ipv6address
         */
        void setIpv6Address(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link InstanceIpv6AddressProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``InstanceResource.InstanceIpv6AddressProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html#cfn-ec2-instance-instanceipv6address-ipv6address
             */
            public Build withIpv6Address(final java.lang.String value) {
                return new FullBuilder().withIpv6Address(value);
            }
            /**
             * ``InstanceResource.InstanceIpv6AddressProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html#cfn-ec2-instance-instanceipv6address-ipv6address
             */
            public Build withIpv6Address(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withIpv6Address(value);
            }

            public interface Build {
                /**
                 * @return a new {@link InstanceIpv6AddressProperty} object, initialized with the values set on this builder.
                 */
                InstanceIpv6AddressProperty build();
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``InstanceResource.InstanceIpv6AddressProperty.Ipv6Address``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html#cfn-ec2-instance-instanceipv6address-ipv6address
                 */
                public Build withIpv6Address(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "InstanceIpv6AddressProperty#ipv6Address is required");
                    this.instance._ipv6Address = value;
                    return this;
                }
                /**
                 * ``InstanceResource.InstanceIpv6AddressProperty.Ipv6Address``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html#cfn-ec2-instance-instanceipv6address-ipv6address
                 */
                public Build withIpv6Address(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "InstanceIpv6AddressProperty#ipv6Address is required");
                    this.instance._ipv6Address = value;
                    return this;
                }
                public InstanceIpv6AddressProperty build() {
                    InstanceIpv6AddressProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link InstanceIpv6AddressProperty}.
         */
        final class Jsii$Pojo implements InstanceIpv6AddressProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _ipv6Address;

            public java.lang.Object getIpv6Address() {
                return this._ipv6Address;
            }
            public void setIpv6Address(final java.lang.String value) {
                this._ipv6Address = value;
            }
            public void setIpv6Address(final software.amazon.awscdk.Token value) {
                this._ipv6Address = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.InstanceIpv6AddressProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``InstanceResource.InstanceIpv6AddressProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html#cfn-ec2-instance-instanceipv6address-ipv6address
             */
            public java.lang.Object getIpv6Address() {
                return this.jsiiGet("ipv6Address", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.InstanceIpv6AddressProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html#cfn-ec2-instance-instanceipv6address-ipv6address
             */
            public void setIpv6Address(final java.lang.String value) {
                this.jsiiSet("ipv6Address", java.util.Objects.requireNonNull(value, "ipv6Address is required"));
            }
            /**
             * ``InstanceResource.InstanceIpv6AddressProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html#cfn-ec2-instance-instanceipv6address-ipv6address
             */
            public void setIpv6Address(final software.amazon.awscdk.Token value) {
                this.jsiiSet("ipv6Address", java.util.Objects.requireNonNull(value, "ipv6Address is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html
     */
    public static interface LaunchTemplateSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``InstanceResource.LaunchTemplateSpecificationProperty.LaunchTemplateId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplateid
         */
        java.lang.Object getLaunchTemplateId();
        /**
         * ``InstanceResource.LaunchTemplateSpecificationProperty.LaunchTemplateId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplateid
         */
        void setLaunchTemplateId(final java.lang.String value);
        /**
         * ``InstanceResource.LaunchTemplateSpecificationProperty.LaunchTemplateId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplateid
         */
        void setLaunchTemplateId(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.LaunchTemplateSpecificationProperty.LaunchTemplateName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplatename
         */
        java.lang.Object getLaunchTemplateName();
        /**
         * ``InstanceResource.LaunchTemplateSpecificationProperty.LaunchTemplateName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplatename
         */
        void setLaunchTemplateName(final java.lang.String value);
        /**
         * ``InstanceResource.LaunchTemplateSpecificationProperty.LaunchTemplateName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplatename
         */
        void setLaunchTemplateName(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.LaunchTemplateSpecificationProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-version
         */
        java.lang.Object getVersion();
        /**
         * ``InstanceResource.LaunchTemplateSpecificationProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-version
         */
        void setVersion(final java.lang.String value);
        /**
         * ``InstanceResource.LaunchTemplateSpecificationProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-version
         */
        void setVersion(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link LaunchTemplateSpecificationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``InstanceResource.LaunchTemplateSpecificationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-version
             */
            public Build withVersion(final java.lang.String value) {
                return new FullBuilder().withVersion(value);
            }
            /**
             * ``InstanceResource.LaunchTemplateSpecificationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-version
             */
            public Build withVersion(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withVersion(value);
            }

            public interface Build {
                /**
                 * @return a new {@link LaunchTemplateSpecificationProperty} object, initialized with the values set on this builder.
                 */
                LaunchTemplateSpecificationProperty build();
                /**
                 * ``InstanceResource.LaunchTemplateSpecificationProperty.LaunchTemplateId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplateid
                 */
                Build withLaunchTemplateId(final java.lang.String value);
                /**
                 * ``InstanceResource.LaunchTemplateSpecificationProperty.LaunchTemplateId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplateid
                 */
                Build withLaunchTemplateId(final software.amazon.awscdk.Token value);
                /**
                 * ``InstanceResource.LaunchTemplateSpecificationProperty.LaunchTemplateName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplatename
                 */
                Build withLaunchTemplateName(final java.lang.String value);
                /**
                 * ``InstanceResource.LaunchTemplateSpecificationProperty.LaunchTemplateName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplatename
                 */
                Build withLaunchTemplateName(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``InstanceResource.LaunchTemplateSpecificationProperty.LaunchTemplateId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplateid
                 */
                public Build withLaunchTemplateId(final java.lang.String value) {
                    this.instance._launchTemplateId = value;
                    return this;
                }
                /**
                 * ``InstanceResource.LaunchTemplateSpecificationProperty.LaunchTemplateId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplateid
                 */
                public Build withLaunchTemplateId(final software.amazon.awscdk.Token value) {
                    this.instance._launchTemplateId = value;
                    return this;
                }
                /**
                 * ``InstanceResource.LaunchTemplateSpecificationProperty.LaunchTemplateName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplatename
                 */
                public Build withLaunchTemplateName(final java.lang.String value) {
                    this.instance._launchTemplateName = value;
                    return this;
                }
                /**
                 * ``InstanceResource.LaunchTemplateSpecificationProperty.LaunchTemplateName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplatename
                 */
                public Build withLaunchTemplateName(final software.amazon.awscdk.Token value) {
                    this.instance._launchTemplateName = value;
                    return this;
                }
                /**
                 * ``InstanceResource.LaunchTemplateSpecificationProperty.Version``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-version
                 */
                public Build withVersion(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "LaunchTemplateSpecificationProperty#version is required");
                    this.instance._version = value;
                    return this;
                }
                /**
                 * ``InstanceResource.LaunchTemplateSpecificationProperty.Version``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-version
                 */
                public Build withVersion(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "LaunchTemplateSpecificationProperty#version is required");
                    this.instance._version = value;
                    return this;
                }
                public LaunchTemplateSpecificationProperty build() {
                    LaunchTemplateSpecificationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link LaunchTemplateSpecificationProperty}.
         */
        final class Jsii$Pojo implements LaunchTemplateSpecificationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _launchTemplateId;

            public java.lang.Object getLaunchTemplateId() {
                return this._launchTemplateId;
            }
            public void setLaunchTemplateId(final java.lang.String value) {
                this._launchTemplateId = value;
            }
            public void setLaunchTemplateId(final software.amazon.awscdk.Token value) {
                this._launchTemplateId = value;
            }

            protected java.lang.Object _launchTemplateName;

            public java.lang.Object getLaunchTemplateName() {
                return this._launchTemplateName;
            }
            public void setLaunchTemplateName(final java.lang.String value) {
                this._launchTemplateName = value;
            }
            public void setLaunchTemplateName(final software.amazon.awscdk.Token value) {
                this._launchTemplateName = value;
            }

            protected java.lang.Object _version;

            public java.lang.Object getVersion() {
                return this._version;
            }
            public void setVersion(final java.lang.String value) {
                this._version = value;
            }
            public void setVersion(final software.amazon.awscdk.Token value) {
                this._version = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.LaunchTemplateSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``InstanceResource.LaunchTemplateSpecificationProperty.LaunchTemplateId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplateid
             */
            @javax.annotation.Nullable
            public java.lang.Object getLaunchTemplateId() {
                return this.jsiiGet("launchTemplateId", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.LaunchTemplateSpecificationProperty.LaunchTemplateId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplateid
             */
            public void setLaunchTemplateId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("launchTemplateId", value);
            }
            /**
             * ``InstanceResource.LaunchTemplateSpecificationProperty.LaunchTemplateId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplateid
             */
            public void setLaunchTemplateId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("launchTemplateId", value);
            }
            /**
             * ``InstanceResource.LaunchTemplateSpecificationProperty.LaunchTemplateName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplatename
             */
            @javax.annotation.Nullable
            public java.lang.Object getLaunchTemplateName() {
                return this.jsiiGet("launchTemplateName", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.LaunchTemplateSpecificationProperty.LaunchTemplateName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplatename
             */
            public void setLaunchTemplateName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("launchTemplateName", value);
            }
            /**
             * ``InstanceResource.LaunchTemplateSpecificationProperty.LaunchTemplateName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplatename
             */
            public void setLaunchTemplateName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("launchTemplateName", value);
            }
            /**
             * ``InstanceResource.LaunchTemplateSpecificationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-version
             */
            public java.lang.Object getVersion() {
                return this.jsiiGet("version", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.LaunchTemplateSpecificationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-version
             */
            public void setVersion(final java.lang.String value) {
                this.jsiiSet("version", java.util.Objects.requireNonNull(value, "version is required"));
            }
            /**
             * ``InstanceResource.LaunchTemplateSpecificationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-version
             */
            public void setVersion(final software.amazon.awscdk.Token value) {
                this.jsiiSet("version", java.util.Objects.requireNonNull(value, "version is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html
     */
    public static interface NetworkInterfaceProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``InstanceResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-associatepubip
         */
        java.lang.Object getAssociatePublicIpAddress();
        /**
         * ``InstanceResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-associatepubip
         */
        void setAssociatePublicIpAddress(final java.lang.Boolean value);
        /**
         * ``InstanceResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-associatepubip
         */
        void setAssociatePublicIpAddress(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.NetworkInterfaceProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-delete
         */
        java.lang.Object getDeleteOnTermination();
        /**
         * ``InstanceResource.NetworkInterfaceProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-delete
         */
        void setDeleteOnTermination(final java.lang.Boolean value);
        /**
         * ``InstanceResource.NetworkInterfaceProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-delete
         */
        void setDeleteOnTermination(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.NetworkInterfaceProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-description
         */
        java.lang.Object getDescription();
        /**
         * ``InstanceResource.NetworkInterfaceProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-description
         */
        void setDescription(final java.lang.String value);
        /**
         * ``InstanceResource.NetworkInterfaceProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-description
         */
        void setDescription(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.NetworkInterfaceProperty.DeviceIndex``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-deviceindex
         */
        java.lang.Object getDeviceIndex();
        /**
         * ``InstanceResource.NetworkInterfaceProperty.DeviceIndex``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-deviceindex
         */
        void setDeviceIndex(final java.lang.String value);
        /**
         * ``InstanceResource.NetworkInterfaceProperty.DeviceIndex``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-deviceindex
         */
        void setDeviceIndex(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.NetworkInterfaceProperty.GroupSet``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-groupset
         */
        java.lang.Object getGroupSet();
        /**
         * ``InstanceResource.NetworkInterfaceProperty.GroupSet``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-groupset
         */
        void setGroupSet(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.NetworkInterfaceProperty.GroupSet``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-groupset
         */
        void setGroupSet(final java.util.List<java.lang.Object> value);
        /**
         * ``InstanceResource.NetworkInterfaceProperty.Ipv6AddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresscount
         */
        java.lang.Object getIpv6AddressCount();
        /**
         * ``InstanceResource.NetworkInterfaceProperty.Ipv6AddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresscount
         */
        void setIpv6AddressCount(final java.lang.Number value);
        /**
         * ``InstanceResource.NetworkInterfaceProperty.Ipv6AddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresscount
         */
        void setIpv6AddressCount(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.NetworkInterfaceProperty.Ipv6Addresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresses
         */
        java.lang.Object getIpv6Addresses();
        /**
         * ``InstanceResource.NetworkInterfaceProperty.Ipv6Addresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresses
         */
        void setIpv6Addresses(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.NetworkInterfaceProperty.Ipv6Addresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresses
         */
        void setIpv6Addresses(final java.util.List<java.lang.Object> value);
        /**
         * ``InstanceResource.NetworkInterfaceProperty.NetworkInterfaceId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-network-iface
         */
        java.lang.Object getNetworkInterfaceId();
        /**
         * ``InstanceResource.NetworkInterfaceProperty.NetworkInterfaceId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-network-iface
         */
        void setNetworkInterfaceId(final java.lang.String value);
        /**
         * ``InstanceResource.NetworkInterfaceProperty.NetworkInterfaceId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-network-iface
         */
        void setNetworkInterfaceId(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.NetworkInterfaceProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddress
         */
        java.lang.Object getPrivateIpAddress();
        /**
         * ``InstanceResource.NetworkInterfaceProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddress
         */
        void setPrivateIpAddress(final java.lang.String value);
        /**
         * ``InstanceResource.NetworkInterfaceProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddress
         */
        void setPrivateIpAddress(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.NetworkInterfaceProperty.PrivateIpAddresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddresses
         */
        java.lang.Object getPrivateIpAddresses();
        /**
         * ``InstanceResource.NetworkInterfaceProperty.PrivateIpAddresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddresses
         */
        void setPrivateIpAddresses(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.NetworkInterfaceProperty.PrivateIpAddresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddresses
         */
        void setPrivateIpAddresses(final java.util.List<java.lang.Object> value);
        /**
         * ``InstanceResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-secondprivateip
         */
        java.lang.Object getSecondaryPrivateIpAddressCount();
        /**
         * ``InstanceResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-secondprivateip
         */
        void setSecondaryPrivateIpAddressCount(final java.lang.Number value);
        /**
         * ``InstanceResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-secondprivateip
         */
        void setSecondaryPrivateIpAddressCount(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.NetworkInterfaceProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-subnetid
         */
        java.lang.Object getSubnetId();
        /**
         * ``InstanceResource.NetworkInterfaceProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-subnetid
         */
        void setSubnetId(final java.lang.String value);
        /**
         * ``InstanceResource.NetworkInterfaceProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-subnetid
         */
        void setSubnetId(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link NetworkInterfaceProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``InstanceResource.NetworkInterfaceProperty.DeviceIndex``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-deviceindex
             */
            public Build withDeviceIndex(final java.lang.String value) {
                return new FullBuilder().withDeviceIndex(value);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.DeviceIndex``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-deviceindex
             */
            public Build withDeviceIndex(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withDeviceIndex(value);
            }

            public interface Build {
                /**
                 * @return a new {@link NetworkInterfaceProperty} object, initialized with the values set on this builder.
                 */
                NetworkInterfaceProperty build();
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-associatepubip
                 */
                Build withAssociatePublicIpAddress(final java.lang.Boolean value);
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-associatepubip
                 */
                Build withAssociatePublicIpAddress(final software.amazon.awscdk.Token value);
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.DeleteOnTermination``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-delete
                 */
                Build withDeleteOnTermination(final java.lang.Boolean value);
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.DeleteOnTermination``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-delete
                 */
                Build withDeleteOnTermination(final software.amazon.awscdk.Token value);
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.Description``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-description
                 */
                Build withDescription(final java.lang.String value);
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.Description``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-description
                 */
                Build withDescription(final software.amazon.awscdk.Token value);
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.GroupSet``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-groupset
                 */
                Build withGroupSet(final software.amazon.awscdk.Token value);
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.GroupSet``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-groupset
                 */
                Build withGroupSet(final java.util.List<java.lang.Object> value);
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.Ipv6AddressCount``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresscount
                 */
                Build withIpv6AddressCount(final java.lang.Number value);
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.Ipv6AddressCount``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresscount
                 */
                Build withIpv6AddressCount(final software.amazon.awscdk.Token value);
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.Ipv6Addresses``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresses
                 */
                Build withIpv6Addresses(final software.amazon.awscdk.Token value);
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.Ipv6Addresses``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresses
                 */
                Build withIpv6Addresses(final java.util.List<java.lang.Object> value);
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.NetworkInterfaceId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-network-iface
                 */
                Build withNetworkInterfaceId(final java.lang.String value);
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.NetworkInterfaceId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-network-iface
                 */
                Build withNetworkInterfaceId(final software.amazon.awscdk.Token value);
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.PrivateIpAddress``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddress
                 */
                Build withPrivateIpAddress(final java.lang.String value);
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.PrivateIpAddress``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddress
                 */
                Build withPrivateIpAddress(final software.amazon.awscdk.Token value);
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.PrivateIpAddresses``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddresses
                 */
                Build withPrivateIpAddresses(final software.amazon.awscdk.Token value);
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.PrivateIpAddresses``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddresses
                 */
                Build withPrivateIpAddresses(final java.util.List<java.lang.Object> value);
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-secondprivateip
                 */
                Build withSecondaryPrivateIpAddressCount(final java.lang.Number value);
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-secondprivateip
                 */
                Build withSecondaryPrivateIpAddressCount(final software.amazon.awscdk.Token value);
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.SubnetId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-subnetid
                 */
                Build withSubnetId(final java.lang.String value);
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.SubnetId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-subnetid
                 */
                Build withSubnetId(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``InstanceResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-associatepubip
                 */
                public Build withAssociatePublicIpAddress(final java.lang.Boolean value) {
                    this.instance._associatePublicIpAddress = value;
                    return this;
                }
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-associatepubip
                 */
                public Build withAssociatePublicIpAddress(final software.amazon.awscdk.Token value) {
                    this.instance._associatePublicIpAddress = value;
                    return this;
                }
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.DeleteOnTermination``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-delete
                 */
                public Build withDeleteOnTermination(final java.lang.Boolean value) {
                    this.instance._deleteOnTermination = value;
                    return this;
                }
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.DeleteOnTermination``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-delete
                 */
                public Build withDeleteOnTermination(final software.amazon.awscdk.Token value) {
                    this.instance._deleteOnTermination = value;
                    return this;
                }
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.Description``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-description
                 */
                public Build withDescription(final java.lang.String value) {
                    this.instance._description = value;
                    return this;
                }
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.Description``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-description
                 */
                public Build withDescription(final software.amazon.awscdk.Token value) {
                    this.instance._description = value;
                    return this;
                }
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.DeviceIndex``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-deviceindex
                 */
                public Build withDeviceIndex(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "NetworkInterfaceProperty#deviceIndex is required");
                    this.instance._deviceIndex = value;
                    return this;
                }
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.DeviceIndex``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-deviceindex
                 */
                public Build withDeviceIndex(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "NetworkInterfaceProperty#deviceIndex is required");
                    this.instance._deviceIndex = value;
                    return this;
                }
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.GroupSet``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-groupset
                 */
                public Build withGroupSet(final software.amazon.awscdk.Token value) {
                    this.instance._groupSet = value;
                    return this;
                }
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.GroupSet``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-groupset
                 */
                public Build withGroupSet(final java.util.List<java.lang.Object> value) {
                    this.instance._groupSet = value;
                    return this;
                }
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.Ipv6AddressCount``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresscount
                 */
                public Build withIpv6AddressCount(final java.lang.Number value) {
                    this.instance._ipv6AddressCount = value;
                    return this;
                }
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.Ipv6AddressCount``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresscount
                 */
                public Build withIpv6AddressCount(final software.amazon.awscdk.Token value) {
                    this.instance._ipv6AddressCount = value;
                    return this;
                }
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.Ipv6Addresses``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresses
                 */
                public Build withIpv6Addresses(final software.amazon.awscdk.Token value) {
                    this.instance._ipv6Addresses = value;
                    return this;
                }
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.Ipv6Addresses``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresses
                 */
                public Build withIpv6Addresses(final java.util.List<java.lang.Object> value) {
                    this.instance._ipv6Addresses = value;
                    return this;
                }
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.NetworkInterfaceId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-network-iface
                 */
                public Build withNetworkInterfaceId(final java.lang.String value) {
                    this.instance._networkInterfaceId = value;
                    return this;
                }
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.NetworkInterfaceId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-network-iface
                 */
                public Build withNetworkInterfaceId(final software.amazon.awscdk.Token value) {
                    this.instance._networkInterfaceId = value;
                    return this;
                }
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.PrivateIpAddress``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddress
                 */
                public Build withPrivateIpAddress(final java.lang.String value) {
                    this.instance._privateIpAddress = value;
                    return this;
                }
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.PrivateIpAddress``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddress
                 */
                public Build withPrivateIpAddress(final software.amazon.awscdk.Token value) {
                    this.instance._privateIpAddress = value;
                    return this;
                }
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.PrivateIpAddresses``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddresses
                 */
                public Build withPrivateIpAddresses(final software.amazon.awscdk.Token value) {
                    this.instance._privateIpAddresses = value;
                    return this;
                }
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.PrivateIpAddresses``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddresses
                 */
                public Build withPrivateIpAddresses(final java.util.List<java.lang.Object> value) {
                    this.instance._privateIpAddresses = value;
                    return this;
                }
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-secondprivateip
                 */
                public Build withSecondaryPrivateIpAddressCount(final java.lang.Number value) {
                    this.instance._secondaryPrivateIpAddressCount = value;
                    return this;
                }
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-secondprivateip
                 */
                public Build withSecondaryPrivateIpAddressCount(final software.amazon.awscdk.Token value) {
                    this.instance._secondaryPrivateIpAddressCount = value;
                    return this;
                }
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.SubnetId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-subnetid
                 */
                public Build withSubnetId(final java.lang.String value) {
                    this.instance._subnetId = value;
                    return this;
                }
                /**
                 * ``InstanceResource.NetworkInterfaceProperty.SubnetId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-subnetid
                 */
                public Build withSubnetId(final software.amazon.awscdk.Token value) {
                    this.instance._subnetId = value;
                    return this;
                }
                public NetworkInterfaceProperty build() {
                    NetworkInterfaceProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link NetworkInterfaceProperty}.
         */
        final class Jsii$Pojo implements NetworkInterfaceProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _associatePublicIpAddress;

            public java.lang.Object getAssociatePublicIpAddress() {
                return this._associatePublicIpAddress;
            }
            public void setAssociatePublicIpAddress(final java.lang.Boolean value) {
                this._associatePublicIpAddress = value;
            }
            public void setAssociatePublicIpAddress(final software.amazon.awscdk.Token value) {
                this._associatePublicIpAddress = value;
            }

            protected java.lang.Object _deleteOnTermination;

            public java.lang.Object getDeleteOnTermination() {
                return this._deleteOnTermination;
            }
            public void setDeleteOnTermination(final java.lang.Boolean value) {
                this._deleteOnTermination = value;
            }
            public void setDeleteOnTermination(final software.amazon.awscdk.Token value) {
                this._deleteOnTermination = value;
            }

            protected java.lang.Object _description;

            public java.lang.Object getDescription() {
                return this._description;
            }
            public void setDescription(final java.lang.String value) {
                this._description = value;
            }
            public void setDescription(final software.amazon.awscdk.Token value) {
                this._description = value;
            }

            protected java.lang.Object _deviceIndex;

            public java.lang.Object getDeviceIndex() {
                return this._deviceIndex;
            }
            public void setDeviceIndex(final java.lang.String value) {
                this._deviceIndex = value;
            }
            public void setDeviceIndex(final software.amazon.awscdk.Token value) {
                this._deviceIndex = value;
            }

            protected java.lang.Object _groupSet;

            public java.lang.Object getGroupSet() {
                return this._groupSet;
            }
            public void setGroupSet(final software.amazon.awscdk.Token value) {
                this._groupSet = value;
            }
            public void setGroupSet(final java.util.List<java.lang.Object> value) {
                this._groupSet = value;
            }

            protected java.lang.Object _ipv6AddressCount;

            public java.lang.Object getIpv6AddressCount() {
                return this._ipv6AddressCount;
            }
            public void setIpv6AddressCount(final java.lang.Number value) {
                this._ipv6AddressCount = value;
            }
            public void setIpv6AddressCount(final software.amazon.awscdk.Token value) {
                this._ipv6AddressCount = value;
            }

            protected java.lang.Object _ipv6Addresses;

            public java.lang.Object getIpv6Addresses() {
                return this._ipv6Addresses;
            }
            public void setIpv6Addresses(final software.amazon.awscdk.Token value) {
                this._ipv6Addresses = value;
            }
            public void setIpv6Addresses(final java.util.List<java.lang.Object> value) {
                this._ipv6Addresses = value;
            }

            protected java.lang.Object _networkInterfaceId;

            public java.lang.Object getNetworkInterfaceId() {
                return this._networkInterfaceId;
            }
            public void setNetworkInterfaceId(final java.lang.String value) {
                this._networkInterfaceId = value;
            }
            public void setNetworkInterfaceId(final software.amazon.awscdk.Token value) {
                this._networkInterfaceId = value;
            }

            protected java.lang.Object _privateIpAddress;

            public java.lang.Object getPrivateIpAddress() {
                return this._privateIpAddress;
            }
            public void setPrivateIpAddress(final java.lang.String value) {
                this._privateIpAddress = value;
            }
            public void setPrivateIpAddress(final software.amazon.awscdk.Token value) {
                this._privateIpAddress = value;
            }

            protected java.lang.Object _privateIpAddresses;

            public java.lang.Object getPrivateIpAddresses() {
                return this._privateIpAddresses;
            }
            public void setPrivateIpAddresses(final software.amazon.awscdk.Token value) {
                this._privateIpAddresses = value;
            }
            public void setPrivateIpAddresses(final java.util.List<java.lang.Object> value) {
                this._privateIpAddresses = value;
            }

            protected java.lang.Object _secondaryPrivateIpAddressCount;

            public java.lang.Object getSecondaryPrivateIpAddressCount() {
                return this._secondaryPrivateIpAddressCount;
            }
            public void setSecondaryPrivateIpAddressCount(final java.lang.Number value) {
                this._secondaryPrivateIpAddressCount = value;
            }
            public void setSecondaryPrivateIpAddressCount(final software.amazon.awscdk.Token value) {
                this._secondaryPrivateIpAddressCount = value;
            }

            protected java.lang.Object _subnetId;

            public java.lang.Object getSubnetId() {
                return this._subnetId;
            }
            public void setSubnetId(final java.lang.String value) {
                this._subnetId = value;
            }
            public void setSubnetId(final software.amazon.awscdk.Token value) {
                this._subnetId = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.NetworkInterfaceProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-associatepubip
             */
            @javax.annotation.Nullable
            public java.lang.Object getAssociatePublicIpAddress() {
                return this.jsiiGet("associatePublicIpAddress", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-associatepubip
             */
            public void setAssociatePublicIpAddress(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("associatePublicIpAddress", value);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-associatepubip
             */
            public void setAssociatePublicIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("associatePublicIpAddress", value);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-delete
             */
            @javax.annotation.Nullable
            public java.lang.Object getDeleteOnTermination() {
                return this.jsiiGet("deleteOnTermination", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-delete
             */
            public void setDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("deleteOnTermination", value);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-delete
             */
            public void setDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("deleteOnTermination", value);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-description
             */
            @javax.annotation.Nullable
            public java.lang.Object getDescription() {
                return this.jsiiGet("description", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-description
             */
            public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("description", value);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-description
             */
            public void setDescription(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("description", value);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.DeviceIndex``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-deviceindex
             */
            public java.lang.Object getDeviceIndex() {
                return this.jsiiGet("deviceIndex", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.DeviceIndex``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-deviceindex
             */
            public void setDeviceIndex(final java.lang.String value) {
                this.jsiiSet("deviceIndex", java.util.Objects.requireNonNull(value, "deviceIndex is required"));
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.DeviceIndex``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-deviceindex
             */
            public void setDeviceIndex(final software.amazon.awscdk.Token value) {
                this.jsiiSet("deviceIndex", java.util.Objects.requireNonNull(value, "deviceIndex is required"));
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.GroupSet``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-groupset
             */
            @javax.annotation.Nullable
            public java.lang.Object getGroupSet() {
                return this.jsiiGet("groupSet", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.GroupSet``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-groupset
             */
            public void setGroupSet(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("groupSet", value);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.GroupSet``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-groupset
             */
            public void setGroupSet(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("groupSet", value);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresscount
             */
            @javax.annotation.Nullable
            public java.lang.Object getIpv6AddressCount() {
                return this.jsiiGet("ipv6AddressCount", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresscount
             */
            public void setIpv6AddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("ipv6AddressCount", value);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresscount
             */
            public void setIpv6AddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ipv6AddressCount", value);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresses
             */
            @javax.annotation.Nullable
            public java.lang.Object getIpv6Addresses() {
                return this.jsiiGet("ipv6Addresses", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresses
             */
            public void setIpv6Addresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ipv6Addresses", value);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresses
             */
            public void setIpv6Addresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("ipv6Addresses", value);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.NetworkInterfaceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-network-iface
             */
            @javax.annotation.Nullable
            public java.lang.Object getNetworkInterfaceId() {
                return this.jsiiGet("networkInterfaceId", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.NetworkInterfaceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-network-iface
             */
            public void setNetworkInterfaceId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("networkInterfaceId", value);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.NetworkInterfaceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-network-iface
             */
            public void setNetworkInterfaceId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("networkInterfaceId", value);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddress
             */
            @javax.annotation.Nullable
            public java.lang.Object getPrivateIpAddress() {
                return this.jsiiGet("privateIpAddress", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddress
             */
            public void setPrivateIpAddress(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("privateIpAddress", value);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddress
             */
            public void setPrivateIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("privateIpAddress", value);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddresses
             */
            @javax.annotation.Nullable
            public java.lang.Object getPrivateIpAddresses() {
                return this.jsiiGet("privateIpAddresses", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddresses
             */
            public void setPrivateIpAddresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("privateIpAddresses", value);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddresses
             */
            public void setPrivateIpAddresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("privateIpAddresses", value);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-secondprivateip
             */
            @javax.annotation.Nullable
            public java.lang.Object getSecondaryPrivateIpAddressCount() {
                return this.jsiiGet("secondaryPrivateIpAddressCount", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-secondprivateip
             */
            public void setSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("secondaryPrivateIpAddressCount", value);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-secondprivateip
             */
            public void setSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("secondaryPrivateIpAddressCount", value);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-subnetid
             */
            @javax.annotation.Nullable
            public java.lang.Object getSubnetId() {
                return this.jsiiGet("subnetId", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-subnetid
             */
            public void setSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("subnetId", value);
            }
            /**
             * ``InstanceResource.NetworkInterfaceProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-subnetid
             */
            public void setSubnetId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("subnetId", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-nodevice.html
     */
    public static interface NoDeviceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.NoDeviceProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html
     */
    public static interface PrivateIpAddressSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``InstanceResource.PrivateIpAddressSpecificationProperty.Primary``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
         */
        java.lang.Object getPrimary();
        /**
         * ``InstanceResource.PrivateIpAddressSpecificationProperty.Primary``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
         */
        void setPrimary(final java.lang.Boolean value);
        /**
         * ``InstanceResource.PrivateIpAddressSpecificationProperty.Primary``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
         */
        void setPrimary(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
         */
        java.lang.Object getPrivateIpAddress();
        /**
         * ``InstanceResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
         */
        void setPrivateIpAddress(final java.lang.String value);
        /**
         * ``InstanceResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
         */
        void setPrivateIpAddress(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link PrivateIpAddressSpecificationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``InstanceResource.PrivateIpAddressSpecificationProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
             */
            public PrivateIpAddressStep withPrimary(final java.lang.Boolean value) {
                return new FullBuilder().withPrimary(value);
            }
            /**
             * ``InstanceResource.PrivateIpAddressSpecificationProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
             */
            public PrivateIpAddressStep withPrimary(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withPrimary(value);
            }

            public interface PrivateIpAddressStep {
                /**
                 * ``InstanceResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
                 */
                Build withPrivateIpAddress(final java.lang.String value);
                /**
                 * ``InstanceResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
                 */
                Build withPrivateIpAddress(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link PrivateIpAddressSpecificationProperty} object, initialized with the values set on this builder.
                 */
                PrivateIpAddressSpecificationProperty build();
            }

            final class FullBuilder implements PrivateIpAddressStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``InstanceResource.PrivateIpAddressSpecificationProperty.Primary``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
                 */
                public PrivateIpAddressStep withPrimary(final java.lang.Boolean value) {
                    java.util.Objects.requireNonNull(value, "PrivateIpAddressSpecificationProperty#primary is required");
                    this.instance._primary = value;
                    return this;
                }
                /**
                 * ``InstanceResource.PrivateIpAddressSpecificationProperty.Primary``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
                 */
                public PrivateIpAddressStep withPrimary(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "PrivateIpAddressSpecificationProperty#primary is required");
                    this.instance._primary = value;
                    return this;
                }
                /**
                 * ``InstanceResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
                 */
                public Build withPrivateIpAddress(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "PrivateIpAddressSpecificationProperty#privateIpAddress is required");
                    this.instance._privateIpAddress = value;
                    return this;
                }
                /**
                 * ``InstanceResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
                 */
                public Build withPrivateIpAddress(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "PrivateIpAddressSpecificationProperty#privateIpAddress is required");
                    this.instance._privateIpAddress = value;
                    return this;
                }
                public PrivateIpAddressSpecificationProperty build() {
                    PrivateIpAddressSpecificationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link PrivateIpAddressSpecificationProperty}.
         */
        final class Jsii$Pojo implements PrivateIpAddressSpecificationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _primary;

            public java.lang.Object getPrimary() {
                return this._primary;
            }
            public void setPrimary(final java.lang.Boolean value) {
                this._primary = value;
            }
            public void setPrimary(final software.amazon.awscdk.Token value) {
                this._primary = value;
            }

            protected java.lang.Object _privateIpAddress;

            public java.lang.Object getPrivateIpAddress() {
                return this._privateIpAddress;
            }
            public void setPrivateIpAddress(final java.lang.String value) {
                this._privateIpAddress = value;
            }
            public void setPrivateIpAddress(final software.amazon.awscdk.Token value) {
                this._privateIpAddress = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.PrivateIpAddressSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``InstanceResource.PrivateIpAddressSpecificationProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
             */
            public java.lang.Object getPrimary() {
                return this.jsiiGet("primary", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.PrivateIpAddressSpecificationProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
             */
            public void setPrimary(final java.lang.Boolean value) {
                this.jsiiSet("primary", java.util.Objects.requireNonNull(value, "primary is required"));
            }
            /**
             * ``InstanceResource.PrivateIpAddressSpecificationProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
             */
            public void setPrimary(final software.amazon.awscdk.Token value) {
                this.jsiiSet("primary", java.util.Objects.requireNonNull(value, "primary is required"));
            }
            /**
             * ``InstanceResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
             */
            public java.lang.Object getPrivateIpAddress() {
                return this.jsiiGet("privateIpAddress", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
             */
            public void setPrivateIpAddress(final java.lang.String value) {
                this.jsiiSet("privateIpAddress", java.util.Objects.requireNonNull(value, "privateIpAddress is required"));
            }
            /**
             * ``InstanceResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
             */
            public void setPrivateIpAddress(final software.amazon.awscdk.Token value) {
                this.jsiiSet("privateIpAddress", java.util.Objects.requireNonNull(value, "privateIpAddress is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html
     */
    public static interface SsmAssociationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``InstanceResource.SsmAssociationProperty.AssociationParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-associationparameters
         */
        java.lang.Object getAssociationParameters();
        /**
         * ``InstanceResource.SsmAssociationProperty.AssociationParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-associationparameters
         */
        void setAssociationParameters(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.SsmAssociationProperty.AssociationParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-associationparameters
         */
        void setAssociationParameters(final java.util.List<java.lang.Object> value);
        /**
         * ``InstanceResource.SsmAssociationProperty.DocumentName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-documentname
         */
        java.lang.Object getDocumentName();
        /**
         * ``InstanceResource.SsmAssociationProperty.DocumentName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-documentname
         */
        void setDocumentName(final java.lang.String value);
        /**
         * ``InstanceResource.SsmAssociationProperty.DocumentName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-documentname
         */
        void setDocumentName(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link SsmAssociationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``InstanceResource.SsmAssociationProperty.DocumentName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-documentname
             */
            public Build withDocumentName(final java.lang.String value) {
                return new FullBuilder().withDocumentName(value);
            }
            /**
             * ``InstanceResource.SsmAssociationProperty.DocumentName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-documentname
             */
            public Build withDocumentName(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withDocumentName(value);
            }

            public interface Build {
                /**
                 * @return a new {@link SsmAssociationProperty} object, initialized with the values set on this builder.
                 */
                SsmAssociationProperty build();
                /**
                 * ``InstanceResource.SsmAssociationProperty.AssociationParameters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-associationparameters
                 */
                Build withAssociationParameters(final software.amazon.awscdk.Token value);
                /**
                 * ``InstanceResource.SsmAssociationProperty.AssociationParameters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-associationparameters
                 */
                Build withAssociationParameters(final java.util.List<java.lang.Object> value);
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``InstanceResource.SsmAssociationProperty.AssociationParameters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-associationparameters
                 */
                public Build withAssociationParameters(final software.amazon.awscdk.Token value) {
                    this.instance._associationParameters = value;
                    return this;
                }
                /**
                 * ``InstanceResource.SsmAssociationProperty.AssociationParameters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-associationparameters
                 */
                public Build withAssociationParameters(final java.util.List<java.lang.Object> value) {
                    this.instance._associationParameters = value;
                    return this;
                }
                /**
                 * ``InstanceResource.SsmAssociationProperty.DocumentName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-documentname
                 */
                public Build withDocumentName(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "SsmAssociationProperty#documentName is required");
                    this.instance._documentName = value;
                    return this;
                }
                /**
                 * ``InstanceResource.SsmAssociationProperty.DocumentName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-documentname
                 */
                public Build withDocumentName(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "SsmAssociationProperty#documentName is required");
                    this.instance._documentName = value;
                    return this;
                }
                public SsmAssociationProperty build() {
                    SsmAssociationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link SsmAssociationProperty}.
         */
        final class Jsii$Pojo implements SsmAssociationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _associationParameters;

            public java.lang.Object getAssociationParameters() {
                return this._associationParameters;
            }
            public void setAssociationParameters(final software.amazon.awscdk.Token value) {
                this._associationParameters = value;
            }
            public void setAssociationParameters(final java.util.List<java.lang.Object> value) {
                this._associationParameters = value;
            }

            protected java.lang.Object _documentName;

            public java.lang.Object getDocumentName() {
                return this._documentName;
            }
            public void setDocumentName(final java.lang.String value) {
                this._documentName = value;
            }
            public void setDocumentName(final software.amazon.awscdk.Token value) {
                this._documentName = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.SsmAssociationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``InstanceResource.SsmAssociationProperty.AssociationParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-associationparameters
             */
            @javax.annotation.Nullable
            public java.lang.Object getAssociationParameters() {
                return this.jsiiGet("associationParameters", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.SsmAssociationProperty.AssociationParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-associationparameters
             */
            public void setAssociationParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("associationParameters", value);
            }
            /**
             * ``InstanceResource.SsmAssociationProperty.AssociationParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-associationparameters
             */
            public void setAssociationParameters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("associationParameters", value);
            }
            /**
             * ``InstanceResource.SsmAssociationProperty.DocumentName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-documentname
             */
            public java.lang.Object getDocumentName() {
                return this.jsiiGet("documentName", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.SsmAssociationProperty.DocumentName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-documentname
             */
            public void setDocumentName(final java.lang.String value) {
                this.jsiiSet("documentName", java.util.Objects.requireNonNull(value, "documentName is required"));
            }
            /**
             * ``InstanceResource.SsmAssociationProperty.DocumentName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-documentname
             */
            public void setDocumentName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("documentName", java.util.Objects.requireNonNull(value, "documentName is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html
     */
    public static interface VolumeProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``InstanceResource.VolumeProperty.Device``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-device
         */
        java.lang.Object getDevice();
        /**
         * ``InstanceResource.VolumeProperty.Device``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-device
         */
        void setDevice(final java.lang.String value);
        /**
         * ``InstanceResource.VolumeProperty.Device``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-device
         */
        void setDevice(final software.amazon.awscdk.Token value);
        /**
         * ``InstanceResource.VolumeProperty.VolumeId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-volumeid
         */
        java.lang.Object getVolumeId();
        /**
         * ``InstanceResource.VolumeProperty.VolumeId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-volumeid
         */
        void setVolumeId(final java.lang.String value);
        /**
         * ``InstanceResource.VolumeProperty.VolumeId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-volumeid
         */
        void setVolumeId(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link VolumeProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``InstanceResource.VolumeProperty.Device``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-device
             */
            public VolumeIdStep withDevice(final java.lang.String value) {
                return new FullBuilder().withDevice(value);
            }
            /**
             * ``InstanceResource.VolumeProperty.Device``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-device
             */
            public VolumeIdStep withDevice(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withDevice(value);
            }

            public interface VolumeIdStep {
                /**
                 * ``InstanceResource.VolumeProperty.VolumeId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-volumeid
                 */
                Build withVolumeId(final java.lang.String value);
                /**
                 * ``InstanceResource.VolumeProperty.VolumeId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-volumeid
                 */
                Build withVolumeId(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link VolumeProperty} object, initialized with the values set on this builder.
                 */
                VolumeProperty build();
            }

            final class FullBuilder implements VolumeIdStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``InstanceResource.VolumeProperty.Device``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-device
                 */
                public VolumeIdStep withDevice(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "VolumeProperty#device is required");
                    this.instance._device = value;
                    return this;
                }
                /**
                 * ``InstanceResource.VolumeProperty.Device``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-device
                 */
                public VolumeIdStep withDevice(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "VolumeProperty#device is required");
                    this.instance._device = value;
                    return this;
                }
                /**
                 * ``InstanceResource.VolumeProperty.VolumeId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-volumeid
                 */
                public Build withVolumeId(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "VolumeProperty#volumeId is required");
                    this.instance._volumeId = value;
                    return this;
                }
                /**
                 * ``InstanceResource.VolumeProperty.VolumeId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-volumeid
                 */
                public Build withVolumeId(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "VolumeProperty#volumeId is required");
                    this.instance._volumeId = value;
                    return this;
                }
                public VolumeProperty build() {
                    VolumeProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link VolumeProperty}.
         */
        final class Jsii$Pojo implements VolumeProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _device;

            public java.lang.Object getDevice() {
                return this._device;
            }
            public void setDevice(final java.lang.String value) {
                this._device = value;
            }
            public void setDevice(final software.amazon.awscdk.Token value) {
                this._device = value;
            }

            protected java.lang.Object _volumeId;

            public java.lang.Object getVolumeId() {
                return this._volumeId;
            }
            public void setVolumeId(final java.lang.String value) {
                this._volumeId = value;
            }
            public void setVolumeId(final software.amazon.awscdk.Token value) {
                this._volumeId = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.VolumeProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``InstanceResource.VolumeProperty.Device``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-device
             */
            public java.lang.Object getDevice() {
                return this.jsiiGet("device", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.VolumeProperty.Device``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-device
             */
            public void setDevice(final java.lang.String value) {
                this.jsiiSet("device", java.util.Objects.requireNonNull(value, "device is required"));
            }
            /**
             * ``InstanceResource.VolumeProperty.Device``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-device
             */
            public void setDevice(final software.amazon.awscdk.Token value) {
                this.jsiiSet("device", java.util.Objects.requireNonNull(value, "device is required"));
            }
            /**
             * ``InstanceResource.VolumeProperty.VolumeId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-volumeid
             */
            public java.lang.Object getVolumeId() {
                return this.jsiiGet("volumeId", java.lang.Object.class);
            }
            /**
             * ``InstanceResource.VolumeProperty.VolumeId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-volumeid
             */
            public void setVolumeId(final java.lang.String value) {
                this.jsiiSet("volumeId", java.util.Objects.requireNonNull(value, "volumeId is required"));
            }
            /**
             * ``InstanceResource.VolumeProperty.VolumeId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-volumeid
             */
            public void setVolumeId(final software.amazon.awscdk.Token value) {
                this.jsiiSet("volumeId", java.util.Objects.requireNonNull(value, "volumeId is required"));
            }
        }
    }
}
