package software.amazon.awscdk.services.ec2.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.cloudformation.LaunchTemplateResource")
public class LaunchTemplateResource extends software.amazon.awscdk.Resource {
    protected LaunchTemplateResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::EC2::LaunchTemplate``.
     * @param parent the ``cdk.Construct`` this ``LaunchTemplateResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``LaunchTemplateResource``
     */
    public LaunchTemplateResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(properties)).toArray());
    }
    /**
     * Creates a new ``AWS::EC2::LaunchTemplate``.
     * @param parent the ``cdk.Construct`` this ``LaunchTemplateResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     */
    public LaunchTemplateResource(final software.amazon.awscdk.Construct parent, final java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @cloudformation_attribute DefaultVersionNumber
     */
    public software.amazon.awscdk.services.ec2.LaunchTemplateDefaultVersionNumber getLaunchTemplateDefaultVersionNumber() {
        return this.jsiiGet("launchTemplateDefaultVersionNumber", software.amazon.awscdk.services.ec2.LaunchTemplateDefaultVersionNumber.class);
    }
    /**
     * @cloudformation_attribute LatestVersionNumber
     */
    public software.amazon.awscdk.services.ec2.LaunchTemplateLatestVersionNumber getLaunchTemplateLatestVersionNumber() {
        return this.jsiiGet("launchTemplateLatestVersionNumber", software.amazon.awscdk.services.ec2.LaunchTemplateLatestVersionNumber.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html
     */
    public static interface BlockDeviceMappingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.BlockDeviceMappingProperty.DeviceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-devicename
         */
        java.lang.Object getDeviceName();
        /**
         * ``LaunchTemplateResource.BlockDeviceMappingProperty.DeviceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-devicename
         */
        void setDeviceName(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.BlockDeviceMappingProperty.DeviceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-devicename
         */
        void setDeviceName(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.BlockDeviceMappingProperty.Ebs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs
         */
        java.lang.Object getEbs();
        /**
         * ``LaunchTemplateResource.BlockDeviceMappingProperty.Ebs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs
         */
        void setEbs(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.BlockDeviceMappingProperty.Ebs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs
         */
        void setEbs(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.EbsProperty value);
        /**
         * ``LaunchTemplateResource.BlockDeviceMappingProperty.NoDevice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-nodevice
         */
        java.lang.Object getNoDevice();
        /**
         * ``LaunchTemplateResource.BlockDeviceMappingProperty.NoDevice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-nodevice
         */
        void setNoDevice(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.BlockDeviceMappingProperty.NoDevice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-nodevice
         */
        void setNoDevice(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.BlockDeviceMappingProperty.VirtualName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-virtualname
         */
        java.lang.Object getVirtualName();
        /**
         * ``LaunchTemplateResource.BlockDeviceMappingProperty.VirtualName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-virtualname
         */
        void setVirtualName(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.BlockDeviceMappingProperty.VirtualName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-virtualname
         */
        void setVirtualName(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link BlockDeviceMappingProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.DeviceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-devicename
             */
            public Builder withDeviceName(final java.lang.String value) {
                this.instance._deviceName = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.DeviceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-devicename
             */
            public Builder withDeviceName(final software.amazon.awscdk.Token value) {
                this.instance._deviceName = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.Ebs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs
             */
            public Builder withEbs(final software.amazon.awscdk.Token value) {
                this.instance._ebs = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.Ebs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs
             */
            public Builder withEbs(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.EbsProperty value) {
                this.instance._ebs = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.NoDevice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-nodevice
             */
            public Builder withNoDevice(final java.lang.String value) {
                this.instance._noDevice = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.NoDevice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-nodevice
             */
            public Builder withNoDevice(final software.amazon.awscdk.Token value) {
                this.instance._noDevice = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.VirtualName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-virtualname
             */
            public Builder withVirtualName(final java.lang.String value) {
                this.instance._virtualName = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.VirtualName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-virtualname
             */
            public Builder withVirtualName(final software.amazon.awscdk.Token value) {
                this.instance._virtualName = value;
                return this;
            }
            public BlockDeviceMappingProperty build() {
                BlockDeviceMappingProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link BlockDeviceMappingProperty}.
         */
        final class Jsii$Pojo implements BlockDeviceMappingProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _deviceName;

            public java.lang.Object getDeviceName() {
                return this._deviceName;
            }
            public void setDeviceName(final java.lang.String value) {
                this._deviceName = value;
            }
            public void setDeviceName(final software.amazon.awscdk.Token value) {
                this._deviceName = value;
            }

            protected java.lang.Object _ebs;

            public java.lang.Object getEbs() {
                return this._ebs;
            }
            public void setEbs(final software.amazon.awscdk.Token value) {
                this._ebs = value;
            }
            public void setEbs(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.EbsProperty value) {
                this._ebs = value;
            }

            protected java.lang.Object _noDevice;

            public java.lang.Object getNoDevice() {
                return this._noDevice;
            }
            public void setNoDevice(final java.lang.String value) {
                this._noDevice = value;
            }
            public void setNoDevice(final software.amazon.awscdk.Token value) {
                this._noDevice = value;
            }

            protected java.lang.Object _virtualName;

            public java.lang.Object getVirtualName() {
                return this._virtualName;
            }
            public void setVirtualName(final java.lang.String value) {
                this._virtualName = value;
            }
            public void setVirtualName(final software.amazon.awscdk.Token value) {
                this._virtualName = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.BlockDeviceMappingProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.DeviceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-devicename
             */
            @javax.annotation.Nullable
            public java.lang.Object getDeviceName() {
                return this.jsiiGet("deviceName", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.DeviceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-devicename
             */
            public void setDeviceName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("deviceName", value);
            }
            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.DeviceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-devicename
             */
            public void setDeviceName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("deviceName", value);
            }
            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.Ebs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs
             */
            @javax.annotation.Nullable
            public java.lang.Object getEbs() {
                return this.jsiiGet("ebs", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.Ebs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs
             */
            public void setEbs(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ebs", value);
            }
            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.Ebs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs
             */
            public void setEbs(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.EbsProperty value) {
                this.jsiiSet("ebs", value);
            }
            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.NoDevice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-nodevice
             */
            @javax.annotation.Nullable
            public java.lang.Object getNoDevice() {
                return this.jsiiGet("noDevice", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.NoDevice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-nodevice
             */
            public void setNoDevice(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("noDevice", value);
            }
            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.NoDevice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-nodevice
             */
            public void setNoDevice(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("noDevice", value);
            }
            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.VirtualName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-virtualname
             */
            @javax.annotation.Nullable
            public java.lang.Object getVirtualName() {
                return this.jsiiGet("virtualName", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.VirtualName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-virtualname
             */
            public void setVirtualName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("virtualName", value);
            }
            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.VirtualName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-virtualname
             */
            public void setVirtualName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("virtualName", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html
     */
    public static interface CreditSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.CreditSpecificationProperty.CpuCredits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification-cpucredits
         */
        java.lang.Object getCpuCredits();
        /**
         * ``LaunchTemplateResource.CreditSpecificationProperty.CpuCredits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification-cpucredits
         */
        void setCpuCredits(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.CreditSpecificationProperty.CpuCredits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification-cpucredits
         */
        void setCpuCredits(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link CreditSpecificationProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``LaunchTemplateResource.CreditSpecificationProperty.CpuCredits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification-cpucredits
             */
            public Builder withCpuCredits(final java.lang.String value) {
                this.instance._cpuCredits = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.CreditSpecificationProperty.CpuCredits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification-cpucredits
             */
            public Builder withCpuCredits(final software.amazon.awscdk.Token value) {
                this.instance._cpuCredits = value;
                return this;
            }
            public CreditSpecificationProperty build() {
                CreditSpecificationProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link CreditSpecificationProperty}.
         */
        final class Jsii$Pojo implements CreditSpecificationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _cpuCredits;

            public java.lang.Object getCpuCredits() {
                return this._cpuCredits;
            }
            public void setCpuCredits(final java.lang.String value) {
                this._cpuCredits = value;
            }
            public void setCpuCredits(final software.amazon.awscdk.Token value) {
                this._cpuCredits = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.CreditSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``LaunchTemplateResource.CreditSpecificationProperty.CpuCredits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification-cpucredits
             */
            @javax.annotation.Nullable
            public java.lang.Object getCpuCredits() {
                return this.jsiiGet("cpuCredits", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.CreditSpecificationProperty.CpuCredits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification-cpucredits
             */
            public void setCpuCredits(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("cpuCredits", value);
            }
            /**
             * ``LaunchTemplateResource.CreditSpecificationProperty.CpuCredits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification-cpucredits
             */
            public void setCpuCredits(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cpuCredits", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html
     */
    public static interface EbsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.EbsProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-deleteontermination
         */
        java.lang.Object getDeleteOnTermination();
        /**
         * ``LaunchTemplateResource.EbsProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-deleteontermination
         */
        void setDeleteOnTermination(final java.lang.Boolean value);
        /**
         * ``LaunchTemplateResource.EbsProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-deleteontermination
         */
        void setDeleteOnTermination(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.EbsProperty.Encrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-encrypted
         */
        java.lang.Object getEncrypted();
        /**
         * ``LaunchTemplateResource.EbsProperty.Encrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-encrypted
         */
        void setEncrypted(final java.lang.Boolean value);
        /**
         * ``LaunchTemplateResource.EbsProperty.Encrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-encrypted
         */
        void setEncrypted(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.EbsProperty.Iops``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-iops
         */
        java.lang.Object getIops();
        /**
         * ``LaunchTemplateResource.EbsProperty.Iops``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-iops
         */
        void setIops(final java.lang.Number value);
        /**
         * ``LaunchTemplateResource.EbsProperty.Iops``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-iops
         */
        void setIops(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.EbsProperty.KmsKeyId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-kmskeyid
         */
        java.lang.Object getKmsKeyId();
        /**
         * ``LaunchTemplateResource.EbsProperty.KmsKeyId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-kmskeyid
         */
        void setKmsKeyId(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.EbsProperty.KmsKeyId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-kmskeyid
         */
        void setKmsKeyId(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.EbsProperty.SnapshotId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-snapshotid
         */
        java.lang.Object getSnapshotId();
        /**
         * ``LaunchTemplateResource.EbsProperty.SnapshotId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-snapshotid
         */
        void setSnapshotId(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.EbsProperty.SnapshotId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-snapshotid
         */
        void setSnapshotId(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.EbsProperty.VolumeSize``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumesize
         */
        java.lang.Object getVolumeSize();
        /**
         * ``LaunchTemplateResource.EbsProperty.VolumeSize``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumesize
         */
        void setVolumeSize(final java.lang.Number value);
        /**
         * ``LaunchTemplateResource.EbsProperty.VolumeSize``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumesize
         */
        void setVolumeSize(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.EbsProperty.VolumeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumetype
         */
        java.lang.Object getVolumeType();
        /**
         * ``LaunchTemplateResource.EbsProperty.VolumeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumetype
         */
        void setVolumeType(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.EbsProperty.VolumeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumetype
         */
        void setVolumeType(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link EbsProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``LaunchTemplateResource.EbsProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-deleteontermination
             */
            public Builder withDeleteOnTermination(final java.lang.Boolean value) {
                this.instance._deleteOnTermination = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-deleteontermination
             */
            public Builder withDeleteOnTermination(final software.amazon.awscdk.Token value) {
                this.instance._deleteOnTermination = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.Encrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-encrypted
             */
            public Builder withEncrypted(final java.lang.Boolean value) {
                this.instance._encrypted = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.Encrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-encrypted
             */
            public Builder withEncrypted(final software.amazon.awscdk.Token value) {
                this.instance._encrypted = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.Iops``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-iops
             */
            public Builder withIops(final java.lang.Number value) {
                this.instance._iops = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.Iops``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-iops
             */
            public Builder withIops(final software.amazon.awscdk.Token value) {
                this.instance._iops = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.KmsKeyId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-kmskeyid
             */
            public Builder withKmsKeyId(final java.lang.String value) {
                this.instance._kmsKeyId = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.KmsKeyId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-kmskeyid
             */
            public Builder withKmsKeyId(final software.amazon.awscdk.Token value) {
                this.instance._kmsKeyId = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.SnapshotId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-snapshotid
             */
            public Builder withSnapshotId(final java.lang.String value) {
                this.instance._snapshotId = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.SnapshotId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-snapshotid
             */
            public Builder withSnapshotId(final software.amazon.awscdk.Token value) {
                this.instance._snapshotId = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.VolumeSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumesize
             */
            public Builder withVolumeSize(final java.lang.Number value) {
                this.instance._volumeSize = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.VolumeSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumesize
             */
            public Builder withVolumeSize(final software.amazon.awscdk.Token value) {
                this.instance._volumeSize = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.VolumeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumetype
             */
            public Builder withVolumeType(final java.lang.String value) {
                this.instance._volumeType = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.VolumeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumetype
             */
            public Builder withVolumeType(final software.amazon.awscdk.Token value) {
                this.instance._volumeType = value;
                return this;
            }
            public EbsProperty build() {
                EbsProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link EbsProperty}.
         */
        final class Jsii$Pojo implements EbsProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _deleteOnTermination;

            public java.lang.Object getDeleteOnTermination() {
                return this._deleteOnTermination;
            }
            public void setDeleteOnTermination(final java.lang.Boolean value) {
                this._deleteOnTermination = value;
            }
            public void setDeleteOnTermination(final software.amazon.awscdk.Token value) {
                this._deleteOnTermination = value;
            }

            protected java.lang.Object _encrypted;

            public java.lang.Object getEncrypted() {
                return this._encrypted;
            }
            public void setEncrypted(final java.lang.Boolean value) {
                this._encrypted = value;
            }
            public void setEncrypted(final software.amazon.awscdk.Token value) {
                this._encrypted = value;
            }

            protected java.lang.Object _iops;

            public java.lang.Object getIops() {
                return this._iops;
            }
            public void setIops(final java.lang.Number value) {
                this._iops = value;
            }
            public void setIops(final software.amazon.awscdk.Token value) {
                this._iops = value;
            }

            protected java.lang.Object _kmsKeyId;

            public java.lang.Object getKmsKeyId() {
                return this._kmsKeyId;
            }
            public void setKmsKeyId(final java.lang.String value) {
                this._kmsKeyId = value;
            }
            public void setKmsKeyId(final software.amazon.awscdk.Token value) {
                this._kmsKeyId = value;
            }

            protected java.lang.Object _snapshotId;

            public java.lang.Object getSnapshotId() {
                return this._snapshotId;
            }
            public void setSnapshotId(final java.lang.String value) {
                this._snapshotId = value;
            }
            public void setSnapshotId(final software.amazon.awscdk.Token value) {
                this._snapshotId = value;
            }

            protected java.lang.Object _volumeSize;

            public java.lang.Object getVolumeSize() {
                return this._volumeSize;
            }
            public void setVolumeSize(final java.lang.Number value) {
                this._volumeSize = value;
            }
            public void setVolumeSize(final software.amazon.awscdk.Token value) {
                this._volumeSize = value;
            }

            protected java.lang.Object _volumeType;

            public java.lang.Object getVolumeType() {
                return this._volumeType;
            }
            public void setVolumeType(final java.lang.String value) {
                this._volumeType = value;
            }
            public void setVolumeType(final software.amazon.awscdk.Token value) {
                this._volumeType = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.EbsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-deleteontermination
             */
            @javax.annotation.Nullable
            public java.lang.Object getDeleteOnTermination() {
                return this.jsiiGet("deleteOnTermination", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-deleteontermination
             */
            public void setDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("deleteOnTermination", value);
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-deleteontermination
             */
            public void setDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("deleteOnTermination", value);
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.Encrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-encrypted
             */
            @javax.annotation.Nullable
            public java.lang.Object getEncrypted() {
                return this.jsiiGet("encrypted", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.Encrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-encrypted
             */
            public void setEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("encrypted", value);
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.Encrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-encrypted
             */
            public void setEncrypted(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("encrypted", value);
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.Iops``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-iops
             */
            @javax.annotation.Nullable
            public java.lang.Object getIops() {
                return this.jsiiGet("iops", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.Iops``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-iops
             */
            public void setIops(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("iops", value);
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.Iops``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-iops
             */
            public void setIops(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("iops", value);
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.KmsKeyId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-kmskeyid
             */
            @javax.annotation.Nullable
            public java.lang.Object getKmsKeyId() {
                return this.jsiiGet("kmsKeyId", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.KmsKeyId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-kmskeyid
             */
            public void setKmsKeyId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("kmsKeyId", value);
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.KmsKeyId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-kmskeyid
             */
            public void setKmsKeyId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("kmsKeyId", value);
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.SnapshotId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-snapshotid
             */
            @javax.annotation.Nullable
            public java.lang.Object getSnapshotId() {
                return this.jsiiGet("snapshotId", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.SnapshotId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-snapshotid
             */
            public void setSnapshotId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("snapshotId", value);
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.SnapshotId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-snapshotid
             */
            public void setSnapshotId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("snapshotId", value);
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.VolumeSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumesize
             */
            @javax.annotation.Nullable
            public java.lang.Object getVolumeSize() {
                return this.jsiiGet("volumeSize", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.VolumeSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumesize
             */
            public void setVolumeSize(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("volumeSize", value);
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.VolumeSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumesize
             */
            public void setVolumeSize(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("volumeSize", value);
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.VolumeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumetype
             */
            @javax.annotation.Nullable
            public java.lang.Object getVolumeType() {
                return this.jsiiGet("volumeType", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.VolumeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumetype
             */
            public void setVolumeType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("volumeType", value);
            }
            /**
             * ``LaunchTemplateResource.EbsProperty.VolumeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumetype
             */
            public void setVolumeType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("volumeType", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html
     */
    public static interface ElasticGpuSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.ElasticGpuSpecificationProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html#cfn-ec2-launchtemplate-elasticgpuspecification-type
         */
        java.lang.Object getType();
        /**
         * ``LaunchTemplateResource.ElasticGpuSpecificationProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html#cfn-ec2-launchtemplate-elasticgpuspecification-type
         */
        void setType(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.ElasticGpuSpecificationProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html#cfn-ec2-launchtemplate-elasticgpuspecification-type
         */
        void setType(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link ElasticGpuSpecificationProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``LaunchTemplateResource.ElasticGpuSpecificationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html#cfn-ec2-launchtemplate-elasticgpuspecification-type
             */
            public Builder withType(final java.lang.String value) {
                this.instance._type = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.ElasticGpuSpecificationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html#cfn-ec2-launchtemplate-elasticgpuspecification-type
             */
            public Builder withType(final software.amazon.awscdk.Token value) {
                this.instance._type = value;
                return this;
            }
            public ElasticGpuSpecificationProperty build() {
                ElasticGpuSpecificationProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link ElasticGpuSpecificationProperty}.
         */
        final class Jsii$Pojo implements ElasticGpuSpecificationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _type;

            public java.lang.Object getType() {
                return this._type;
            }
            public void setType(final java.lang.String value) {
                this._type = value;
            }
            public void setType(final software.amazon.awscdk.Token value) {
                this._type = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.ElasticGpuSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``LaunchTemplateResource.ElasticGpuSpecificationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html#cfn-ec2-launchtemplate-elasticgpuspecification-type
             */
            @javax.annotation.Nullable
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.ElasticGpuSpecificationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html#cfn-ec2-launchtemplate-elasticgpuspecification-type
             */
            public void setType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("type", value);
            }
            /**
             * ``LaunchTemplateResource.ElasticGpuSpecificationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html#cfn-ec2-launchtemplate-elasticgpuspecification-type
             */
            public void setType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("type", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html
     */
    public static interface IamInstanceProfileProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.IamInstanceProfileProperty.Arn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-arn
         */
        java.lang.Object getArn();
        /**
         * ``LaunchTemplateResource.IamInstanceProfileProperty.Arn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-arn
         */
        void setArn(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.IamInstanceProfileProperty.Arn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-arn
         */
        void setArn(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.IamInstanceProfileProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-name
         */
        java.lang.Object getName();
        /**
         * ``LaunchTemplateResource.IamInstanceProfileProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-name
         */
        void setName(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.IamInstanceProfileProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-name
         */
        void setName(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link IamInstanceProfileProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``LaunchTemplateResource.IamInstanceProfileProperty.Arn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-arn
             */
            public Builder withArn(final java.lang.String value) {
                this.instance._arn = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.IamInstanceProfileProperty.Arn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-arn
             */
            public Builder withArn(final software.amazon.awscdk.Token value) {
                this.instance._arn = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.IamInstanceProfileProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-name
             */
            public Builder withName(final java.lang.String value) {
                this.instance._name = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.IamInstanceProfileProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-name
             */
            public Builder withName(final software.amazon.awscdk.Token value) {
                this.instance._name = value;
                return this;
            }
            public IamInstanceProfileProperty build() {
                IamInstanceProfileProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link IamInstanceProfileProperty}.
         */
        final class Jsii$Pojo implements IamInstanceProfileProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _arn;

            public java.lang.Object getArn() {
                return this._arn;
            }
            public void setArn(final java.lang.String value) {
                this._arn = value;
            }
            public void setArn(final software.amazon.awscdk.Token value) {
                this._arn = value;
            }

            protected java.lang.Object _name;

            public java.lang.Object getName() {
                return this._name;
            }
            public void setName(final java.lang.String value) {
                this._name = value;
            }
            public void setName(final software.amazon.awscdk.Token value) {
                this._name = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.IamInstanceProfileProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``LaunchTemplateResource.IamInstanceProfileProperty.Arn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-arn
             */
            @javax.annotation.Nullable
            public java.lang.Object getArn() {
                return this.jsiiGet("arn", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.IamInstanceProfileProperty.Arn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-arn
             */
            public void setArn(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("arn", value);
            }
            /**
             * ``LaunchTemplateResource.IamInstanceProfileProperty.Arn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-arn
             */
            public void setArn(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("arn", value);
            }
            /**
             * ``LaunchTemplateResource.IamInstanceProfileProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-name
             */
            @javax.annotation.Nullable
            public java.lang.Object getName() {
                return this.jsiiGet("name", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.IamInstanceProfileProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-name
             */
            public void setName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("name", value);
            }
            /**
             * ``LaunchTemplateResource.IamInstanceProfileProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-name
             */
            public void setName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("name", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html
     */
    public static interface InstanceMarketOptionsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.InstanceMarketOptionsProperty.MarketType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-markettype
         */
        java.lang.Object getMarketType();
        /**
         * ``LaunchTemplateResource.InstanceMarketOptionsProperty.MarketType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-markettype
         */
        void setMarketType(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.InstanceMarketOptionsProperty.MarketType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-markettype
         */
        void setMarketType(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.InstanceMarketOptionsProperty.SpotOptions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions
         */
        java.lang.Object getSpotOptions();
        /**
         * ``LaunchTemplateResource.InstanceMarketOptionsProperty.SpotOptions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions
         */
        void setSpotOptions(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.InstanceMarketOptionsProperty.SpotOptions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions
         */
        void setSpotOptions(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.SpotOptionsProperty value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link InstanceMarketOptionsProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``LaunchTemplateResource.InstanceMarketOptionsProperty.MarketType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-markettype
             */
            public Builder withMarketType(final java.lang.String value) {
                this.instance._marketType = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.InstanceMarketOptionsProperty.MarketType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-markettype
             */
            public Builder withMarketType(final software.amazon.awscdk.Token value) {
                this.instance._marketType = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.InstanceMarketOptionsProperty.SpotOptions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions
             */
            public Builder withSpotOptions(final software.amazon.awscdk.Token value) {
                this.instance._spotOptions = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.InstanceMarketOptionsProperty.SpotOptions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions
             */
            public Builder withSpotOptions(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.SpotOptionsProperty value) {
                this.instance._spotOptions = value;
                return this;
            }
            public InstanceMarketOptionsProperty build() {
                InstanceMarketOptionsProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link InstanceMarketOptionsProperty}.
         */
        final class Jsii$Pojo implements InstanceMarketOptionsProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _marketType;

            public java.lang.Object getMarketType() {
                return this._marketType;
            }
            public void setMarketType(final java.lang.String value) {
                this._marketType = value;
            }
            public void setMarketType(final software.amazon.awscdk.Token value) {
                this._marketType = value;
            }

            protected java.lang.Object _spotOptions;

            public java.lang.Object getSpotOptions() {
                return this._spotOptions;
            }
            public void setSpotOptions(final software.amazon.awscdk.Token value) {
                this._spotOptions = value;
            }
            public void setSpotOptions(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.SpotOptionsProperty value) {
                this._spotOptions = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.InstanceMarketOptionsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``LaunchTemplateResource.InstanceMarketOptionsProperty.MarketType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-markettype
             */
            @javax.annotation.Nullable
            public java.lang.Object getMarketType() {
                return this.jsiiGet("marketType", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.InstanceMarketOptionsProperty.MarketType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-markettype
             */
            public void setMarketType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("marketType", value);
            }
            /**
             * ``LaunchTemplateResource.InstanceMarketOptionsProperty.MarketType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-markettype
             */
            public void setMarketType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("marketType", value);
            }
            /**
             * ``LaunchTemplateResource.InstanceMarketOptionsProperty.SpotOptions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions
             */
            @javax.annotation.Nullable
            public java.lang.Object getSpotOptions() {
                return this.jsiiGet("spotOptions", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.InstanceMarketOptionsProperty.SpotOptions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions
             */
            public void setSpotOptions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("spotOptions", value);
            }
            /**
             * ``LaunchTemplateResource.InstanceMarketOptionsProperty.SpotOptions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions
             */
            public void setSpotOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.SpotOptionsProperty value) {
                this.jsiiSet("spotOptions", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html
     */
    public static interface Ipv6AddProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.Ipv6AddProperty.Ipv6Address``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html#cfn-ec2-launchtemplate-ipv6add-ipv6address
         */
        java.lang.Object getIpv6Address();
        /**
         * ``LaunchTemplateResource.Ipv6AddProperty.Ipv6Address``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html#cfn-ec2-launchtemplate-ipv6add-ipv6address
         */
        void setIpv6Address(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.Ipv6AddProperty.Ipv6Address``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html#cfn-ec2-launchtemplate-ipv6add-ipv6address
         */
        void setIpv6Address(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link Ipv6AddProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``LaunchTemplateResource.Ipv6AddProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html#cfn-ec2-launchtemplate-ipv6add-ipv6address
             */
            public Builder withIpv6Address(final java.lang.String value) {
                this.instance._ipv6Address = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.Ipv6AddProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html#cfn-ec2-launchtemplate-ipv6add-ipv6address
             */
            public Builder withIpv6Address(final software.amazon.awscdk.Token value) {
                this.instance._ipv6Address = value;
                return this;
            }
            public Ipv6AddProperty build() {
                Ipv6AddProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link Ipv6AddProperty}.
         */
        final class Jsii$Pojo implements Ipv6AddProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _ipv6Address;

            public java.lang.Object getIpv6Address() {
                return this._ipv6Address;
            }
            public void setIpv6Address(final java.lang.String value) {
                this._ipv6Address = value;
            }
            public void setIpv6Address(final software.amazon.awscdk.Token value) {
                this._ipv6Address = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.Ipv6AddProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``LaunchTemplateResource.Ipv6AddProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html#cfn-ec2-launchtemplate-ipv6add-ipv6address
             */
            @javax.annotation.Nullable
            public java.lang.Object getIpv6Address() {
                return this.jsiiGet("ipv6Address", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.Ipv6AddProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html#cfn-ec2-launchtemplate-ipv6add-ipv6address
             */
            public void setIpv6Address(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("ipv6Address", value);
            }
            /**
             * ``LaunchTemplateResource.Ipv6AddProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html#cfn-ec2-launchtemplate-ipv6add-ipv6address
             */
            public void setIpv6Address(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ipv6Address", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html
     */
    public static interface LaunchTemplateDataProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.BlockDeviceMappings``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-blockdevicemappings
         */
        java.lang.Object getBlockDeviceMappings();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.BlockDeviceMappings``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-blockdevicemappings
         */
        void setBlockDeviceMappings(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.BlockDeviceMappings``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-blockdevicemappings
         */
        void setBlockDeviceMappings(final java.util.List<java.lang.Object> value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.CreditSpecification``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification
         */
        java.lang.Object getCreditSpecification();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.CreditSpecification``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification
         */
        void setCreditSpecification(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.CreditSpecification``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification
         */
        void setCreditSpecification(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.CreditSpecificationProperty value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.DisableApiTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-disableapitermination
         */
        java.lang.Object getDisableApiTermination();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.DisableApiTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-disableapitermination
         */
        void setDisableApiTermination(final java.lang.Boolean value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.DisableApiTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-disableapitermination
         */
        void setDisableApiTermination(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.EbsOptimized``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ebsoptimized
         */
        java.lang.Object getEbsOptimized();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.EbsOptimized``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ebsoptimized
         */
        void setEbsOptimized(final java.lang.Boolean value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.EbsOptimized``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ebsoptimized
         */
        void setEbsOptimized(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.ElasticGpuSpecifications``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticgpuspecifications
         */
        java.lang.Object getElasticGpuSpecifications();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.ElasticGpuSpecifications``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticgpuspecifications
         */
        void setElasticGpuSpecifications(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.ElasticGpuSpecifications``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticgpuspecifications
         */
        void setElasticGpuSpecifications(final java.util.List<java.lang.Object> value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.IamInstanceProfile``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile
         */
        java.lang.Object getIamInstanceProfile();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.IamInstanceProfile``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile
         */
        void setIamInstanceProfile(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.IamInstanceProfile``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile
         */
        void setIamInstanceProfile(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.IamInstanceProfileProperty value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.ImageId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-imageid
         */
        java.lang.Object getImageId();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.ImageId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-imageid
         */
        void setImageId(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.ImageId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-imageid
         */
        void setImageId(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instanceinitiatedshutdownbehavior
         */
        java.lang.Object getInstanceInitiatedShutdownBehavior();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instanceinitiatedshutdownbehavior
         */
        void setInstanceInitiatedShutdownBehavior(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instanceinitiatedshutdownbehavior
         */
        void setInstanceInitiatedShutdownBehavior(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceMarketOptions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions
         */
        java.lang.Object getInstanceMarketOptions();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceMarketOptions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions
         */
        void setInstanceMarketOptions(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceMarketOptions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions
         */
        void setInstanceMarketOptions(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.InstanceMarketOptionsProperty value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancetype
         */
        java.lang.Object getInstanceType();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancetype
         */
        void setInstanceType(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancetype
         */
        void setInstanceType(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.KernelId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-kernelid
         */
        java.lang.Object getKernelId();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.KernelId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-kernelid
         */
        void setKernelId(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.KernelId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-kernelid
         */
        void setKernelId(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.KeyName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-keyname
         */
        java.lang.Object getKeyName();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.KeyName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-keyname
         */
        void setKeyName(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.KeyName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-keyname
         */
        void setKeyName(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.Monitoring``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring
         */
        java.lang.Object getMonitoring();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.Monitoring``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring
         */
        void setMonitoring(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.Monitoring``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring
         */
        void setMonitoring(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.MonitoringProperty value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.NetworkInterfaces``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-networkinterfaces
         */
        java.lang.Object getNetworkInterfaces();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.NetworkInterfaces``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-networkinterfaces
         */
        void setNetworkInterfaces(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.NetworkInterfaces``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-networkinterfaces
         */
        void setNetworkInterfaces(final java.util.List<java.lang.Object> value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.Placement``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-placement
         */
        java.lang.Object getPlacement();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.Placement``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-placement
         */
        void setPlacement(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.Placement``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-placement
         */
        void setPlacement(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.PlacementProperty value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.RamDiskId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ramdiskid
         */
        java.lang.Object getRamDiskId();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.RamDiskId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ramdiskid
         */
        void setRamDiskId(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.RamDiskId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ramdiskid
         */
        void setRamDiskId(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroupIds``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroupids
         */
        java.lang.Object getSecurityGroupIds();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroupIds``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroupids
         */
        void setSecurityGroupIds(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroupIds``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroupids
         */
        void setSecurityGroupIds(final java.util.List<java.lang.Object> value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroups
         */
        java.lang.Object getSecurityGroups();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroups
         */
        void setSecurityGroups(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroups
         */
        void setSecurityGroups(final java.util.List<java.lang.Object> value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.TagSpecifications``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications
         */
        java.lang.Object getTagSpecifications();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.TagSpecifications``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications
         */
        void setTagSpecifications(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.TagSpecifications``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications
         */
        void setTagSpecifications(final java.util.List<java.lang.Object> value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.UserData``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-userdata
         */
        java.lang.Object getUserData();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.UserData``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-userdata
         */
        void setUserData(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.UserData``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-userdata
         */
        void setUserData(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link LaunchTemplateDataProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.BlockDeviceMappings``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-blockdevicemappings
             */
            public Builder withBlockDeviceMappings(final software.amazon.awscdk.Token value) {
                this.instance._blockDeviceMappings = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.BlockDeviceMappings``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-blockdevicemappings
             */
            public Builder withBlockDeviceMappings(final java.util.List<java.lang.Object> value) {
                this.instance._blockDeviceMappings = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.CreditSpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification
             */
            public Builder withCreditSpecification(final software.amazon.awscdk.Token value) {
                this.instance._creditSpecification = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.CreditSpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification
             */
            public Builder withCreditSpecification(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.CreditSpecificationProperty value) {
                this.instance._creditSpecification = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.DisableApiTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-disableapitermination
             */
            public Builder withDisableApiTermination(final java.lang.Boolean value) {
                this.instance._disableApiTermination = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.DisableApiTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-disableapitermination
             */
            public Builder withDisableApiTermination(final software.amazon.awscdk.Token value) {
                this.instance._disableApiTermination = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.EbsOptimized``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ebsoptimized
             */
            public Builder withEbsOptimized(final java.lang.Boolean value) {
                this.instance._ebsOptimized = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.EbsOptimized``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ebsoptimized
             */
            public Builder withEbsOptimized(final software.amazon.awscdk.Token value) {
                this.instance._ebsOptimized = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.ElasticGpuSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticgpuspecifications
             */
            public Builder withElasticGpuSpecifications(final software.amazon.awscdk.Token value) {
                this.instance._elasticGpuSpecifications = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.ElasticGpuSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticgpuspecifications
             */
            public Builder withElasticGpuSpecifications(final java.util.List<java.lang.Object> value) {
                this.instance._elasticGpuSpecifications = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.IamInstanceProfile``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile
             */
            public Builder withIamInstanceProfile(final software.amazon.awscdk.Token value) {
                this.instance._iamInstanceProfile = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.IamInstanceProfile``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile
             */
            public Builder withIamInstanceProfile(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.IamInstanceProfileProperty value) {
                this.instance._iamInstanceProfile = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.ImageId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-imageid
             */
            public Builder withImageId(final java.lang.String value) {
                this.instance._imageId = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.ImageId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-imageid
             */
            public Builder withImageId(final software.amazon.awscdk.Token value) {
                this.instance._imageId = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instanceinitiatedshutdownbehavior
             */
            public Builder withInstanceInitiatedShutdownBehavior(final java.lang.String value) {
                this.instance._instanceInitiatedShutdownBehavior = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instanceinitiatedshutdownbehavior
             */
            public Builder withInstanceInitiatedShutdownBehavior(final software.amazon.awscdk.Token value) {
                this.instance._instanceInitiatedShutdownBehavior = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceMarketOptions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions
             */
            public Builder withInstanceMarketOptions(final software.amazon.awscdk.Token value) {
                this.instance._instanceMarketOptions = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceMarketOptions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions
             */
            public Builder withInstanceMarketOptions(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.InstanceMarketOptionsProperty value) {
                this.instance._instanceMarketOptions = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancetype
             */
            public Builder withInstanceType(final java.lang.String value) {
                this.instance._instanceType = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancetype
             */
            public Builder withInstanceType(final software.amazon.awscdk.Token value) {
                this.instance._instanceType = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.KernelId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-kernelid
             */
            public Builder withKernelId(final java.lang.String value) {
                this.instance._kernelId = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.KernelId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-kernelid
             */
            public Builder withKernelId(final software.amazon.awscdk.Token value) {
                this.instance._kernelId = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.KeyName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-keyname
             */
            public Builder withKeyName(final java.lang.String value) {
                this.instance._keyName = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.KeyName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-keyname
             */
            public Builder withKeyName(final software.amazon.awscdk.Token value) {
                this.instance._keyName = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.Monitoring``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring
             */
            public Builder withMonitoring(final software.amazon.awscdk.Token value) {
                this.instance._monitoring = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.Monitoring``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring
             */
            public Builder withMonitoring(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.MonitoringProperty value) {
                this.instance._monitoring = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.NetworkInterfaces``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-networkinterfaces
             */
            public Builder withNetworkInterfaces(final software.amazon.awscdk.Token value) {
                this.instance._networkInterfaces = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.NetworkInterfaces``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-networkinterfaces
             */
            public Builder withNetworkInterfaces(final java.util.List<java.lang.Object> value) {
                this.instance._networkInterfaces = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.Placement``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-placement
             */
            public Builder withPlacement(final software.amazon.awscdk.Token value) {
                this.instance._placement = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.Placement``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-placement
             */
            public Builder withPlacement(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.PlacementProperty value) {
                this.instance._placement = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.RamDiskId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ramdiskid
             */
            public Builder withRamDiskId(final java.lang.String value) {
                this.instance._ramDiskId = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.RamDiskId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ramdiskid
             */
            public Builder withRamDiskId(final software.amazon.awscdk.Token value) {
                this.instance._ramDiskId = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroupIds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroupids
             */
            public Builder withSecurityGroupIds(final software.amazon.awscdk.Token value) {
                this.instance._securityGroupIds = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroupIds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroupids
             */
            public Builder withSecurityGroupIds(final java.util.List<java.lang.Object> value) {
                this.instance._securityGroupIds = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroups
             */
            public Builder withSecurityGroups(final software.amazon.awscdk.Token value) {
                this.instance._securityGroups = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroups
             */
            public Builder withSecurityGroups(final java.util.List<java.lang.Object> value) {
                this.instance._securityGroups = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.TagSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications
             */
            public Builder withTagSpecifications(final software.amazon.awscdk.Token value) {
                this.instance._tagSpecifications = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.TagSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications
             */
            public Builder withTagSpecifications(final java.util.List<java.lang.Object> value) {
                this.instance._tagSpecifications = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.UserData``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-userdata
             */
            public Builder withUserData(final java.lang.String value) {
                this.instance._userData = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.UserData``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-userdata
             */
            public Builder withUserData(final software.amazon.awscdk.Token value) {
                this.instance._userData = value;
                return this;
            }
            public LaunchTemplateDataProperty build() {
                LaunchTemplateDataProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link LaunchTemplateDataProperty}.
         */
        final class Jsii$Pojo implements LaunchTemplateDataProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _blockDeviceMappings;

            public java.lang.Object getBlockDeviceMappings() {
                return this._blockDeviceMappings;
            }
            public void setBlockDeviceMappings(final software.amazon.awscdk.Token value) {
                this._blockDeviceMappings = value;
            }
            public void setBlockDeviceMappings(final java.util.List<java.lang.Object> value) {
                this._blockDeviceMappings = value;
            }

            protected java.lang.Object _creditSpecification;

            public java.lang.Object getCreditSpecification() {
                return this._creditSpecification;
            }
            public void setCreditSpecification(final software.amazon.awscdk.Token value) {
                this._creditSpecification = value;
            }
            public void setCreditSpecification(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.CreditSpecificationProperty value) {
                this._creditSpecification = value;
            }

            protected java.lang.Object _disableApiTermination;

            public java.lang.Object getDisableApiTermination() {
                return this._disableApiTermination;
            }
            public void setDisableApiTermination(final java.lang.Boolean value) {
                this._disableApiTermination = value;
            }
            public void setDisableApiTermination(final software.amazon.awscdk.Token value) {
                this._disableApiTermination = value;
            }

            protected java.lang.Object _ebsOptimized;

            public java.lang.Object getEbsOptimized() {
                return this._ebsOptimized;
            }
            public void setEbsOptimized(final java.lang.Boolean value) {
                this._ebsOptimized = value;
            }
            public void setEbsOptimized(final software.amazon.awscdk.Token value) {
                this._ebsOptimized = value;
            }

            protected java.lang.Object _elasticGpuSpecifications;

            public java.lang.Object getElasticGpuSpecifications() {
                return this._elasticGpuSpecifications;
            }
            public void setElasticGpuSpecifications(final software.amazon.awscdk.Token value) {
                this._elasticGpuSpecifications = value;
            }
            public void setElasticGpuSpecifications(final java.util.List<java.lang.Object> value) {
                this._elasticGpuSpecifications = value;
            }

            protected java.lang.Object _iamInstanceProfile;

            public java.lang.Object getIamInstanceProfile() {
                return this._iamInstanceProfile;
            }
            public void setIamInstanceProfile(final software.amazon.awscdk.Token value) {
                this._iamInstanceProfile = value;
            }
            public void setIamInstanceProfile(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.IamInstanceProfileProperty value) {
                this._iamInstanceProfile = value;
            }

            protected java.lang.Object _imageId;

            public java.lang.Object getImageId() {
                return this._imageId;
            }
            public void setImageId(final java.lang.String value) {
                this._imageId = value;
            }
            public void setImageId(final software.amazon.awscdk.Token value) {
                this._imageId = value;
            }

            protected java.lang.Object _instanceInitiatedShutdownBehavior;

            public java.lang.Object getInstanceInitiatedShutdownBehavior() {
                return this._instanceInitiatedShutdownBehavior;
            }
            public void setInstanceInitiatedShutdownBehavior(final java.lang.String value) {
                this._instanceInitiatedShutdownBehavior = value;
            }
            public void setInstanceInitiatedShutdownBehavior(final software.amazon.awscdk.Token value) {
                this._instanceInitiatedShutdownBehavior = value;
            }

            protected java.lang.Object _instanceMarketOptions;

            public java.lang.Object getInstanceMarketOptions() {
                return this._instanceMarketOptions;
            }
            public void setInstanceMarketOptions(final software.amazon.awscdk.Token value) {
                this._instanceMarketOptions = value;
            }
            public void setInstanceMarketOptions(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.InstanceMarketOptionsProperty value) {
                this._instanceMarketOptions = value;
            }

            protected java.lang.Object _instanceType;

            public java.lang.Object getInstanceType() {
                return this._instanceType;
            }
            public void setInstanceType(final java.lang.String value) {
                this._instanceType = value;
            }
            public void setInstanceType(final software.amazon.awscdk.Token value) {
                this._instanceType = value;
            }

            protected java.lang.Object _kernelId;

            public java.lang.Object getKernelId() {
                return this._kernelId;
            }
            public void setKernelId(final java.lang.String value) {
                this._kernelId = value;
            }
            public void setKernelId(final software.amazon.awscdk.Token value) {
                this._kernelId = value;
            }

            protected java.lang.Object _keyName;

            public java.lang.Object getKeyName() {
                return this._keyName;
            }
            public void setKeyName(final java.lang.String value) {
                this._keyName = value;
            }
            public void setKeyName(final software.amazon.awscdk.Token value) {
                this._keyName = value;
            }

            protected java.lang.Object _monitoring;

            public java.lang.Object getMonitoring() {
                return this._monitoring;
            }
            public void setMonitoring(final software.amazon.awscdk.Token value) {
                this._monitoring = value;
            }
            public void setMonitoring(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.MonitoringProperty value) {
                this._monitoring = value;
            }

            protected java.lang.Object _networkInterfaces;

            public java.lang.Object getNetworkInterfaces() {
                return this._networkInterfaces;
            }
            public void setNetworkInterfaces(final software.amazon.awscdk.Token value) {
                this._networkInterfaces = value;
            }
            public void setNetworkInterfaces(final java.util.List<java.lang.Object> value) {
                this._networkInterfaces = value;
            }

            protected java.lang.Object _placement;

            public java.lang.Object getPlacement() {
                return this._placement;
            }
            public void setPlacement(final software.amazon.awscdk.Token value) {
                this._placement = value;
            }
            public void setPlacement(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.PlacementProperty value) {
                this._placement = value;
            }

            protected java.lang.Object _ramDiskId;

            public java.lang.Object getRamDiskId() {
                return this._ramDiskId;
            }
            public void setRamDiskId(final java.lang.String value) {
                this._ramDiskId = value;
            }
            public void setRamDiskId(final software.amazon.awscdk.Token value) {
                this._ramDiskId = value;
            }

            protected java.lang.Object _securityGroupIds;

            public java.lang.Object getSecurityGroupIds() {
                return this._securityGroupIds;
            }
            public void setSecurityGroupIds(final software.amazon.awscdk.Token value) {
                this._securityGroupIds = value;
            }
            public void setSecurityGroupIds(final java.util.List<java.lang.Object> value) {
                this._securityGroupIds = value;
            }

            protected java.lang.Object _securityGroups;

            public java.lang.Object getSecurityGroups() {
                return this._securityGroups;
            }
            public void setSecurityGroups(final software.amazon.awscdk.Token value) {
                this._securityGroups = value;
            }
            public void setSecurityGroups(final java.util.List<java.lang.Object> value) {
                this._securityGroups = value;
            }

            protected java.lang.Object _tagSpecifications;

            public java.lang.Object getTagSpecifications() {
                return this._tagSpecifications;
            }
            public void setTagSpecifications(final software.amazon.awscdk.Token value) {
                this._tagSpecifications = value;
            }
            public void setTagSpecifications(final java.util.List<java.lang.Object> value) {
                this._tagSpecifications = value;
            }

            protected java.lang.Object _userData;

            public java.lang.Object getUserData() {
                return this._userData;
            }
            public void setUserData(final java.lang.String value) {
                this._userData = value;
            }
            public void setUserData(final software.amazon.awscdk.Token value) {
                this._userData = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.LaunchTemplateDataProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.BlockDeviceMappings``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-blockdevicemappings
             */
            @javax.annotation.Nullable
            public java.lang.Object getBlockDeviceMappings() {
                return this.jsiiGet("blockDeviceMappings", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.BlockDeviceMappings``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-blockdevicemappings
             */
            public void setBlockDeviceMappings(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("blockDeviceMappings", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.BlockDeviceMappings``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-blockdevicemappings
             */
            public void setBlockDeviceMappings(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("blockDeviceMappings", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.CreditSpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification
             */
            @javax.annotation.Nullable
            public java.lang.Object getCreditSpecification() {
                return this.jsiiGet("creditSpecification", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.CreditSpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification
             */
            public void setCreditSpecification(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("creditSpecification", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.CreditSpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification
             */
            public void setCreditSpecification(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.CreditSpecificationProperty value) {
                this.jsiiSet("creditSpecification", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.DisableApiTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-disableapitermination
             */
            @javax.annotation.Nullable
            public java.lang.Object getDisableApiTermination() {
                return this.jsiiGet("disableApiTermination", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.DisableApiTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-disableapitermination
             */
            public void setDisableApiTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("disableApiTermination", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.DisableApiTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-disableapitermination
             */
            public void setDisableApiTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("disableApiTermination", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.EbsOptimized``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ebsoptimized
             */
            @javax.annotation.Nullable
            public java.lang.Object getEbsOptimized() {
                return this.jsiiGet("ebsOptimized", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.EbsOptimized``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ebsoptimized
             */
            public void setEbsOptimized(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("ebsOptimized", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.EbsOptimized``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ebsoptimized
             */
            public void setEbsOptimized(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ebsOptimized", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.ElasticGpuSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticgpuspecifications
             */
            @javax.annotation.Nullable
            public java.lang.Object getElasticGpuSpecifications() {
                return this.jsiiGet("elasticGpuSpecifications", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.ElasticGpuSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticgpuspecifications
             */
            public void setElasticGpuSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("elasticGpuSpecifications", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.ElasticGpuSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticgpuspecifications
             */
            public void setElasticGpuSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("elasticGpuSpecifications", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.IamInstanceProfile``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile
             */
            @javax.annotation.Nullable
            public java.lang.Object getIamInstanceProfile() {
                return this.jsiiGet("iamInstanceProfile", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.IamInstanceProfile``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile
             */
            public void setIamInstanceProfile(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("iamInstanceProfile", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.IamInstanceProfile``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile
             */
            public void setIamInstanceProfile(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.IamInstanceProfileProperty value) {
                this.jsiiSet("iamInstanceProfile", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.ImageId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-imageid
             */
            @javax.annotation.Nullable
            public java.lang.Object getImageId() {
                return this.jsiiGet("imageId", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.ImageId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-imageid
             */
            public void setImageId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("imageId", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.ImageId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-imageid
             */
            public void setImageId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("imageId", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instanceinitiatedshutdownbehavior
             */
            @javax.annotation.Nullable
            public java.lang.Object getInstanceInitiatedShutdownBehavior() {
                return this.jsiiGet("instanceInitiatedShutdownBehavior", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instanceinitiatedshutdownbehavior
             */
            public void setInstanceInitiatedShutdownBehavior(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("instanceInitiatedShutdownBehavior", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instanceinitiatedshutdownbehavior
             */
            public void setInstanceInitiatedShutdownBehavior(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("instanceInitiatedShutdownBehavior", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceMarketOptions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions
             */
            @javax.annotation.Nullable
            public java.lang.Object getInstanceMarketOptions() {
                return this.jsiiGet("instanceMarketOptions", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceMarketOptions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions
             */
            public void setInstanceMarketOptions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("instanceMarketOptions", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceMarketOptions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions
             */
            public void setInstanceMarketOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.InstanceMarketOptionsProperty value) {
                this.jsiiSet("instanceMarketOptions", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancetype
             */
            @javax.annotation.Nullable
            public java.lang.Object getInstanceType() {
                return this.jsiiGet("instanceType", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancetype
             */
            public void setInstanceType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("instanceType", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancetype
             */
            public void setInstanceType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("instanceType", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.KernelId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-kernelid
             */
            @javax.annotation.Nullable
            public java.lang.Object getKernelId() {
                return this.jsiiGet("kernelId", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.KernelId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-kernelid
             */
            public void setKernelId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("kernelId", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.KernelId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-kernelid
             */
            public void setKernelId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("kernelId", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.KeyName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-keyname
             */
            @javax.annotation.Nullable
            public java.lang.Object getKeyName() {
                return this.jsiiGet("keyName", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.KeyName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-keyname
             */
            public void setKeyName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("keyName", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.KeyName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-keyname
             */
            public void setKeyName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("keyName", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.Monitoring``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring
             */
            @javax.annotation.Nullable
            public java.lang.Object getMonitoring() {
                return this.jsiiGet("monitoring", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.Monitoring``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring
             */
            public void setMonitoring(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("monitoring", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.Monitoring``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring
             */
            public void setMonitoring(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.MonitoringProperty value) {
                this.jsiiSet("monitoring", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.NetworkInterfaces``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-networkinterfaces
             */
            @javax.annotation.Nullable
            public java.lang.Object getNetworkInterfaces() {
                return this.jsiiGet("networkInterfaces", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.NetworkInterfaces``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-networkinterfaces
             */
            public void setNetworkInterfaces(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("networkInterfaces", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.NetworkInterfaces``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-networkinterfaces
             */
            public void setNetworkInterfaces(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("networkInterfaces", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.Placement``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-placement
             */
            @javax.annotation.Nullable
            public java.lang.Object getPlacement() {
                return this.jsiiGet("placement", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.Placement``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-placement
             */
            public void setPlacement(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("placement", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.Placement``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-placement
             */
            public void setPlacement(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.PlacementProperty value) {
                this.jsiiSet("placement", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.RamDiskId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ramdiskid
             */
            @javax.annotation.Nullable
            public java.lang.Object getRamDiskId() {
                return this.jsiiGet("ramDiskId", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.RamDiskId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ramdiskid
             */
            public void setRamDiskId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("ramDiskId", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.RamDiskId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ramdiskid
             */
            public void setRamDiskId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ramDiskId", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroupIds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroupids
             */
            @javax.annotation.Nullable
            public java.lang.Object getSecurityGroupIds() {
                return this.jsiiGet("securityGroupIds", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroupIds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroupids
             */
            public void setSecurityGroupIds(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("securityGroupIds", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroupIds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroupids
             */
            public void setSecurityGroupIds(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("securityGroupIds", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroups
             */
            @javax.annotation.Nullable
            public java.lang.Object getSecurityGroups() {
                return this.jsiiGet("securityGroups", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroups
             */
            public void setSecurityGroups(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("securityGroups", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroups
             */
            public void setSecurityGroups(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("securityGroups", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.TagSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications
             */
            @javax.annotation.Nullable
            public java.lang.Object getTagSpecifications() {
                return this.jsiiGet("tagSpecifications", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.TagSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications
             */
            public void setTagSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("tagSpecifications", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.TagSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications
             */
            public void setTagSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("tagSpecifications", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.UserData``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-userdata
             */
            @javax.annotation.Nullable
            public java.lang.Object getUserData() {
                return this.jsiiGet("userData", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.UserData``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-userdata
             */
            public void setUserData(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("userData", value);
            }
            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.UserData``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-userdata
             */
            public void setUserData(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("userData", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html
     */
    public static interface MonitoringProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.MonitoringProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring-enabled
         */
        java.lang.Object getEnabled();
        /**
         * ``LaunchTemplateResource.MonitoringProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring-enabled
         */
        void setEnabled(final java.lang.Boolean value);
        /**
         * ``LaunchTemplateResource.MonitoringProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring-enabled
         */
        void setEnabled(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link MonitoringProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``LaunchTemplateResource.MonitoringProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring-enabled
             */
            public Builder withEnabled(final java.lang.Boolean value) {
                this.instance._enabled = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.MonitoringProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring-enabled
             */
            public Builder withEnabled(final software.amazon.awscdk.Token value) {
                this.instance._enabled = value;
                return this;
            }
            public MonitoringProperty build() {
                MonitoringProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link MonitoringProperty}.
         */
        final class Jsii$Pojo implements MonitoringProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _enabled;

            public java.lang.Object getEnabled() {
                return this._enabled;
            }
            public void setEnabled(final java.lang.Boolean value) {
                this._enabled = value;
            }
            public void setEnabled(final software.amazon.awscdk.Token value) {
                this._enabled = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.MonitoringProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``LaunchTemplateResource.MonitoringProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring-enabled
             */
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.MonitoringProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring-enabled
             */
            public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("enabled", value);
            }
            /**
             * ``LaunchTemplateResource.MonitoringProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring-enabled
             */
            public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("enabled", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html
     */
    public static interface NetworkInterfaceProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatepublicipaddress
         */
        java.lang.Object getAssociatePublicIpAddress();
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatepublicipaddress
         */
        void setAssociatePublicIpAddress(final java.lang.Boolean value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatepublicipaddress
         */
        void setAssociatePublicIpAddress(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deleteontermination
         */
        java.lang.Object getDeleteOnTermination();
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deleteontermination
         */
        void setDeleteOnTermination(final java.lang.Boolean value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deleteontermination
         */
        void setDeleteOnTermination(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-description
         */
        java.lang.Object getDescription();
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-description
         */
        void setDescription(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-description
         */
        void setDescription(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.DeviceIndex``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deviceindex
         */
        java.lang.Object getDeviceIndex();
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.DeviceIndex``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deviceindex
         */
        void setDeviceIndex(final java.lang.Number value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.DeviceIndex``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deviceindex
         */
        void setDeviceIndex(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.Groups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-groups
         */
        java.lang.Object getGroups();
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.Groups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-groups
         */
        void setGroups(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.Groups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-groups
         */
        void setGroups(final java.util.List<java.lang.Object> value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6AddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresscount
         */
        java.lang.Object getIpv6AddressCount();
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6AddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresscount
         */
        void setIpv6AddressCount(final java.lang.Number value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6AddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresscount
         */
        void setIpv6AddressCount(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6Addresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresses
         */
        java.lang.Object getIpv6Addresses();
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6Addresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresses
         */
        void setIpv6Addresses(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6Addresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresses
         */
        void setIpv6Addresses(final java.util.List<java.lang.Object> value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.NetworkInterfaceId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkinterfaceid
         */
        java.lang.Object getNetworkInterfaceId();
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.NetworkInterfaceId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkinterfaceid
         */
        void setNetworkInterfaceId(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.NetworkInterfaceId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkinterfaceid
         */
        void setNetworkInterfaceId(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddress
         */
        java.lang.Object getPrivateIpAddress();
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddress
         */
        void setPrivateIpAddress(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddress
         */
        void setPrivateIpAddress(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddresses
         */
        java.lang.Object getPrivateIpAddresses();
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddresses
         */
        void setPrivateIpAddresses(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddresses
         */
        void setPrivateIpAddresses(final java.util.List<java.lang.Object> value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-secondaryprivateipaddresscount
         */
        java.lang.Object getSecondaryPrivateIpAddressCount();
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-secondaryprivateipaddresscount
         */
        void setSecondaryPrivateIpAddressCount(final java.lang.Number value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-secondaryprivateipaddresscount
         */
        void setSecondaryPrivateIpAddressCount(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-subnetid
         */
        java.lang.Object getSubnetId();
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-subnetid
         */
        void setSubnetId(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-subnetid
         */
        void setSubnetId(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link NetworkInterfaceProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatepublicipaddress
             */
            public Builder withAssociatePublicIpAddress(final java.lang.Boolean value) {
                this.instance._associatePublicIpAddress = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatepublicipaddress
             */
            public Builder withAssociatePublicIpAddress(final software.amazon.awscdk.Token value) {
                this.instance._associatePublicIpAddress = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deleteontermination
             */
            public Builder withDeleteOnTermination(final java.lang.Boolean value) {
                this.instance._deleteOnTermination = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deleteontermination
             */
            public Builder withDeleteOnTermination(final software.amazon.awscdk.Token value) {
                this.instance._deleteOnTermination = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-description
             */
            public Builder withDescription(final java.lang.String value) {
                this.instance._description = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-description
             */
            public Builder withDescription(final software.amazon.awscdk.Token value) {
                this.instance._description = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.DeviceIndex``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deviceindex
             */
            public Builder withDeviceIndex(final java.lang.Number value) {
                this.instance._deviceIndex = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.DeviceIndex``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deviceindex
             */
            public Builder withDeviceIndex(final software.amazon.awscdk.Token value) {
                this.instance._deviceIndex = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Groups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-groups
             */
            public Builder withGroups(final software.amazon.awscdk.Token value) {
                this.instance._groups = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Groups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-groups
             */
            public Builder withGroups(final java.util.List<java.lang.Object> value) {
                this.instance._groups = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresscount
             */
            public Builder withIpv6AddressCount(final java.lang.Number value) {
                this.instance._ipv6AddressCount = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresscount
             */
            public Builder withIpv6AddressCount(final software.amazon.awscdk.Token value) {
                this.instance._ipv6AddressCount = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresses
             */
            public Builder withIpv6Addresses(final software.amazon.awscdk.Token value) {
                this.instance._ipv6Addresses = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresses
             */
            public Builder withIpv6Addresses(final java.util.List<java.lang.Object> value) {
                this.instance._ipv6Addresses = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.NetworkInterfaceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkinterfaceid
             */
            public Builder withNetworkInterfaceId(final java.lang.String value) {
                this.instance._networkInterfaceId = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.NetworkInterfaceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkinterfaceid
             */
            public Builder withNetworkInterfaceId(final software.amazon.awscdk.Token value) {
                this.instance._networkInterfaceId = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddress
             */
            public Builder withPrivateIpAddress(final java.lang.String value) {
                this.instance._privateIpAddress = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddress
             */
            public Builder withPrivateIpAddress(final software.amazon.awscdk.Token value) {
                this.instance._privateIpAddress = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddresses
             */
            public Builder withPrivateIpAddresses(final software.amazon.awscdk.Token value) {
                this.instance._privateIpAddresses = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddresses
             */
            public Builder withPrivateIpAddresses(final java.util.List<java.lang.Object> value) {
                this.instance._privateIpAddresses = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-secondaryprivateipaddresscount
             */
            public Builder withSecondaryPrivateIpAddressCount(final java.lang.Number value) {
                this.instance._secondaryPrivateIpAddressCount = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-secondaryprivateipaddresscount
             */
            public Builder withSecondaryPrivateIpAddressCount(final software.amazon.awscdk.Token value) {
                this.instance._secondaryPrivateIpAddressCount = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-subnetid
             */
            public Builder withSubnetId(final java.lang.String value) {
                this.instance._subnetId = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-subnetid
             */
            public Builder withSubnetId(final software.amazon.awscdk.Token value) {
                this.instance._subnetId = value;
                return this;
            }
            public NetworkInterfaceProperty build() {
                NetworkInterfaceProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link NetworkInterfaceProperty}.
         */
        final class Jsii$Pojo implements NetworkInterfaceProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _associatePublicIpAddress;

            public java.lang.Object getAssociatePublicIpAddress() {
                return this._associatePublicIpAddress;
            }
            public void setAssociatePublicIpAddress(final java.lang.Boolean value) {
                this._associatePublicIpAddress = value;
            }
            public void setAssociatePublicIpAddress(final software.amazon.awscdk.Token value) {
                this._associatePublicIpAddress = value;
            }

            protected java.lang.Object _deleteOnTermination;

            public java.lang.Object getDeleteOnTermination() {
                return this._deleteOnTermination;
            }
            public void setDeleteOnTermination(final java.lang.Boolean value) {
                this._deleteOnTermination = value;
            }
            public void setDeleteOnTermination(final software.amazon.awscdk.Token value) {
                this._deleteOnTermination = value;
            }

            protected java.lang.Object _description;

            public java.lang.Object getDescription() {
                return this._description;
            }
            public void setDescription(final java.lang.String value) {
                this._description = value;
            }
            public void setDescription(final software.amazon.awscdk.Token value) {
                this._description = value;
            }

            protected java.lang.Object _deviceIndex;

            public java.lang.Object getDeviceIndex() {
                return this._deviceIndex;
            }
            public void setDeviceIndex(final java.lang.Number value) {
                this._deviceIndex = value;
            }
            public void setDeviceIndex(final software.amazon.awscdk.Token value) {
                this._deviceIndex = value;
            }

            protected java.lang.Object _groups;

            public java.lang.Object getGroups() {
                return this._groups;
            }
            public void setGroups(final software.amazon.awscdk.Token value) {
                this._groups = value;
            }
            public void setGroups(final java.util.List<java.lang.Object> value) {
                this._groups = value;
            }

            protected java.lang.Object _ipv6AddressCount;

            public java.lang.Object getIpv6AddressCount() {
                return this._ipv6AddressCount;
            }
            public void setIpv6AddressCount(final java.lang.Number value) {
                this._ipv6AddressCount = value;
            }
            public void setIpv6AddressCount(final software.amazon.awscdk.Token value) {
                this._ipv6AddressCount = value;
            }

            protected java.lang.Object _ipv6Addresses;

            public java.lang.Object getIpv6Addresses() {
                return this._ipv6Addresses;
            }
            public void setIpv6Addresses(final software.amazon.awscdk.Token value) {
                this._ipv6Addresses = value;
            }
            public void setIpv6Addresses(final java.util.List<java.lang.Object> value) {
                this._ipv6Addresses = value;
            }

            protected java.lang.Object _networkInterfaceId;

            public java.lang.Object getNetworkInterfaceId() {
                return this._networkInterfaceId;
            }
            public void setNetworkInterfaceId(final java.lang.String value) {
                this._networkInterfaceId = value;
            }
            public void setNetworkInterfaceId(final software.amazon.awscdk.Token value) {
                this._networkInterfaceId = value;
            }

            protected java.lang.Object _privateIpAddress;

            public java.lang.Object getPrivateIpAddress() {
                return this._privateIpAddress;
            }
            public void setPrivateIpAddress(final java.lang.String value) {
                this._privateIpAddress = value;
            }
            public void setPrivateIpAddress(final software.amazon.awscdk.Token value) {
                this._privateIpAddress = value;
            }

            protected java.lang.Object _privateIpAddresses;

            public java.lang.Object getPrivateIpAddresses() {
                return this._privateIpAddresses;
            }
            public void setPrivateIpAddresses(final software.amazon.awscdk.Token value) {
                this._privateIpAddresses = value;
            }
            public void setPrivateIpAddresses(final java.util.List<java.lang.Object> value) {
                this._privateIpAddresses = value;
            }

            protected java.lang.Object _secondaryPrivateIpAddressCount;

            public java.lang.Object getSecondaryPrivateIpAddressCount() {
                return this._secondaryPrivateIpAddressCount;
            }
            public void setSecondaryPrivateIpAddressCount(final java.lang.Number value) {
                this._secondaryPrivateIpAddressCount = value;
            }
            public void setSecondaryPrivateIpAddressCount(final software.amazon.awscdk.Token value) {
                this._secondaryPrivateIpAddressCount = value;
            }

            protected java.lang.Object _subnetId;

            public java.lang.Object getSubnetId() {
                return this._subnetId;
            }
            public void setSubnetId(final java.lang.String value) {
                this._subnetId = value;
            }
            public void setSubnetId(final software.amazon.awscdk.Token value) {
                this._subnetId = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.NetworkInterfaceProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatepublicipaddress
             */
            @javax.annotation.Nullable
            public java.lang.Object getAssociatePublicIpAddress() {
                return this.jsiiGet("associatePublicIpAddress", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatepublicipaddress
             */
            public void setAssociatePublicIpAddress(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("associatePublicIpAddress", value);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatepublicipaddress
             */
            public void setAssociatePublicIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("associatePublicIpAddress", value);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deleteontermination
             */
            @javax.annotation.Nullable
            public java.lang.Object getDeleteOnTermination() {
                return this.jsiiGet("deleteOnTermination", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deleteontermination
             */
            public void setDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("deleteOnTermination", value);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deleteontermination
             */
            public void setDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("deleteOnTermination", value);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-description
             */
            @javax.annotation.Nullable
            public java.lang.Object getDescription() {
                return this.jsiiGet("description", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-description
             */
            public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("description", value);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-description
             */
            public void setDescription(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("description", value);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.DeviceIndex``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deviceindex
             */
            @javax.annotation.Nullable
            public java.lang.Object getDeviceIndex() {
                return this.jsiiGet("deviceIndex", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.DeviceIndex``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deviceindex
             */
            public void setDeviceIndex(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("deviceIndex", value);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.DeviceIndex``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deviceindex
             */
            public void setDeviceIndex(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("deviceIndex", value);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Groups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-groups
             */
            @javax.annotation.Nullable
            public java.lang.Object getGroups() {
                return this.jsiiGet("groups", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Groups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-groups
             */
            public void setGroups(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("groups", value);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Groups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-groups
             */
            public void setGroups(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("groups", value);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresscount
             */
            @javax.annotation.Nullable
            public java.lang.Object getIpv6AddressCount() {
                return this.jsiiGet("ipv6AddressCount", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresscount
             */
            public void setIpv6AddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("ipv6AddressCount", value);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresscount
             */
            public void setIpv6AddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ipv6AddressCount", value);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresses
             */
            @javax.annotation.Nullable
            public java.lang.Object getIpv6Addresses() {
                return this.jsiiGet("ipv6Addresses", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresses
             */
            public void setIpv6Addresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ipv6Addresses", value);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresses
             */
            public void setIpv6Addresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("ipv6Addresses", value);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.NetworkInterfaceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkinterfaceid
             */
            @javax.annotation.Nullable
            public java.lang.Object getNetworkInterfaceId() {
                return this.jsiiGet("networkInterfaceId", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.NetworkInterfaceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkinterfaceid
             */
            public void setNetworkInterfaceId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("networkInterfaceId", value);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.NetworkInterfaceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkinterfaceid
             */
            public void setNetworkInterfaceId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("networkInterfaceId", value);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddress
             */
            @javax.annotation.Nullable
            public java.lang.Object getPrivateIpAddress() {
                return this.jsiiGet("privateIpAddress", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddress
             */
            public void setPrivateIpAddress(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("privateIpAddress", value);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddress
             */
            public void setPrivateIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("privateIpAddress", value);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddresses
             */
            @javax.annotation.Nullable
            public java.lang.Object getPrivateIpAddresses() {
                return this.jsiiGet("privateIpAddresses", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddresses
             */
            public void setPrivateIpAddresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("privateIpAddresses", value);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddresses
             */
            public void setPrivateIpAddresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("privateIpAddresses", value);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-secondaryprivateipaddresscount
             */
            @javax.annotation.Nullable
            public java.lang.Object getSecondaryPrivateIpAddressCount() {
                return this.jsiiGet("secondaryPrivateIpAddressCount", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-secondaryprivateipaddresscount
             */
            public void setSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("secondaryPrivateIpAddressCount", value);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-secondaryprivateipaddresscount
             */
            public void setSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("secondaryPrivateIpAddressCount", value);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-subnetid
             */
            @javax.annotation.Nullable
            public java.lang.Object getSubnetId() {
                return this.jsiiGet("subnetId", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-subnetid
             */
            public void setSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("subnetId", value);
            }
            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-subnetid
             */
            public void setSubnetId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("subnetId", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html
     */
    public static interface PlacementProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.PlacementProperty.Affinity``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-affinity
         */
        java.lang.Object getAffinity();
        /**
         * ``LaunchTemplateResource.PlacementProperty.Affinity``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-affinity
         */
        void setAffinity(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.PlacementProperty.Affinity``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-affinity
         */
        void setAffinity(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.PlacementProperty.AvailabilityZone``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-availabilityzone
         */
        java.lang.Object getAvailabilityZone();
        /**
         * ``LaunchTemplateResource.PlacementProperty.AvailabilityZone``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-availabilityzone
         */
        void setAvailabilityZone(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.PlacementProperty.AvailabilityZone``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-availabilityzone
         */
        void setAvailabilityZone(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.PlacementProperty.GroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-groupname
         */
        java.lang.Object getGroupName();
        /**
         * ``LaunchTemplateResource.PlacementProperty.GroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-groupname
         */
        void setGroupName(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.PlacementProperty.GroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-groupname
         */
        void setGroupName(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.PlacementProperty.HostId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostid
         */
        java.lang.Object getHostId();
        /**
         * ``LaunchTemplateResource.PlacementProperty.HostId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostid
         */
        void setHostId(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.PlacementProperty.HostId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostid
         */
        void setHostId(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.PlacementProperty.Tenancy``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-tenancy
         */
        java.lang.Object getTenancy();
        /**
         * ``LaunchTemplateResource.PlacementProperty.Tenancy``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-tenancy
         */
        void setTenancy(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.PlacementProperty.Tenancy``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-tenancy
         */
        void setTenancy(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link PlacementProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``LaunchTemplateResource.PlacementProperty.Affinity``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-affinity
             */
            public Builder withAffinity(final java.lang.String value) {
                this.instance._affinity = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.PlacementProperty.Affinity``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-affinity
             */
            public Builder withAffinity(final software.amazon.awscdk.Token value) {
                this.instance._affinity = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.PlacementProperty.AvailabilityZone``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-availabilityzone
             */
            public Builder withAvailabilityZone(final java.lang.String value) {
                this.instance._availabilityZone = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.PlacementProperty.AvailabilityZone``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-availabilityzone
             */
            public Builder withAvailabilityZone(final software.amazon.awscdk.Token value) {
                this.instance._availabilityZone = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.PlacementProperty.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-groupname
             */
            public Builder withGroupName(final java.lang.String value) {
                this.instance._groupName = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.PlacementProperty.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-groupname
             */
            public Builder withGroupName(final software.amazon.awscdk.Token value) {
                this.instance._groupName = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.PlacementProperty.HostId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostid
             */
            public Builder withHostId(final java.lang.String value) {
                this.instance._hostId = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.PlacementProperty.HostId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostid
             */
            public Builder withHostId(final software.amazon.awscdk.Token value) {
                this.instance._hostId = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.PlacementProperty.Tenancy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-tenancy
             */
            public Builder withTenancy(final java.lang.String value) {
                this.instance._tenancy = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.PlacementProperty.Tenancy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-tenancy
             */
            public Builder withTenancy(final software.amazon.awscdk.Token value) {
                this.instance._tenancy = value;
                return this;
            }
            public PlacementProperty build() {
                PlacementProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link PlacementProperty}.
         */
        final class Jsii$Pojo implements PlacementProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _affinity;

            public java.lang.Object getAffinity() {
                return this._affinity;
            }
            public void setAffinity(final java.lang.String value) {
                this._affinity = value;
            }
            public void setAffinity(final software.amazon.awscdk.Token value) {
                this._affinity = value;
            }

            protected java.lang.Object _availabilityZone;

            public java.lang.Object getAvailabilityZone() {
                return this._availabilityZone;
            }
            public void setAvailabilityZone(final java.lang.String value) {
                this._availabilityZone = value;
            }
            public void setAvailabilityZone(final software.amazon.awscdk.Token value) {
                this._availabilityZone = value;
            }

            protected java.lang.Object _groupName;

            public java.lang.Object getGroupName() {
                return this._groupName;
            }
            public void setGroupName(final java.lang.String value) {
                this._groupName = value;
            }
            public void setGroupName(final software.amazon.awscdk.Token value) {
                this._groupName = value;
            }

            protected java.lang.Object _hostId;

            public java.lang.Object getHostId() {
                return this._hostId;
            }
            public void setHostId(final java.lang.String value) {
                this._hostId = value;
            }
            public void setHostId(final software.amazon.awscdk.Token value) {
                this._hostId = value;
            }

            protected java.lang.Object _tenancy;

            public java.lang.Object getTenancy() {
                return this._tenancy;
            }
            public void setTenancy(final java.lang.String value) {
                this._tenancy = value;
            }
            public void setTenancy(final software.amazon.awscdk.Token value) {
                this._tenancy = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.PlacementProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``LaunchTemplateResource.PlacementProperty.Affinity``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-affinity
             */
            @javax.annotation.Nullable
            public java.lang.Object getAffinity() {
                return this.jsiiGet("affinity", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.PlacementProperty.Affinity``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-affinity
             */
            public void setAffinity(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("affinity", value);
            }
            /**
             * ``LaunchTemplateResource.PlacementProperty.Affinity``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-affinity
             */
            public void setAffinity(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("affinity", value);
            }
            /**
             * ``LaunchTemplateResource.PlacementProperty.AvailabilityZone``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-availabilityzone
             */
            @javax.annotation.Nullable
            public java.lang.Object getAvailabilityZone() {
                return this.jsiiGet("availabilityZone", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.PlacementProperty.AvailabilityZone``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-availabilityzone
             */
            public void setAvailabilityZone(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("availabilityZone", value);
            }
            /**
             * ``LaunchTemplateResource.PlacementProperty.AvailabilityZone``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-availabilityzone
             */
            public void setAvailabilityZone(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("availabilityZone", value);
            }
            /**
             * ``LaunchTemplateResource.PlacementProperty.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-groupname
             */
            @javax.annotation.Nullable
            public java.lang.Object getGroupName() {
                return this.jsiiGet("groupName", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.PlacementProperty.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-groupname
             */
            public void setGroupName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("groupName", value);
            }
            /**
             * ``LaunchTemplateResource.PlacementProperty.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-groupname
             */
            public void setGroupName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("groupName", value);
            }
            /**
             * ``LaunchTemplateResource.PlacementProperty.HostId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostid
             */
            @javax.annotation.Nullable
            public java.lang.Object getHostId() {
                return this.jsiiGet("hostId", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.PlacementProperty.HostId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostid
             */
            public void setHostId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("hostId", value);
            }
            /**
             * ``LaunchTemplateResource.PlacementProperty.HostId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostid
             */
            public void setHostId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("hostId", value);
            }
            /**
             * ``LaunchTemplateResource.PlacementProperty.Tenancy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-tenancy
             */
            @javax.annotation.Nullable
            public java.lang.Object getTenancy() {
                return this.jsiiGet("tenancy", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.PlacementProperty.Tenancy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-tenancy
             */
            public void setTenancy(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("tenancy", value);
            }
            /**
             * ``LaunchTemplateResource.PlacementProperty.Tenancy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-tenancy
             */
            public void setTenancy(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("tenancy", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html
     */
    public static interface PrivateIpAddProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.PrivateIpAddProperty.Primary``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-primary
         */
        java.lang.Object getPrimary();
        /**
         * ``LaunchTemplateResource.PrivateIpAddProperty.Primary``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-primary
         */
        void setPrimary(final java.lang.Boolean value);
        /**
         * ``LaunchTemplateResource.PrivateIpAddProperty.Primary``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-primary
         */
        void setPrimary(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.PrivateIpAddProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-privateipaddress
         */
        java.lang.Object getPrivateIpAddress();
        /**
         * ``LaunchTemplateResource.PrivateIpAddProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-privateipaddress
         */
        void setPrivateIpAddress(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.PrivateIpAddProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-privateipaddress
         */
        void setPrivateIpAddress(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link PrivateIpAddProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``LaunchTemplateResource.PrivateIpAddProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-primary
             */
            public Builder withPrimary(final java.lang.Boolean value) {
                this.instance._primary = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.PrivateIpAddProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-primary
             */
            public Builder withPrimary(final software.amazon.awscdk.Token value) {
                this.instance._primary = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.PrivateIpAddProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-privateipaddress
             */
            public Builder withPrivateIpAddress(final java.lang.String value) {
                this.instance._privateIpAddress = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.PrivateIpAddProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-privateipaddress
             */
            public Builder withPrivateIpAddress(final software.amazon.awscdk.Token value) {
                this.instance._privateIpAddress = value;
                return this;
            }
            public PrivateIpAddProperty build() {
                PrivateIpAddProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link PrivateIpAddProperty}.
         */
        final class Jsii$Pojo implements PrivateIpAddProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _primary;

            public java.lang.Object getPrimary() {
                return this._primary;
            }
            public void setPrimary(final java.lang.Boolean value) {
                this._primary = value;
            }
            public void setPrimary(final software.amazon.awscdk.Token value) {
                this._primary = value;
            }

            protected java.lang.Object _privateIpAddress;

            public java.lang.Object getPrivateIpAddress() {
                return this._privateIpAddress;
            }
            public void setPrivateIpAddress(final java.lang.String value) {
                this._privateIpAddress = value;
            }
            public void setPrivateIpAddress(final software.amazon.awscdk.Token value) {
                this._privateIpAddress = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.PrivateIpAddProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``LaunchTemplateResource.PrivateIpAddProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-primary
             */
            @javax.annotation.Nullable
            public java.lang.Object getPrimary() {
                return this.jsiiGet("primary", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.PrivateIpAddProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-primary
             */
            public void setPrimary(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("primary", value);
            }
            /**
             * ``LaunchTemplateResource.PrivateIpAddProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-primary
             */
            public void setPrimary(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("primary", value);
            }
            /**
             * ``LaunchTemplateResource.PrivateIpAddProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-privateipaddress
             */
            @javax.annotation.Nullable
            public java.lang.Object getPrivateIpAddress() {
                return this.jsiiGet("privateIpAddress", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.PrivateIpAddProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-privateipaddress
             */
            public void setPrivateIpAddress(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("privateIpAddress", value);
            }
            /**
             * ``LaunchTemplateResource.PrivateIpAddProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-privateipaddress
             */
            public void setPrivateIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("privateIpAddress", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html
     */
    public static interface SpotOptionsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.SpotOptionsProperty.InstanceInterruptionBehavior``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-instanceinterruptionbehavior
         */
        java.lang.Object getInstanceInterruptionBehavior();
        /**
         * ``LaunchTemplateResource.SpotOptionsProperty.InstanceInterruptionBehavior``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-instanceinterruptionbehavior
         */
        void setInstanceInterruptionBehavior(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.SpotOptionsProperty.InstanceInterruptionBehavior``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-instanceinterruptionbehavior
         */
        void setInstanceInterruptionBehavior(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.SpotOptionsProperty.MaxPrice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-maxprice
         */
        java.lang.Object getMaxPrice();
        /**
         * ``LaunchTemplateResource.SpotOptionsProperty.MaxPrice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-maxprice
         */
        void setMaxPrice(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.SpotOptionsProperty.MaxPrice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-maxprice
         */
        void setMaxPrice(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.SpotOptionsProperty.SpotInstanceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-spotinstancetype
         */
        java.lang.Object getSpotInstanceType();
        /**
         * ``LaunchTemplateResource.SpotOptionsProperty.SpotInstanceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-spotinstancetype
         */
        void setSpotInstanceType(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.SpotOptionsProperty.SpotInstanceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-spotinstancetype
         */
        void setSpotInstanceType(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link SpotOptionsProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``LaunchTemplateResource.SpotOptionsProperty.InstanceInterruptionBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-instanceinterruptionbehavior
             */
            public Builder withInstanceInterruptionBehavior(final java.lang.String value) {
                this.instance._instanceInterruptionBehavior = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.SpotOptionsProperty.InstanceInterruptionBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-instanceinterruptionbehavior
             */
            public Builder withInstanceInterruptionBehavior(final software.amazon.awscdk.Token value) {
                this.instance._instanceInterruptionBehavior = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.SpotOptionsProperty.MaxPrice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-maxprice
             */
            public Builder withMaxPrice(final java.lang.String value) {
                this.instance._maxPrice = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.SpotOptionsProperty.MaxPrice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-maxprice
             */
            public Builder withMaxPrice(final software.amazon.awscdk.Token value) {
                this.instance._maxPrice = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.SpotOptionsProperty.SpotInstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-spotinstancetype
             */
            public Builder withSpotInstanceType(final java.lang.String value) {
                this.instance._spotInstanceType = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.SpotOptionsProperty.SpotInstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-spotinstancetype
             */
            public Builder withSpotInstanceType(final software.amazon.awscdk.Token value) {
                this.instance._spotInstanceType = value;
                return this;
            }
            public SpotOptionsProperty build() {
                SpotOptionsProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link SpotOptionsProperty}.
         */
        final class Jsii$Pojo implements SpotOptionsProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _instanceInterruptionBehavior;

            public java.lang.Object getInstanceInterruptionBehavior() {
                return this._instanceInterruptionBehavior;
            }
            public void setInstanceInterruptionBehavior(final java.lang.String value) {
                this._instanceInterruptionBehavior = value;
            }
            public void setInstanceInterruptionBehavior(final software.amazon.awscdk.Token value) {
                this._instanceInterruptionBehavior = value;
            }

            protected java.lang.Object _maxPrice;

            public java.lang.Object getMaxPrice() {
                return this._maxPrice;
            }
            public void setMaxPrice(final java.lang.String value) {
                this._maxPrice = value;
            }
            public void setMaxPrice(final software.amazon.awscdk.Token value) {
                this._maxPrice = value;
            }

            protected java.lang.Object _spotInstanceType;

            public java.lang.Object getSpotInstanceType() {
                return this._spotInstanceType;
            }
            public void setSpotInstanceType(final java.lang.String value) {
                this._spotInstanceType = value;
            }
            public void setSpotInstanceType(final software.amazon.awscdk.Token value) {
                this._spotInstanceType = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.SpotOptionsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``LaunchTemplateResource.SpotOptionsProperty.InstanceInterruptionBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-instanceinterruptionbehavior
             */
            @javax.annotation.Nullable
            public java.lang.Object getInstanceInterruptionBehavior() {
                return this.jsiiGet("instanceInterruptionBehavior", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.SpotOptionsProperty.InstanceInterruptionBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-instanceinterruptionbehavior
             */
            public void setInstanceInterruptionBehavior(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("instanceInterruptionBehavior", value);
            }
            /**
             * ``LaunchTemplateResource.SpotOptionsProperty.InstanceInterruptionBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-instanceinterruptionbehavior
             */
            public void setInstanceInterruptionBehavior(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("instanceInterruptionBehavior", value);
            }
            /**
             * ``LaunchTemplateResource.SpotOptionsProperty.MaxPrice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-maxprice
             */
            @javax.annotation.Nullable
            public java.lang.Object getMaxPrice() {
                return this.jsiiGet("maxPrice", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.SpotOptionsProperty.MaxPrice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-maxprice
             */
            public void setMaxPrice(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("maxPrice", value);
            }
            /**
             * ``LaunchTemplateResource.SpotOptionsProperty.MaxPrice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-maxprice
             */
            public void setMaxPrice(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("maxPrice", value);
            }
            /**
             * ``LaunchTemplateResource.SpotOptionsProperty.SpotInstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-spotinstancetype
             */
            @javax.annotation.Nullable
            public java.lang.Object getSpotInstanceType() {
                return this.jsiiGet("spotInstanceType", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.SpotOptionsProperty.SpotInstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-spotinstancetype
             */
            public void setSpotInstanceType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("spotInstanceType", value);
            }
            /**
             * ``LaunchTemplateResource.SpotOptionsProperty.SpotInstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-spotinstancetype
             */
            public void setSpotInstanceType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("spotInstanceType", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html
     */
    public static interface TagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.TagSpecificationProperty.ResourceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-resourcetype
         */
        java.lang.Object getResourceType();
        /**
         * ``LaunchTemplateResource.TagSpecificationProperty.ResourceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-resourcetype
         */
        void setResourceType(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.TagSpecificationProperty.ResourceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-resourcetype
         */
        void setResourceType(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.TagSpecificationProperty.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-tags
         */
        java.lang.Object getTags();
        /**
         * ``LaunchTemplateResource.TagSpecificationProperty.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-tags
         */
        void setTags(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.TagSpecificationProperty.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-tags
         */
        void setTags(final java.util.List<java.lang.Object> value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link TagSpecificationProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``LaunchTemplateResource.TagSpecificationProperty.ResourceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-resourcetype
             */
            public Builder withResourceType(final java.lang.String value) {
                this.instance._resourceType = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.TagSpecificationProperty.ResourceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-resourcetype
             */
            public Builder withResourceType(final software.amazon.awscdk.Token value) {
                this.instance._resourceType = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.TagSpecificationProperty.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-tags
             */
            public Builder withTags(final software.amazon.awscdk.Token value) {
                this.instance._tags = value;
                return this;
            }
            /**
             * ``LaunchTemplateResource.TagSpecificationProperty.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-tags
             */
            public Builder withTags(final java.util.List<java.lang.Object> value) {
                this.instance._tags = value;
                return this;
            }
            public TagSpecificationProperty build() {
                TagSpecificationProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link TagSpecificationProperty}.
         */
        final class Jsii$Pojo implements TagSpecificationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _resourceType;

            public java.lang.Object getResourceType() {
                return this._resourceType;
            }
            public void setResourceType(final java.lang.String value) {
                this._resourceType = value;
            }
            public void setResourceType(final software.amazon.awscdk.Token value) {
                this._resourceType = value;
            }

            protected java.lang.Object _tags;

            public java.lang.Object getTags() {
                return this._tags;
            }
            public void setTags(final software.amazon.awscdk.Token value) {
                this._tags = value;
            }
            public void setTags(final java.util.List<java.lang.Object> value) {
                this._tags = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.TagSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``LaunchTemplateResource.TagSpecificationProperty.ResourceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-resourcetype
             */
            @javax.annotation.Nullable
            public java.lang.Object getResourceType() {
                return this.jsiiGet("resourceType", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.TagSpecificationProperty.ResourceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-resourcetype
             */
            public void setResourceType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("resourceType", value);
            }
            /**
             * ``LaunchTemplateResource.TagSpecificationProperty.ResourceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-resourcetype
             */
            public void setResourceType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("resourceType", value);
            }
            /**
             * ``LaunchTemplateResource.TagSpecificationProperty.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-tags
             */
            @javax.annotation.Nullable
            public java.lang.Object getTags() {
                return this.jsiiGet("tags", java.lang.Object.class);
            }
            /**
             * ``LaunchTemplateResource.TagSpecificationProperty.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-tags
             */
            public void setTags(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("tags", value);
            }
            /**
             * ``LaunchTemplateResource.TagSpecificationProperty.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-tags
             */
            public void setTags(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("tags", value);
            }
        }
    }
}
