package software.amazon.awscdk.services.ec2.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.cloudformation.NetworkAclEntryResource")
public class NetworkAclEntryResource extends software.amazon.awscdk.Resource {
    protected NetworkAclEntryResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.cloudformation.NetworkAclEntryResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::EC2::NetworkAclEntry``.
     * @param parent the ``cdk.Construct`` this ``NetworkAclEntryResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``NetworkAclEntryResource``
     */
    public NetworkAclEntryResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.ec2.cloudformation.NetworkAclEntryResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html
     */
    public static interface IcmpProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``NetworkAclEntryResource.IcmpProperty.Code``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-code
         */
        java.lang.Object getCode();
        /**
         * ``NetworkAclEntryResource.IcmpProperty.Code``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-code
         */
        void setCode(final java.lang.Number value);
        /**
         * ``NetworkAclEntryResource.IcmpProperty.Code``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-code
         */
        void setCode(final software.amazon.awscdk.Token value);
        /**
         * ``NetworkAclEntryResource.IcmpProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-type
         */
        java.lang.Object getType();
        /**
         * ``NetworkAclEntryResource.IcmpProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-type
         */
        void setType(final java.lang.Number value);
        /**
         * ``NetworkAclEntryResource.IcmpProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-type
         */
        void setType(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link IcmpProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``NetworkAclEntryResource.IcmpProperty.Code``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-code
             */
            public Builder withCode(final java.lang.Number value) {
                this.instance._code = value;
                return this;
            }
            /**
             * ``NetworkAclEntryResource.IcmpProperty.Code``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-code
             */
            public Builder withCode(final software.amazon.awscdk.Token value) {
                this.instance._code = value;
                return this;
            }
            /**
             * ``NetworkAclEntryResource.IcmpProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-type
             */
            public Builder withType(final java.lang.Number value) {
                this.instance._type = value;
                return this;
            }
            /**
             * ``NetworkAclEntryResource.IcmpProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-type
             */
            public Builder withType(final software.amazon.awscdk.Token value) {
                this.instance._type = value;
                return this;
            }
            public IcmpProperty build() {
                IcmpProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link IcmpProperty}.
         */
        final class Jsii$Pojo implements IcmpProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _code;

            public java.lang.Object getCode() {
                return this._code;
            }
            public void setCode(final java.lang.Number value) {
                this._code = value;
            }
            public void setCode(final software.amazon.awscdk.Token value) {
                this._code = value;
            }

            protected java.lang.Object _type;

            public java.lang.Object getType() {
                return this._type;
            }
            public void setType(final java.lang.Number value) {
                this._type = value;
            }
            public void setType(final software.amazon.awscdk.Token value) {
                this._type = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.NetworkAclEntryResource.IcmpProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``NetworkAclEntryResource.IcmpProperty.Code``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-code
             */
            @javax.annotation.Nullable
            public java.lang.Object getCode() {
                return this.jsiiGet("code", java.lang.Object.class);
            }
            /**
             * ``NetworkAclEntryResource.IcmpProperty.Code``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-code
             */
            public void setCode(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("code", value);
            }
            /**
             * ``NetworkAclEntryResource.IcmpProperty.Code``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-code
             */
            public void setCode(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("code", value);
            }
            /**
             * ``NetworkAclEntryResource.IcmpProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-type
             */
            @javax.annotation.Nullable
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }
            /**
             * ``NetworkAclEntryResource.IcmpProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-type
             */
            public void setType(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("type", value);
            }
            /**
             * ``NetworkAclEntryResource.IcmpProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-type
             */
            public void setType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("type", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html
     */
    public static interface PortRangeProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``NetworkAclEntryResource.PortRangeProperty.From``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-from
         */
        java.lang.Object getFrom();
        /**
         * ``NetworkAclEntryResource.PortRangeProperty.From``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-from
         */
        void setFrom(final java.lang.Number value);
        /**
         * ``NetworkAclEntryResource.PortRangeProperty.From``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-from
         */
        void setFrom(final software.amazon.awscdk.Token value);
        /**
         * ``NetworkAclEntryResource.PortRangeProperty.To``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-to
         */
        java.lang.Object getTo();
        /**
         * ``NetworkAclEntryResource.PortRangeProperty.To``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-to
         */
        void setTo(final java.lang.Number value);
        /**
         * ``NetworkAclEntryResource.PortRangeProperty.To``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-to
         */
        void setTo(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link PortRangeProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``NetworkAclEntryResource.PortRangeProperty.From``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-from
             */
            public Builder withFrom(final java.lang.Number value) {
                this.instance._from = value;
                return this;
            }
            /**
             * ``NetworkAclEntryResource.PortRangeProperty.From``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-from
             */
            public Builder withFrom(final software.amazon.awscdk.Token value) {
                this.instance._from = value;
                return this;
            }
            /**
             * ``NetworkAclEntryResource.PortRangeProperty.To``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-to
             */
            public Builder withTo(final java.lang.Number value) {
                this.instance._to = value;
                return this;
            }
            /**
             * ``NetworkAclEntryResource.PortRangeProperty.To``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-to
             */
            public Builder withTo(final software.amazon.awscdk.Token value) {
                this.instance._to = value;
                return this;
            }
            public PortRangeProperty build() {
                PortRangeProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link PortRangeProperty}.
         */
        final class Jsii$Pojo implements PortRangeProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _from;

            public java.lang.Object getFrom() {
                return this._from;
            }
            public void setFrom(final java.lang.Number value) {
                this._from = value;
            }
            public void setFrom(final software.amazon.awscdk.Token value) {
                this._from = value;
            }

            protected java.lang.Object _to;

            public java.lang.Object getTo() {
                return this._to;
            }
            public void setTo(final java.lang.Number value) {
                this._to = value;
            }
            public void setTo(final software.amazon.awscdk.Token value) {
                this._to = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.NetworkAclEntryResource.PortRangeProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``NetworkAclEntryResource.PortRangeProperty.From``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-from
             */
            @javax.annotation.Nullable
            public java.lang.Object getFrom() {
                return this.jsiiGet("from", java.lang.Object.class);
            }
            /**
             * ``NetworkAclEntryResource.PortRangeProperty.From``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-from
             */
            public void setFrom(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("from", value);
            }
            /**
             * ``NetworkAclEntryResource.PortRangeProperty.From``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-from
             */
            public void setFrom(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("from", value);
            }
            /**
             * ``NetworkAclEntryResource.PortRangeProperty.To``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-to
             */
            @javax.annotation.Nullable
            public java.lang.Object getTo() {
                return this.jsiiGet("to", java.lang.Object.class);
            }
            /**
             * ``NetworkAclEntryResource.PortRangeProperty.To``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-to
             */
            public void setTo(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("to", value);
            }
            /**
             * ``NetworkAclEntryResource.PortRangeProperty.To``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-to
             */
            public void setTo(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("to", value);
            }
        }
    }
}
