package software.amazon.awscdk.services.ec2.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html
 */
public interface NetworkInterfaceResourceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ``AWS::EC2::NetworkInterface.SubnetId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-subnetid
     */
    java.lang.Object getSubnetId();
    /**
     * ``AWS::EC2::NetworkInterface.SubnetId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-subnetid
     */
    void setSubnetId(final java.lang.String value);
    /**
     * ``AWS::EC2::NetworkInterface.SubnetId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-subnetid
     */
    void setSubnetId(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::NetworkInterface.Description``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-description
     */
    java.lang.Object getDescription();
    /**
     * ``AWS::EC2::NetworkInterface.Description``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-description
     */
    void setDescription(final java.lang.String value);
    /**
     * ``AWS::EC2::NetworkInterface.Description``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-description
     */
    void setDescription(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::NetworkInterface.GroupSet``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-groupset
     */
    java.lang.Object getGroupSet();
    /**
     * ``AWS::EC2::NetworkInterface.GroupSet``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-groupset
     */
    void setGroupSet(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::NetworkInterface.GroupSet``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-groupset
     */
    void setGroupSet(final java.util.List<java.lang.Object> value);
    /**
     * ``AWS::EC2::NetworkInterface.InterfaceType``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-interfacetype
     */
    java.lang.Object getInterfaceType();
    /**
     * ``AWS::EC2::NetworkInterface.InterfaceType``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-interfacetype
     */
    void setInterfaceType(final java.lang.String value);
    /**
     * ``AWS::EC2::NetworkInterface.InterfaceType``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-interfacetype
     */
    void setInterfaceType(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::NetworkInterface.Ipv6AddressCount``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresscount
     */
    java.lang.Object getIpv6AddressCount();
    /**
     * ``AWS::EC2::NetworkInterface.Ipv6AddressCount``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresscount
     */
    void setIpv6AddressCount(final java.lang.Number value);
    /**
     * ``AWS::EC2::NetworkInterface.Ipv6AddressCount``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresscount
     */
    void setIpv6AddressCount(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::NetworkInterface.Ipv6Addresses``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresses
     */
    java.lang.Object getIpv6Addresses();
    /**
     * ``AWS::EC2::NetworkInterface.Ipv6Addresses``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresses
     */
    void setIpv6Addresses(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::NetworkInterface.Ipv6Addresses``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresses
     */
    void setIpv6Addresses(final software.amazon.awscdk.services.ec2.cloudformation.NetworkInterfaceResource.InstanceIpv6AddressProperty value);
    /**
     * ``AWS::EC2::NetworkInterface.PrivateIpAddress``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddress
     */
    java.lang.Object getPrivateIpAddress();
    /**
     * ``AWS::EC2::NetworkInterface.PrivateIpAddress``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddress
     */
    void setPrivateIpAddress(final java.lang.String value);
    /**
     * ``AWS::EC2::NetworkInterface.PrivateIpAddress``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddress
     */
    void setPrivateIpAddress(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::NetworkInterface.PrivateIpAddresses``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddresses
     */
    java.lang.Object getPrivateIpAddresses();
    /**
     * ``AWS::EC2::NetworkInterface.PrivateIpAddresses``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddresses
     */
    void setPrivateIpAddresses(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::NetworkInterface.PrivateIpAddresses``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddresses
     */
    void setPrivateIpAddresses(final java.util.List<java.lang.Object> value);
    /**
     * ``AWS::EC2::NetworkInterface.SecondaryPrivateIpAddressCount``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-secondaryprivateipcount
     */
    java.lang.Object getSecondaryPrivateIpAddressCount();
    /**
     * ``AWS::EC2::NetworkInterface.SecondaryPrivateIpAddressCount``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-secondaryprivateipcount
     */
    void setSecondaryPrivateIpAddressCount(final java.lang.Number value);
    /**
     * ``AWS::EC2::NetworkInterface.SecondaryPrivateIpAddressCount``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-secondaryprivateipcount
     */
    void setSecondaryPrivateIpAddressCount(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::NetworkInterface.SourceDestCheck``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-sourcedestcheck
     */
    java.lang.Object getSourceDestCheck();
    /**
     * ``AWS::EC2::NetworkInterface.SourceDestCheck``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-sourcedestcheck
     */
    void setSourceDestCheck(final java.lang.Boolean value);
    /**
     * ``AWS::EC2::NetworkInterface.SourceDestCheck``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-sourcedestcheck
     */
    void setSourceDestCheck(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::NetworkInterface.Tags``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-tags
     */
    java.lang.Object getTags();
    /**
     * ``AWS::EC2::NetworkInterface.Tags``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-tags
     */
    void setTags(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::NetworkInterface.Tags``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-tags
     */
    void setTags(final java.util.List<java.lang.Object> value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link NetworkInterfaceResourceProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * ``AWS::EC2::NetworkInterface.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-subnetid
         */
        public Build withSubnetId(final java.lang.String value) {
            return new FullBuilder().withSubnetId(value);
        }
        /**
         * ``AWS::EC2::NetworkInterface.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-subnetid
         */
        public Build withSubnetId(final software.amazon.awscdk.Token value) {
            return new FullBuilder().withSubnetId(value);
        }

        public interface Build {
            /**
             * @return a new {@link NetworkInterfaceResourceProps} object, initialized with the values set on this builder.
             */
            NetworkInterfaceResourceProps build();
            /**
             * ``AWS::EC2::NetworkInterface.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-description
             */
            Build withDescription(final java.lang.String value);
            /**
             * ``AWS::EC2::NetworkInterface.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-description
             */
            Build withDescription(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::EC2::NetworkInterface.GroupSet``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-groupset
             */
            Build withGroupSet(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::EC2::NetworkInterface.GroupSet``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-groupset
             */
            Build withGroupSet(final java.util.List<java.lang.Object> value);
            /**
             * ``AWS::EC2::NetworkInterface.InterfaceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-interfacetype
             */
            Build withInterfaceType(final java.lang.String value);
            /**
             * ``AWS::EC2::NetworkInterface.InterfaceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-interfacetype
             */
            Build withInterfaceType(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::EC2::NetworkInterface.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresscount
             */
            Build withIpv6AddressCount(final java.lang.Number value);
            /**
             * ``AWS::EC2::NetworkInterface.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresscount
             */
            Build withIpv6AddressCount(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::EC2::NetworkInterface.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresses
             */
            Build withIpv6Addresses(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::EC2::NetworkInterface.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresses
             */
            Build withIpv6Addresses(final software.amazon.awscdk.services.ec2.cloudformation.NetworkInterfaceResource.InstanceIpv6AddressProperty value);
            /**
             * ``AWS::EC2::NetworkInterface.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddress
             */
            Build withPrivateIpAddress(final java.lang.String value);
            /**
             * ``AWS::EC2::NetworkInterface.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddress
             */
            Build withPrivateIpAddress(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::EC2::NetworkInterface.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddresses
             */
            Build withPrivateIpAddresses(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::EC2::NetworkInterface.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddresses
             */
            Build withPrivateIpAddresses(final java.util.List<java.lang.Object> value);
            /**
             * ``AWS::EC2::NetworkInterface.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-secondaryprivateipcount
             */
            Build withSecondaryPrivateIpAddressCount(final java.lang.Number value);
            /**
             * ``AWS::EC2::NetworkInterface.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-secondaryprivateipcount
             */
            Build withSecondaryPrivateIpAddressCount(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::EC2::NetworkInterface.SourceDestCheck``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-sourcedestcheck
             */
            Build withSourceDestCheck(final java.lang.Boolean value);
            /**
             * ``AWS::EC2::NetworkInterface.SourceDestCheck``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-sourcedestcheck
             */
            Build withSourceDestCheck(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::EC2::NetworkInterface.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-tags
             */
            Build withTags(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::EC2::NetworkInterface.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-tags
             */
            Build withTags(final java.util.List<java.lang.Object> value);
        }

        final class FullBuilder implements Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``AWS::EC2::NetworkInterface.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-subnetid
             */
            public Build withSubnetId(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "NetworkInterfaceResourceProps#subnetId is required");
                this.instance._subnetId = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterface.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-subnetid
             */
            public Build withSubnetId(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "NetworkInterfaceResourceProps#subnetId is required");
                this.instance._subnetId = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterface.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-description
             */
            public Build withDescription(final java.lang.String value) {
                this.instance._description = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterface.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-description
             */
            public Build withDescription(final software.amazon.awscdk.Token value) {
                this.instance._description = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterface.GroupSet``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-groupset
             */
            public Build withGroupSet(final software.amazon.awscdk.Token value) {
                this.instance._groupSet = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterface.GroupSet``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-groupset
             */
            public Build withGroupSet(final java.util.List<java.lang.Object> value) {
                this.instance._groupSet = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterface.InterfaceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-interfacetype
             */
            public Build withInterfaceType(final java.lang.String value) {
                this.instance._interfaceType = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterface.InterfaceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-interfacetype
             */
            public Build withInterfaceType(final software.amazon.awscdk.Token value) {
                this.instance._interfaceType = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterface.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresscount
             */
            public Build withIpv6AddressCount(final java.lang.Number value) {
                this.instance._ipv6AddressCount = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterface.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresscount
             */
            public Build withIpv6AddressCount(final software.amazon.awscdk.Token value) {
                this.instance._ipv6AddressCount = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterface.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresses
             */
            public Build withIpv6Addresses(final software.amazon.awscdk.Token value) {
                this.instance._ipv6Addresses = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterface.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresses
             */
            public Build withIpv6Addresses(final software.amazon.awscdk.services.ec2.cloudformation.NetworkInterfaceResource.InstanceIpv6AddressProperty value) {
                this.instance._ipv6Addresses = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterface.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddress
             */
            public Build withPrivateIpAddress(final java.lang.String value) {
                this.instance._privateIpAddress = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterface.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddress
             */
            public Build withPrivateIpAddress(final software.amazon.awscdk.Token value) {
                this.instance._privateIpAddress = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterface.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddresses
             */
            public Build withPrivateIpAddresses(final software.amazon.awscdk.Token value) {
                this.instance._privateIpAddresses = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterface.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddresses
             */
            public Build withPrivateIpAddresses(final java.util.List<java.lang.Object> value) {
                this.instance._privateIpAddresses = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterface.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-secondaryprivateipcount
             */
            public Build withSecondaryPrivateIpAddressCount(final java.lang.Number value) {
                this.instance._secondaryPrivateIpAddressCount = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterface.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-secondaryprivateipcount
             */
            public Build withSecondaryPrivateIpAddressCount(final software.amazon.awscdk.Token value) {
                this.instance._secondaryPrivateIpAddressCount = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterface.SourceDestCheck``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-sourcedestcheck
             */
            public Build withSourceDestCheck(final java.lang.Boolean value) {
                this.instance._sourceDestCheck = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterface.SourceDestCheck``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-sourcedestcheck
             */
            public Build withSourceDestCheck(final software.amazon.awscdk.Token value) {
                this.instance._sourceDestCheck = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterface.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-tags
             */
            public Build withTags(final software.amazon.awscdk.Token value) {
                this.instance._tags = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterface.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-tags
             */
            public Build withTags(final java.util.List<java.lang.Object> value) {
                this.instance._tags = value;
                return this;
            }
            public NetworkInterfaceResourceProps build() {
                NetworkInterfaceResourceProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link NetworkInterfaceResourceProps}.
     */
    final class Jsii$Pojo implements NetworkInterfaceResourceProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Object _subnetId;

        public java.lang.Object getSubnetId() {
            return this._subnetId;
        }
        public void setSubnetId(final java.lang.String value) {
            this._subnetId = value;
        }
        public void setSubnetId(final software.amazon.awscdk.Token value) {
            this._subnetId = value;
        }

        protected java.lang.Object _description;

        public java.lang.Object getDescription() {
            return this._description;
        }
        public void setDescription(final java.lang.String value) {
            this._description = value;
        }
        public void setDescription(final software.amazon.awscdk.Token value) {
            this._description = value;
        }

        protected java.lang.Object _groupSet;

        public java.lang.Object getGroupSet() {
            return this._groupSet;
        }
        public void setGroupSet(final software.amazon.awscdk.Token value) {
            this._groupSet = value;
        }
        public void setGroupSet(final java.util.List<java.lang.Object> value) {
            this._groupSet = value;
        }

        protected java.lang.Object _interfaceType;

        public java.lang.Object getInterfaceType() {
            return this._interfaceType;
        }
        public void setInterfaceType(final java.lang.String value) {
            this._interfaceType = value;
        }
        public void setInterfaceType(final software.amazon.awscdk.Token value) {
            this._interfaceType = value;
        }

        protected java.lang.Object _ipv6AddressCount;

        public java.lang.Object getIpv6AddressCount() {
            return this._ipv6AddressCount;
        }
        public void setIpv6AddressCount(final java.lang.Number value) {
            this._ipv6AddressCount = value;
        }
        public void setIpv6AddressCount(final software.amazon.awscdk.Token value) {
            this._ipv6AddressCount = value;
        }

        protected java.lang.Object _ipv6Addresses;

        public java.lang.Object getIpv6Addresses() {
            return this._ipv6Addresses;
        }
        public void setIpv6Addresses(final software.amazon.awscdk.Token value) {
            this._ipv6Addresses = value;
        }
        public void setIpv6Addresses(final software.amazon.awscdk.services.ec2.cloudformation.NetworkInterfaceResource.InstanceIpv6AddressProperty value) {
            this._ipv6Addresses = value;
        }

        protected java.lang.Object _privateIpAddress;

        public java.lang.Object getPrivateIpAddress() {
            return this._privateIpAddress;
        }
        public void setPrivateIpAddress(final java.lang.String value) {
            this._privateIpAddress = value;
        }
        public void setPrivateIpAddress(final software.amazon.awscdk.Token value) {
            this._privateIpAddress = value;
        }

        protected java.lang.Object _privateIpAddresses;

        public java.lang.Object getPrivateIpAddresses() {
            return this._privateIpAddresses;
        }
        public void setPrivateIpAddresses(final software.amazon.awscdk.Token value) {
            this._privateIpAddresses = value;
        }
        public void setPrivateIpAddresses(final java.util.List<java.lang.Object> value) {
            this._privateIpAddresses = value;
        }

        protected java.lang.Object _secondaryPrivateIpAddressCount;

        public java.lang.Object getSecondaryPrivateIpAddressCount() {
            return this._secondaryPrivateIpAddressCount;
        }
        public void setSecondaryPrivateIpAddressCount(final java.lang.Number value) {
            this._secondaryPrivateIpAddressCount = value;
        }
        public void setSecondaryPrivateIpAddressCount(final software.amazon.awscdk.Token value) {
            this._secondaryPrivateIpAddressCount = value;
        }

        protected java.lang.Object _sourceDestCheck;

        public java.lang.Object getSourceDestCheck() {
            return this._sourceDestCheck;
        }
        public void setSourceDestCheck(final java.lang.Boolean value) {
            this._sourceDestCheck = value;
        }
        public void setSourceDestCheck(final software.amazon.awscdk.Token value) {
            this._sourceDestCheck = value;
        }

        protected java.lang.Object _tags;

        public java.lang.Object getTags() {
            return this._tags;
        }
        public void setTags(final software.amazon.awscdk.Token value) {
            this._tags = value;
        }
        public void setTags(final java.util.List<java.lang.Object> value) {
            this._tags = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.NetworkInterfaceResourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * ``AWS::EC2::NetworkInterface.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-subnetid
         */
        public java.lang.Object getSubnetId() {
            return this.jsiiGet("subnetId", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::NetworkInterface.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-subnetid
         */
        public void setSubnetId(final java.lang.String value) {
            this.jsiiSet("subnetId", java.util.Objects.requireNonNull(value, "subnetId is required"));
        }
        /**
         * ``AWS::EC2::NetworkInterface.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-subnetid
         */
        public void setSubnetId(final software.amazon.awscdk.Token value) {
            this.jsiiSet("subnetId", java.util.Objects.requireNonNull(value, "subnetId is required"));
        }
        /**
         * ``AWS::EC2::NetworkInterface.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-description
         */
        @javax.annotation.Nullable
        public java.lang.Object getDescription() {
            return this.jsiiGet("description", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::NetworkInterface.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-description
         */
        public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("description", value);
        }
        /**
         * ``AWS::EC2::NetworkInterface.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-description
         */
        public void setDescription(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("description", value);
        }
        /**
         * ``AWS::EC2::NetworkInterface.GroupSet``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-groupset
         */
        @javax.annotation.Nullable
        public java.lang.Object getGroupSet() {
            return this.jsiiGet("groupSet", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::NetworkInterface.GroupSet``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-groupset
         */
        public void setGroupSet(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("groupSet", value);
        }
        /**
         * ``AWS::EC2::NetworkInterface.GroupSet``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-groupset
         */
        public void setGroupSet(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this.jsiiSet("groupSet", value);
        }
        /**
         * ``AWS::EC2::NetworkInterface.InterfaceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-interfacetype
         */
        @javax.annotation.Nullable
        public java.lang.Object getInterfaceType() {
            return this.jsiiGet("interfaceType", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::NetworkInterface.InterfaceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-interfacetype
         */
        public void setInterfaceType(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("interfaceType", value);
        }
        /**
         * ``AWS::EC2::NetworkInterface.InterfaceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-interfacetype
         */
        public void setInterfaceType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("interfaceType", value);
        }
        /**
         * ``AWS::EC2::NetworkInterface.Ipv6AddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresscount
         */
        @javax.annotation.Nullable
        public java.lang.Object getIpv6AddressCount() {
            return this.jsiiGet("ipv6AddressCount", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::NetworkInterface.Ipv6AddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresscount
         */
        public void setIpv6AddressCount(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("ipv6AddressCount", value);
        }
        /**
         * ``AWS::EC2::NetworkInterface.Ipv6AddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresscount
         */
        public void setIpv6AddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("ipv6AddressCount", value);
        }
        /**
         * ``AWS::EC2::NetworkInterface.Ipv6Addresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresses
         */
        @javax.annotation.Nullable
        public java.lang.Object getIpv6Addresses() {
            return this.jsiiGet("ipv6Addresses", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::NetworkInterface.Ipv6Addresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresses
         */
        public void setIpv6Addresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("ipv6Addresses", value);
        }
        /**
         * ``AWS::EC2::NetworkInterface.Ipv6Addresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresses
         */
        public void setIpv6Addresses(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.NetworkInterfaceResource.InstanceIpv6AddressProperty value) {
            this.jsiiSet("ipv6Addresses", value);
        }
        /**
         * ``AWS::EC2::NetworkInterface.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddress
         */
        @javax.annotation.Nullable
        public java.lang.Object getPrivateIpAddress() {
            return this.jsiiGet("privateIpAddress", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::NetworkInterface.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddress
         */
        public void setPrivateIpAddress(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("privateIpAddress", value);
        }
        /**
         * ``AWS::EC2::NetworkInterface.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddress
         */
        public void setPrivateIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("privateIpAddress", value);
        }
        /**
         * ``AWS::EC2::NetworkInterface.PrivateIpAddresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddresses
         */
        @javax.annotation.Nullable
        public java.lang.Object getPrivateIpAddresses() {
            return this.jsiiGet("privateIpAddresses", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::NetworkInterface.PrivateIpAddresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddresses
         */
        public void setPrivateIpAddresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("privateIpAddresses", value);
        }
        /**
         * ``AWS::EC2::NetworkInterface.PrivateIpAddresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddresses
         */
        public void setPrivateIpAddresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this.jsiiSet("privateIpAddresses", value);
        }
        /**
         * ``AWS::EC2::NetworkInterface.SecondaryPrivateIpAddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-secondaryprivateipcount
         */
        @javax.annotation.Nullable
        public java.lang.Object getSecondaryPrivateIpAddressCount() {
            return this.jsiiGet("secondaryPrivateIpAddressCount", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::NetworkInterface.SecondaryPrivateIpAddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-secondaryprivateipcount
         */
        public void setSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("secondaryPrivateIpAddressCount", value);
        }
        /**
         * ``AWS::EC2::NetworkInterface.SecondaryPrivateIpAddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-secondaryprivateipcount
         */
        public void setSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("secondaryPrivateIpAddressCount", value);
        }
        /**
         * ``AWS::EC2::NetworkInterface.SourceDestCheck``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-sourcedestcheck
         */
        @javax.annotation.Nullable
        public java.lang.Object getSourceDestCheck() {
            return this.jsiiGet("sourceDestCheck", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::NetworkInterface.SourceDestCheck``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-sourcedestcheck
         */
        public void setSourceDestCheck(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("sourceDestCheck", value);
        }
        /**
         * ``AWS::EC2::NetworkInterface.SourceDestCheck``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-sourcedestcheck
         */
        public void setSourceDestCheck(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("sourceDestCheck", value);
        }
        /**
         * ``AWS::EC2::NetworkInterface.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-tags
         */
        @javax.annotation.Nullable
        public java.lang.Object getTags() {
            return this.jsiiGet("tags", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::NetworkInterface.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-tags
         */
        public void setTags(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("tags", value);
        }
        /**
         * ``AWS::EC2::NetworkInterface.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-tags
         */
        public void setTags(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this.jsiiSet("tags", value);
        }
    }
}
