package software.amazon.awscdk.services.ec2.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html
 */
public interface SecurityGroupIngressResourceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ``AWS::EC2::SecurityGroupIngress.IpProtocol``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-ipprotocol
     */
    java.lang.Object getIpProtocol();
    /**
     * ``AWS::EC2::SecurityGroupIngress.IpProtocol``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-ipprotocol
     */
    void setIpProtocol(final java.lang.String value);
    /**
     * ``AWS::EC2::SecurityGroupIngress.IpProtocol``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-ipprotocol
     */
    void setIpProtocol(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::SecurityGroupIngress.CidrIp``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidrip
     */
    java.lang.Object getCidrIp();
    /**
     * ``AWS::EC2::SecurityGroupIngress.CidrIp``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidrip
     */
    void setCidrIp(final java.lang.String value);
    /**
     * ``AWS::EC2::SecurityGroupIngress.CidrIp``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidrip
     */
    void setCidrIp(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::SecurityGroupIngress.CidrIpv6``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidripv6
     */
    java.lang.Object getCidrIpv6();
    /**
     * ``AWS::EC2::SecurityGroupIngress.CidrIpv6``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidripv6
     */
    void setCidrIpv6(final java.lang.String value);
    /**
     * ``AWS::EC2::SecurityGroupIngress.CidrIpv6``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidripv6
     */
    void setCidrIpv6(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::SecurityGroupIngress.Description``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-description
     */
    java.lang.Object getDescription();
    /**
     * ``AWS::EC2::SecurityGroupIngress.Description``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-description
     */
    void setDescription(final java.lang.String value);
    /**
     * ``AWS::EC2::SecurityGroupIngress.Description``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-description
     */
    void setDescription(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::SecurityGroupIngress.FromPort``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-fromport
     */
    java.lang.Object getFromPort();
    /**
     * ``AWS::EC2::SecurityGroupIngress.FromPort``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-fromport
     */
    void setFromPort(final java.lang.Number value);
    /**
     * ``AWS::EC2::SecurityGroupIngress.FromPort``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-fromport
     */
    void setFromPort(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::SecurityGroupIngress.GroupId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupid
     */
    java.lang.Object getGroupId();
    /**
     * ``AWS::EC2::SecurityGroupIngress.GroupId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupid
     */
    void setGroupId(final java.lang.String value);
    /**
     * ``AWS::EC2::SecurityGroupIngress.GroupId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupid
     */
    void setGroupId(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::SecurityGroupIngress.GroupName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupname
     */
    java.lang.Object getGroupName();
    /**
     * ``AWS::EC2::SecurityGroupIngress.GroupName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupname
     */
    void setGroupName(final java.lang.String value);
    /**
     * ``AWS::EC2::SecurityGroupIngress.GroupName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupname
     */
    void setGroupName(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupid
     */
    java.lang.Object getSourceSecurityGroupId();
    /**
     * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupid
     */
    void setSourceSecurityGroupId(final java.lang.String value);
    /**
     * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupid
     */
    void setSourceSecurityGroupId(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupname
     */
    java.lang.Object getSourceSecurityGroupName();
    /**
     * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupname
     */
    void setSourceSecurityGroupName(final java.lang.String value);
    /**
     * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupname
     */
    void setSourceSecurityGroupName(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupOwnerId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupownerid
     */
    java.lang.Object getSourceSecurityGroupOwnerId();
    /**
     * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupOwnerId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupownerid
     */
    void setSourceSecurityGroupOwnerId(final java.lang.String value);
    /**
     * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupOwnerId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupownerid
     */
    void setSourceSecurityGroupOwnerId(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::SecurityGroupIngress.ToPort``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-toport
     */
    java.lang.Object getToPort();
    /**
     * ``AWS::EC2::SecurityGroupIngress.ToPort``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-toport
     */
    void setToPort(final java.lang.Number value);
    /**
     * ``AWS::EC2::SecurityGroupIngress.ToPort``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-toport
     */
    void setToPort(final software.amazon.awscdk.Token value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link SecurityGroupIngressResourceProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * ``AWS::EC2::SecurityGroupIngress.IpProtocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-ipprotocol
         */
        public Build withIpProtocol(final java.lang.String value) {
            return new FullBuilder().withIpProtocol(value);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.IpProtocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-ipprotocol
         */
        public Build withIpProtocol(final software.amazon.awscdk.Token value) {
            return new FullBuilder().withIpProtocol(value);
        }

        public interface Build {
            /**
             * @return a new {@link SecurityGroupIngressResourceProps} object, initialized with the values set on this builder.
             */
            SecurityGroupIngressResourceProps build();
            /**
             * ``AWS::EC2::SecurityGroupIngress.CidrIp``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidrip
             */
            Build withCidrIp(final java.lang.String value);
            /**
             * ``AWS::EC2::SecurityGroupIngress.CidrIp``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidrip
             */
            Build withCidrIp(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::EC2::SecurityGroupIngress.CidrIpv6``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidripv6
             */
            Build withCidrIpv6(final java.lang.String value);
            /**
             * ``AWS::EC2::SecurityGroupIngress.CidrIpv6``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidripv6
             */
            Build withCidrIpv6(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::EC2::SecurityGroupIngress.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-description
             */
            Build withDescription(final java.lang.String value);
            /**
             * ``AWS::EC2::SecurityGroupIngress.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-description
             */
            Build withDescription(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::EC2::SecurityGroupIngress.FromPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-fromport
             */
            Build withFromPort(final java.lang.Number value);
            /**
             * ``AWS::EC2::SecurityGroupIngress.FromPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-fromport
             */
            Build withFromPort(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::EC2::SecurityGroupIngress.GroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupid
             */
            Build withGroupId(final java.lang.String value);
            /**
             * ``AWS::EC2::SecurityGroupIngress.GroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupid
             */
            Build withGroupId(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::EC2::SecurityGroupIngress.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupname
             */
            Build withGroupName(final java.lang.String value);
            /**
             * ``AWS::EC2::SecurityGroupIngress.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupname
             */
            Build withGroupName(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupid
             */
            Build withSourceSecurityGroupId(final java.lang.String value);
            /**
             * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupid
             */
            Build withSourceSecurityGroupId(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupname
             */
            Build withSourceSecurityGroupName(final java.lang.String value);
            /**
             * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupname
             */
            Build withSourceSecurityGroupName(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupOwnerId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupownerid
             */
            Build withSourceSecurityGroupOwnerId(final java.lang.String value);
            /**
             * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupOwnerId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupownerid
             */
            Build withSourceSecurityGroupOwnerId(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::EC2::SecurityGroupIngress.ToPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-toport
             */
            Build withToPort(final java.lang.Number value);
            /**
             * ``AWS::EC2::SecurityGroupIngress.ToPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-toport
             */
            Build withToPort(final software.amazon.awscdk.Token value);
        }

        final class FullBuilder implements Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``AWS::EC2::SecurityGroupIngress.IpProtocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-ipprotocol
             */
            public Build withIpProtocol(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "SecurityGroupIngressResourceProps#ipProtocol is required");
                this.instance._ipProtocol = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroupIngress.IpProtocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-ipprotocol
             */
            public Build withIpProtocol(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "SecurityGroupIngressResourceProps#ipProtocol is required");
                this.instance._ipProtocol = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroupIngress.CidrIp``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidrip
             */
            public Build withCidrIp(final java.lang.String value) {
                this.instance._cidrIp = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroupIngress.CidrIp``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidrip
             */
            public Build withCidrIp(final software.amazon.awscdk.Token value) {
                this.instance._cidrIp = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroupIngress.CidrIpv6``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidripv6
             */
            public Build withCidrIpv6(final java.lang.String value) {
                this.instance._cidrIpv6 = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroupIngress.CidrIpv6``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidripv6
             */
            public Build withCidrIpv6(final software.amazon.awscdk.Token value) {
                this.instance._cidrIpv6 = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroupIngress.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-description
             */
            public Build withDescription(final java.lang.String value) {
                this.instance._description = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroupIngress.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-description
             */
            public Build withDescription(final software.amazon.awscdk.Token value) {
                this.instance._description = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroupIngress.FromPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-fromport
             */
            public Build withFromPort(final java.lang.Number value) {
                this.instance._fromPort = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroupIngress.FromPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-fromport
             */
            public Build withFromPort(final software.amazon.awscdk.Token value) {
                this.instance._fromPort = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroupIngress.GroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupid
             */
            public Build withGroupId(final java.lang.String value) {
                this.instance._groupId = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroupIngress.GroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupid
             */
            public Build withGroupId(final software.amazon.awscdk.Token value) {
                this.instance._groupId = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroupIngress.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupname
             */
            public Build withGroupName(final java.lang.String value) {
                this.instance._groupName = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroupIngress.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupname
             */
            public Build withGroupName(final software.amazon.awscdk.Token value) {
                this.instance._groupName = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupid
             */
            public Build withSourceSecurityGroupId(final java.lang.String value) {
                this.instance._sourceSecurityGroupId = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupid
             */
            public Build withSourceSecurityGroupId(final software.amazon.awscdk.Token value) {
                this.instance._sourceSecurityGroupId = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupname
             */
            public Build withSourceSecurityGroupName(final java.lang.String value) {
                this.instance._sourceSecurityGroupName = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupname
             */
            public Build withSourceSecurityGroupName(final software.amazon.awscdk.Token value) {
                this.instance._sourceSecurityGroupName = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupOwnerId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupownerid
             */
            public Build withSourceSecurityGroupOwnerId(final java.lang.String value) {
                this.instance._sourceSecurityGroupOwnerId = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupOwnerId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupownerid
             */
            public Build withSourceSecurityGroupOwnerId(final software.amazon.awscdk.Token value) {
                this.instance._sourceSecurityGroupOwnerId = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroupIngress.ToPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-toport
             */
            public Build withToPort(final java.lang.Number value) {
                this.instance._toPort = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroupIngress.ToPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-toport
             */
            public Build withToPort(final software.amazon.awscdk.Token value) {
                this.instance._toPort = value;
                return this;
            }
            public SecurityGroupIngressResourceProps build() {
                SecurityGroupIngressResourceProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link SecurityGroupIngressResourceProps}.
     */
    final class Jsii$Pojo implements SecurityGroupIngressResourceProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Object _ipProtocol;

        public java.lang.Object getIpProtocol() {
            return this._ipProtocol;
        }
        public void setIpProtocol(final java.lang.String value) {
            this._ipProtocol = value;
        }
        public void setIpProtocol(final software.amazon.awscdk.Token value) {
            this._ipProtocol = value;
        }

        protected java.lang.Object _cidrIp;

        public java.lang.Object getCidrIp() {
            return this._cidrIp;
        }
        public void setCidrIp(final java.lang.String value) {
            this._cidrIp = value;
        }
        public void setCidrIp(final software.amazon.awscdk.Token value) {
            this._cidrIp = value;
        }

        protected java.lang.Object _cidrIpv6;

        public java.lang.Object getCidrIpv6() {
            return this._cidrIpv6;
        }
        public void setCidrIpv6(final java.lang.String value) {
            this._cidrIpv6 = value;
        }
        public void setCidrIpv6(final software.amazon.awscdk.Token value) {
            this._cidrIpv6 = value;
        }

        protected java.lang.Object _description;

        public java.lang.Object getDescription() {
            return this._description;
        }
        public void setDescription(final java.lang.String value) {
            this._description = value;
        }
        public void setDescription(final software.amazon.awscdk.Token value) {
            this._description = value;
        }

        protected java.lang.Object _fromPort;

        public java.lang.Object getFromPort() {
            return this._fromPort;
        }
        public void setFromPort(final java.lang.Number value) {
            this._fromPort = value;
        }
        public void setFromPort(final software.amazon.awscdk.Token value) {
            this._fromPort = value;
        }

        protected java.lang.Object _groupId;

        public java.lang.Object getGroupId() {
            return this._groupId;
        }
        public void setGroupId(final java.lang.String value) {
            this._groupId = value;
        }
        public void setGroupId(final software.amazon.awscdk.Token value) {
            this._groupId = value;
        }

        protected java.lang.Object _groupName;

        public java.lang.Object getGroupName() {
            return this._groupName;
        }
        public void setGroupName(final java.lang.String value) {
            this._groupName = value;
        }
        public void setGroupName(final software.amazon.awscdk.Token value) {
            this._groupName = value;
        }

        protected java.lang.Object _sourceSecurityGroupId;

        public java.lang.Object getSourceSecurityGroupId() {
            return this._sourceSecurityGroupId;
        }
        public void setSourceSecurityGroupId(final java.lang.String value) {
            this._sourceSecurityGroupId = value;
        }
        public void setSourceSecurityGroupId(final software.amazon.awscdk.Token value) {
            this._sourceSecurityGroupId = value;
        }

        protected java.lang.Object _sourceSecurityGroupName;

        public java.lang.Object getSourceSecurityGroupName() {
            return this._sourceSecurityGroupName;
        }
        public void setSourceSecurityGroupName(final java.lang.String value) {
            this._sourceSecurityGroupName = value;
        }
        public void setSourceSecurityGroupName(final software.amazon.awscdk.Token value) {
            this._sourceSecurityGroupName = value;
        }

        protected java.lang.Object _sourceSecurityGroupOwnerId;

        public java.lang.Object getSourceSecurityGroupOwnerId() {
            return this._sourceSecurityGroupOwnerId;
        }
        public void setSourceSecurityGroupOwnerId(final java.lang.String value) {
            this._sourceSecurityGroupOwnerId = value;
        }
        public void setSourceSecurityGroupOwnerId(final software.amazon.awscdk.Token value) {
            this._sourceSecurityGroupOwnerId = value;
        }

        protected java.lang.Object _toPort;

        public java.lang.Object getToPort() {
            return this._toPort;
        }
        public void setToPort(final java.lang.Number value) {
            this._toPort = value;
        }
        public void setToPort(final software.amazon.awscdk.Token value) {
            this._toPort = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.SecurityGroupIngressResourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.IpProtocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-ipprotocol
         */
        public java.lang.Object getIpProtocol() {
            return this.jsiiGet("ipProtocol", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.IpProtocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-ipprotocol
         */
        public void setIpProtocol(final java.lang.String value) {
            this.jsiiSet("ipProtocol", java.util.Objects.requireNonNull(value, "ipProtocol is required"));
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.IpProtocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-ipprotocol
         */
        public void setIpProtocol(final software.amazon.awscdk.Token value) {
            this.jsiiSet("ipProtocol", java.util.Objects.requireNonNull(value, "ipProtocol is required"));
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.CidrIp``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidrip
         */
        @javax.annotation.Nullable
        public java.lang.Object getCidrIp() {
            return this.jsiiGet("cidrIp", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.CidrIp``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidrip
         */
        public void setCidrIp(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("cidrIp", value);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.CidrIp``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidrip
         */
        public void setCidrIp(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("cidrIp", value);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.CidrIpv6``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidripv6
         */
        @javax.annotation.Nullable
        public java.lang.Object getCidrIpv6() {
            return this.jsiiGet("cidrIpv6", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.CidrIpv6``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidripv6
         */
        public void setCidrIpv6(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("cidrIpv6", value);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.CidrIpv6``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidripv6
         */
        public void setCidrIpv6(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("cidrIpv6", value);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-description
         */
        @javax.annotation.Nullable
        public java.lang.Object getDescription() {
            return this.jsiiGet("description", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-description
         */
        public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("description", value);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-description
         */
        public void setDescription(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("description", value);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.FromPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-fromport
         */
        @javax.annotation.Nullable
        public java.lang.Object getFromPort() {
            return this.jsiiGet("fromPort", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.FromPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-fromport
         */
        public void setFromPort(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("fromPort", value);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.FromPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-fromport
         */
        public void setFromPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("fromPort", value);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.GroupId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupid
         */
        @javax.annotation.Nullable
        public java.lang.Object getGroupId() {
            return this.jsiiGet("groupId", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.GroupId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupid
         */
        public void setGroupId(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("groupId", value);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.GroupId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupid
         */
        public void setGroupId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("groupId", value);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.GroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupname
         */
        @javax.annotation.Nullable
        public java.lang.Object getGroupName() {
            return this.jsiiGet("groupName", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.GroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupname
         */
        public void setGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("groupName", value);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.GroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupname
         */
        public void setGroupName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("groupName", value);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupid
         */
        @javax.annotation.Nullable
        public java.lang.Object getSourceSecurityGroupId() {
            return this.jsiiGet("sourceSecurityGroupId", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupid
         */
        public void setSourceSecurityGroupId(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("sourceSecurityGroupId", value);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupid
         */
        public void setSourceSecurityGroupId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("sourceSecurityGroupId", value);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupname
         */
        @javax.annotation.Nullable
        public java.lang.Object getSourceSecurityGroupName() {
            return this.jsiiGet("sourceSecurityGroupName", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupname
         */
        public void setSourceSecurityGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("sourceSecurityGroupName", value);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupname
         */
        public void setSourceSecurityGroupName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("sourceSecurityGroupName", value);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupOwnerId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupownerid
         */
        @javax.annotation.Nullable
        public java.lang.Object getSourceSecurityGroupOwnerId() {
            return this.jsiiGet("sourceSecurityGroupOwnerId", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupOwnerId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupownerid
         */
        public void setSourceSecurityGroupOwnerId(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("sourceSecurityGroupOwnerId", value);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupOwnerId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupownerid
         */
        public void setSourceSecurityGroupOwnerId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("sourceSecurityGroupOwnerId", value);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.ToPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-toport
         */
        @javax.annotation.Nullable
        public java.lang.Object getToPort() {
            return this.jsiiGet("toPort", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.ToPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-toport
         */
        public void setToPort(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("toPort", value);
        }
        /**
         * ``AWS::EC2::SecurityGroupIngress.ToPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-toport
         */
        public void setToPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("toPort", value);
        }
    }
}
