package software.amazon.awscdk.services.ec2.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html
 */
public interface SecurityGroupResourceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ``AWS::EC2::SecurityGroup.GroupDescription``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupdescription
     */
    java.lang.Object getGroupDescription();
    /**
     * ``AWS::EC2::SecurityGroup.GroupDescription``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupdescription
     */
    void setGroupDescription(final java.lang.String value);
    /**
     * ``AWS::EC2::SecurityGroup.GroupDescription``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupdescription
     */
    void setGroupDescription(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::SecurityGroup.GroupName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupname
     */
    java.lang.Object getGroupName();
    /**
     * ``AWS::EC2::SecurityGroup.GroupName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupname
     */
    void setGroupName(final java.lang.String value);
    /**
     * ``AWS::EC2::SecurityGroup.GroupName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupname
     */
    void setGroupName(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::SecurityGroup.SecurityGroupEgress``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
     */
    java.lang.Object getSecurityGroupEgress();
    /**
     * ``AWS::EC2::SecurityGroup.SecurityGroupEgress``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
     */
    void setSecurityGroupEgress(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::SecurityGroup.SecurityGroupEgress``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
     */
    void setSecurityGroupEgress(final java.util.List<java.lang.Object> value);
    /**
     * ``AWS::EC2::SecurityGroup.SecurityGroupIngress``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
     */
    java.lang.Object getSecurityGroupIngress();
    /**
     * ``AWS::EC2::SecurityGroup.SecurityGroupIngress``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
     */
    void setSecurityGroupIngress(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::SecurityGroup.SecurityGroupIngress``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
     */
    void setSecurityGroupIngress(final java.util.List<java.lang.Object> value);
    /**
     * ``AWS::EC2::SecurityGroup.Tags``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-tags
     */
    java.lang.Object getTags();
    /**
     * ``AWS::EC2::SecurityGroup.Tags``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-tags
     */
    void setTags(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::SecurityGroup.Tags``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-tags
     */
    void setTags(final java.util.List<java.lang.Object> value);
    /**
     * ``AWS::EC2::SecurityGroup.VpcId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-vpcid
     */
    java.lang.Object getVpcId();
    /**
     * ``AWS::EC2::SecurityGroup.VpcId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-vpcid
     */
    void setVpcId(final java.lang.String value);
    /**
     * ``AWS::EC2::SecurityGroup.VpcId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-vpcid
     */
    void setVpcId(final software.amazon.awscdk.Token value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link SecurityGroupResourceProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * ``AWS::EC2::SecurityGroup.GroupDescription``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupdescription
         */
        public Build withGroupDescription(final java.lang.String value) {
            return new FullBuilder().withGroupDescription(value);
        }
        /**
         * ``AWS::EC2::SecurityGroup.GroupDescription``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupdescription
         */
        public Build withGroupDescription(final software.amazon.awscdk.Token value) {
            return new FullBuilder().withGroupDescription(value);
        }

        public interface Build {
            /**
             * @return a new {@link SecurityGroupResourceProps} object, initialized with the values set on this builder.
             */
            SecurityGroupResourceProps build();
            /**
             * ``AWS::EC2::SecurityGroup.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupname
             */
            Build withGroupName(final java.lang.String value);
            /**
             * ``AWS::EC2::SecurityGroup.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupname
             */
            Build withGroupName(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::EC2::SecurityGroup.SecurityGroupEgress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
             */
            Build withSecurityGroupEgress(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::EC2::SecurityGroup.SecurityGroupEgress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
             */
            Build withSecurityGroupEgress(final java.util.List<java.lang.Object> value);
            /**
             * ``AWS::EC2::SecurityGroup.SecurityGroupIngress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
             */
            Build withSecurityGroupIngress(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::EC2::SecurityGroup.SecurityGroupIngress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
             */
            Build withSecurityGroupIngress(final java.util.List<java.lang.Object> value);
            /**
             * ``AWS::EC2::SecurityGroup.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-tags
             */
            Build withTags(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::EC2::SecurityGroup.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-tags
             */
            Build withTags(final java.util.List<java.lang.Object> value);
            /**
             * ``AWS::EC2::SecurityGroup.VpcId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-vpcid
             */
            Build withVpcId(final java.lang.String value);
            /**
             * ``AWS::EC2::SecurityGroup.VpcId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-vpcid
             */
            Build withVpcId(final software.amazon.awscdk.Token value);
        }

        final class FullBuilder implements Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``AWS::EC2::SecurityGroup.GroupDescription``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupdescription
             */
            public Build withGroupDescription(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "SecurityGroupResourceProps#groupDescription is required");
                this.instance._groupDescription = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroup.GroupDescription``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupdescription
             */
            public Build withGroupDescription(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "SecurityGroupResourceProps#groupDescription is required");
                this.instance._groupDescription = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroup.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupname
             */
            public Build withGroupName(final java.lang.String value) {
                this.instance._groupName = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroup.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupname
             */
            public Build withGroupName(final software.amazon.awscdk.Token value) {
                this.instance._groupName = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroup.SecurityGroupEgress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
             */
            public Build withSecurityGroupEgress(final software.amazon.awscdk.Token value) {
                this.instance._securityGroupEgress = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroup.SecurityGroupEgress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
             */
            public Build withSecurityGroupEgress(final java.util.List<java.lang.Object> value) {
                this.instance._securityGroupEgress = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroup.SecurityGroupIngress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
             */
            public Build withSecurityGroupIngress(final software.amazon.awscdk.Token value) {
                this.instance._securityGroupIngress = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroup.SecurityGroupIngress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
             */
            public Build withSecurityGroupIngress(final java.util.List<java.lang.Object> value) {
                this.instance._securityGroupIngress = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroup.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-tags
             */
            public Build withTags(final software.amazon.awscdk.Token value) {
                this.instance._tags = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroup.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-tags
             */
            public Build withTags(final java.util.List<java.lang.Object> value) {
                this.instance._tags = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroup.VpcId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-vpcid
             */
            public Build withVpcId(final java.lang.String value) {
                this.instance._vpcId = value;
                return this;
            }
            /**
             * ``AWS::EC2::SecurityGroup.VpcId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-vpcid
             */
            public Build withVpcId(final software.amazon.awscdk.Token value) {
                this.instance._vpcId = value;
                return this;
            }
            public SecurityGroupResourceProps build() {
                SecurityGroupResourceProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link SecurityGroupResourceProps}.
     */
    final class Jsii$Pojo implements SecurityGroupResourceProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Object _groupDescription;

        public java.lang.Object getGroupDescription() {
            return this._groupDescription;
        }
        public void setGroupDescription(final java.lang.String value) {
            this._groupDescription = value;
        }
        public void setGroupDescription(final software.amazon.awscdk.Token value) {
            this._groupDescription = value;
        }

        protected java.lang.Object _groupName;

        public java.lang.Object getGroupName() {
            return this._groupName;
        }
        public void setGroupName(final java.lang.String value) {
            this._groupName = value;
        }
        public void setGroupName(final software.amazon.awscdk.Token value) {
            this._groupName = value;
        }

        protected java.lang.Object _securityGroupEgress;

        public java.lang.Object getSecurityGroupEgress() {
            return this._securityGroupEgress;
        }
        public void setSecurityGroupEgress(final software.amazon.awscdk.Token value) {
            this._securityGroupEgress = value;
        }
        public void setSecurityGroupEgress(final java.util.List<java.lang.Object> value) {
            this._securityGroupEgress = value;
        }

        protected java.lang.Object _securityGroupIngress;

        public java.lang.Object getSecurityGroupIngress() {
            return this._securityGroupIngress;
        }
        public void setSecurityGroupIngress(final software.amazon.awscdk.Token value) {
            this._securityGroupIngress = value;
        }
        public void setSecurityGroupIngress(final java.util.List<java.lang.Object> value) {
            this._securityGroupIngress = value;
        }

        protected java.lang.Object _tags;

        public java.lang.Object getTags() {
            return this._tags;
        }
        public void setTags(final software.amazon.awscdk.Token value) {
            this._tags = value;
        }
        public void setTags(final java.util.List<java.lang.Object> value) {
            this._tags = value;
        }

        protected java.lang.Object _vpcId;

        public java.lang.Object getVpcId() {
            return this._vpcId;
        }
        public void setVpcId(final java.lang.String value) {
            this._vpcId = value;
        }
        public void setVpcId(final software.amazon.awscdk.Token value) {
            this._vpcId = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.SecurityGroupResourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * ``AWS::EC2::SecurityGroup.GroupDescription``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupdescription
         */
        public java.lang.Object getGroupDescription() {
            return this.jsiiGet("groupDescription", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::SecurityGroup.GroupDescription``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupdescription
         */
        public void setGroupDescription(final java.lang.String value) {
            this.jsiiSet("groupDescription", java.util.Objects.requireNonNull(value, "groupDescription is required"));
        }
        /**
         * ``AWS::EC2::SecurityGroup.GroupDescription``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupdescription
         */
        public void setGroupDescription(final software.amazon.awscdk.Token value) {
            this.jsiiSet("groupDescription", java.util.Objects.requireNonNull(value, "groupDescription is required"));
        }
        /**
         * ``AWS::EC2::SecurityGroup.GroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupname
         */
        @javax.annotation.Nullable
        public java.lang.Object getGroupName() {
            return this.jsiiGet("groupName", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::SecurityGroup.GroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupname
         */
        public void setGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("groupName", value);
        }
        /**
         * ``AWS::EC2::SecurityGroup.GroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupname
         */
        public void setGroupName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("groupName", value);
        }
        /**
         * ``AWS::EC2::SecurityGroup.SecurityGroupEgress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
         */
        @javax.annotation.Nullable
        public java.lang.Object getSecurityGroupEgress() {
            return this.jsiiGet("securityGroupEgress", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::SecurityGroup.SecurityGroupEgress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
         */
        public void setSecurityGroupEgress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("securityGroupEgress", value);
        }
        /**
         * ``AWS::EC2::SecurityGroup.SecurityGroupEgress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
         */
        public void setSecurityGroupEgress(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this.jsiiSet("securityGroupEgress", value);
        }
        /**
         * ``AWS::EC2::SecurityGroup.SecurityGroupIngress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
         */
        @javax.annotation.Nullable
        public java.lang.Object getSecurityGroupIngress() {
            return this.jsiiGet("securityGroupIngress", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::SecurityGroup.SecurityGroupIngress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
         */
        public void setSecurityGroupIngress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("securityGroupIngress", value);
        }
        /**
         * ``AWS::EC2::SecurityGroup.SecurityGroupIngress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
         */
        public void setSecurityGroupIngress(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this.jsiiSet("securityGroupIngress", value);
        }
        /**
         * ``AWS::EC2::SecurityGroup.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-tags
         */
        @javax.annotation.Nullable
        public java.lang.Object getTags() {
            return this.jsiiGet("tags", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::SecurityGroup.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-tags
         */
        public void setTags(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("tags", value);
        }
        /**
         * ``AWS::EC2::SecurityGroup.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-tags
         */
        public void setTags(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this.jsiiSet("tags", value);
        }
        /**
         * ``AWS::EC2::SecurityGroup.VpcId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-vpcid
         */
        @javax.annotation.Nullable
        public java.lang.Object getVpcId() {
            return this.jsiiGet("vpcId", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::SecurityGroup.VpcId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-vpcid
         */
        public void setVpcId(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("vpcId", value);
        }
        /**
         * ``AWS::EC2::SecurityGroup.VpcId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-vpcid
         */
        public void setVpcId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("vpcId", value);
        }
    }
}
