package software.amazon.awscdk.services.ec2.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.cloudformation.SpotFleetResource")
public class SpotFleetResource extends software.amazon.awscdk.Resource {
    protected SpotFleetResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::EC2::SpotFleet``.
     * @param parent the ``cdk.Construct`` this ``SpotFleetResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``SpotFleetResource``
     */
    public SpotFleetResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html
     */
    public static interface BlockDeviceMappingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``SpotFleetResource.BlockDeviceMappingProperty.DeviceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-devicename
         */
        java.lang.Object getDeviceName();
        /**
         * ``SpotFleetResource.BlockDeviceMappingProperty.DeviceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-devicename
         */
        void setDeviceName(final java.lang.String value);
        /**
         * ``SpotFleetResource.BlockDeviceMappingProperty.DeviceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-devicename
         */
        void setDeviceName(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.BlockDeviceMappingProperty.Ebs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-ebs
         */
        java.lang.Object getEbs();
        /**
         * ``SpotFleetResource.BlockDeviceMappingProperty.Ebs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-ebs
         */
        void setEbs(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.BlockDeviceMappingProperty.Ebs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-ebs
         */
        void setEbs(final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.EbsBlockDeviceProperty value);
        /**
         * ``SpotFleetResource.BlockDeviceMappingProperty.NoDevice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-nodevice
         */
        java.lang.Object getNoDevice();
        /**
         * ``SpotFleetResource.BlockDeviceMappingProperty.NoDevice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-nodevice
         */
        void setNoDevice(final java.lang.String value);
        /**
         * ``SpotFleetResource.BlockDeviceMappingProperty.NoDevice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-nodevice
         */
        void setNoDevice(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.BlockDeviceMappingProperty.VirtualName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-virtualname
         */
        java.lang.Object getVirtualName();
        /**
         * ``SpotFleetResource.BlockDeviceMappingProperty.VirtualName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-virtualname
         */
        void setVirtualName(final java.lang.String value);
        /**
         * ``SpotFleetResource.BlockDeviceMappingProperty.VirtualName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-virtualname
         */
        void setVirtualName(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link BlockDeviceMappingProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``SpotFleetResource.BlockDeviceMappingProperty.DeviceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-devicename
             */
            public Build withDeviceName(final java.lang.String value) {
                return new FullBuilder().withDeviceName(value);
            }
            /**
             * ``SpotFleetResource.BlockDeviceMappingProperty.DeviceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-devicename
             */
            public Build withDeviceName(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withDeviceName(value);
            }

            public interface Build {
                /**
                 * @return a new {@link BlockDeviceMappingProperty} object, initialized with the values set on this builder.
                 */
                BlockDeviceMappingProperty build();
                /**
                 * ``SpotFleetResource.BlockDeviceMappingProperty.Ebs``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-ebs
                 */
                Build withEbs(final software.amazon.awscdk.Token value);
                /**
                 * ``SpotFleetResource.BlockDeviceMappingProperty.Ebs``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-ebs
                 */
                Build withEbs(final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.EbsBlockDeviceProperty value);
                /**
                 * ``SpotFleetResource.BlockDeviceMappingProperty.NoDevice``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-nodevice
                 */
                Build withNoDevice(final java.lang.String value);
                /**
                 * ``SpotFleetResource.BlockDeviceMappingProperty.NoDevice``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-nodevice
                 */
                Build withNoDevice(final software.amazon.awscdk.Token value);
                /**
                 * ``SpotFleetResource.BlockDeviceMappingProperty.VirtualName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-virtualname
                 */
                Build withVirtualName(final java.lang.String value);
                /**
                 * ``SpotFleetResource.BlockDeviceMappingProperty.VirtualName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-virtualname
                 */
                Build withVirtualName(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``SpotFleetResource.BlockDeviceMappingProperty.DeviceName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-devicename
                 */
                public Build withDeviceName(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "BlockDeviceMappingProperty#deviceName is required");
                    this.instance._deviceName = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.BlockDeviceMappingProperty.DeviceName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-devicename
                 */
                public Build withDeviceName(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "BlockDeviceMappingProperty#deviceName is required");
                    this.instance._deviceName = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.BlockDeviceMappingProperty.Ebs``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-ebs
                 */
                public Build withEbs(final software.amazon.awscdk.Token value) {
                    this.instance._ebs = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.BlockDeviceMappingProperty.Ebs``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-ebs
                 */
                public Build withEbs(final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.EbsBlockDeviceProperty value) {
                    this.instance._ebs = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.BlockDeviceMappingProperty.NoDevice``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-nodevice
                 */
                public Build withNoDevice(final java.lang.String value) {
                    this.instance._noDevice = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.BlockDeviceMappingProperty.NoDevice``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-nodevice
                 */
                public Build withNoDevice(final software.amazon.awscdk.Token value) {
                    this.instance._noDevice = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.BlockDeviceMappingProperty.VirtualName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-virtualname
                 */
                public Build withVirtualName(final java.lang.String value) {
                    this.instance._virtualName = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.BlockDeviceMappingProperty.VirtualName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-virtualname
                 */
                public Build withVirtualName(final software.amazon.awscdk.Token value) {
                    this.instance._virtualName = value;
                    return this;
                }
                public BlockDeviceMappingProperty build() {
                    BlockDeviceMappingProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link BlockDeviceMappingProperty}.
         */
        final class Jsii$Pojo implements BlockDeviceMappingProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _deviceName;

            public java.lang.Object getDeviceName() {
                return this._deviceName;
            }
            public void setDeviceName(final java.lang.String value) {
                this._deviceName = value;
            }
            public void setDeviceName(final software.amazon.awscdk.Token value) {
                this._deviceName = value;
            }

            protected java.lang.Object _ebs;

            public java.lang.Object getEbs() {
                return this._ebs;
            }
            public void setEbs(final software.amazon.awscdk.Token value) {
                this._ebs = value;
            }
            public void setEbs(final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.EbsBlockDeviceProperty value) {
                this._ebs = value;
            }

            protected java.lang.Object _noDevice;

            public java.lang.Object getNoDevice() {
                return this._noDevice;
            }
            public void setNoDevice(final java.lang.String value) {
                this._noDevice = value;
            }
            public void setNoDevice(final software.amazon.awscdk.Token value) {
                this._noDevice = value;
            }

            protected java.lang.Object _virtualName;

            public java.lang.Object getVirtualName() {
                return this._virtualName;
            }
            public void setVirtualName(final java.lang.String value) {
                this._virtualName = value;
            }
            public void setVirtualName(final software.amazon.awscdk.Token value) {
                this._virtualName = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.BlockDeviceMappingProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``SpotFleetResource.BlockDeviceMappingProperty.DeviceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-devicename
             */
            public java.lang.Object getDeviceName() {
                return this.jsiiGet("deviceName", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.BlockDeviceMappingProperty.DeviceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-devicename
             */
            public void setDeviceName(final java.lang.String value) {
                this.jsiiSet("deviceName", java.util.Objects.requireNonNull(value, "deviceName is required"));
            }
            /**
             * ``SpotFleetResource.BlockDeviceMappingProperty.DeviceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-devicename
             */
            public void setDeviceName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("deviceName", java.util.Objects.requireNonNull(value, "deviceName is required"));
            }
            /**
             * ``SpotFleetResource.BlockDeviceMappingProperty.Ebs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-ebs
             */
            @javax.annotation.Nullable
            public java.lang.Object getEbs() {
                return this.jsiiGet("ebs", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.BlockDeviceMappingProperty.Ebs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-ebs
             */
            public void setEbs(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ebs", value);
            }
            /**
             * ``SpotFleetResource.BlockDeviceMappingProperty.Ebs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-ebs
             */
            public void setEbs(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.EbsBlockDeviceProperty value) {
                this.jsiiSet("ebs", value);
            }
            /**
             * ``SpotFleetResource.BlockDeviceMappingProperty.NoDevice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-nodevice
             */
            @javax.annotation.Nullable
            public java.lang.Object getNoDevice() {
                return this.jsiiGet("noDevice", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.BlockDeviceMappingProperty.NoDevice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-nodevice
             */
            public void setNoDevice(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("noDevice", value);
            }
            /**
             * ``SpotFleetResource.BlockDeviceMappingProperty.NoDevice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-nodevice
             */
            public void setNoDevice(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("noDevice", value);
            }
            /**
             * ``SpotFleetResource.BlockDeviceMappingProperty.VirtualName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-virtualname
             */
            @javax.annotation.Nullable
            public java.lang.Object getVirtualName() {
                return this.jsiiGet("virtualName", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.BlockDeviceMappingProperty.VirtualName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-virtualname
             */
            public void setVirtualName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("virtualName", value);
            }
            /**
             * ``SpotFleetResource.BlockDeviceMappingProperty.VirtualName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-virtualname
             */
            public void setVirtualName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("virtualName", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html
     */
    public static interface EbsBlockDeviceProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``SpotFleetResource.EbsBlockDeviceProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-deleteontermination
         */
        java.lang.Object getDeleteOnTermination();
        /**
         * ``SpotFleetResource.EbsBlockDeviceProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-deleteontermination
         */
        void setDeleteOnTermination(final java.lang.Boolean value);
        /**
         * ``SpotFleetResource.EbsBlockDeviceProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-deleteontermination
         */
        void setDeleteOnTermination(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.EbsBlockDeviceProperty.Encrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-encrypted
         */
        java.lang.Object getEncrypted();
        /**
         * ``SpotFleetResource.EbsBlockDeviceProperty.Encrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-encrypted
         */
        void setEncrypted(final java.lang.Boolean value);
        /**
         * ``SpotFleetResource.EbsBlockDeviceProperty.Encrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-encrypted
         */
        void setEncrypted(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.EbsBlockDeviceProperty.Iops``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-iops
         */
        java.lang.Object getIops();
        /**
         * ``SpotFleetResource.EbsBlockDeviceProperty.Iops``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-iops
         */
        void setIops(final java.lang.Number value);
        /**
         * ``SpotFleetResource.EbsBlockDeviceProperty.Iops``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-iops
         */
        void setIops(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.EbsBlockDeviceProperty.SnapshotId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-snapshotid
         */
        java.lang.Object getSnapshotId();
        /**
         * ``SpotFleetResource.EbsBlockDeviceProperty.SnapshotId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-snapshotid
         */
        void setSnapshotId(final java.lang.String value);
        /**
         * ``SpotFleetResource.EbsBlockDeviceProperty.SnapshotId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-snapshotid
         */
        void setSnapshotId(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.EbsBlockDeviceProperty.VolumeSize``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumesize
         */
        java.lang.Object getVolumeSize();
        /**
         * ``SpotFleetResource.EbsBlockDeviceProperty.VolumeSize``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumesize
         */
        void setVolumeSize(final java.lang.Number value);
        /**
         * ``SpotFleetResource.EbsBlockDeviceProperty.VolumeSize``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumesize
         */
        void setVolumeSize(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.EbsBlockDeviceProperty.VolumeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumetype
         */
        java.lang.Object getVolumeType();
        /**
         * ``SpotFleetResource.EbsBlockDeviceProperty.VolumeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumetype
         */
        void setVolumeType(final java.lang.String value);
        /**
         * ``SpotFleetResource.EbsBlockDeviceProperty.VolumeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumetype
         */
        void setVolumeType(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link EbsBlockDeviceProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-deleteontermination
             */
            public Builder withDeleteOnTermination(final java.lang.Boolean value) {
                this.instance._deleteOnTermination = value;
                return this;
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-deleteontermination
             */
            public Builder withDeleteOnTermination(final software.amazon.awscdk.Token value) {
                this.instance._deleteOnTermination = value;
                return this;
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.Encrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-encrypted
             */
            public Builder withEncrypted(final java.lang.Boolean value) {
                this.instance._encrypted = value;
                return this;
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.Encrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-encrypted
             */
            public Builder withEncrypted(final software.amazon.awscdk.Token value) {
                this.instance._encrypted = value;
                return this;
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.Iops``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-iops
             */
            public Builder withIops(final java.lang.Number value) {
                this.instance._iops = value;
                return this;
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.Iops``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-iops
             */
            public Builder withIops(final software.amazon.awscdk.Token value) {
                this.instance._iops = value;
                return this;
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.SnapshotId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-snapshotid
             */
            public Builder withSnapshotId(final java.lang.String value) {
                this.instance._snapshotId = value;
                return this;
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.SnapshotId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-snapshotid
             */
            public Builder withSnapshotId(final software.amazon.awscdk.Token value) {
                this.instance._snapshotId = value;
                return this;
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.VolumeSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumesize
             */
            public Builder withVolumeSize(final java.lang.Number value) {
                this.instance._volumeSize = value;
                return this;
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.VolumeSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumesize
             */
            public Builder withVolumeSize(final software.amazon.awscdk.Token value) {
                this.instance._volumeSize = value;
                return this;
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.VolumeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumetype
             */
            public Builder withVolumeType(final java.lang.String value) {
                this.instance._volumeType = value;
                return this;
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.VolumeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumetype
             */
            public Builder withVolumeType(final software.amazon.awscdk.Token value) {
                this.instance._volumeType = value;
                return this;
            }
            public EbsBlockDeviceProperty build() {
                EbsBlockDeviceProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link EbsBlockDeviceProperty}.
         */
        final class Jsii$Pojo implements EbsBlockDeviceProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _deleteOnTermination;

            public java.lang.Object getDeleteOnTermination() {
                return this._deleteOnTermination;
            }
            public void setDeleteOnTermination(final java.lang.Boolean value) {
                this._deleteOnTermination = value;
            }
            public void setDeleteOnTermination(final software.amazon.awscdk.Token value) {
                this._deleteOnTermination = value;
            }

            protected java.lang.Object _encrypted;

            public java.lang.Object getEncrypted() {
                return this._encrypted;
            }
            public void setEncrypted(final java.lang.Boolean value) {
                this._encrypted = value;
            }
            public void setEncrypted(final software.amazon.awscdk.Token value) {
                this._encrypted = value;
            }

            protected java.lang.Object _iops;

            public java.lang.Object getIops() {
                return this._iops;
            }
            public void setIops(final java.lang.Number value) {
                this._iops = value;
            }
            public void setIops(final software.amazon.awscdk.Token value) {
                this._iops = value;
            }

            protected java.lang.Object _snapshotId;

            public java.lang.Object getSnapshotId() {
                return this._snapshotId;
            }
            public void setSnapshotId(final java.lang.String value) {
                this._snapshotId = value;
            }
            public void setSnapshotId(final software.amazon.awscdk.Token value) {
                this._snapshotId = value;
            }

            protected java.lang.Object _volumeSize;

            public java.lang.Object getVolumeSize() {
                return this._volumeSize;
            }
            public void setVolumeSize(final java.lang.Number value) {
                this._volumeSize = value;
            }
            public void setVolumeSize(final software.amazon.awscdk.Token value) {
                this._volumeSize = value;
            }

            protected java.lang.Object _volumeType;

            public java.lang.Object getVolumeType() {
                return this._volumeType;
            }
            public void setVolumeType(final java.lang.String value) {
                this._volumeType = value;
            }
            public void setVolumeType(final software.amazon.awscdk.Token value) {
                this._volumeType = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.EbsBlockDeviceProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-deleteontermination
             */
            @javax.annotation.Nullable
            public java.lang.Object getDeleteOnTermination() {
                return this.jsiiGet("deleteOnTermination", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-deleteontermination
             */
            public void setDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("deleteOnTermination", value);
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-deleteontermination
             */
            public void setDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("deleteOnTermination", value);
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.Encrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-encrypted
             */
            @javax.annotation.Nullable
            public java.lang.Object getEncrypted() {
                return this.jsiiGet("encrypted", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.Encrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-encrypted
             */
            public void setEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("encrypted", value);
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.Encrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-encrypted
             */
            public void setEncrypted(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("encrypted", value);
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.Iops``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-iops
             */
            @javax.annotation.Nullable
            public java.lang.Object getIops() {
                return this.jsiiGet("iops", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.Iops``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-iops
             */
            public void setIops(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("iops", value);
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.Iops``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-iops
             */
            public void setIops(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("iops", value);
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.SnapshotId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-snapshotid
             */
            @javax.annotation.Nullable
            public java.lang.Object getSnapshotId() {
                return this.jsiiGet("snapshotId", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.SnapshotId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-snapshotid
             */
            public void setSnapshotId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("snapshotId", value);
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.SnapshotId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-snapshotid
             */
            public void setSnapshotId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("snapshotId", value);
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.VolumeSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumesize
             */
            @javax.annotation.Nullable
            public java.lang.Object getVolumeSize() {
                return this.jsiiGet("volumeSize", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.VolumeSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumesize
             */
            public void setVolumeSize(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("volumeSize", value);
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.VolumeSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumesize
             */
            public void setVolumeSize(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("volumeSize", value);
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.VolumeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumetype
             */
            @javax.annotation.Nullable
            public java.lang.Object getVolumeType() {
                return this.jsiiGet("volumeType", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.VolumeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumetype
             */
            public void setVolumeType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("volumeType", value);
            }
            /**
             * ``SpotFleetResource.EbsBlockDeviceProperty.VolumeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumetype
             */
            public void setVolumeType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("volumeType", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html
     */
    public static interface GroupIdentifierProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``SpotFleetResource.GroupIdentifierProperty.GroupId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html#cfn-ec2-spotfleet-groupidentifier-groupid
         */
        java.lang.Object getGroupId();
        /**
         * ``SpotFleetResource.GroupIdentifierProperty.GroupId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html#cfn-ec2-spotfleet-groupidentifier-groupid
         */
        void setGroupId(final java.lang.String value);
        /**
         * ``SpotFleetResource.GroupIdentifierProperty.GroupId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html#cfn-ec2-spotfleet-groupidentifier-groupid
         */
        void setGroupId(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link GroupIdentifierProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``SpotFleetResource.GroupIdentifierProperty.GroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html#cfn-ec2-spotfleet-groupidentifier-groupid
             */
            public Build withGroupId(final java.lang.String value) {
                return new FullBuilder().withGroupId(value);
            }
            /**
             * ``SpotFleetResource.GroupIdentifierProperty.GroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html#cfn-ec2-spotfleet-groupidentifier-groupid
             */
            public Build withGroupId(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withGroupId(value);
            }

            public interface Build {
                /**
                 * @return a new {@link GroupIdentifierProperty} object, initialized with the values set on this builder.
                 */
                GroupIdentifierProperty build();
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``SpotFleetResource.GroupIdentifierProperty.GroupId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html#cfn-ec2-spotfleet-groupidentifier-groupid
                 */
                public Build withGroupId(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "GroupIdentifierProperty#groupId is required");
                    this.instance._groupId = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.GroupIdentifierProperty.GroupId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html#cfn-ec2-spotfleet-groupidentifier-groupid
                 */
                public Build withGroupId(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "GroupIdentifierProperty#groupId is required");
                    this.instance._groupId = value;
                    return this;
                }
                public GroupIdentifierProperty build() {
                    GroupIdentifierProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link GroupIdentifierProperty}.
         */
        final class Jsii$Pojo implements GroupIdentifierProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _groupId;

            public java.lang.Object getGroupId() {
                return this._groupId;
            }
            public void setGroupId(final java.lang.String value) {
                this._groupId = value;
            }
            public void setGroupId(final software.amazon.awscdk.Token value) {
                this._groupId = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.GroupIdentifierProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``SpotFleetResource.GroupIdentifierProperty.GroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html#cfn-ec2-spotfleet-groupidentifier-groupid
             */
            public java.lang.Object getGroupId() {
                return this.jsiiGet("groupId", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.GroupIdentifierProperty.GroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html#cfn-ec2-spotfleet-groupidentifier-groupid
             */
            public void setGroupId(final java.lang.String value) {
                this.jsiiSet("groupId", java.util.Objects.requireNonNull(value, "groupId is required"));
            }
            /**
             * ``SpotFleetResource.GroupIdentifierProperty.GroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html#cfn-ec2-spotfleet-groupidentifier-groupid
             */
            public void setGroupId(final software.amazon.awscdk.Token value) {
                this.jsiiSet("groupId", java.util.Objects.requireNonNull(value, "groupId is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html
     */
    public static interface IamInstanceProfileSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``SpotFleetResource.IamInstanceProfileSpecificationProperty.Arn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html#cfn-ec2-spotfleet-iaminstanceprofilespecification-arn
         */
        java.lang.Object getArn();
        /**
         * ``SpotFleetResource.IamInstanceProfileSpecificationProperty.Arn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html#cfn-ec2-spotfleet-iaminstanceprofilespecification-arn
         */
        void setArn(final java.lang.String value);
        /**
         * ``SpotFleetResource.IamInstanceProfileSpecificationProperty.Arn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html#cfn-ec2-spotfleet-iaminstanceprofilespecification-arn
         */
        void setArn(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link IamInstanceProfileSpecificationProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``SpotFleetResource.IamInstanceProfileSpecificationProperty.Arn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html#cfn-ec2-spotfleet-iaminstanceprofilespecification-arn
             */
            public Builder withArn(final java.lang.String value) {
                this.instance._arn = value;
                return this;
            }
            /**
             * ``SpotFleetResource.IamInstanceProfileSpecificationProperty.Arn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html#cfn-ec2-spotfleet-iaminstanceprofilespecification-arn
             */
            public Builder withArn(final software.amazon.awscdk.Token value) {
                this.instance._arn = value;
                return this;
            }
            public IamInstanceProfileSpecificationProperty build() {
                IamInstanceProfileSpecificationProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link IamInstanceProfileSpecificationProperty}.
         */
        final class Jsii$Pojo implements IamInstanceProfileSpecificationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _arn;

            public java.lang.Object getArn() {
                return this._arn;
            }
            public void setArn(final java.lang.String value) {
                this._arn = value;
            }
            public void setArn(final software.amazon.awscdk.Token value) {
                this._arn = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.IamInstanceProfileSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``SpotFleetResource.IamInstanceProfileSpecificationProperty.Arn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html#cfn-ec2-spotfleet-iaminstanceprofilespecification-arn
             */
            @javax.annotation.Nullable
            public java.lang.Object getArn() {
                return this.jsiiGet("arn", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.IamInstanceProfileSpecificationProperty.Arn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html#cfn-ec2-spotfleet-iaminstanceprofilespecification-arn
             */
            public void setArn(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("arn", value);
            }
            /**
             * ``SpotFleetResource.IamInstanceProfileSpecificationProperty.Arn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html#cfn-ec2-spotfleet-iaminstanceprofilespecification-arn
             */
            public void setArn(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("arn", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html
     */
    public static interface InstanceIpv6AddressProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``SpotFleetResource.InstanceIpv6AddressProperty.Ipv6Address``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html#cfn-ec2-spotfleet-instanceipv6address-ipv6address
         */
        java.lang.Object getIpv6Address();
        /**
         * ``SpotFleetResource.InstanceIpv6AddressProperty.Ipv6Address``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html#cfn-ec2-spotfleet-instanceipv6address-ipv6address
         */
        void setIpv6Address(final java.lang.String value);
        /**
         * ``SpotFleetResource.InstanceIpv6AddressProperty.Ipv6Address``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html#cfn-ec2-spotfleet-instanceipv6address-ipv6address
         */
        void setIpv6Address(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link InstanceIpv6AddressProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``SpotFleetResource.InstanceIpv6AddressProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html#cfn-ec2-spotfleet-instanceipv6address-ipv6address
             */
            public Build withIpv6Address(final java.lang.String value) {
                return new FullBuilder().withIpv6Address(value);
            }
            /**
             * ``SpotFleetResource.InstanceIpv6AddressProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html#cfn-ec2-spotfleet-instanceipv6address-ipv6address
             */
            public Build withIpv6Address(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withIpv6Address(value);
            }

            public interface Build {
                /**
                 * @return a new {@link InstanceIpv6AddressProperty} object, initialized with the values set on this builder.
                 */
                InstanceIpv6AddressProperty build();
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``SpotFleetResource.InstanceIpv6AddressProperty.Ipv6Address``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html#cfn-ec2-spotfleet-instanceipv6address-ipv6address
                 */
                public Build withIpv6Address(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "InstanceIpv6AddressProperty#ipv6Address is required");
                    this.instance._ipv6Address = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.InstanceIpv6AddressProperty.Ipv6Address``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html#cfn-ec2-spotfleet-instanceipv6address-ipv6address
                 */
                public Build withIpv6Address(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "InstanceIpv6AddressProperty#ipv6Address is required");
                    this.instance._ipv6Address = value;
                    return this;
                }
                public InstanceIpv6AddressProperty build() {
                    InstanceIpv6AddressProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link InstanceIpv6AddressProperty}.
         */
        final class Jsii$Pojo implements InstanceIpv6AddressProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _ipv6Address;

            public java.lang.Object getIpv6Address() {
                return this._ipv6Address;
            }
            public void setIpv6Address(final java.lang.String value) {
                this._ipv6Address = value;
            }
            public void setIpv6Address(final software.amazon.awscdk.Token value) {
                this._ipv6Address = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.InstanceIpv6AddressProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``SpotFleetResource.InstanceIpv6AddressProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html#cfn-ec2-spotfleet-instanceipv6address-ipv6address
             */
            public java.lang.Object getIpv6Address() {
                return this.jsiiGet("ipv6Address", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.InstanceIpv6AddressProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html#cfn-ec2-spotfleet-instanceipv6address-ipv6address
             */
            public void setIpv6Address(final java.lang.String value) {
                this.jsiiSet("ipv6Address", java.util.Objects.requireNonNull(value, "ipv6Address is required"));
            }
            /**
             * ``SpotFleetResource.InstanceIpv6AddressProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html#cfn-ec2-spotfleet-instanceipv6address-ipv6address
             */
            public void setIpv6Address(final software.amazon.awscdk.Token value) {
                this.jsiiSet("ipv6Address", java.util.Objects.requireNonNull(value, "ipv6Address is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html
     */
    public static interface InstanceNetworkInterfaceSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-associatepublicipaddress
         */
        java.lang.Object getAssociatePublicIpAddress();
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-associatepublicipaddress
         */
        void setAssociatePublicIpAddress(final java.lang.Boolean value);
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-associatepublicipaddress
         */
        void setAssociatePublicIpAddress(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deleteontermination
         */
        java.lang.Object getDeleteOnTermination();
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deleteontermination
         */
        void setDeleteOnTermination(final java.lang.Boolean value);
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deleteontermination
         */
        void setDeleteOnTermination(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-description
         */
        java.lang.Object getDescription();
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-description
         */
        void setDescription(final java.lang.String value);
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-description
         */
        void setDescription(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deviceindex
         */
        java.lang.Object getDeviceIndex();
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deviceindex
         */
        void setDeviceIndex(final java.lang.Number value);
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deviceindex
         */
        void setDeviceIndex(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Groups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-groups
         */
        java.lang.Object getGroups();
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Groups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-groups
         */
        void setGroups(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Groups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-groups
         */
        void setGroups(final java.util.List<java.lang.Object> value);
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresscount
         */
        java.lang.Object getIpv6AddressCount();
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresscount
         */
        void setIpv6AddressCount(final java.lang.Number value);
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresscount
         */
        void setIpv6AddressCount(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresses
         */
        java.lang.Object getIpv6Addresses();
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresses
         */
        void setIpv6Addresses(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresses
         */
        void setIpv6Addresses(final java.util.List<java.lang.Object> value);
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-networkinterfaceid
         */
        java.lang.Object getNetworkInterfaceId();
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-networkinterfaceid
         */
        void setNetworkInterfaceId(final java.lang.String value);
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-networkinterfaceid
         */
        void setNetworkInterfaceId(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-privateipaddresses
         */
        java.lang.Object getPrivateIpAddresses();
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-privateipaddresses
         */
        void setPrivateIpAddresses(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-privateipaddresses
         */
        void setPrivateIpAddresses(final java.util.List<java.lang.Object> value);
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-secondaryprivateipaddresscount
         */
        java.lang.Object getSecondaryPrivateIpAddressCount();
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-secondaryprivateipaddresscount
         */
        void setSecondaryPrivateIpAddressCount(final java.lang.Number value);
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-secondaryprivateipaddresscount
         */
        void setSecondaryPrivateIpAddressCount(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-subnetid
         */
        java.lang.Object getSubnetId();
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-subnetid
         */
        void setSubnetId(final java.lang.String value);
        /**
         * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-subnetid
         */
        void setSubnetId(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link InstanceNetworkInterfaceSpecificationProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-associatepublicipaddress
             */
            public Builder withAssociatePublicIpAddress(final java.lang.Boolean value) {
                this.instance._associatePublicIpAddress = value;
                return this;
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-associatepublicipaddress
             */
            public Builder withAssociatePublicIpAddress(final software.amazon.awscdk.Token value) {
                this.instance._associatePublicIpAddress = value;
                return this;
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deleteontermination
             */
            public Builder withDeleteOnTermination(final java.lang.Boolean value) {
                this.instance._deleteOnTermination = value;
                return this;
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deleteontermination
             */
            public Builder withDeleteOnTermination(final software.amazon.awscdk.Token value) {
                this.instance._deleteOnTermination = value;
                return this;
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-description
             */
            public Builder withDescription(final java.lang.String value) {
                this.instance._description = value;
                return this;
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-description
             */
            public Builder withDescription(final software.amazon.awscdk.Token value) {
                this.instance._description = value;
                return this;
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deviceindex
             */
            public Builder withDeviceIndex(final java.lang.Number value) {
                this.instance._deviceIndex = value;
                return this;
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deviceindex
             */
            public Builder withDeviceIndex(final software.amazon.awscdk.Token value) {
                this.instance._deviceIndex = value;
                return this;
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Groups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-groups
             */
            public Builder withGroups(final software.amazon.awscdk.Token value) {
                this.instance._groups = value;
                return this;
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Groups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-groups
             */
            public Builder withGroups(final java.util.List<java.lang.Object> value) {
                this.instance._groups = value;
                return this;
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresscount
             */
            public Builder withIpv6AddressCount(final java.lang.Number value) {
                this.instance._ipv6AddressCount = value;
                return this;
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresscount
             */
            public Builder withIpv6AddressCount(final software.amazon.awscdk.Token value) {
                this.instance._ipv6AddressCount = value;
                return this;
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresses
             */
            public Builder withIpv6Addresses(final software.amazon.awscdk.Token value) {
                this.instance._ipv6Addresses = value;
                return this;
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresses
             */
            public Builder withIpv6Addresses(final java.util.List<java.lang.Object> value) {
                this.instance._ipv6Addresses = value;
                return this;
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-networkinterfaceid
             */
            public Builder withNetworkInterfaceId(final java.lang.String value) {
                this.instance._networkInterfaceId = value;
                return this;
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-networkinterfaceid
             */
            public Builder withNetworkInterfaceId(final software.amazon.awscdk.Token value) {
                this.instance._networkInterfaceId = value;
                return this;
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-privateipaddresses
             */
            public Builder withPrivateIpAddresses(final software.amazon.awscdk.Token value) {
                this.instance._privateIpAddresses = value;
                return this;
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-privateipaddresses
             */
            public Builder withPrivateIpAddresses(final java.util.List<java.lang.Object> value) {
                this.instance._privateIpAddresses = value;
                return this;
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-secondaryprivateipaddresscount
             */
            public Builder withSecondaryPrivateIpAddressCount(final java.lang.Number value) {
                this.instance._secondaryPrivateIpAddressCount = value;
                return this;
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-secondaryprivateipaddresscount
             */
            public Builder withSecondaryPrivateIpAddressCount(final software.amazon.awscdk.Token value) {
                this.instance._secondaryPrivateIpAddressCount = value;
                return this;
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-subnetid
             */
            public Builder withSubnetId(final java.lang.String value) {
                this.instance._subnetId = value;
                return this;
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-subnetid
             */
            public Builder withSubnetId(final software.amazon.awscdk.Token value) {
                this.instance._subnetId = value;
                return this;
            }
            public InstanceNetworkInterfaceSpecificationProperty build() {
                InstanceNetworkInterfaceSpecificationProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link InstanceNetworkInterfaceSpecificationProperty}.
         */
        final class Jsii$Pojo implements InstanceNetworkInterfaceSpecificationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _associatePublicIpAddress;

            public java.lang.Object getAssociatePublicIpAddress() {
                return this._associatePublicIpAddress;
            }
            public void setAssociatePublicIpAddress(final java.lang.Boolean value) {
                this._associatePublicIpAddress = value;
            }
            public void setAssociatePublicIpAddress(final software.amazon.awscdk.Token value) {
                this._associatePublicIpAddress = value;
            }

            protected java.lang.Object _deleteOnTermination;

            public java.lang.Object getDeleteOnTermination() {
                return this._deleteOnTermination;
            }
            public void setDeleteOnTermination(final java.lang.Boolean value) {
                this._deleteOnTermination = value;
            }
            public void setDeleteOnTermination(final software.amazon.awscdk.Token value) {
                this._deleteOnTermination = value;
            }

            protected java.lang.Object _description;

            public java.lang.Object getDescription() {
                return this._description;
            }
            public void setDescription(final java.lang.String value) {
                this._description = value;
            }
            public void setDescription(final software.amazon.awscdk.Token value) {
                this._description = value;
            }

            protected java.lang.Object _deviceIndex;

            public java.lang.Object getDeviceIndex() {
                return this._deviceIndex;
            }
            public void setDeviceIndex(final java.lang.Number value) {
                this._deviceIndex = value;
            }
            public void setDeviceIndex(final software.amazon.awscdk.Token value) {
                this._deviceIndex = value;
            }

            protected java.lang.Object _groups;

            public java.lang.Object getGroups() {
                return this._groups;
            }
            public void setGroups(final software.amazon.awscdk.Token value) {
                this._groups = value;
            }
            public void setGroups(final java.util.List<java.lang.Object> value) {
                this._groups = value;
            }

            protected java.lang.Object _ipv6AddressCount;

            public java.lang.Object getIpv6AddressCount() {
                return this._ipv6AddressCount;
            }
            public void setIpv6AddressCount(final java.lang.Number value) {
                this._ipv6AddressCount = value;
            }
            public void setIpv6AddressCount(final software.amazon.awscdk.Token value) {
                this._ipv6AddressCount = value;
            }

            protected java.lang.Object _ipv6Addresses;

            public java.lang.Object getIpv6Addresses() {
                return this._ipv6Addresses;
            }
            public void setIpv6Addresses(final software.amazon.awscdk.Token value) {
                this._ipv6Addresses = value;
            }
            public void setIpv6Addresses(final java.util.List<java.lang.Object> value) {
                this._ipv6Addresses = value;
            }

            protected java.lang.Object _networkInterfaceId;

            public java.lang.Object getNetworkInterfaceId() {
                return this._networkInterfaceId;
            }
            public void setNetworkInterfaceId(final java.lang.String value) {
                this._networkInterfaceId = value;
            }
            public void setNetworkInterfaceId(final software.amazon.awscdk.Token value) {
                this._networkInterfaceId = value;
            }

            protected java.lang.Object _privateIpAddresses;

            public java.lang.Object getPrivateIpAddresses() {
                return this._privateIpAddresses;
            }
            public void setPrivateIpAddresses(final software.amazon.awscdk.Token value) {
                this._privateIpAddresses = value;
            }
            public void setPrivateIpAddresses(final java.util.List<java.lang.Object> value) {
                this._privateIpAddresses = value;
            }

            protected java.lang.Object _secondaryPrivateIpAddressCount;

            public java.lang.Object getSecondaryPrivateIpAddressCount() {
                return this._secondaryPrivateIpAddressCount;
            }
            public void setSecondaryPrivateIpAddressCount(final java.lang.Number value) {
                this._secondaryPrivateIpAddressCount = value;
            }
            public void setSecondaryPrivateIpAddressCount(final software.amazon.awscdk.Token value) {
                this._secondaryPrivateIpAddressCount = value;
            }

            protected java.lang.Object _subnetId;

            public java.lang.Object getSubnetId() {
                return this._subnetId;
            }
            public void setSubnetId(final java.lang.String value) {
                this._subnetId = value;
            }
            public void setSubnetId(final software.amazon.awscdk.Token value) {
                this._subnetId = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-associatepublicipaddress
             */
            @javax.annotation.Nullable
            public java.lang.Object getAssociatePublicIpAddress() {
                return this.jsiiGet("associatePublicIpAddress", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-associatepublicipaddress
             */
            public void setAssociatePublicIpAddress(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("associatePublicIpAddress", value);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-associatepublicipaddress
             */
            public void setAssociatePublicIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("associatePublicIpAddress", value);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deleteontermination
             */
            @javax.annotation.Nullable
            public java.lang.Object getDeleteOnTermination() {
                return this.jsiiGet("deleteOnTermination", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deleteontermination
             */
            public void setDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("deleteOnTermination", value);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deleteontermination
             */
            public void setDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("deleteOnTermination", value);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-description
             */
            @javax.annotation.Nullable
            public java.lang.Object getDescription() {
                return this.jsiiGet("description", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-description
             */
            public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("description", value);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-description
             */
            public void setDescription(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("description", value);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deviceindex
             */
            @javax.annotation.Nullable
            public java.lang.Object getDeviceIndex() {
                return this.jsiiGet("deviceIndex", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deviceindex
             */
            public void setDeviceIndex(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("deviceIndex", value);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deviceindex
             */
            public void setDeviceIndex(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("deviceIndex", value);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Groups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-groups
             */
            @javax.annotation.Nullable
            public java.lang.Object getGroups() {
                return this.jsiiGet("groups", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Groups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-groups
             */
            public void setGroups(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("groups", value);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Groups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-groups
             */
            public void setGroups(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("groups", value);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresscount
             */
            @javax.annotation.Nullable
            public java.lang.Object getIpv6AddressCount() {
                return this.jsiiGet("ipv6AddressCount", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresscount
             */
            public void setIpv6AddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("ipv6AddressCount", value);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresscount
             */
            public void setIpv6AddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ipv6AddressCount", value);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresses
             */
            @javax.annotation.Nullable
            public java.lang.Object getIpv6Addresses() {
                return this.jsiiGet("ipv6Addresses", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresses
             */
            public void setIpv6Addresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ipv6Addresses", value);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresses
             */
            public void setIpv6Addresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("ipv6Addresses", value);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-networkinterfaceid
             */
            @javax.annotation.Nullable
            public java.lang.Object getNetworkInterfaceId() {
                return this.jsiiGet("networkInterfaceId", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-networkinterfaceid
             */
            public void setNetworkInterfaceId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("networkInterfaceId", value);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-networkinterfaceid
             */
            public void setNetworkInterfaceId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("networkInterfaceId", value);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-privateipaddresses
             */
            @javax.annotation.Nullable
            public java.lang.Object getPrivateIpAddresses() {
                return this.jsiiGet("privateIpAddresses", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-privateipaddresses
             */
            public void setPrivateIpAddresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("privateIpAddresses", value);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-privateipaddresses
             */
            public void setPrivateIpAddresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("privateIpAddresses", value);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-secondaryprivateipaddresscount
             */
            @javax.annotation.Nullable
            public java.lang.Object getSecondaryPrivateIpAddressCount() {
                return this.jsiiGet("secondaryPrivateIpAddressCount", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-secondaryprivateipaddresscount
             */
            public void setSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("secondaryPrivateIpAddressCount", value);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-secondaryprivateipaddresscount
             */
            public void setSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("secondaryPrivateIpAddressCount", value);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-subnetid
             */
            @javax.annotation.Nullable
            public java.lang.Object getSubnetId() {
                return this.jsiiGet("subnetId", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-subnetid
             */
            public void setSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("subnetId", value);
            }
            /**
             * ``SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-subnetid
             */
            public void setSubnetId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("subnetId", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html
     */
    public static interface PrivateIpAddressSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``SpotFleetResource.PrivateIpAddressSpecificationProperty.Primary``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-primary
         */
        java.lang.Object getPrimary();
        /**
         * ``SpotFleetResource.PrivateIpAddressSpecificationProperty.Primary``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-primary
         */
        void setPrimary(final java.lang.Boolean value);
        /**
         * ``SpotFleetResource.PrivateIpAddressSpecificationProperty.Primary``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-primary
         */
        void setPrimary(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-privateipaddress
         */
        java.lang.Object getPrivateIpAddress();
        /**
         * ``SpotFleetResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-privateipaddress
         */
        void setPrivateIpAddress(final java.lang.String value);
        /**
         * ``SpotFleetResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-privateipaddress
         */
        void setPrivateIpAddress(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link PrivateIpAddressSpecificationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``SpotFleetResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-privateipaddress
             */
            public Build withPrivateIpAddress(final java.lang.String value) {
                return new FullBuilder().withPrivateIpAddress(value);
            }
            /**
             * ``SpotFleetResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-privateipaddress
             */
            public Build withPrivateIpAddress(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withPrivateIpAddress(value);
            }

            public interface Build {
                /**
                 * @return a new {@link PrivateIpAddressSpecificationProperty} object, initialized with the values set on this builder.
                 */
                PrivateIpAddressSpecificationProperty build();
                /**
                 * ``SpotFleetResource.PrivateIpAddressSpecificationProperty.Primary``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-primary
                 */
                Build withPrimary(final java.lang.Boolean value);
                /**
                 * ``SpotFleetResource.PrivateIpAddressSpecificationProperty.Primary``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-primary
                 */
                Build withPrimary(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``SpotFleetResource.PrivateIpAddressSpecificationProperty.Primary``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-primary
                 */
                public Build withPrimary(final java.lang.Boolean value) {
                    this.instance._primary = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.PrivateIpAddressSpecificationProperty.Primary``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-primary
                 */
                public Build withPrimary(final software.amazon.awscdk.Token value) {
                    this.instance._primary = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-privateipaddress
                 */
                public Build withPrivateIpAddress(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "PrivateIpAddressSpecificationProperty#privateIpAddress is required");
                    this.instance._privateIpAddress = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-privateipaddress
                 */
                public Build withPrivateIpAddress(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "PrivateIpAddressSpecificationProperty#privateIpAddress is required");
                    this.instance._privateIpAddress = value;
                    return this;
                }
                public PrivateIpAddressSpecificationProperty build() {
                    PrivateIpAddressSpecificationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link PrivateIpAddressSpecificationProperty}.
         */
        final class Jsii$Pojo implements PrivateIpAddressSpecificationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _primary;

            public java.lang.Object getPrimary() {
                return this._primary;
            }
            public void setPrimary(final java.lang.Boolean value) {
                this._primary = value;
            }
            public void setPrimary(final software.amazon.awscdk.Token value) {
                this._primary = value;
            }

            protected java.lang.Object _privateIpAddress;

            public java.lang.Object getPrivateIpAddress() {
                return this._privateIpAddress;
            }
            public void setPrivateIpAddress(final java.lang.String value) {
                this._privateIpAddress = value;
            }
            public void setPrivateIpAddress(final software.amazon.awscdk.Token value) {
                this._privateIpAddress = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.PrivateIpAddressSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``SpotFleetResource.PrivateIpAddressSpecificationProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-primary
             */
            @javax.annotation.Nullable
            public java.lang.Object getPrimary() {
                return this.jsiiGet("primary", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.PrivateIpAddressSpecificationProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-primary
             */
            public void setPrimary(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("primary", value);
            }
            /**
             * ``SpotFleetResource.PrivateIpAddressSpecificationProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-primary
             */
            public void setPrimary(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("primary", value);
            }
            /**
             * ``SpotFleetResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-privateipaddress
             */
            public java.lang.Object getPrivateIpAddress() {
                return this.jsiiGet("privateIpAddress", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-privateipaddress
             */
            public void setPrivateIpAddress(final java.lang.String value) {
                this.jsiiSet("privateIpAddress", java.util.Objects.requireNonNull(value, "privateIpAddress is required"));
            }
            /**
             * ``SpotFleetResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-privateipaddress
             */
            public void setPrivateIpAddress(final software.amazon.awscdk.Token value) {
                this.jsiiSet("privateIpAddress", java.util.Objects.requireNonNull(value, "privateIpAddress is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html
     */
    public static interface SpotFleetLaunchSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-blockdevicemappings
         */
        java.lang.Object getBlockDeviceMappings();
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-blockdevicemappings
         */
        void setBlockDeviceMappings(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-blockdevicemappings
         */
        void setBlockDeviceMappings(final java.util.List<java.lang.Object> value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.EbsOptimized``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ebsoptimized
         */
        java.lang.Object getEbsOptimized();
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.EbsOptimized``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ebsoptimized
         */
        void setEbsOptimized(final java.lang.Boolean value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.EbsOptimized``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ebsoptimized
         */
        void setEbsOptimized(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.IamInstanceProfile``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-iaminstanceprofile
         */
        java.lang.Object getIamInstanceProfile();
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.IamInstanceProfile``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-iaminstanceprofile
         */
        void setIamInstanceProfile(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.IamInstanceProfile``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-iaminstanceprofile
         */
        void setIamInstanceProfile(final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.IamInstanceProfileSpecificationProperty value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.ImageId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-imageid
         */
        java.lang.Object getImageId();
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.ImageId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-imageid
         */
        void setImageId(final java.lang.String value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.ImageId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-imageid
         */
        void setImageId(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.InstanceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-instancetype
         */
        java.lang.Object getInstanceType();
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.InstanceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-instancetype
         */
        void setInstanceType(final java.lang.String value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.InstanceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-instancetype
         */
        void setInstanceType(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.KernelId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-kernelid
         */
        java.lang.Object getKernelId();
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.KernelId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-kernelid
         */
        void setKernelId(final java.lang.String value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.KernelId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-kernelid
         */
        void setKernelId(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.KeyName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-keyname
         */
        java.lang.Object getKeyName();
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.KeyName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-keyname
         */
        void setKeyName(final java.lang.String value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.KeyName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-keyname
         */
        void setKeyName(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.Monitoring``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-monitoring
         */
        java.lang.Object getMonitoring();
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.Monitoring``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-monitoring
         */
        void setMonitoring(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.Monitoring``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-monitoring
         */
        void setMonitoring(final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.SpotFleetMonitoringProperty value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.NetworkInterfaces``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-networkinterfaces
         */
        java.lang.Object getNetworkInterfaces();
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.NetworkInterfaces``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-networkinterfaces
         */
        void setNetworkInterfaces(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.NetworkInterfaces``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-networkinterfaces
         */
        void setNetworkInterfaces(final java.util.List<java.lang.Object> value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.Placement``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-placement
         */
        java.lang.Object getPlacement();
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.Placement``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-placement
         */
        void setPlacement(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.Placement``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-placement
         */
        void setPlacement(final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.SpotPlacementProperty value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.RamdiskId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ramdiskid
         */
        java.lang.Object getRamdiskId();
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.RamdiskId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ramdiskid
         */
        void setRamdiskId(final java.lang.String value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.RamdiskId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ramdiskid
         */
        void setRamdiskId(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SecurityGroups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-securitygroups
         */
        java.lang.Object getSecurityGroups();
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SecurityGroups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-securitygroups
         */
        void setSecurityGroups(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SecurityGroups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-securitygroups
         */
        void setSecurityGroups(final java.util.List<java.lang.Object> value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SpotPrice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-spotprice
         */
        java.lang.Object getSpotPrice();
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SpotPrice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-spotprice
         */
        void setSpotPrice(final java.lang.String value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SpotPrice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-spotprice
         */
        void setSpotPrice(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-subnetid
         */
        java.lang.Object getSubnetId();
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-subnetid
         */
        void setSubnetId(final java.lang.String value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-subnetid
         */
        void setSubnetId(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.TagSpecifications``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-tagspecifications
         */
        java.lang.Object getTagSpecifications();
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.TagSpecifications``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-tagspecifications
         */
        void setTagSpecifications(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.TagSpecifications``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-tagspecifications
         */
        void setTagSpecifications(final java.util.List<java.lang.Object> value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.UserData``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-userdata
         */
        java.lang.Object getUserData();
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.UserData``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-userdata
         */
        void setUserData(final java.lang.String value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.UserData``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-userdata
         */
        void setUserData(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.WeightedCapacity``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-weightedcapacity
         */
        java.lang.Object getWeightedCapacity();
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.WeightedCapacity``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-weightedcapacity
         */
        void setWeightedCapacity(final java.lang.Number value);
        /**
         * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.WeightedCapacity``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-weightedcapacity
         */
        void setWeightedCapacity(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link SpotFleetLaunchSpecificationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.ImageId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-imageid
             */
            public InstanceTypeStep withImageId(final java.lang.String value) {
                return new FullBuilder().withImageId(value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.ImageId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-imageid
             */
            public InstanceTypeStep withImageId(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withImageId(value);
            }

            public interface InstanceTypeStep {
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.InstanceType``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-instancetype
                 */
                Build withInstanceType(final java.lang.String value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.InstanceType``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-instancetype
                 */
                Build withInstanceType(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link SpotFleetLaunchSpecificationProperty} object, initialized with the values set on this builder.
                 */
                SpotFleetLaunchSpecificationProperty build();
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-blockdevicemappings
                 */
                Build withBlockDeviceMappings(final software.amazon.awscdk.Token value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-blockdevicemappings
                 */
                Build withBlockDeviceMappings(final java.util.List<java.lang.Object> value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.EbsOptimized``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ebsoptimized
                 */
                Build withEbsOptimized(final java.lang.Boolean value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.EbsOptimized``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ebsoptimized
                 */
                Build withEbsOptimized(final software.amazon.awscdk.Token value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.IamInstanceProfile``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-iaminstanceprofile
                 */
                Build withIamInstanceProfile(final software.amazon.awscdk.Token value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.IamInstanceProfile``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-iaminstanceprofile
                 */
                Build withIamInstanceProfile(final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.IamInstanceProfileSpecificationProperty value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.KernelId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-kernelid
                 */
                Build withKernelId(final java.lang.String value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.KernelId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-kernelid
                 */
                Build withKernelId(final software.amazon.awscdk.Token value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.KeyName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-keyname
                 */
                Build withKeyName(final java.lang.String value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.KeyName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-keyname
                 */
                Build withKeyName(final software.amazon.awscdk.Token value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.Monitoring``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-monitoring
                 */
                Build withMonitoring(final software.amazon.awscdk.Token value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.Monitoring``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-monitoring
                 */
                Build withMonitoring(final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.SpotFleetMonitoringProperty value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.NetworkInterfaces``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-networkinterfaces
                 */
                Build withNetworkInterfaces(final software.amazon.awscdk.Token value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.NetworkInterfaces``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-networkinterfaces
                 */
                Build withNetworkInterfaces(final java.util.List<java.lang.Object> value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.Placement``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-placement
                 */
                Build withPlacement(final software.amazon.awscdk.Token value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.Placement``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-placement
                 */
                Build withPlacement(final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.SpotPlacementProperty value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.RamdiskId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ramdiskid
                 */
                Build withRamdiskId(final java.lang.String value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.RamdiskId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ramdiskid
                 */
                Build withRamdiskId(final software.amazon.awscdk.Token value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SecurityGroups``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-securitygroups
                 */
                Build withSecurityGroups(final software.amazon.awscdk.Token value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SecurityGroups``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-securitygroups
                 */
                Build withSecurityGroups(final java.util.List<java.lang.Object> value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SpotPrice``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-spotprice
                 */
                Build withSpotPrice(final java.lang.String value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SpotPrice``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-spotprice
                 */
                Build withSpotPrice(final software.amazon.awscdk.Token value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SubnetId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-subnetid
                 */
                Build withSubnetId(final java.lang.String value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SubnetId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-subnetid
                 */
                Build withSubnetId(final software.amazon.awscdk.Token value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.TagSpecifications``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-tagspecifications
                 */
                Build withTagSpecifications(final software.amazon.awscdk.Token value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.TagSpecifications``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-tagspecifications
                 */
                Build withTagSpecifications(final java.util.List<java.lang.Object> value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.UserData``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-userdata
                 */
                Build withUserData(final java.lang.String value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.UserData``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-userdata
                 */
                Build withUserData(final software.amazon.awscdk.Token value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.WeightedCapacity``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-weightedcapacity
                 */
                Build withWeightedCapacity(final java.lang.Number value);
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.WeightedCapacity``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-weightedcapacity
                 */
                Build withWeightedCapacity(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements InstanceTypeStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-blockdevicemappings
                 */
                public Build withBlockDeviceMappings(final software.amazon.awscdk.Token value) {
                    this.instance._blockDeviceMappings = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-blockdevicemappings
                 */
                public Build withBlockDeviceMappings(final java.util.List<java.lang.Object> value) {
                    this.instance._blockDeviceMappings = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.EbsOptimized``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ebsoptimized
                 */
                public Build withEbsOptimized(final java.lang.Boolean value) {
                    this.instance._ebsOptimized = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.EbsOptimized``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ebsoptimized
                 */
                public Build withEbsOptimized(final software.amazon.awscdk.Token value) {
                    this.instance._ebsOptimized = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.IamInstanceProfile``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-iaminstanceprofile
                 */
                public Build withIamInstanceProfile(final software.amazon.awscdk.Token value) {
                    this.instance._iamInstanceProfile = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.IamInstanceProfile``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-iaminstanceprofile
                 */
                public Build withIamInstanceProfile(final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.IamInstanceProfileSpecificationProperty value) {
                    this.instance._iamInstanceProfile = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.ImageId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-imageid
                 */
                public InstanceTypeStep withImageId(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "SpotFleetLaunchSpecificationProperty#imageId is required");
                    this.instance._imageId = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.ImageId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-imageid
                 */
                public InstanceTypeStep withImageId(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "SpotFleetLaunchSpecificationProperty#imageId is required");
                    this.instance._imageId = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.InstanceType``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-instancetype
                 */
                public Build withInstanceType(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "SpotFleetLaunchSpecificationProperty#instanceType is required");
                    this.instance._instanceType = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.InstanceType``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-instancetype
                 */
                public Build withInstanceType(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "SpotFleetLaunchSpecificationProperty#instanceType is required");
                    this.instance._instanceType = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.KernelId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-kernelid
                 */
                public Build withKernelId(final java.lang.String value) {
                    this.instance._kernelId = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.KernelId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-kernelid
                 */
                public Build withKernelId(final software.amazon.awscdk.Token value) {
                    this.instance._kernelId = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.KeyName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-keyname
                 */
                public Build withKeyName(final java.lang.String value) {
                    this.instance._keyName = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.KeyName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-keyname
                 */
                public Build withKeyName(final software.amazon.awscdk.Token value) {
                    this.instance._keyName = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.Monitoring``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-monitoring
                 */
                public Build withMonitoring(final software.amazon.awscdk.Token value) {
                    this.instance._monitoring = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.Monitoring``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-monitoring
                 */
                public Build withMonitoring(final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.SpotFleetMonitoringProperty value) {
                    this.instance._monitoring = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.NetworkInterfaces``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-networkinterfaces
                 */
                public Build withNetworkInterfaces(final software.amazon.awscdk.Token value) {
                    this.instance._networkInterfaces = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.NetworkInterfaces``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-networkinterfaces
                 */
                public Build withNetworkInterfaces(final java.util.List<java.lang.Object> value) {
                    this.instance._networkInterfaces = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.Placement``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-placement
                 */
                public Build withPlacement(final software.amazon.awscdk.Token value) {
                    this.instance._placement = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.Placement``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-placement
                 */
                public Build withPlacement(final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.SpotPlacementProperty value) {
                    this.instance._placement = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.RamdiskId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ramdiskid
                 */
                public Build withRamdiskId(final java.lang.String value) {
                    this.instance._ramdiskId = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.RamdiskId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ramdiskid
                 */
                public Build withRamdiskId(final software.amazon.awscdk.Token value) {
                    this.instance._ramdiskId = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SecurityGroups``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-securitygroups
                 */
                public Build withSecurityGroups(final software.amazon.awscdk.Token value) {
                    this.instance._securityGroups = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SecurityGroups``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-securitygroups
                 */
                public Build withSecurityGroups(final java.util.List<java.lang.Object> value) {
                    this.instance._securityGroups = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SpotPrice``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-spotprice
                 */
                public Build withSpotPrice(final java.lang.String value) {
                    this.instance._spotPrice = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SpotPrice``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-spotprice
                 */
                public Build withSpotPrice(final software.amazon.awscdk.Token value) {
                    this.instance._spotPrice = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SubnetId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-subnetid
                 */
                public Build withSubnetId(final java.lang.String value) {
                    this.instance._subnetId = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SubnetId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-subnetid
                 */
                public Build withSubnetId(final software.amazon.awscdk.Token value) {
                    this.instance._subnetId = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.TagSpecifications``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-tagspecifications
                 */
                public Build withTagSpecifications(final software.amazon.awscdk.Token value) {
                    this.instance._tagSpecifications = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.TagSpecifications``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-tagspecifications
                 */
                public Build withTagSpecifications(final java.util.List<java.lang.Object> value) {
                    this.instance._tagSpecifications = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.UserData``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-userdata
                 */
                public Build withUserData(final java.lang.String value) {
                    this.instance._userData = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.UserData``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-userdata
                 */
                public Build withUserData(final software.amazon.awscdk.Token value) {
                    this.instance._userData = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.WeightedCapacity``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-weightedcapacity
                 */
                public Build withWeightedCapacity(final java.lang.Number value) {
                    this.instance._weightedCapacity = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.WeightedCapacity``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-weightedcapacity
                 */
                public Build withWeightedCapacity(final software.amazon.awscdk.Token value) {
                    this.instance._weightedCapacity = value;
                    return this;
                }
                public SpotFleetLaunchSpecificationProperty build() {
                    SpotFleetLaunchSpecificationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link SpotFleetLaunchSpecificationProperty}.
         */
        final class Jsii$Pojo implements SpotFleetLaunchSpecificationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _blockDeviceMappings;

            public java.lang.Object getBlockDeviceMappings() {
                return this._blockDeviceMappings;
            }
            public void setBlockDeviceMappings(final software.amazon.awscdk.Token value) {
                this._blockDeviceMappings = value;
            }
            public void setBlockDeviceMappings(final java.util.List<java.lang.Object> value) {
                this._blockDeviceMappings = value;
            }

            protected java.lang.Object _ebsOptimized;

            public java.lang.Object getEbsOptimized() {
                return this._ebsOptimized;
            }
            public void setEbsOptimized(final java.lang.Boolean value) {
                this._ebsOptimized = value;
            }
            public void setEbsOptimized(final software.amazon.awscdk.Token value) {
                this._ebsOptimized = value;
            }

            protected java.lang.Object _iamInstanceProfile;

            public java.lang.Object getIamInstanceProfile() {
                return this._iamInstanceProfile;
            }
            public void setIamInstanceProfile(final software.amazon.awscdk.Token value) {
                this._iamInstanceProfile = value;
            }
            public void setIamInstanceProfile(final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.IamInstanceProfileSpecificationProperty value) {
                this._iamInstanceProfile = value;
            }

            protected java.lang.Object _imageId;

            public java.lang.Object getImageId() {
                return this._imageId;
            }
            public void setImageId(final java.lang.String value) {
                this._imageId = value;
            }
            public void setImageId(final software.amazon.awscdk.Token value) {
                this._imageId = value;
            }

            protected java.lang.Object _instanceType;

            public java.lang.Object getInstanceType() {
                return this._instanceType;
            }
            public void setInstanceType(final java.lang.String value) {
                this._instanceType = value;
            }
            public void setInstanceType(final software.amazon.awscdk.Token value) {
                this._instanceType = value;
            }

            protected java.lang.Object _kernelId;

            public java.lang.Object getKernelId() {
                return this._kernelId;
            }
            public void setKernelId(final java.lang.String value) {
                this._kernelId = value;
            }
            public void setKernelId(final software.amazon.awscdk.Token value) {
                this._kernelId = value;
            }

            protected java.lang.Object _keyName;

            public java.lang.Object getKeyName() {
                return this._keyName;
            }
            public void setKeyName(final java.lang.String value) {
                this._keyName = value;
            }
            public void setKeyName(final software.amazon.awscdk.Token value) {
                this._keyName = value;
            }

            protected java.lang.Object _monitoring;

            public java.lang.Object getMonitoring() {
                return this._monitoring;
            }
            public void setMonitoring(final software.amazon.awscdk.Token value) {
                this._monitoring = value;
            }
            public void setMonitoring(final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.SpotFleetMonitoringProperty value) {
                this._monitoring = value;
            }

            protected java.lang.Object _networkInterfaces;

            public java.lang.Object getNetworkInterfaces() {
                return this._networkInterfaces;
            }
            public void setNetworkInterfaces(final software.amazon.awscdk.Token value) {
                this._networkInterfaces = value;
            }
            public void setNetworkInterfaces(final java.util.List<java.lang.Object> value) {
                this._networkInterfaces = value;
            }

            protected java.lang.Object _placement;

            public java.lang.Object getPlacement() {
                return this._placement;
            }
            public void setPlacement(final software.amazon.awscdk.Token value) {
                this._placement = value;
            }
            public void setPlacement(final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.SpotPlacementProperty value) {
                this._placement = value;
            }

            protected java.lang.Object _ramdiskId;

            public java.lang.Object getRamdiskId() {
                return this._ramdiskId;
            }
            public void setRamdiskId(final java.lang.String value) {
                this._ramdiskId = value;
            }
            public void setRamdiskId(final software.amazon.awscdk.Token value) {
                this._ramdiskId = value;
            }

            protected java.lang.Object _securityGroups;

            public java.lang.Object getSecurityGroups() {
                return this._securityGroups;
            }
            public void setSecurityGroups(final software.amazon.awscdk.Token value) {
                this._securityGroups = value;
            }
            public void setSecurityGroups(final java.util.List<java.lang.Object> value) {
                this._securityGroups = value;
            }

            protected java.lang.Object _spotPrice;

            public java.lang.Object getSpotPrice() {
                return this._spotPrice;
            }
            public void setSpotPrice(final java.lang.String value) {
                this._spotPrice = value;
            }
            public void setSpotPrice(final software.amazon.awscdk.Token value) {
                this._spotPrice = value;
            }

            protected java.lang.Object _subnetId;

            public java.lang.Object getSubnetId() {
                return this._subnetId;
            }
            public void setSubnetId(final java.lang.String value) {
                this._subnetId = value;
            }
            public void setSubnetId(final software.amazon.awscdk.Token value) {
                this._subnetId = value;
            }

            protected java.lang.Object _tagSpecifications;

            public java.lang.Object getTagSpecifications() {
                return this._tagSpecifications;
            }
            public void setTagSpecifications(final software.amazon.awscdk.Token value) {
                this._tagSpecifications = value;
            }
            public void setTagSpecifications(final java.util.List<java.lang.Object> value) {
                this._tagSpecifications = value;
            }

            protected java.lang.Object _userData;

            public java.lang.Object getUserData() {
                return this._userData;
            }
            public void setUserData(final java.lang.String value) {
                this._userData = value;
            }
            public void setUserData(final software.amazon.awscdk.Token value) {
                this._userData = value;
            }

            protected java.lang.Object _weightedCapacity;

            public java.lang.Object getWeightedCapacity() {
                return this._weightedCapacity;
            }
            public void setWeightedCapacity(final java.lang.Number value) {
                this._weightedCapacity = value;
            }
            public void setWeightedCapacity(final software.amazon.awscdk.Token value) {
                this._weightedCapacity = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.SpotFleetLaunchSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-blockdevicemappings
             */
            @javax.annotation.Nullable
            public java.lang.Object getBlockDeviceMappings() {
                return this.jsiiGet("blockDeviceMappings", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-blockdevicemappings
             */
            public void setBlockDeviceMappings(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("blockDeviceMappings", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-blockdevicemappings
             */
            public void setBlockDeviceMappings(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("blockDeviceMappings", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.EbsOptimized``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ebsoptimized
             */
            @javax.annotation.Nullable
            public java.lang.Object getEbsOptimized() {
                return this.jsiiGet("ebsOptimized", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.EbsOptimized``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ebsoptimized
             */
            public void setEbsOptimized(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("ebsOptimized", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.EbsOptimized``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ebsoptimized
             */
            public void setEbsOptimized(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ebsOptimized", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.IamInstanceProfile``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-iaminstanceprofile
             */
            @javax.annotation.Nullable
            public java.lang.Object getIamInstanceProfile() {
                return this.jsiiGet("iamInstanceProfile", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.IamInstanceProfile``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-iaminstanceprofile
             */
            public void setIamInstanceProfile(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("iamInstanceProfile", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.IamInstanceProfile``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-iaminstanceprofile
             */
            public void setIamInstanceProfile(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.IamInstanceProfileSpecificationProperty value) {
                this.jsiiSet("iamInstanceProfile", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.ImageId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-imageid
             */
            public java.lang.Object getImageId() {
                return this.jsiiGet("imageId", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.ImageId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-imageid
             */
            public void setImageId(final java.lang.String value) {
                this.jsiiSet("imageId", java.util.Objects.requireNonNull(value, "imageId is required"));
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.ImageId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-imageid
             */
            public void setImageId(final software.amazon.awscdk.Token value) {
                this.jsiiSet("imageId", java.util.Objects.requireNonNull(value, "imageId is required"));
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.InstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-instancetype
             */
            public java.lang.Object getInstanceType() {
                return this.jsiiGet("instanceType", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.InstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-instancetype
             */
            public void setInstanceType(final java.lang.String value) {
                this.jsiiSet("instanceType", java.util.Objects.requireNonNull(value, "instanceType is required"));
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.InstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-instancetype
             */
            public void setInstanceType(final software.amazon.awscdk.Token value) {
                this.jsiiSet("instanceType", java.util.Objects.requireNonNull(value, "instanceType is required"));
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.KernelId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-kernelid
             */
            @javax.annotation.Nullable
            public java.lang.Object getKernelId() {
                return this.jsiiGet("kernelId", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.KernelId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-kernelid
             */
            public void setKernelId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("kernelId", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.KernelId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-kernelid
             */
            public void setKernelId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("kernelId", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.KeyName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-keyname
             */
            @javax.annotation.Nullable
            public java.lang.Object getKeyName() {
                return this.jsiiGet("keyName", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.KeyName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-keyname
             */
            public void setKeyName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("keyName", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.KeyName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-keyname
             */
            public void setKeyName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("keyName", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.Monitoring``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-monitoring
             */
            @javax.annotation.Nullable
            public java.lang.Object getMonitoring() {
                return this.jsiiGet("monitoring", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.Monitoring``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-monitoring
             */
            public void setMonitoring(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("monitoring", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.Monitoring``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-monitoring
             */
            public void setMonitoring(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.SpotFleetMonitoringProperty value) {
                this.jsiiSet("monitoring", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.NetworkInterfaces``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-networkinterfaces
             */
            @javax.annotation.Nullable
            public java.lang.Object getNetworkInterfaces() {
                return this.jsiiGet("networkInterfaces", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.NetworkInterfaces``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-networkinterfaces
             */
            public void setNetworkInterfaces(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("networkInterfaces", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.NetworkInterfaces``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-networkinterfaces
             */
            public void setNetworkInterfaces(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("networkInterfaces", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.Placement``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-placement
             */
            @javax.annotation.Nullable
            public java.lang.Object getPlacement() {
                return this.jsiiGet("placement", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.Placement``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-placement
             */
            public void setPlacement(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("placement", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.Placement``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-placement
             */
            public void setPlacement(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.SpotPlacementProperty value) {
                this.jsiiSet("placement", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.RamdiskId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ramdiskid
             */
            @javax.annotation.Nullable
            public java.lang.Object getRamdiskId() {
                return this.jsiiGet("ramdiskId", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.RamdiskId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ramdiskid
             */
            public void setRamdiskId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("ramdiskId", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.RamdiskId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ramdiskid
             */
            public void setRamdiskId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ramdiskId", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SecurityGroups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-securitygroups
             */
            @javax.annotation.Nullable
            public java.lang.Object getSecurityGroups() {
                return this.jsiiGet("securityGroups", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SecurityGroups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-securitygroups
             */
            public void setSecurityGroups(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("securityGroups", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SecurityGroups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-securitygroups
             */
            public void setSecurityGroups(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("securityGroups", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SpotPrice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-spotprice
             */
            @javax.annotation.Nullable
            public java.lang.Object getSpotPrice() {
                return this.jsiiGet("spotPrice", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SpotPrice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-spotprice
             */
            public void setSpotPrice(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("spotPrice", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SpotPrice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-spotprice
             */
            public void setSpotPrice(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("spotPrice", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-subnetid
             */
            @javax.annotation.Nullable
            public java.lang.Object getSubnetId() {
                return this.jsiiGet("subnetId", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-subnetid
             */
            public void setSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("subnetId", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-subnetid
             */
            public void setSubnetId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("subnetId", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.TagSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-tagspecifications
             */
            @javax.annotation.Nullable
            public java.lang.Object getTagSpecifications() {
                return this.jsiiGet("tagSpecifications", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.TagSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-tagspecifications
             */
            public void setTagSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("tagSpecifications", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.TagSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-tagspecifications
             */
            public void setTagSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("tagSpecifications", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.UserData``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-userdata
             */
            @javax.annotation.Nullable
            public java.lang.Object getUserData() {
                return this.jsiiGet("userData", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.UserData``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-userdata
             */
            public void setUserData(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("userData", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.UserData``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-userdata
             */
            public void setUserData(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("userData", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.WeightedCapacity``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-weightedcapacity
             */
            @javax.annotation.Nullable
            public java.lang.Object getWeightedCapacity() {
                return this.jsiiGet("weightedCapacity", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.WeightedCapacity``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-weightedcapacity
             */
            public void setWeightedCapacity(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("weightedCapacity", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetLaunchSpecificationProperty.WeightedCapacity``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-weightedcapacity
             */
            public void setWeightedCapacity(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("weightedCapacity", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html
     */
    public static interface SpotFleetMonitoringProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``SpotFleetResource.SpotFleetMonitoringProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html#cfn-ec2-spotfleet-spotfleetmonitoring-enabled
         */
        java.lang.Object getEnabled();
        /**
         * ``SpotFleetResource.SpotFleetMonitoringProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html#cfn-ec2-spotfleet-spotfleetmonitoring-enabled
         */
        void setEnabled(final java.lang.Boolean value);
        /**
         * ``SpotFleetResource.SpotFleetMonitoringProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html#cfn-ec2-spotfleet-spotfleetmonitoring-enabled
         */
        void setEnabled(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link SpotFleetMonitoringProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``SpotFleetResource.SpotFleetMonitoringProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html#cfn-ec2-spotfleet-spotfleetmonitoring-enabled
             */
            public Builder withEnabled(final java.lang.Boolean value) {
                this.instance._enabled = value;
                return this;
            }
            /**
             * ``SpotFleetResource.SpotFleetMonitoringProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html#cfn-ec2-spotfleet-spotfleetmonitoring-enabled
             */
            public Builder withEnabled(final software.amazon.awscdk.Token value) {
                this.instance._enabled = value;
                return this;
            }
            public SpotFleetMonitoringProperty build() {
                SpotFleetMonitoringProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link SpotFleetMonitoringProperty}.
         */
        final class Jsii$Pojo implements SpotFleetMonitoringProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _enabled;

            public java.lang.Object getEnabled() {
                return this._enabled;
            }
            public void setEnabled(final java.lang.Boolean value) {
                this._enabled = value;
            }
            public void setEnabled(final software.amazon.awscdk.Token value) {
                this._enabled = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.SpotFleetMonitoringProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``SpotFleetResource.SpotFleetMonitoringProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html#cfn-ec2-spotfleet-spotfleetmonitoring-enabled
             */
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetMonitoringProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html#cfn-ec2-spotfleet-spotfleetmonitoring-enabled
             */
            public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("enabled", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetMonitoringProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html#cfn-ec2-spotfleet-spotfleetmonitoring-enabled
             */
            public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("enabled", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html
     */
    public static interface SpotFleetRequestConfigDataProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.AllocationStrategy``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-allocationstrategy
         */
        java.lang.Object getAllocationStrategy();
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.AllocationStrategy``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-allocationstrategy
         */
        void setAllocationStrategy(final java.lang.String value);
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.AllocationStrategy``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-allocationstrategy
         */
        void setAllocationStrategy(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-excesscapacityterminationpolicy
         */
        java.lang.Object getExcessCapacityTerminationPolicy();
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-excesscapacityterminationpolicy
         */
        void setExcessCapacityTerminationPolicy(final java.lang.String value);
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-excesscapacityterminationpolicy
         */
        void setExcessCapacityTerminationPolicy(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.IamFleetRole``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-iamfleetrole
         */
        java.lang.Object getIamFleetRole();
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.IamFleetRole``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-iamfleetrole
         */
        void setIamFleetRole(final java.lang.String value);
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.IamFleetRole``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-iamfleetrole
         */
        void setIamFleetRole(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.LaunchSpecifications``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications
         */
        java.lang.Object getLaunchSpecifications();
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.LaunchSpecifications``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications
         */
        void setLaunchSpecifications(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.LaunchSpecifications``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications
         */
        void setLaunchSpecifications(final java.util.List<java.lang.Object> value);
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-replaceunhealthyinstances
         */
        java.lang.Object getReplaceUnhealthyInstances();
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-replaceunhealthyinstances
         */
        void setReplaceUnhealthyInstances(final java.lang.Boolean value);
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-replaceunhealthyinstances
         */
        void setReplaceUnhealthyInstances(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.SpotPrice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotprice
         */
        java.lang.Object getSpotPrice();
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.SpotPrice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotprice
         */
        void setSpotPrice(final java.lang.String value);
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.SpotPrice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotprice
         */
        void setSpotPrice(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.TargetCapacity``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacity
         */
        java.lang.Object getTargetCapacity();
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.TargetCapacity``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacity
         */
        void setTargetCapacity(final java.lang.Number value);
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.TargetCapacity``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacity
         */
        void setTargetCapacity(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-terminateinstanceswithexpiration
         */
        java.lang.Object getTerminateInstancesWithExpiration();
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-terminateinstanceswithexpiration
         */
        void setTerminateInstancesWithExpiration(final java.lang.Boolean value);
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-terminateinstanceswithexpiration
         */
        void setTerminateInstancesWithExpiration(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-type
         */
        java.lang.Object getType();
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-type
         */
        void setType(final java.lang.String value);
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-type
         */
        void setType(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ValidFrom``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validfrom
         */
        java.lang.Object getValidFrom();
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ValidFrom``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validfrom
         */
        void setValidFrom(final java.lang.String value);
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ValidFrom``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validfrom
         */
        void setValidFrom(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ValidUntil``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validuntil
         */
        java.lang.Object getValidUntil();
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ValidUntil``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validuntil
         */
        void setValidUntil(final java.lang.String value);
        /**
         * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ValidUntil``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validuntil
         */
        void setValidUntil(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link SpotFleetRequestConfigDataProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.IamFleetRole``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-iamfleetrole
             */
            public TargetCapacityStep withIamFleetRole(final java.lang.String value) {
                return new FullBuilder().withIamFleetRole(value);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.IamFleetRole``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-iamfleetrole
             */
            public TargetCapacityStep withIamFleetRole(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withIamFleetRole(value);
            }

            public interface TargetCapacityStep {
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.TargetCapacity``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacity
                 */
                Build withTargetCapacity(final java.lang.Number value);
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.TargetCapacity``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacity
                 */
                Build withTargetCapacity(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link SpotFleetRequestConfigDataProperty} object, initialized with the values set on this builder.
                 */
                SpotFleetRequestConfigDataProperty build();
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.AllocationStrategy``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-allocationstrategy
                 */
                Build withAllocationStrategy(final java.lang.String value);
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.AllocationStrategy``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-allocationstrategy
                 */
                Build withAllocationStrategy(final software.amazon.awscdk.Token value);
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-excesscapacityterminationpolicy
                 */
                Build withExcessCapacityTerminationPolicy(final java.lang.String value);
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-excesscapacityterminationpolicy
                 */
                Build withExcessCapacityTerminationPolicy(final software.amazon.awscdk.Token value);
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.LaunchSpecifications``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications
                 */
                Build withLaunchSpecifications(final software.amazon.awscdk.Token value);
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.LaunchSpecifications``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications
                 */
                Build withLaunchSpecifications(final java.util.List<java.lang.Object> value);
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-replaceunhealthyinstances
                 */
                Build withReplaceUnhealthyInstances(final java.lang.Boolean value);
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-replaceunhealthyinstances
                 */
                Build withReplaceUnhealthyInstances(final software.amazon.awscdk.Token value);
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.SpotPrice``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotprice
                 */
                Build withSpotPrice(final java.lang.String value);
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.SpotPrice``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotprice
                 */
                Build withSpotPrice(final software.amazon.awscdk.Token value);
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-terminateinstanceswithexpiration
                 */
                Build withTerminateInstancesWithExpiration(final java.lang.Boolean value);
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-terminateinstanceswithexpiration
                 */
                Build withTerminateInstancesWithExpiration(final software.amazon.awscdk.Token value);
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.Type``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-type
                 */
                Build withType(final java.lang.String value);
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.Type``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-type
                 */
                Build withType(final software.amazon.awscdk.Token value);
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ValidFrom``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validfrom
                 */
                Build withValidFrom(final java.lang.String value);
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ValidFrom``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validfrom
                 */
                Build withValidFrom(final software.amazon.awscdk.Token value);
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ValidUntil``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validuntil
                 */
                Build withValidUntil(final java.lang.String value);
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ValidUntil``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validuntil
                 */
                Build withValidUntil(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements TargetCapacityStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.AllocationStrategy``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-allocationstrategy
                 */
                public Build withAllocationStrategy(final java.lang.String value) {
                    this.instance._allocationStrategy = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.AllocationStrategy``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-allocationstrategy
                 */
                public Build withAllocationStrategy(final software.amazon.awscdk.Token value) {
                    this.instance._allocationStrategy = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-excesscapacityterminationpolicy
                 */
                public Build withExcessCapacityTerminationPolicy(final java.lang.String value) {
                    this.instance._excessCapacityTerminationPolicy = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-excesscapacityterminationpolicy
                 */
                public Build withExcessCapacityTerminationPolicy(final software.amazon.awscdk.Token value) {
                    this.instance._excessCapacityTerminationPolicy = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.IamFleetRole``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-iamfleetrole
                 */
                public TargetCapacityStep withIamFleetRole(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "SpotFleetRequestConfigDataProperty#iamFleetRole is required");
                    this.instance._iamFleetRole = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.IamFleetRole``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-iamfleetrole
                 */
                public TargetCapacityStep withIamFleetRole(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "SpotFleetRequestConfigDataProperty#iamFleetRole is required");
                    this.instance._iamFleetRole = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.LaunchSpecifications``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications
                 */
                public Build withLaunchSpecifications(final software.amazon.awscdk.Token value) {
                    this.instance._launchSpecifications = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.LaunchSpecifications``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications
                 */
                public Build withLaunchSpecifications(final java.util.List<java.lang.Object> value) {
                    this.instance._launchSpecifications = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-replaceunhealthyinstances
                 */
                public Build withReplaceUnhealthyInstances(final java.lang.Boolean value) {
                    this.instance._replaceUnhealthyInstances = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-replaceunhealthyinstances
                 */
                public Build withReplaceUnhealthyInstances(final software.amazon.awscdk.Token value) {
                    this.instance._replaceUnhealthyInstances = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.SpotPrice``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotprice
                 */
                public Build withSpotPrice(final java.lang.String value) {
                    this.instance._spotPrice = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.SpotPrice``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotprice
                 */
                public Build withSpotPrice(final software.amazon.awscdk.Token value) {
                    this.instance._spotPrice = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.TargetCapacity``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacity
                 */
                public Build withTargetCapacity(final java.lang.Number value) {
                    java.util.Objects.requireNonNull(value, "SpotFleetRequestConfigDataProperty#targetCapacity is required");
                    this.instance._targetCapacity = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.TargetCapacity``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacity
                 */
                public Build withTargetCapacity(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "SpotFleetRequestConfigDataProperty#targetCapacity is required");
                    this.instance._targetCapacity = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-terminateinstanceswithexpiration
                 */
                public Build withTerminateInstancesWithExpiration(final java.lang.Boolean value) {
                    this.instance._terminateInstancesWithExpiration = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-terminateinstanceswithexpiration
                 */
                public Build withTerminateInstancesWithExpiration(final software.amazon.awscdk.Token value) {
                    this.instance._terminateInstancesWithExpiration = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.Type``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-type
                 */
                public Build withType(final java.lang.String value) {
                    this.instance._type = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.Type``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-type
                 */
                public Build withType(final software.amazon.awscdk.Token value) {
                    this.instance._type = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ValidFrom``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validfrom
                 */
                public Build withValidFrom(final java.lang.String value) {
                    this.instance._validFrom = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ValidFrom``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validfrom
                 */
                public Build withValidFrom(final software.amazon.awscdk.Token value) {
                    this.instance._validFrom = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ValidUntil``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validuntil
                 */
                public Build withValidUntil(final java.lang.String value) {
                    this.instance._validUntil = value;
                    return this;
                }
                /**
                 * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ValidUntil``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validuntil
                 */
                public Build withValidUntil(final software.amazon.awscdk.Token value) {
                    this.instance._validUntil = value;
                    return this;
                }
                public SpotFleetRequestConfigDataProperty build() {
                    SpotFleetRequestConfigDataProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link SpotFleetRequestConfigDataProperty}.
         */
        final class Jsii$Pojo implements SpotFleetRequestConfigDataProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _allocationStrategy;

            public java.lang.Object getAllocationStrategy() {
                return this._allocationStrategy;
            }
            public void setAllocationStrategy(final java.lang.String value) {
                this._allocationStrategy = value;
            }
            public void setAllocationStrategy(final software.amazon.awscdk.Token value) {
                this._allocationStrategy = value;
            }

            protected java.lang.Object _excessCapacityTerminationPolicy;

            public java.lang.Object getExcessCapacityTerminationPolicy() {
                return this._excessCapacityTerminationPolicy;
            }
            public void setExcessCapacityTerminationPolicy(final java.lang.String value) {
                this._excessCapacityTerminationPolicy = value;
            }
            public void setExcessCapacityTerminationPolicy(final software.amazon.awscdk.Token value) {
                this._excessCapacityTerminationPolicy = value;
            }

            protected java.lang.Object _iamFleetRole;

            public java.lang.Object getIamFleetRole() {
                return this._iamFleetRole;
            }
            public void setIamFleetRole(final java.lang.String value) {
                this._iamFleetRole = value;
            }
            public void setIamFleetRole(final software.amazon.awscdk.Token value) {
                this._iamFleetRole = value;
            }

            protected java.lang.Object _launchSpecifications;

            public java.lang.Object getLaunchSpecifications() {
                return this._launchSpecifications;
            }
            public void setLaunchSpecifications(final software.amazon.awscdk.Token value) {
                this._launchSpecifications = value;
            }
            public void setLaunchSpecifications(final java.util.List<java.lang.Object> value) {
                this._launchSpecifications = value;
            }

            protected java.lang.Object _replaceUnhealthyInstances;

            public java.lang.Object getReplaceUnhealthyInstances() {
                return this._replaceUnhealthyInstances;
            }
            public void setReplaceUnhealthyInstances(final java.lang.Boolean value) {
                this._replaceUnhealthyInstances = value;
            }
            public void setReplaceUnhealthyInstances(final software.amazon.awscdk.Token value) {
                this._replaceUnhealthyInstances = value;
            }

            protected java.lang.Object _spotPrice;

            public java.lang.Object getSpotPrice() {
                return this._spotPrice;
            }
            public void setSpotPrice(final java.lang.String value) {
                this._spotPrice = value;
            }
            public void setSpotPrice(final software.amazon.awscdk.Token value) {
                this._spotPrice = value;
            }

            protected java.lang.Object _targetCapacity;

            public java.lang.Object getTargetCapacity() {
                return this._targetCapacity;
            }
            public void setTargetCapacity(final java.lang.Number value) {
                this._targetCapacity = value;
            }
            public void setTargetCapacity(final software.amazon.awscdk.Token value) {
                this._targetCapacity = value;
            }

            protected java.lang.Object _terminateInstancesWithExpiration;

            public java.lang.Object getTerminateInstancesWithExpiration() {
                return this._terminateInstancesWithExpiration;
            }
            public void setTerminateInstancesWithExpiration(final java.lang.Boolean value) {
                this._terminateInstancesWithExpiration = value;
            }
            public void setTerminateInstancesWithExpiration(final software.amazon.awscdk.Token value) {
                this._terminateInstancesWithExpiration = value;
            }

            protected java.lang.Object _type;

            public java.lang.Object getType() {
                return this._type;
            }
            public void setType(final java.lang.String value) {
                this._type = value;
            }
            public void setType(final software.amazon.awscdk.Token value) {
                this._type = value;
            }

            protected java.lang.Object _validFrom;

            public java.lang.Object getValidFrom() {
                return this._validFrom;
            }
            public void setValidFrom(final java.lang.String value) {
                this._validFrom = value;
            }
            public void setValidFrom(final software.amazon.awscdk.Token value) {
                this._validFrom = value;
            }

            protected java.lang.Object _validUntil;

            public java.lang.Object getValidUntil() {
                return this._validUntil;
            }
            public void setValidUntil(final java.lang.String value) {
                this._validUntil = value;
            }
            public void setValidUntil(final software.amazon.awscdk.Token value) {
                this._validUntil = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.SpotFleetRequestConfigDataProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.AllocationStrategy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-allocationstrategy
             */
            @javax.annotation.Nullable
            public java.lang.Object getAllocationStrategy() {
                return this.jsiiGet("allocationStrategy", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.AllocationStrategy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-allocationstrategy
             */
            public void setAllocationStrategy(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("allocationStrategy", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.AllocationStrategy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-allocationstrategy
             */
            public void setAllocationStrategy(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("allocationStrategy", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-excesscapacityterminationpolicy
             */
            @javax.annotation.Nullable
            public java.lang.Object getExcessCapacityTerminationPolicy() {
                return this.jsiiGet("excessCapacityTerminationPolicy", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-excesscapacityterminationpolicy
             */
            public void setExcessCapacityTerminationPolicy(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("excessCapacityTerminationPolicy", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-excesscapacityterminationpolicy
             */
            public void setExcessCapacityTerminationPolicy(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("excessCapacityTerminationPolicy", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.IamFleetRole``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-iamfleetrole
             */
            public java.lang.Object getIamFleetRole() {
                return this.jsiiGet("iamFleetRole", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.IamFleetRole``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-iamfleetrole
             */
            public void setIamFleetRole(final java.lang.String value) {
                this.jsiiSet("iamFleetRole", java.util.Objects.requireNonNull(value, "iamFleetRole is required"));
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.IamFleetRole``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-iamfleetrole
             */
            public void setIamFleetRole(final software.amazon.awscdk.Token value) {
                this.jsiiSet("iamFleetRole", java.util.Objects.requireNonNull(value, "iamFleetRole is required"));
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.LaunchSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications
             */
            @javax.annotation.Nullable
            public java.lang.Object getLaunchSpecifications() {
                return this.jsiiGet("launchSpecifications", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.LaunchSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications
             */
            public void setLaunchSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("launchSpecifications", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.LaunchSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications
             */
            public void setLaunchSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("launchSpecifications", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-replaceunhealthyinstances
             */
            @javax.annotation.Nullable
            public java.lang.Object getReplaceUnhealthyInstances() {
                return this.jsiiGet("replaceUnhealthyInstances", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-replaceunhealthyinstances
             */
            public void setReplaceUnhealthyInstances(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("replaceUnhealthyInstances", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-replaceunhealthyinstances
             */
            public void setReplaceUnhealthyInstances(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("replaceUnhealthyInstances", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.SpotPrice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotprice
             */
            @javax.annotation.Nullable
            public java.lang.Object getSpotPrice() {
                return this.jsiiGet("spotPrice", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.SpotPrice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotprice
             */
            public void setSpotPrice(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("spotPrice", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.SpotPrice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotprice
             */
            public void setSpotPrice(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("spotPrice", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.TargetCapacity``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacity
             */
            public java.lang.Object getTargetCapacity() {
                return this.jsiiGet("targetCapacity", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.TargetCapacity``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacity
             */
            public void setTargetCapacity(final java.lang.Number value) {
                this.jsiiSet("targetCapacity", java.util.Objects.requireNonNull(value, "targetCapacity is required"));
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.TargetCapacity``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacity
             */
            public void setTargetCapacity(final software.amazon.awscdk.Token value) {
                this.jsiiSet("targetCapacity", java.util.Objects.requireNonNull(value, "targetCapacity is required"));
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-terminateinstanceswithexpiration
             */
            @javax.annotation.Nullable
            public java.lang.Object getTerminateInstancesWithExpiration() {
                return this.jsiiGet("terminateInstancesWithExpiration", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-terminateinstanceswithexpiration
             */
            public void setTerminateInstancesWithExpiration(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("terminateInstancesWithExpiration", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-terminateinstanceswithexpiration
             */
            public void setTerminateInstancesWithExpiration(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("terminateInstancesWithExpiration", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-type
             */
            @javax.annotation.Nullable
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-type
             */
            public void setType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("type", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-type
             */
            public void setType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("type", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ValidFrom``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validfrom
             */
            @javax.annotation.Nullable
            public java.lang.Object getValidFrom() {
                return this.jsiiGet("validFrom", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ValidFrom``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validfrom
             */
            public void setValidFrom(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("validFrom", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ValidFrom``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validfrom
             */
            public void setValidFrom(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("validFrom", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ValidUntil``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validuntil
             */
            @javax.annotation.Nullable
            public java.lang.Object getValidUntil() {
                return this.jsiiGet("validUntil", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ValidUntil``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validuntil
             */
            public void setValidUntil(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("validUntil", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetRequestConfigDataProperty.ValidUntil``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validuntil
             */
            public void setValidUntil(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("validUntil", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html
     */
    public static interface SpotFleetTagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``SpotFleetResource.SpotFleetTagSpecificationProperty.ResourceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-spotfleettagspecification-resourcetype
         */
        java.lang.Object getResourceType();
        /**
         * ``SpotFleetResource.SpotFleetTagSpecificationProperty.ResourceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-spotfleettagspecification-resourcetype
         */
        void setResourceType(final java.lang.String value);
        /**
         * ``SpotFleetResource.SpotFleetTagSpecificationProperty.ResourceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-spotfleettagspecification-resourcetype
         */
        void setResourceType(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link SpotFleetTagSpecificationProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``SpotFleetResource.SpotFleetTagSpecificationProperty.ResourceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-spotfleettagspecification-resourcetype
             */
            public Builder withResourceType(final java.lang.String value) {
                this.instance._resourceType = value;
                return this;
            }
            /**
             * ``SpotFleetResource.SpotFleetTagSpecificationProperty.ResourceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-spotfleettagspecification-resourcetype
             */
            public Builder withResourceType(final software.amazon.awscdk.Token value) {
                this.instance._resourceType = value;
                return this;
            }
            public SpotFleetTagSpecificationProperty build() {
                SpotFleetTagSpecificationProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link SpotFleetTagSpecificationProperty}.
         */
        final class Jsii$Pojo implements SpotFleetTagSpecificationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _resourceType;

            public java.lang.Object getResourceType() {
                return this._resourceType;
            }
            public void setResourceType(final java.lang.String value) {
                this._resourceType = value;
            }
            public void setResourceType(final software.amazon.awscdk.Token value) {
                this._resourceType = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.SpotFleetTagSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``SpotFleetResource.SpotFleetTagSpecificationProperty.ResourceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-spotfleettagspecification-resourcetype
             */
            @javax.annotation.Nullable
            public java.lang.Object getResourceType() {
                return this.jsiiGet("resourceType", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotFleetTagSpecificationProperty.ResourceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-spotfleettagspecification-resourcetype
             */
            public void setResourceType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("resourceType", value);
            }
            /**
             * ``SpotFleetResource.SpotFleetTagSpecificationProperty.ResourceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-spotfleettagspecification-resourcetype
             */
            public void setResourceType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("resourceType", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html
     */
    public static interface SpotPlacementProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``SpotFleetResource.SpotPlacementProperty.AvailabilityZone``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-availabilityzone
         */
        java.lang.Object getAvailabilityZone();
        /**
         * ``SpotFleetResource.SpotPlacementProperty.AvailabilityZone``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-availabilityzone
         */
        void setAvailabilityZone(final java.lang.String value);
        /**
         * ``SpotFleetResource.SpotPlacementProperty.AvailabilityZone``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-availabilityzone
         */
        void setAvailabilityZone(final software.amazon.awscdk.Token value);
        /**
         * ``SpotFleetResource.SpotPlacementProperty.GroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-groupname
         */
        java.lang.Object getGroupName();
        /**
         * ``SpotFleetResource.SpotPlacementProperty.GroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-groupname
         */
        void setGroupName(final java.lang.String value);
        /**
         * ``SpotFleetResource.SpotPlacementProperty.GroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-groupname
         */
        void setGroupName(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link SpotPlacementProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``SpotFleetResource.SpotPlacementProperty.AvailabilityZone``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-availabilityzone
             */
            public Builder withAvailabilityZone(final java.lang.String value) {
                this.instance._availabilityZone = value;
                return this;
            }
            /**
             * ``SpotFleetResource.SpotPlacementProperty.AvailabilityZone``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-availabilityzone
             */
            public Builder withAvailabilityZone(final software.amazon.awscdk.Token value) {
                this.instance._availabilityZone = value;
                return this;
            }
            /**
             * ``SpotFleetResource.SpotPlacementProperty.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-groupname
             */
            public Builder withGroupName(final java.lang.String value) {
                this.instance._groupName = value;
                return this;
            }
            /**
             * ``SpotFleetResource.SpotPlacementProperty.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-groupname
             */
            public Builder withGroupName(final software.amazon.awscdk.Token value) {
                this.instance._groupName = value;
                return this;
            }
            public SpotPlacementProperty build() {
                SpotPlacementProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link SpotPlacementProperty}.
         */
        final class Jsii$Pojo implements SpotPlacementProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _availabilityZone;

            public java.lang.Object getAvailabilityZone() {
                return this._availabilityZone;
            }
            public void setAvailabilityZone(final java.lang.String value) {
                this._availabilityZone = value;
            }
            public void setAvailabilityZone(final software.amazon.awscdk.Token value) {
                this._availabilityZone = value;
            }

            protected java.lang.Object _groupName;

            public java.lang.Object getGroupName() {
                return this._groupName;
            }
            public void setGroupName(final java.lang.String value) {
                this._groupName = value;
            }
            public void setGroupName(final software.amazon.awscdk.Token value) {
                this._groupName = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.SpotPlacementProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``SpotFleetResource.SpotPlacementProperty.AvailabilityZone``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-availabilityzone
             */
            @javax.annotation.Nullable
            public java.lang.Object getAvailabilityZone() {
                return this.jsiiGet("availabilityZone", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotPlacementProperty.AvailabilityZone``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-availabilityzone
             */
            public void setAvailabilityZone(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("availabilityZone", value);
            }
            /**
             * ``SpotFleetResource.SpotPlacementProperty.AvailabilityZone``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-availabilityzone
             */
            public void setAvailabilityZone(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("availabilityZone", value);
            }
            /**
             * ``SpotFleetResource.SpotPlacementProperty.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-groupname
             */
            @javax.annotation.Nullable
            public java.lang.Object getGroupName() {
                return this.jsiiGet("groupName", java.lang.Object.class);
            }
            /**
             * ``SpotFleetResource.SpotPlacementProperty.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-groupname
             */
            public void setGroupName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("groupName", value);
            }
            /**
             * ``SpotFleetResource.SpotPlacementProperty.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-groupname
             */
            public void setGroupName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("groupName", value);
            }
        }
    }
}
