package software.amazon.awscdk.services.ec2.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
public interface SpotFleetResourceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ``AWS::EC2::SpotFleet.SpotFleetRequestConfigData``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
     */
    java.lang.Object getSpotFleetRequestConfigData();
    /**
     * ``AWS::EC2::SpotFleet.SpotFleetRequestConfigData``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
     */
    void setSpotFleetRequestConfigData(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::SpotFleet.SpotFleetRequestConfigData``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
     */
    void setSpotFleetRequestConfigData(final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.SpotFleetRequestConfigDataProperty value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link SpotFleetResourceProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * ``AWS::EC2::SpotFleet.SpotFleetRequestConfigData``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
         */
        public Build withSpotFleetRequestConfigData(final software.amazon.awscdk.Token value) {
            return new FullBuilder().withSpotFleetRequestConfigData(value);
        }
        /**
         * ``AWS::EC2::SpotFleet.SpotFleetRequestConfigData``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
         */
        public Build withSpotFleetRequestConfigData(final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.SpotFleetRequestConfigDataProperty value) {
            return new FullBuilder().withSpotFleetRequestConfigData(value);
        }

        public interface Build {
            /**
             * @return a new {@link SpotFleetResourceProps} object, initialized with the values set on this builder.
             */
            SpotFleetResourceProps build();
        }

        final class FullBuilder implements Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``AWS::EC2::SpotFleet.SpotFleetRequestConfigData``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
             */
            public Build withSpotFleetRequestConfigData(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "SpotFleetResourceProps#spotFleetRequestConfigData is required");
                this.instance._spotFleetRequestConfigData = value;
                return this;
            }
            /**
             * ``AWS::EC2::SpotFleet.SpotFleetRequestConfigData``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
             */
            public Build withSpotFleetRequestConfigData(final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.SpotFleetRequestConfigDataProperty value) {
                java.util.Objects.requireNonNull(value, "SpotFleetResourceProps#spotFleetRequestConfigData is required");
                this.instance._spotFleetRequestConfigData = value;
                return this;
            }
            public SpotFleetResourceProps build() {
                SpotFleetResourceProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link SpotFleetResourceProps}.
     */
    final class Jsii$Pojo implements SpotFleetResourceProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Object _spotFleetRequestConfigData;

        public java.lang.Object getSpotFleetRequestConfigData() {
            return this._spotFleetRequestConfigData;
        }
        public void setSpotFleetRequestConfigData(final software.amazon.awscdk.Token value) {
            this._spotFleetRequestConfigData = value;
        }
        public void setSpotFleetRequestConfigData(final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.SpotFleetRequestConfigDataProperty value) {
            this._spotFleetRequestConfigData = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * ``AWS::EC2::SpotFleet.SpotFleetRequestConfigData``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
         */
        public java.lang.Object getSpotFleetRequestConfigData() {
            return this.jsiiGet("spotFleetRequestConfigData", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::SpotFleet.SpotFleetRequestConfigData``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
         */
        public void setSpotFleetRequestConfigData(final software.amazon.awscdk.Token value) {
            this.jsiiSet("spotFleetRequestConfigData", java.util.Objects.requireNonNull(value, "spotFleetRequestConfigData is required"));
        }
        /**
         * ``AWS::EC2::SpotFleet.SpotFleetRequestConfigData``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
         */
        public void setSpotFleetRequestConfigData(final software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.SpotFleetRequestConfigDataProperty value) {
            this.jsiiSet("spotFleetRequestConfigData", java.util.Objects.requireNonNull(value, "spotFleetRequestConfigData is required"));
        }
    }
}
