package software.amazon.awscdk.services.ec2.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html
 */
public interface SubnetCidrBlockResourceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ``AWS::EC2::SubnetCidrBlock.Ipv6CidrBlock``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-ipv6cidrblock
     */
    java.lang.Object getIpv6CidrBlock();
    /**
     * ``AWS::EC2::SubnetCidrBlock.Ipv6CidrBlock``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-ipv6cidrblock
     */
    void setIpv6CidrBlock(final java.lang.String value);
    /**
     * ``AWS::EC2::SubnetCidrBlock.Ipv6CidrBlock``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-ipv6cidrblock
     */
    void setIpv6CidrBlock(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::SubnetCidrBlock.SubnetId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-subnetid
     */
    java.lang.Object getSubnetId();
    /**
     * ``AWS::EC2::SubnetCidrBlock.SubnetId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-subnetid
     */
    void setSubnetId(final java.lang.String value);
    /**
     * ``AWS::EC2::SubnetCidrBlock.SubnetId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-subnetid
     */
    void setSubnetId(final software.amazon.awscdk.Token value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link SubnetCidrBlockResourceProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * ``AWS::EC2::SubnetCidrBlock.Ipv6CidrBlock``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-ipv6cidrblock
         */
        public SubnetIdStep withIpv6CidrBlock(final java.lang.String value) {
            return new FullBuilder().withIpv6CidrBlock(value);
        }
        /**
         * ``AWS::EC2::SubnetCidrBlock.Ipv6CidrBlock``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-ipv6cidrblock
         */
        public SubnetIdStep withIpv6CidrBlock(final software.amazon.awscdk.Token value) {
            return new FullBuilder().withIpv6CidrBlock(value);
        }

        public interface SubnetIdStep {
            /**
             * ``AWS::EC2::SubnetCidrBlock.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-subnetid
             */
            Build withSubnetId(final java.lang.String value);
            /**
             * ``AWS::EC2::SubnetCidrBlock.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-subnetid
             */
            Build withSubnetId(final software.amazon.awscdk.Token value);
        }

        public interface Build {
            /**
             * @return a new {@link SubnetCidrBlockResourceProps} object, initialized with the values set on this builder.
             */
            SubnetCidrBlockResourceProps build();
        }

        final class FullBuilder implements SubnetIdStep, Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``AWS::EC2::SubnetCidrBlock.Ipv6CidrBlock``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-ipv6cidrblock
             */
            public SubnetIdStep withIpv6CidrBlock(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "SubnetCidrBlockResourceProps#ipv6CidrBlock is required");
                this.instance._ipv6CidrBlock = value;
                return this;
            }
            /**
             * ``AWS::EC2::SubnetCidrBlock.Ipv6CidrBlock``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-ipv6cidrblock
             */
            public SubnetIdStep withIpv6CidrBlock(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "SubnetCidrBlockResourceProps#ipv6CidrBlock is required");
                this.instance._ipv6CidrBlock = value;
                return this;
            }
            /**
             * ``AWS::EC2::SubnetCidrBlock.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-subnetid
             */
            public Build withSubnetId(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "SubnetCidrBlockResourceProps#subnetId is required");
                this.instance._subnetId = value;
                return this;
            }
            /**
             * ``AWS::EC2::SubnetCidrBlock.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-subnetid
             */
            public Build withSubnetId(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "SubnetCidrBlockResourceProps#subnetId is required");
                this.instance._subnetId = value;
                return this;
            }
            public SubnetCidrBlockResourceProps build() {
                SubnetCidrBlockResourceProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link SubnetCidrBlockResourceProps}.
     */
    final class Jsii$Pojo implements SubnetCidrBlockResourceProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Object _ipv6CidrBlock;

        public java.lang.Object getIpv6CidrBlock() {
            return this._ipv6CidrBlock;
        }
        public void setIpv6CidrBlock(final java.lang.String value) {
            this._ipv6CidrBlock = value;
        }
        public void setIpv6CidrBlock(final software.amazon.awscdk.Token value) {
            this._ipv6CidrBlock = value;
        }

        protected java.lang.Object _subnetId;

        public java.lang.Object getSubnetId() {
            return this._subnetId;
        }
        public void setSubnetId(final java.lang.String value) {
            this._subnetId = value;
        }
        public void setSubnetId(final software.amazon.awscdk.Token value) {
            this._subnetId = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.SubnetCidrBlockResourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * ``AWS::EC2::SubnetCidrBlock.Ipv6CidrBlock``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-ipv6cidrblock
         */
        public java.lang.Object getIpv6CidrBlock() {
            return this.jsiiGet("ipv6CidrBlock", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::SubnetCidrBlock.Ipv6CidrBlock``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-ipv6cidrblock
         */
        public void setIpv6CidrBlock(final java.lang.String value) {
            this.jsiiSet("ipv6CidrBlock", java.util.Objects.requireNonNull(value, "ipv6CidrBlock is required"));
        }
        /**
         * ``AWS::EC2::SubnetCidrBlock.Ipv6CidrBlock``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-ipv6cidrblock
         */
        public void setIpv6CidrBlock(final software.amazon.awscdk.Token value) {
            this.jsiiSet("ipv6CidrBlock", java.util.Objects.requireNonNull(value, "ipv6CidrBlock is required"));
        }
        /**
         * ``AWS::EC2::SubnetCidrBlock.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-subnetid
         */
        public java.lang.Object getSubnetId() {
            return this.jsiiGet("subnetId", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::SubnetCidrBlock.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-subnetid
         */
        public void setSubnetId(final java.lang.String value) {
            this.jsiiSet("subnetId", java.util.Objects.requireNonNull(value, "subnetId is required"));
        }
        /**
         * ``AWS::EC2::SubnetCidrBlock.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-subnetid
         */
        public void setSubnetId(final software.amazon.awscdk.Token value) {
            this.jsiiSet("subnetId", java.util.Objects.requireNonNull(value, "subnetId is required"));
        }
    }
}
