package software.amazon.awscdk.services.ec2.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.cloudformation.SubnetResource")
public class SubnetResource extends software.amazon.awscdk.Resource {
    protected SubnetResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.cloudformation.SubnetResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::EC2::Subnet``.
     * @param parent the ``cdk.Construct`` this ``SubnetResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``SubnetResource``
     */
    public SubnetResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.ec2.cloudformation.SubnetResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @cloudformation_attribute AvailabilityZone
     */
    public software.amazon.awscdk.services.ec2.SubnetAvailabilityZone getSubnetAvailabilityZone() {
        return this.jsiiGet("subnetAvailabilityZone", software.amazon.awscdk.services.ec2.SubnetAvailabilityZone.class);
    }
    /**
     * @cloudformation_attribute Ipv6CidrBlocks
     */
    public software.amazon.awscdk.services.ec2.SubnetIpv6CidrBlocks getSubnetIpv6CidrBlocks() {
        return this.jsiiGet("subnetIpv6CidrBlocks", software.amazon.awscdk.services.ec2.SubnetIpv6CidrBlocks.class);
    }
    /**
     * @cloudformation_attribute NetworkAclAssociationId
     */
    public software.amazon.awscdk.services.ec2.SubnetNetworkAclAssociationId getSubnetNetworkAclAssociationId() {
        return this.jsiiGet("subnetNetworkAclAssociationId", software.amazon.awscdk.services.ec2.SubnetNetworkAclAssociationId.class);
    }
    /**
     * @cloudformation_attribute VpcId
     */
    public software.amazon.awscdk.services.ec2.SubnetVpcId getSubnetVpcId() {
        return this.jsiiGet("subnetVpcId", software.amazon.awscdk.services.ec2.SubnetVpcId.class);
    }
}
