/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.List;
import java.util.Objects;
import software.amazon.awscdk.services.ec2.ClassicLoadBalancerListener;
import software.amazon.awscdk.services.ec2.ClassicLoadBalancerProps;
import software.amazon.awscdk.services.ec2.HealthCheck;
import software.amazon.awscdk.services.ec2.IClassicLoadBalancerTarget;
import software.amazon.awscdk.services.ec2.VpcNetworkRef;
import software.amazon.jsii.JsiiSerializable;

public interface ClassicLoadBalancerProps
extends JsiiSerializable {
    public VpcNetworkRef getVpc();

    public void setVpc(VpcNetworkRef var1);

    public Boolean getInternetFacing();

    public void setInternetFacing(Boolean var1);

    public List<ClassicLoadBalancerListener> getListeners();

    public void setListeners(List<ClassicLoadBalancerListener> var1);

    public List<IClassicLoadBalancerTarget> getTargets();

    public void setTargets(List<IClassicLoadBalancerTarget> var1);

    public HealthCheck getHealthCheck();

    public void setHealthCheck(HealthCheck var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        public Build withVpc(VpcNetworkRef value) {
            return new FullBuilder().withVpc(value);
        }

        final class FullBuilder
        implements Build {
            private Jsii.Pojo instance = new Jsii.Pojo();

            FullBuilder() {
            }

            public Build withVpc(VpcNetworkRef value) {
                Objects.requireNonNull(value, "ClassicLoadBalancerProps#vpc is required");
                this.instance._vpc = value;
                return this;
            }

            @Override
            public Build withInternetFacing(Boolean value) {
                this.instance._internetFacing = value;
                return this;
            }

            @Override
            public Build withListeners(List<ClassicLoadBalancerListener> value) {
                this.instance._listeners = value;
                return this;
            }

            @Override
            public Build withTargets(List<IClassicLoadBalancerTarget> value) {
                this.instance._targets = value;
                return this;
            }

            @Override
            public Build withHealthCheck(HealthCheck value) {
                this.instance._healthCheck = value;
                return this;
            }

            @Override
            public ClassicLoadBalancerProps build() {
                Jsii.Pojo result = this.instance;
                this.instance = new Jsii.Pojo();
                return result;
            }
        }

        public static interface Build {
            public ClassicLoadBalancerProps build();

            public Build withInternetFacing(Boolean var1);

            public Build withListeners(List<ClassicLoadBalancerListener> var1);

            public Build withTargets(List<IClassicLoadBalancerTarget> var1);

            public Build withHealthCheck(HealthCheck var1);
        }
    }
}

