/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Objects;
import software.amazon.awscdk.services.ec2.AutoScalingGroupProps;
import software.amazon.awscdk.services.ec2.IMachineImageSource;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.VpcNetworkRef;
import software.amazon.awscdk.services.ec2.VpcPlacementStrategy;
import software.amazon.awscdk.services.sns.cloudformation.TopicResource;
import software.amazon.jsii.JsiiSerializable;

public interface AutoScalingGroupProps
extends JsiiSerializable {
    public InstanceType getInstanceType();

    public void setInstanceType(InstanceType var1);

    public Number getMinSize();

    public void setMinSize(Number var1);

    public Number getMaxSize();

    public void setMaxSize(Number var1);

    public Number getDesiredCapacity();

    public void setDesiredCapacity(Number var1);

    public String getKeyName();

    public void setKeyName(String var1);

    public IMachineImageSource getMachineImage();

    public void setMachineImage(IMachineImageSource var1);

    public VpcNetworkRef getVpc();

    public void setVpc(VpcNetworkRef var1);

    public VpcPlacementStrategy getVpcPlacement();

    public void setVpcPlacement(VpcPlacementStrategy var1);

    public TopicResource getNotificationsTopic();

    public void setNotificationsTopic(TopicResource var1);

    public Boolean getAllowAllOutbound();

    public void setAllowAllOutbound(Boolean var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        public MachineImageStep withInstanceType(InstanceType value) {
            return new FullBuilder().withInstanceType(value);
        }

        final class FullBuilder
        implements MachineImageStep,
        VpcStep,
        Build {
            private Jsii.Pojo instance = new Jsii.Pojo();

            FullBuilder() {
            }

            public MachineImageStep withInstanceType(InstanceType value) {
                Objects.requireNonNull(value, "AutoScalingGroupProps#instanceType is required");
                this.instance._instanceType = value;
                return this;
            }

            @Override
            public Build withMinSize(Number value) {
                this.instance._minSize = value;
                return this;
            }

            @Override
            public Build withMaxSize(Number value) {
                this.instance._maxSize = value;
                return this;
            }

            @Override
            public Build withDesiredCapacity(Number value) {
                this.instance._desiredCapacity = value;
                return this;
            }

            @Override
            public Build withKeyName(String value) {
                this.instance._keyName = value;
                return this;
            }

            @Override
            public VpcStep withMachineImage(IMachineImageSource value) {
                Objects.requireNonNull(value, "AutoScalingGroupProps#machineImage is required");
                this.instance._machineImage = value;
                return this;
            }

            @Override
            public Build withVpc(VpcNetworkRef value) {
                Objects.requireNonNull(value, "AutoScalingGroupProps#vpc is required");
                this.instance._vpc = value;
                return this;
            }

            @Override
            public Build withVpcPlacement(VpcPlacementStrategy value) {
                this.instance._vpcPlacement = value;
                return this;
            }

            @Override
            public Build withNotificationsTopic(TopicResource value) {
                this.instance._notificationsTopic = value;
                return this;
            }

            @Override
            public Build withAllowAllOutbound(Boolean value) {
                this.instance._allowAllOutbound = value;
                return this;
            }

            @Override
            public AutoScalingGroupProps build() {
                Jsii.Pojo result = this.instance;
                this.instance = new Jsii.Pojo();
                return result;
            }
        }

        public static interface Build {
            public AutoScalingGroupProps build();

            public Build withMinSize(Number var1);

            public Build withMaxSize(Number var1);

            public Build withDesiredCapacity(Number var1);

            public Build withKeyName(String var1);

            public Build withVpcPlacement(VpcPlacementStrategy var1);

            public Build withNotificationsTopic(TopicResource var1);

            public Build withAllowAllOutbound(Boolean var1);
        }

        public static interface VpcStep {
            public Build withVpc(VpcNetworkRef var1);
        }

        public static interface MachineImageStep {
            public VpcStep withMachineImage(IMachineImageSource var1);
        }
    }
}

