/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.List;
import java.util.Objects;
import software.amazon.awscdk.services.ec2.VpcNetworkId;
import software.amazon.awscdk.services.ec2.VpcNetworkRefProps;
import software.amazon.awscdk.services.ec2.VpcSubnetId;
import software.amazon.jsii.JsiiSerializable;

public interface VpcNetworkRefProps
extends JsiiSerializable {
    public VpcNetworkId getVpcId();

    public void setVpcId(VpcNetworkId var1);

    public List<String> getAvailabilityZones();

    public void setAvailabilityZones(List<String> var1);

    public List<VpcSubnetId> getPublicSubnetIds();

    public void setPublicSubnetIds(List<VpcSubnetId> var1);

    public List<VpcSubnetId> getPrivateSubnetIds();

    public void setPrivateSubnetIds(List<VpcSubnetId> var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        public AvailabilityZonesStep withVpcId(VpcNetworkId value) {
            return new FullBuilder().withVpcId(value);
        }

        final class FullBuilder
        implements AvailabilityZonesStep,
        PublicSubnetIdsStep,
        PrivateSubnetIdsStep,
        Build {
            private Jsii.Pojo instance = new Jsii.Pojo();

            FullBuilder() {
            }

            public AvailabilityZonesStep withVpcId(VpcNetworkId value) {
                Objects.requireNonNull(value, "VpcNetworkRefProps#vpcId is required");
                this.instance._vpcId = value;
                return this;
            }

            @Override
            public PublicSubnetIdsStep withAvailabilityZones(List<String> value) {
                Objects.requireNonNull(value, "VpcNetworkRefProps#availabilityZones is required");
                this.instance._availabilityZones = value;
                return this;
            }

            @Override
            public PrivateSubnetIdsStep withPublicSubnetIds(List<VpcSubnetId> value) {
                Objects.requireNonNull(value, "VpcNetworkRefProps#publicSubnetIds is required");
                this.instance._publicSubnetIds = value;
                return this;
            }

            @Override
            public Build withPrivateSubnetIds(List<VpcSubnetId> value) {
                Objects.requireNonNull(value, "VpcNetworkRefProps#privateSubnetIds is required");
                this.instance._privateSubnetIds = value;
                return this;
            }

            @Override
            public VpcNetworkRefProps build() {
                Jsii.Pojo result = this.instance;
                this.instance = new Jsii.Pojo();
                return result;
            }
        }

        public static interface Build {
            public VpcNetworkRefProps build();
        }

        public static interface PrivateSubnetIdsStep {
            public Build withPrivateSubnetIds(List<VpcSubnetId> var1);
        }

        public static interface PublicSubnetIdsStep {
            public PrivateSubnetIdsStep withPublicSubnetIds(List<VpcSubnetId> var1);
        }

        public static interface AvailabilityZonesStep {
            public PublicSubnetIdsStep withAvailabilityZones(List<String> var1);
        }
    }
}

