package software.amazon.awscdk.services.ec2;
/**
 * Properties of a Fleet
 */
public interface AutoScalingGroupProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Type of instance to launch
     */
    software.amazon.awscdk.services.ec2.InstanceType getInstanceType();
    /**
     * Type of instance to launch
     */
    void setInstanceType(final software.amazon.awscdk.services.ec2.InstanceType value);
    /**
     * Minimum number of instances in the fleet
     * @default 1
     */
    java.lang.Number getMinSize();
    /**
     * Minimum number of instances in the fleet
     * @default 1
     */
    void setMinSize(final java.lang.Number value);
    /**
     * Maximum number of instances in the fleet
     * @default 1
     */
    java.lang.Number getMaxSize();
    /**
     * Maximum number of instances in the fleet
     * @default 1
     */
    void setMaxSize(final java.lang.Number value);
    /**
     * Initial amount of instances in the fleet
     * @default 1
     */
    java.lang.Number getDesiredCapacity();
    /**
     * Initial amount of instances in the fleet
     * @default 1
     */
    void setDesiredCapacity(final java.lang.Number value);
    /**
     * Name of SSH keypair to grant access to instances
     * @default No SSH access will be possible
     */
    java.lang.String getKeyName();
    /**
     * Name of SSH keypair to grant access to instances
     * @default No SSH access will be possible
     */
    void setKeyName(final java.lang.String value);
    /**
     * AMI to launch
     */
    software.amazon.awscdk.services.ec2.IMachineImageSource getMachineImage();
    /**
     * AMI to launch
     */
    void setMachineImage(final software.amazon.awscdk.services.ec2.IMachineImageSource value);
    /**
     * VPC to launch these instances in.
     */
    software.amazon.awscdk.services.ec2.VpcNetworkRef getVpc();
    /**
     * VPC to launch these instances in.
     */
    void setVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value);
    /**
     * Where to place instances within the VPC
     */
    software.amazon.awscdk.services.ec2.VpcPlacementStrategy getVpcPlacement();
    /**
     * Where to place instances within the VPC
     */
    void setVpcPlacement(final software.amazon.awscdk.services.ec2.VpcPlacementStrategy value);
    /**
     * SNS topic to send notifications about fleet changes
     * @default No fleet change notifications will be sent.
     */
    software.amazon.awscdk.services.sns.cloudformation.TopicResource getNotificationsTopic();
    /**
     * SNS topic to send notifications about fleet changes
     * @default No fleet change notifications will be sent.
     */
    void setNotificationsTopic(final software.amazon.awscdk.services.sns.cloudformation.TopicResource value);
    /**
     * Whether the instances can initiate connections to anywhere by default
     * @default true
     */
    java.lang.Boolean getAllowAllOutbound();
    /**
     * Whether the instances can initiate connections to anywhere by default
     * @default true
     */
    void setAllowAllOutbound(final java.lang.Boolean value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link AutoScalingGroupProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * Type of instance to launch
         */
        public MachineImageStep withInstanceType(final software.amazon.awscdk.services.ec2.InstanceType value) {
            return new FullBuilder().withInstanceType(value);
        }

        public interface MachineImageStep {
            /**
             * AMI to launch
             */
            VpcStep withMachineImage(final software.amazon.awscdk.services.ec2.IMachineImageSource value);
        }

        public interface VpcStep {
            /**
             * VPC to launch these instances in.
             */
            Build withVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value);
        }

        public interface Build {
            /**
             * @return a new {@link AutoScalingGroupProps} object, initialized with the values set on this builder.
             */
            AutoScalingGroupProps build();
            /**
             * Minimum number of instances in the fleet
             * @default 1
             */
            Build withMinSize(final java.lang.Number value);
            /**
             * Maximum number of instances in the fleet
             * @default 1
             */
            Build withMaxSize(final java.lang.Number value);
            /**
             * Initial amount of instances in the fleet
             * @default 1
             */
            Build withDesiredCapacity(final java.lang.Number value);
            /**
             * Name of SSH keypair to grant access to instances
             * @default No SSH access will be possible
             */
            Build withKeyName(final java.lang.String value);
            /**
             * Where to place instances within the VPC
             */
            Build withVpcPlacement(final software.amazon.awscdk.services.ec2.VpcPlacementStrategy value);
            /**
             * SNS topic to send notifications about fleet changes
             * @default No fleet change notifications will be sent.
             */
            Build withNotificationsTopic(final software.amazon.awscdk.services.sns.cloudformation.TopicResource value);
            /**
             * Whether the instances can initiate connections to anywhere by default
             * @default true
             */
            Build withAllowAllOutbound(final java.lang.Boolean value);
        }

        final class FullBuilder implements MachineImageStep, VpcStep, Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * Type of instance to launch
             */
            public MachineImageStep withInstanceType(final software.amazon.awscdk.services.ec2.InstanceType value) {
                java.util.Objects.requireNonNull(value, "AutoScalingGroupProps#instanceType is required");
                this.instance._instanceType = value;
                return this;
            }
            /**
             * Minimum number of instances in the fleet
             * @default 1
             */
            public Build withMinSize(final java.lang.Number value) {
                this.instance._minSize = value;
                return this;
            }
            /**
             * Maximum number of instances in the fleet
             * @default 1
             */
            public Build withMaxSize(final java.lang.Number value) {
                this.instance._maxSize = value;
                return this;
            }
            /**
             * Initial amount of instances in the fleet
             * @default 1
             */
            public Build withDesiredCapacity(final java.lang.Number value) {
                this.instance._desiredCapacity = value;
                return this;
            }
            /**
             * Name of SSH keypair to grant access to instances
             * @default No SSH access will be possible
             */
            public Build withKeyName(final java.lang.String value) {
                this.instance._keyName = value;
                return this;
            }
            /**
             * AMI to launch
             */
            public VpcStep withMachineImage(final software.amazon.awscdk.services.ec2.IMachineImageSource value) {
                java.util.Objects.requireNonNull(value, "AutoScalingGroupProps#machineImage is required");
                this.instance._machineImage = value;
                return this;
            }
            /**
             * VPC to launch these instances in.
             */
            public Build withVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
                java.util.Objects.requireNonNull(value, "AutoScalingGroupProps#vpc is required");
                this.instance._vpc = value;
                return this;
            }
            /**
             * Where to place instances within the VPC
             */
            public Build withVpcPlacement(final software.amazon.awscdk.services.ec2.VpcPlacementStrategy value) {
                this.instance._vpcPlacement = value;
                return this;
            }
            /**
             * SNS topic to send notifications about fleet changes
             * @default No fleet change notifications will be sent.
             */
            public Build withNotificationsTopic(final software.amazon.awscdk.services.sns.cloudformation.TopicResource value) {
                this.instance._notificationsTopic = value;
                return this;
            }
            /**
             * Whether the instances can initiate connections to anywhere by default
             * @default true
             */
            public Build withAllowAllOutbound(final java.lang.Boolean value) {
                this.instance._allowAllOutbound = value;
                return this;
            }
            public AutoScalingGroupProps build() {
                AutoScalingGroupProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link AutoScalingGroupProps}.
     */
    final class Jsii$Pojo implements AutoScalingGroupProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected software.amazon.awscdk.services.ec2.InstanceType _instanceType;

        public software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this._instanceType;
        }
        public void setInstanceType(final software.amazon.awscdk.services.ec2.InstanceType value) {
            this._instanceType = value;
        }

        protected java.lang.Number _minSize;

        public java.lang.Number getMinSize() {
            return this._minSize;
        }
        public void setMinSize(final java.lang.Number value) {
            this._minSize = value;
        }

        protected java.lang.Number _maxSize;

        public java.lang.Number getMaxSize() {
            return this._maxSize;
        }
        public void setMaxSize(final java.lang.Number value) {
            this._maxSize = value;
        }

        protected java.lang.Number _desiredCapacity;

        public java.lang.Number getDesiredCapacity() {
            return this._desiredCapacity;
        }
        public void setDesiredCapacity(final java.lang.Number value) {
            this._desiredCapacity = value;
        }

        protected java.lang.String _keyName;

        public java.lang.String getKeyName() {
            return this._keyName;
        }
        public void setKeyName(final java.lang.String value) {
            this._keyName = value;
        }

        protected software.amazon.awscdk.services.ec2.IMachineImageSource _machineImage;

        public software.amazon.awscdk.services.ec2.IMachineImageSource getMachineImage() {
            return this._machineImage;
        }
        public void setMachineImage(final software.amazon.awscdk.services.ec2.IMachineImageSource value) {
            this._machineImage = value;
        }

        protected software.amazon.awscdk.services.ec2.VpcNetworkRef _vpc;

        public software.amazon.awscdk.services.ec2.VpcNetworkRef getVpc() {
            return this._vpc;
        }
        public void setVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
            this._vpc = value;
        }

        protected software.amazon.awscdk.services.ec2.VpcPlacementStrategy _vpcPlacement;

        public software.amazon.awscdk.services.ec2.VpcPlacementStrategy getVpcPlacement() {
            return this._vpcPlacement;
        }
        public void setVpcPlacement(final software.amazon.awscdk.services.ec2.VpcPlacementStrategy value) {
            this._vpcPlacement = value;
        }

        protected software.amazon.awscdk.services.sns.cloudformation.TopicResource _notificationsTopic;

        public software.amazon.awscdk.services.sns.cloudformation.TopicResource getNotificationsTopic() {
            return this._notificationsTopic;
        }
        public void setNotificationsTopic(final software.amazon.awscdk.services.sns.cloudformation.TopicResource value) {
            this._notificationsTopic = value;
        }

        protected java.lang.Boolean _allowAllOutbound;

        public java.lang.Boolean getAllowAllOutbound() {
            return this._allowAllOutbound;
        }
        public void setAllowAllOutbound(final java.lang.Boolean value) {
            this._allowAllOutbound = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.AutoScalingGroupProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * Type of instance to launch
         */
        public software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.jsiiGet("instanceType", software.amazon.awscdk.services.ec2.InstanceType.class);
        }
        /**
         * Type of instance to launch
         */
        public void setInstanceType(final software.amazon.awscdk.services.ec2.InstanceType value) {
            this.jsiiSet("instanceType", java.util.Objects.requireNonNull(value, "instanceType is required"));
        }
        /**
         * Minimum number of instances in the fleet
         * @default 1
         */
        @javax.annotation.Nullable
        public java.lang.Number getMinSize() {
            return this.jsiiGet("minSize", java.lang.Number.class);
        }
        /**
         * Minimum number of instances in the fleet
         * @default 1
         */
        public void setMinSize(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("minSize", value);
        }
        /**
         * Maximum number of instances in the fleet
         * @default 1
         */
        @javax.annotation.Nullable
        public java.lang.Number getMaxSize() {
            return this.jsiiGet("maxSize", java.lang.Number.class);
        }
        /**
         * Maximum number of instances in the fleet
         * @default 1
         */
        public void setMaxSize(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("maxSize", value);
        }
        /**
         * Initial amount of instances in the fleet
         * @default 1
         */
        @javax.annotation.Nullable
        public java.lang.Number getDesiredCapacity() {
            return this.jsiiGet("desiredCapacity", java.lang.Number.class);
        }
        /**
         * Initial amount of instances in the fleet
         * @default 1
         */
        public void setDesiredCapacity(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("desiredCapacity", value);
        }
        /**
         * Name of SSH keypair to grant access to instances
         * @default No SSH access will be possible
         */
        @javax.annotation.Nullable
        public java.lang.String getKeyName() {
            return this.jsiiGet("keyName", java.lang.String.class);
        }
        /**
         * Name of SSH keypair to grant access to instances
         * @default No SSH access will be possible
         */
        public void setKeyName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("keyName", value);
        }
        /**
         * AMI to launch
         */
        public software.amazon.awscdk.services.ec2.IMachineImageSource getMachineImage() {
            return this.jsiiGet("machineImage", software.amazon.awscdk.services.ec2.IMachineImageSource.class);
        }
        /**
         * AMI to launch
         */
        public void setMachineImage(final software.amazon.awscdk.services.ec2.IMachineImageSource value) {
            this.jsiiSet("machineImage", java.util.Objects.requireNonNull(value, "machineImage is required"));
        }
        /**
         * VPC to launch these instances in.
         */
        public software.amazon.awscdk.services.ec2.VpcNetworkRef getVpc() {
            return this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.VpcNetworkRef.class);
        }
        /**
         * VPC to launch these instances in.
         */
        public void setVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
            this.jsiiSet("vpc", java.util.Objects.requireNonNull(value, "vpc is required"));
        }
        /**
         * Where to place instances within the VPC
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.VpcPlacementStrategy getVpcPlacement() {
            return this.jsiiGet("vpcPlacement", software.amazon.awscdk.services.ec2.VpcPlacementStrategy.class);
        }
        /**
         * Where to place instances within the VPC
         */
        public void setVpcPlacement(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.VpcPlacementStrategy value) {
            this.jsiiSet("vpcPlacement", value);
        }
        /**
         * SNS topic to send notifications about fleet changes
         * @default No fleet change notifications will be sent.
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.sns.cloudformation.TopicResource getNotificationsTopic() {
            return this.jsiiGet("notificationsTopic", software.amazon.awscdk.services.sns.cloudformation.TopicResource.class);
        }
        /**
         * SNS topic to send notifications about fleet changes
         * @default No fleet change notifications will be sent.
         */
        public void setNotificationsTopic(@javax.annotation.Nullable final software.amazon.awscdk.services.sns.cloudformation.TopicResource value) {
            this.jsiiSet("notificationsTopic", value);
        }
        /**
         * Whether the instances can initiate connections to anywhere by default
         * @default true
         */
        @javax.annotation.Nullable
        public java.lang.Boolean getAllowAllOutbound() {
            return this.jsiiGet("allowAllOutbound", java.lang.Boolean.class);
        }
        /**
         * Whether the instances can initiate connections to anywhere by default
         * @default true
         */
        public void setAllowAllOutbound(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("allowAllOutbound", value);
        }
    }
}
