package software.amazon.awscdk.services.ec2;
/**
 * Add a backend to the load balancer
 */
public interface ClassicLoadBalancerListener extends software.amazon.jsii.JsiiSerializable {
    /**
     * External listening port
     */
    java.lang.Number getExternalPort();
    /**
     * External listening port
     */
    void setExternalPort(final java.lang.Number value);
    /**
     * What public protocol to use for load balancing
     * 
     * Either 'tcp', 'ssl', 'http' or 'https'.
     * 
     * May be omitted if the external port is either 80 or 443.
     */
    software.amazon.awscdk.services.ec2.LoadBalancingProtocol getExternalProtocol();
    /**
     * What public protocol to use for load balancing
     * 
     * Either 'tcp', 'ssl', 'http' or 'https'.
     * 
     * May be omitted if the external port is either 80 or 443.
     */
    void setExternalProtocol(final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value);
    /**
     * Instance listening port
     * 
     * Same as the externalPort if not specified.
     * @default externalPort
     */
    java.lang.Number getInternalPort();
    /**
     * Instance listening port
     * 
     * Same as the externalPort if not specified.
     * @default externalPort
     */
    void setInternalPort(final java.lang.Number value);
    /**
     * What public protocol to use for load balancing
     * 
     * Either 'tcp', 'ssl', 'http' or 'https'.
     * 
     * May be omitted if the internal port is either 80 or 443.
     * 
     * The instance protocol is 'tcp' if the front-end protocol
     * is 'tcp' or 'ssl', the instance protocol is 'http' if the
     * front-end protocol is 'https'.
     */
    software.amazon.awscdk.services.ec2.LoadBalancingProtocol getInternalProtocol();
    /**
     * What public protocol to use for load balancing
     * 
     * Either 'tcp', 'ssl', 'http' or 'https'.
     * 
     * May be omitted if the internal port is either 80 or 443.
     * 
     * The instance protocol is 'tcp' if the front-end protocol
     * is 'tcp' or 'ssl', the instance protocol is 'http' if the
     * front-end protocol is 'https'.
     */
    void setInternalProtocol(final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value);
    /**
     * SSL policy names
     */
    java.util.List<java.lang.String> getPolicyNames();
    /**
     * SSL policy names
     */
    void setPolicyNames(final java.util.List<java.lang.String> value);
    /**
     * ID of SSL certificate
     */
    software.amazon.awscdk.Arn getSslCertificateId();
    /**
     * ID of SSL certificate
     */
    void setSslCertificateId(final software.amazon.awscdk.Arn value);
    /**
     * Allow connections to the load balancer from the given set of connection peers
     * 
     * By default, connections will be allowed from anywhere. Set this to an empty list
     * to deny connections, or supply a custom list of peers to allow connections from
     * (IP ranges or security groups).
     * @default Anywhere
     */
    java.util.List<software.amazon.awscdk.services.ec2.IConnectable> getAllowConnectionsFrom();
    /**
     * Allow connections to the load balancer from the given set of connection peers
     * 
     * By default, connections will be allowed from anywhere. Set this to an empty list
     * to deny connections, or supply a custom list of peers to allow connections from
     * (IP ranges or security groups).
     * @default Anywhere
     */
    void setAllowConnectionsFrom(final java.util.List<software.amazon.awscdk.services.ec2.IConnectable> value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link ClassicLoadBalancerListener}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * External listening port
         */
        public Build withExternalPort(final java.lang.Number value) {
            return new FullBuilder().withExternalPort(value);
        }

        public interface Build {
            /**
             * @return a new {@link ClassicLoadBalancerListener} object, initialized with the values set on this builder.
             */
            ClassicLoadBalancerListener build();
            /**
             * What public protocol to use for load balancing
             * 
             * Either 'tcp', 'ssl', 'http' or 'https'.
             * 
             * May be omitted if the external port is either 80 or 443.
             */
            Build withExternalProtocol(final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value);
            /**
             * Instance listening port
             * 
             * Same as the externalPort if not specified.
             * @default externalPort
             */
            Build withInternalPort(final java.lang.Number value);
            /**
             * What public protocol to use for load balancing
             * 
             * Either 'tcp', 'ssl', 'http' or 'https'.
             * 
             * May be omitted if the internal port is either 80 or 443.
             * 
             * The instance protocol is 'tcp' if the front-end protocol
             * is 'tcp' or 'ssl', the instance protocol is 'http' if the
             * front-end protocol is 'https'.
             */
            Build withInternalProtocol(final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value);
            /**
             * SSL policy names
             */
            Build withPolicyNames(final java.util.List<java.lang.String> value);
            /**
             * ID of SSL certificate
             */
            Build withSslCertificateId(final software.amazon.awscdk.Arn value);
            /**
             * Allow connections to the load balancer from the given set of connection peers
             * 
             * By default, connections will be allowed from anywhere. Set this to an empty list
             * to deny connections, or supply a custom list of peers to allow connections from
             * (IP ranges or security groups).
             * @default Anywhere
             */
            Build withAllowConnectionsFrom(final java.util.List<software.amazon.awscdk.services.ec2.IConnectable> value);
        }

        final class FullBuilder implements Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * External listening port
             */
            public Build withExternalPort(final java.lang.Number value) {
                java.util.Objects.requireNonNull(value, "ClassicLoadBalancerListener#externalPort is required");
                this.instance._externalPort = value;
                return this;
            }
            /**
             * What public protocol to use for load balancing
             * 
             * Either 'tcp', 'ssl', 'http' or 'https'.
             * 
             * May be omitted if the external port is either 80 or 443.
             */
            public Build withExternalProtocol(final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value) {
                this.instance._externalProtocol = value;
                return this;
            }
            /**
             * Instance listening port
             * 
             * Same as the externalPort if not specified.
             * @default externalPort
             */
            public Build withInternalPort(final java.lang.Number value) {
                this.instance._internalPort = value;
                return this;
            }
            /**
             * What public protocol to use for load balancing
             * 
             * Either 'tcp', 'ssl', 'http' or 'https'.
             * 
             * May be omitted if the internal port is either 80 or 443.
             * 
             * The instance protocol is 'tcp' if the front-end protocol
             * is 'tcp' or 'ssl', the instance protocol is 'http' if the
             * front-end protocol is 'https'.
             */
            public Build withInternalProtocol(final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value) {
                this.instance._internalProtocol = value;
                return this;
            }
            /**
             * SSL policy names
             */
            public Build withPolicyNames(final java.util.List<java.lang.String> value) {
                this.instance._policyNames = value;
                return this;
            }
            /**
             * ID of SSL certificate
             */
            public Build withSslCertificateId(final software.amazon.awscdk.Arn value) {
                this.instance._sslCertificateId = value;
                return this;
            }
            /**
             * Allow connections to the load balancer from the given set of connection peers
             * 
             * By default, connections will be allowed from anywhere. Set this to an empty list
             * to deny connections, or supply a custom list of peers to allow connections from
             * (IP ranges or security groups).
             * @default Anywhere
             */
            public Build withAllowConnectionsFrom(final java.util.List<software.amazon.awscdk.services.ec2.IConnectable> value) {
                this.instance._allowConnectionsFrom = value;
                return this;
            }
            public ClassicLoadBalancerListener build() {
                ClassicLoadBalancerListener result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link ClassicLoadBalancerListener}.
     */
    final class Jsii$Pojo implements ClassicLoadBalancerListener {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Number _externalPort;

        public java.lang.Number getExternalPort() {
            return this._externalPort;
        }
        public void setExternalPort(final java.lang.Number value) {
            this._externalPort = value;
        }

        protected software.amazon.awscdk.services.ec2.LoadBalancingProtocol _externalProtocol;

        public software.amazon.awscdk.services.ec2.LoadBalancingProtocol getExternalProtocol() {
            return this._externalProtocol;
        }
        public void setExternalProtocol(final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value) {
            this._externalProtocol = value;
        }

        protected java.lang.Number _internalPort;

        public java.lang.Number getInternalPort() {
            return this._internalPort;
        }
        public void setInternalPort(final java.lang.Number value) {
            this._internalPort = value;
        }

        protected software.amazon.awscdk.services.ec2.LoadBalancingProtocol _internalProtocol;

        public software.amazon.awscdk.services.ec2.LoadBalancingProtocol getInternalProtocol() {
            return this._internalProtocol;
        }
        public void setInternalProtocol(final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value) {
            this._internalProtocol = value;
        }

        protected java.util.List<java.lang.String> _policyNames;

        public java.util.List<java.lang.String> getPolicyNames() {
            return this._policyNames;
        }
        public void setPolicyNames(final java.util.List<java.lang.String> value) {
            this._policyNames = value;
        }

        protected software.amazon.awscdk.Arn _sslCertificateId;

        public software.amazon.awscdk.Arn getSslCertificateId() {
            return this._sslCertificateId;
        }
        public void setSslCertificateId(final software.amazon.awscdk.Arn value) {
            this._sslCertificateId = value;
        }

        protected java.util.List<software.amazon.awscdk.services.ec2.IConnectable> _allowConnectionsFrom;

        public java.util.List<software.amazon.awscdk.services.ec2.IConnectable> getAllowConnectionsFrom() {
            return this._allowConnectionsFrom;
        }
        public void setAllowConnectionsFrom(final java.util.List<software.amazon.awscdk.services.ec2.IConnectable> value) {
            this._allowConnectionsFrom = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.ClassicLoadBalancerListener {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * External listening port
         */
        public java.lang.Number getExternalPort() {
            return this.jsiiGet("externalPort", java.lang.Number.class);
        }
        /**
         * External listening port
         */
        public void setExternalPort(final java.lang.Number value) {
            this.jsiiSet("externalPort", java.util.Objects.requireNonNull(value, "externalPort is required"));
        }
        /**
         * What public protocol to use for load balancing
         * 
         * Either 'tcp', 'ssl', 'http' or 'https'.
         * 
         * May be omitted if the external port is either 80 or 443.
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.LoadBalancingProtocol getExternalProtocol() {
            return this.jsiiGet("externalProtocol", software.amazon.awscdk.services.ec2.LoadBalancingProtocol.class);
        }
        /**
         * What public protocol to use for load balancing
         * 
         * Either 'tcp', 'ssl', 'http' or 'https'.
         * 
         * May be omitted if the external port is either 80 or 443.
         */
        public void setExternalProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value) {
            this.jsiiSet("externalProtocol", value);
        }
        /**
         * Instance listening port
         * 
         * Same as the externalPort if not specified.
         * @default externalPort
         */
        @javax.annotation.Nullable
        public java.lang.Number getInternalPort() {
            return this.jsiiGet("internalPort", java.lang.Number.class);
        }
        /**
         * Instance listening port
         * 
         * Same as the externalPort if not specified.
         * @default externalPort
         */
        public void setInternalPort(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("internalPort", value);
        }
        /**
         * What public protocol to use for load balancing
         * 
         * Either 'tcp', 'ssl', 'http' or 'https'.
         * 
         * May be omitted if the internal port is either 80 or 443.
         * 
         * The instance protocol is 'tcp' if the front-end protocol
         * is 'tcp' or 'ssl', the instance protocol is 'http' if the
         * front-end protocol is 'https'.
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.LoadBalancingProtocol getInternalProtocol() {
            return this.jsiiGet("internalProtocol", software.amazon.awscdk.services.ec2.LoadBalancingProtocol.class);
        }
        /**
         * What public protocol to use for load balancing
         * 
         * Either 'tcp', 'ssl', 'http' or 'https'.
         * 
         * May be omitted if the internal port is either 80 or 443.
         * 
         * The instance protocol is 'tcp' if the front-end protocol
         * is 'tcp' or 'ssl', the instance protocol is 'http' if the
         * front-end protocol is 'https'.
         */
        public void setInternalProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value) {
            this.jsiiSet("internalProtocol", value);
        }
        /**
         * SSL policy names
         */
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getPolicyNames() {
            return this.jsiiGet("policyNames", java.util.List.class);
        }
        /**
         * SSL policy names
         */
        public void setPolicyNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this.jsiiSet("policyNames", value);
        }
        /**
         * ID of SSL certificate
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.Arn getSslCertificateId() {
            return this.jsiiGet("sslCertificateId", software.amazon.awscdk.Arn.class);
        }
        /**
         * ID of SSL certificate
         */
        public void setSslCertificateId(@javax.annotation.Nullable final software.amazon.awscdk.Arn value) {
            this.jsiiSet("sslCertificateId", value);
        }
        /**
         * Allow connections to the load balancer from the given set of connection peers
         * 
         * By default, connections will be allowed from anywhere. Set this to an empty list
         * to deny connections, or supply a custom list of peers to allow connections from
         * (IP ranges or security groups).
         * @default Anywhere
         */
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.ec2.IConnectable> getAllowConnectionsFrom() {
            return this.jsiiGet("allowConnectionsFrom", java.util.List.class);
        }
        /**
         * Allow connections to the load balancer from the given set of connection peers
         * 
         * By default, connections will be allowed from anywhere. Set this to an empty list
         * to deny connections, or supply a custom list of peers to allow connections from
         * (IP ranges or security groups).
         * @default Anywhere
         */
        public void setAllowConnectionsFrom(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.IConnectable> value) {
            this.jsiiSet("allowConnectionsFrom", value);
        }
    }
}
