package software.amazon.awscdk.services.ec2;
public interface ConnectionRule extends software.amazon.jsii.JsiiSerializable {
    /**
     * The IP protocol name (tcp, udp, icmp) or number (see Protocol Numbers).
     * Use -1 to specify all protocols. If you specify -1, or a protocol number
     * other than tcp, udp, icmp, or 58 (ICMPv6), traffic on all ports is
     * allowed, regardless of any ports you specify. For tcp, udp, and icmp, you
     * must specify a port range. For protocol 58 (ICMPv6), you can optionally
     * specify a port range; if you don't, traffic for all types and codes is
     * allowed.
     * @default tcp
     */
    java.lang.String getProtocol();
    /**
     * The IP protocol name (tcp, udp, icmp) or number (see Protocol Numbers).
     * Use -1 to specify all protocols. If you specify -1, or a protocol number
     * other than tcp, udp, icmp, or 58 (ICMPv6), traffic on all ports is
     * allowed, regardless of any ports you specify. For tcp, udp, and icmp, you
     * must specify a port range. For protocol 58 (ICMPv6), you can optionally
     * specify a port range; if you don't, traffic for all types and codes is
     * allowed.
     * @default tcp
     */
    void setProtocol(final java.lang.String value);
    /**
     * Start of port range for the TCP and UDP protocols, or an ICMP type number.
     * 
     * If you specify icmp for the IpProtocol property, you can specify
     * -1 as a wildcard (i.e., any ICMP type number).
     */
    java.lang.Number getFromPort();
    /**
     * Start of port range for the TCP and UDP protocols, or an ICMP type number.
     * 
     * If you specify icmp for the IpProtocol property, you can specify
     * -1 as a wildcard (i.e., any ICMP type number).
     */
    void setFromPort(final java.lang.Number value);
    /**
     * End of port range for the TCP and UDP protocols, or an ICMP code.
     * 
     * If you specify icmp for the IpProtocol property, you can specify -1 as a
     * wildcard (i.e., any ICMP code).
     * @default If toPort is not specified, it will be the same as fromPort.
     */
    java.lang.Number getToPort();
    /**
     * End of port range for the TCP and UDP protocols, or an ICMP code.
     * 
     * If you specify icmp for the IpProtocol property, you can specify -1 as a
     * wildcard (i.e., any ICMP code).
     * @default If toPort is not specified, it will be the same as fromPort.
     */
    void setToPort(final java.lang.Number value);
    /**
     * Description of this connection. It is applied to both the ingress rule
     * and the egress rule.
     * @default No description
     */
    java.lang.String getDescription();
    /**
     * Description of this connection. It is applied to both the ingress rule
     * and the egress rule.
     * @default No description
     */
    void setDescription(final java.lang.String value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link ConnectionRule}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * Start of port range for the TCP and UDP protocols, or an ICMP type number.
         * 
         * If you specify icmp for the IpProtocol property, you can specify
         * -1 as a wildcard (i.e., any ICMP type number).
         */
        public Build withFromPort(final java.lang.Number value) {
            return new FullBuilder().withFromPort(value);
        }

        public interface Build {
            /**
             * @return a new {@link ConnectionRule} object, initialized with the values set on this builder.
             */
            ConnectionRule build();
            /**
             * The IP protocol name (tcp, udp, icmp) or number (see Protocol Numbers).
             * Use -1 to specify all protocols. If you specify -1, or a protocol number
             * other than tcp, udp, icmp, or 58 (ICMPv6), traffic on all ports is
             * allowed, regardless of any ports you specify. For tcp, udp, and icmp, you
             * must specify a port range. For protocol 58 (ICMPv6), you can optionally
             * specify a port range; if you don't, traffic for all types and codes is
             * allowed.
             * @default tcp
             */
            Build withProtocol(final java.lang.String value);
            /**
             * End of port range for the TCP and UDP protocols, or an ICMP code.
             * 
             * If you specify icmp for the IpProtocol property, you can specify -1 as a
             * wildcard (i.e., any ICMP code).
             * @default If toPort is not specified, it will be the same as fromPort.
             */
            Build withToPort(final java.lang.Number value);
            /**
             * Description of this connection. It is applied to both the ingress rule
             * and the egress rule.
             * @default No description
             */
            Build withDescription(final java.lang.String value);
        }

        final class FullBuilder implements Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * The IP protocol name (tcp, udp, icmp) or number (see Protocol Numbers).
             * Use -1 to specify all protocols. If you specify -1, or a protocol number
             * other than tcp, udp, icmp, or 58 (ICMPv6), traffic on all ports is
             * allowed, regardless of any ports you specify. For tcp, udp, and icmp, you
             * must specify a port range. For protocol 58 (ICMPv6), you can optionally
             * specify a port range; if you don't, traffic for all types and codes is
             * allowed.
             * @default tcp
             */
            public Build withProtocol(final java.lang.String value) {
                this.instance._protocol = value;
                return this;
            }
            /**
             * Start of port range for the TCP and UDP protocols, or an ICMP type number.
             * 
             * If you specify icmp for the IpProtocol property, you can specify
             * -1 as a wildcard (i.e., any ICMP type number).
             */
            public Build withFromPort(final java.lang.Number value) {
                java.util.Objects.requireNonNull(value, "ConnectionRule#fromPort is required");
                this.instance._fromPort = value;
                return this;
            }
            /**
             * End of port range for the TCP and UDP protocols, or an ICMP code.
             * 
             * If you specify icmp for the IpProtocol property, you can specify -1 as a
             * wildcard (i.e., any ICMP code).
             * @default If toPort is not specified, it will be the same as fromPort.
             */
            public Build withToPort(final java.lang.Number value) {
                this.instance._toPort = value;
                return this;
            }
            /**
             * Description of this connection. It is applied to both the ingress rule
             * and the egress rule.
             * @default No description
             */
            public Build withDescription(final java.lang.String value) {
                this.instance._description = value;
                return this;
            }
            public ConnectionRule build() {
                ConnectionRule result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link ConnectionRule}.
     */
    final class Jsii$Pojo implements ConnectionRule {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.String _protocol;

        public java.lang.String getProtocol() {
            return this._protocol;
        }
        public void setProtocol(final java.lang.String value) {
            this._protocol = value;
        }

        protected java.lang.Number _fromPort;

        public java.lang.Number getFromPort() {
            return this._fromPort;
        }
        public void setFromPort(final java.lang.Number value) {
            this._fromPort = value;
        }

        protected java.lang.Number _toPort;

        public java.lang.Number getToPort() {
            return this._toPort;
        }
        public void setToPort(final java.lang.Number value) {
            this._toPort = value;
        }

        protected java.lang.String _description;

        public java.lang.String getDescription() {
            return this._description;
        }
        public void setDescription(final java.lang.String value) {
            this._description = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.ConnectionRule {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * The IP protocol name (tcp, udp, icmp) or number (see Protocol Numbers).
         * Use -1 to specify all protocols. If you specify -1, or a protocol number
         * other than tcp, udp, icmp, or 58 (ICMPv6), traffic on all ports is
         * allowed, regardless of any ports you specify. For tcp, udp, and icmp, you
         * must specify a port range. For protocol 58 (ICMPv6), you can optionally
         * specify a port range; if you don't, traffic for all types and codes is
         * allowed.
         * @default tcp
         */
        @javax.annotation.Nullable
        public java.lang.String getProtocol() {
            return this.jsiiGet("protocol", java.lang.String.class);
        }
        /**
         * The IP protocol name (tcp, udp, icmp) or number (see Protocol Numbers).
         * Use -1 to specify all protocols. If you specify -1, or a protocol number
         * other than tcp, udp, icmp, or 58 (ICMPv6), traffic on all ports is
         * allowed, regardless of any ports you specify. For tcp, udp, and icmp, you
         * must specify a port range. For protocol 58 (ICMPv6), you can optionally
         * specify a port range; if you don't, traffic for all types and codes is
         * allowed.
         * @default tcp
         */
        public void setProtocol(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("protocol", value);
        }
        /**
         * Start of port range for the TCP and UDP protocols, or an ICMP type number.
         * 
         * If you specify icmp for the IpProtocol property, you can specify
         * -1 as a wildcard (i.e., any ICMP type number).
         */
        public java.lang.Number getFromPort() {
            return this.jsiiGet("fromPort", java.lang.Number.class);
        }
        /**
         * Start of port range for the TCP and UDP protocols, or an ICMP type number.
         * 
         * If you specify icmp for the IpProtocol property, you can specify
         * -1 as a wildcard (i.e., any ICMP type number).
         */
        public void setFromPort(final java.lang.Number value) {
            this.jsiiSet("fromPort", java.util.Objects.requireNonNull(value, "fromPort is required"));
        }
        /**
         * End of port range for the TCP and UDP protocols, or an ICMP code.
         * 
         * If you specify icmp for the IpProtocol property, you can specify -1 as a
         * wildcard (i.e., any ICMP code).
         * @default If toPort is not specified, it will be the same as fromPort.
         */
        @javax.annotation.Nullable
        public java.lang.Number getToPort() {
            return this.jsiiGet("toPort", java.lang.Number.class);
        }
        /**
         * End of port range for the TCP and UDP protocols, or an ICMP code.
         * 
         * If you specify icmp for the IpProtocol property, you can specify -1 as a
         * wildcard (i.e., any ICMP code).
         * @default If toPort is not specified, it will be the same as fromPort.
         */
        public void setToPort(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("toPort", value);
        }
        /**
         * Description of this connection. It is applied to both the ingress rule
         * and the egress rule.
         * @default No description
         */
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }
        /**
         * Description of this connection. It is applied to both the ingress rule
         * and the egress rule.
         * @default No description
         */
        public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("description", value);
        }
    }
}
