package software.amazon.awscdk.services.ec2;
/**
 * Describe the health check to a load balancer
 */
public interface HealthCheck extends software.amazon.jsii.JsiiSerializable {
    /**
     * What port number to health check on
     */
    java.lang.Number getPort();
    /**
     * What port number to health check on
     */
    void setPort(final java.lang.Number value);
    /**
     * What protocol to use for health checking
     * 
     * The protocol is automatically determined from the port if it's not supplied.
     * @default Automatic
     */
    software.amazon.awscdk.services.ec2.LoadBalancingProtocol getProtocol();
    /**
     * What protocol to use for health checking
     * 
     * The protocol is automatically determined from the port if it's not supplied.
     * @default Automatic
     */
    void setProtocol(final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value);
    /**
     * What path to use for HTTP or HTTPS health check (must return 200)
     * 
     * For SSL and TCP health checks, accepting connections is enough to be considered
     * healthy.
     * @default "/"
     */
    java.lang.String getPath();
    /**
     * What path to use for HTTP or HTTPS health check (must return 200)
     * 
     * For SSL and TCP health checks, accepting connections is enough to be considered
     * healthy.
     * @default "/"
     */
    void setPath(final java.lang.String value);
    /**
     * After how many successful checks is an instance considered healthy
     * @default 2
     */
    java.lang.Number getHealthyThreshold();
    /**
     * After how many successful checks is an instance considered healthy
     * @default 2
     */
    void setHealthyThreshold(final java.lang.Number value);
    /**
     * After how many unsuccessful checks is an instance considered unhealthy
     * @default 5
     */
    java.lang.Number getUnhealthyThreshold();
    /**
     * After how many unsuccessful checks is an instance considered unhealthy
     * @default 5
     */
    void setUnhealthyThreshold(final java.lang.Number value);
    /**
     * Number of seconds between health checks
     * @default 30
     */
    java.lang.Number getInterval();
    /**
     * Number of seconds between health checks
     * @default 30
     */
    void setInterval(final java.lang.Number value);
    /**
     * Health check timeout
     * @default 5
     */
    java.lang.Number getTimeout();
    /**
     * Health check timeout
     * @default 5
     */
    void setTimeout(final java.lang.Number value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link HealthCheck}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * What port number to health check on
         */
        public Build withPort(final java.lang.Number value) {
            return new FullBuilder().withPort(value);
        }

        public interface Build {
            /**
             * @return a new {@link HealthCheck} object, initialized with the values set on this builder.
             */
            HealthCheck build();
            /**
             * What protocol to use for health checking
             * 
             * The protocol is automatically determined from the port if it's not supplied.
             * @default Automatic
             */
            Build withProtocol(final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value);
            /**
             * What path to use for HTTP or HTTPS health check (must return 200)
             * 
             * For SSL and TCP health checks, accepting connections is enough to be considered
             * healthy.
             * @default "/"
             */
            Build withPath(final java.lang.String value);
            /**
             * After how many successful checks is an instance considered healthy
             * @default 2
             */
            Build withHealthyThreshold(final java.lang.Number value);
            /**
             * After how many unsuccessful checks is an instance considered unhealthy
             * @default 5
             */
            Build withUnhealthyThreshold(final java.lang.Number value);
            /**
             * Number of seconds between health checks
             * @default 30
             */
            Build withInterval(final java.lang.Number value);
            /**
             * Health check timeout
             * @default 5
             */
            Build withTimeout(final java.lang.Number value);
        }

        final class FullBuilder implements Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * What port number to health check on
             */
            public Build withPort(final java.lang.Number value) {
                java.util.Objects.requireNonNull(value, "HealthCheck#port is required");
                this.instance._port = value;
                return this;
            }
            /**
             * What protocol to use for health checking
             * 
             * The protocol is automatically determined from the port if it's not supplied.
             * @default Automatic
             */
            public Build withProtocol(final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value) {
                this.instance._protocol = value;
                return this;
            }
            /**
             * What path to use for HTTP or HTTPS health check (must return 200)
             * 
             * For SSL and TCP health checks, accepting connections is enough to be considered
             * healthy.
             * @default "/"
             */
            public Build withPath(final java.lang.String value) {
                this.instance._path = value;
                return this;
            }
            /**
             * After how many successful checks is an instance considered healthy
             * @default 2
             */
            public Build withHealthyThreshold(final java.lang.Number value) {
                this.instance._healthyThreshold = value;
                return this;
            }
            /**
             * After how many unsuccessful checks is an instance considered unhealthy
             * @default 5
             */
            public Build withUnhealthyThreshold(final java.lang.Number value) {
                this.instance._unhealthyThreshold = value;
                return this;
            }
            /**
             * Number of seconds between health checks
             * @default 30
             */
            public Build withInterval(final java.lang.Number value) {
                this.instance._interval = value;
                return this;
            }
            /**
             * Health check timeout
             * @default 5
             */
            public Build withTimeout(final java.lang.Number value) {
                this.instance._timeout = value;
                return this;
            }
            public HealthCheck build() {
                HealthCheck result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link HealthCheck}.
     */
    final class Jsii$Pojo implements HealthCheck {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Number _port;

        public java.lang.Number getPort() {
            return this._port;
        }
        public void setPort(final java.lang.Number value) {
            this._port = value;
        }

        protected software.amazon.awscdk.services.ec2.LoadBalancingProtocol _protocol;

        public software.amazon.awscdk.services.ec2.LoadBalancingProtocol getProtocol() {
            return this._protocol;
        }
        public void setProtocol(final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value) {
            this._protocol = value;
        }

        protected java.lang.String _path;

        public java.lang.String getPath() {
            return this._path;
        }
        public void setPath(final java.lang.String value) {
            this._path = value;
        }

        protected java.lang.Number _healthyThreshold;

        public java.lang.Number getHealthyThreshold() {
            return this._healthyThreshold;
        }
        public void setHealthyThreshold(final java.lang.Number value) {
            this._healthyThreshold = value;
        }

        protected java.lang.Number _unhealthyThreshold;

        public java.lang.Number getUnhealthyThreshold() {
            return this._unhealthyThreshold;
        }
        public void setUnhealthyThreshold(final java.lang.Number value) {
            this._unhealthyThreshold = value;
        }

        protected java.lang.Number _interval;

        public java.lang.Number getInterval() {
            return this._interval;
        }
        public void setInterval(final java.lang.Number value) {
            this._interval = value;
        }

        protected java.lang.Number _timeout;

        public java.lang.Number getTimeout() {
            return this._timeout;
        }
        public void setTimeout(final java.lang.Number value) {
            this._timeout = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.HealthCheck {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * What port number to health check on
         */
        public java.lang.Number getPort() {
            return this.jsiiGet("port", java.lang.Number.class);
        }
        /**
         * What port number to health check on
         */
        public void setPort(final java.lang.Number value) {
            this.jsiiSet("port", java.util.Objects.requireNonNull(value, "port is required"));
        }
        /**
         * What protocol to use for health checking
         * 
         * The protocol is automatically determined from the port if it's not supplied.
         * @default Automatic
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.LoadBalancingProtocol getProtocol() {
            return this.jsiiGet("protocol", software.amazon.awscdk.services.ec2.LoadBalancingProtocol.class);
        }
        /**
         * What protocol to use for health checking
         * 
         * The protocol is automatically determined from the port if it's not supplied.
         * @default Automatic
         */
        public void setProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value) {
            this.jsiiSet("protocol", value);
        }
        /**
         * What path to use for HTTP or HTTPS health check (must return 200)
         * 
         * For SSL and TCP health checks, accepting connections is enough to be considered
         * healthy.
         * @default "/"
         */
        @javax.annotation.Nullable
        public java.lang.String getPath() {
            return this.jsiiGet("path", java.lang.String.class);
        }
        /**
         * What path to use for HTTP or HTTPS health check (must return 200)
         * 
         * For SSL and TCP health checks, accepting connections is enough to be considered
         * healthy.
         * @default "/"
         */
        public void setPath(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("path", value);
        }
        /**
         * After how many successful checks is an instance considered healthy
         * @default 2
         */
        @javax.annotation.Nullable
        public java.lang.Number getHealthyThreshold() {
            return this.jsiiGet("healthyThreshold", java.lang.Number.class);
        }
        /**
         * After how many successful checks is an instance considered healthy
         * @default 2
         */
        public void setHealthyThreshold(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("healthyThreshold", value);
        }
        /**
         * After how many unsuccessful checks is an instance considered unhealthy
         * @default 5
         */
        @javax.annotation.Nullable
        public java.lang.Number getUnhealthyThreshold() {
            return this.jsiiGet("unhealthyThreshold", java.lang.Number.class);
        }
        /**
         * After how many unsuccessful checks is an instance considered unhealthy
         * @default 5
         */
        public void setUnhealthyThreshold(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("unhealthyThreshold", value);
        }
        /**
         * Number of seconds between health checks
         * @default 30
         */
        @javax.annotation.Nullable
        public java.lang.Number getInterval() {
            return this.jsiiGet("interval", java.lang.Number.class);
        }
        /**
         * Number of seconds between health checks
         * @default 30
         */
        public void setInterval(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("interval", value);
        }
        /**
         * Health check timeout
         * @default 5
         */
        @javax.annotation.Nullable
        public java.lang.Number getTimeout() {
            return this.jsiiGet("timeout", java.lang.Number.class);
        }
        /**
         * Health check timeout
         * @default 5
         */
        public void setTimeout(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("timeout", value);
        }
    }
}
