package software.amazon.awscdk.services.ec2;
/**
 * An object that has a Connections object as well as a default port range.
 */
public interface IDefaultConnectable extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ec2.IConnectable {
    software.amazon.awscdk.services.ec2.IPortRange getDefaultPortRange();

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link IDefaultConnectable}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        public ConnectionsStep withDefaultPortRange(final software.amazon.awscdk.services.ec2.IPortRange value) {
            return new FullBuilder().withDefaultPortRange(value);
        }

        public interface ConnectionsStep {
            /**
             * Sets the value for {@link IDefaultConnectable#getConnections}.
             */
            Build withConnections(final software.amazon.awscdk.services.ec2.Connections value);
        }

        public interface Build {
            /**
             * @return a new {@link IDefaultConnectable} object, initialized with the values set on this builder.
             */
            IDefaultConnectable build();
        }

        final class FullBuilder implements ConnectionsStep, Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            public ConnectionsStep withDefaultPortRange(final software.amazon.awscdk.services.ec2.IPortRange value) {
                java.util.Objects.requireNonNull(value, "IDefaultConnectable#defaultPortRange is required");
                this.instance._defaultPortRange = value;
                return this;
            }
            public Build withConnections(final software.amazon.awscdk.services.ec2.Connections value) {
                java.util.Objects.requireNonNull(value, "IDefaultConnectable#connections is required");
                this.instance._connections = value;
                return this;
            }
            public IDefaultConnectable build() {
                IDefaultConnectable result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link IDefaultConnectable}.
     */
    final class Jsii$Pojo implements IDefaultConnectable {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected software.amazon.awscdk.services.ec2.IPortRange _defaultPortRange;

        public software.amazon.awscdk.services.ec2.IPortRange getDefaultPortRange() {
            return this._defaultPortRange;
        }

        protected software.amazon.awscdk.services.ec2.Connections _connections;

        public software.amazon.awscdk.services.ec2.Connections getConnections() {
            return this._connections;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IDefaultConnectable {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        public software.amazon.awscdk.services.ec2.IPortRange getDefaultPortRange() {
            return this.jsiiGet("defaultPortRange", software.amazon.awscdk.services.ec2.IPortRange.class);
        }
        public software.amazon.awscdk.services.ec2.Connections getConnections() {
            return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
        }
    }
}
