package software.amazon.awscdk.services.ec2;
/**
 * Basic interface for security groups
 */
public interface ISecurityGroup extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ec2.IConnectionPeer {
    software.amazon.awscdk.services.ec2.SecurityGroupId getSecurityGroupId();
    void addIngressRule(final software.amazon.awscdk.services.ec2.IConnectionPeer peer, final software.amazon.awscdk.services.ec2.IPortRange connection, final java.lang.String description);
    void addEgressRule(final software.amazon.awscdk.services.ec2.IConnectionPeer peer, final software.amazon.awscdk.services.ec2.IPortRange connection, final java.lang.String description);

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.ISecurityGroup {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        public software.amazon.awscdk.services.ec2.SecurityGroupId getSecurityGroupId() {
            return this.jsiiGet("securityGroupId", software.amazon.awscdk.services.ec2.SecurityGroupId.class);
        }
        /**
         * Whether the rule can be inlined into a SecurityGroup or not
         */
        public java.lang.Boolean getCanInlineRule() {
            return this.jsiiGet("canInlineRule", java.lang.Boolean.class);
        }
        public void addIngressRule(final software.amazon.awscdk.services.ec2.IConnectionPeer peer, final software.amazon.awscdk.services.ec2.IPortRange connection, final java.lang.String description) {
            this.jsiiCall("addIngressRule", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(peer, "peer is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(connection, "connection is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(description, "description is required"))).toArray());
        }
        public void addEgressRule(final software.amazon.awscdk.services.ec2.IConnectionPeer peer, final software.amazon.awscdk.services.ec2.IPortRange connection, final java.lang.String description) {
            this.jsiiCall("addEgressRule", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(peer, "peer is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(connection, "connection is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(description, "description is required"))).toArray());
        }
        /**
         * Produce the ingress rule JSON for the given connection
         */
        public java.lang.Object toIngressRuleJSON() {
            return this.jsiiCall("toIngressRuleJSON", java.lang.Object.class);
        }
        /**
         * Produce the egress rule JSON for the given connection
         */
        public java.lang.Object toEgressRuleJSON() {
            return this.jsiiCall("toEgressRuleJSON", java.lang.Object.class);
        }
    }
}
