package software.amazon.awscdk.services.ec2;
/**
 * VpcNetworkProps allows you to specify configuration options for a VPC
 */
public interface VpcNetworkProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The CIDR range to use for the VPC (e.g. '10.0.0.0/16'). Should be a minimum of /28 and maximum size of /16.
     * The range will be split evenly into two subnets per Availability Zone (one public, one private).
     */
    java.lang.String getCidr();
    /**
     * The CIDR range to use for the VPC (e.g. '10.0.0.0/16'). Should be a minimum of /28 and maximum size of /16.
     * The range will be split evenly into two subnets per Availability Zone (one public, one private).
     */
    void setCidr(final java.lang.String value);
    /**
     * Indicates whether the instances launched in the VPC get public DNS hostnames.
     * If this attribute is true, instances in the VPC get public DNS hostnames,
     * but only if the enableDnsSupport attribute is also set to true.
     */
    java.lang.Boolean getEnableDnsHostnames();
    /**
     * Indicates whether the instances launched in the VPC get public DNS hostnames.
     * If this attribute is true, instances in the VPC get public DNS hostnames,
     * but only if the enableDnsSupport attribute is also set to true.
     */
    void setEnableDnsHostnames(final java.lang.Boolean value);
    /**
     * Indicates whether the DNS resolution is supported for the VPC. If this attribute
     * is false, the Amazon-provided DNS server in the VPC that resolves public DNS hostnames
     * to IP addresses is not enabled. If this attribute is true, queries to the Amazon
     * provided DNS server at the 169.254.169.253 IP address, or the reserved IP address
     * at the base of the VPC IPv4 network range plus two will succeed.
     */
    java.lang.Boolean getEnableDnsSupport();
    /**
     * Indicates whether the DNS resolution is supported for the VPC. If this attribute
     * is false, the Amazon-provided DNS server in the VPC that resolves public DNS hostnames
     * to IP addresses is not enabled. If this attribute is true, queries to the Amazon
     * provided DNS server at the 169.254.169.253 IP address, or the reserved IP address
     * at the base of the VPC IPv4 network range plus two will succeed.
     */
    void setEnableDnsSupport(final java.lang.Boolean value);
    /**
     * The default tenancy of instances launched into the VPC.
     * By default, instances will be launched with default (shared) tenancy.
     * By setting this to dedicated tenancy, instances will be launched on hardware dedicated
     * to a single AWS customer, unless specifically specified at instance launch time.
     * Please note, not all instance types are usable with Dedicated tenancy.
     */
    software.amazon.awscdk.services.ec2.DefaultInstanceTenancy getDefaultInstanceTenancy();
    /**
     * The default tenancy of instances launched into the VPC.
     * By default, instances will be launched with default (shared) tenancy.
     * By setting this to dedicated tenancy, instances will be launched on hardware dedicated
     * to a single AWS customer, unless specifically specified at instance launch time.
     * Please note, not all instance types are usable with Dedicated tenancy.
     */
    void setDefaultInstanceTenancy(final software.amazon.awscdk.services.ec2.DefaultInstanceTenancy value);
    /**
     * The AWS resource tags to associate with the VPC.
     */
    java.util.List<software.amazon.awscdk.Tag> getTags();
    /**
     * The AWS resource tags to associate with the VPC.
     */
    void setTags(final java.util.List<software.amazon.awscdk.Tag> value);
    /**
     * Define the maximum number of AZs to use in this region
     * 
     * If the region has more AZs than you want to use (for example, because of EIP limits),
     * pick a lower number here. The AZs will be sorted and picked from the start of the list.
     * @default All AZs in the region
     */
    java.lang.Number getMaxAZs();
    /**
     * Define the maximum number of AZs to use in this region
     * 
     * If the region has more AZs than you want to use (for example, because of EIP limits),
     * pick a lower number here. The AZs will be sorted and picked from the start of the list.
     * @default All AZs in the region
     */
    void setMaxAZs(final java.lang.Number value);
    /**
     * Define the maximum number of NAT Gateways for this VPC
     * 
     * Setting this number enables a VPC to trade availability for the cost of
     * running a NAT Gateway. For example, if set this to 1 and your subnet
     * configuration is for 3 Public subnets with natGateway = `true` then only
     * one of the Public subnets will have a gateway and all Private subnets
     * will route to this NAT Gateway.
     * @default maxAZs
     */
    java.lang.Number getNatGateways();
    /**
     * Define the maximum number of NAT Gateways for this VPC
     * 
     * Setting this number enables a VPC to trade availability for the cost of
     * running a NAT Gateway. For example, if set this to 1 and your subnet
     * configuration is for 3 Public subnets with natGateway = `true` then only
     * one of the Public subnets will have a gateway and all Private subnets
     * will route to this NAT Gateway.
     * @default maxAZs
     */
    void setNatGateways(final java.lang.Number value);
    /**
     * Configure the subnets to build for each AZ
     * 
     * The subnets are constructed in the context of the VPC so you only need
     * specify the configuration. The VPC details (VPC ID, specific CIDR,
     * specific AZ will be calculated during creation)
     * 
     * For example if you want 1 public subnet, 1 private subnet, and 1 isolated
     * subnet in each AZ provide the following:
     * subnetConfiguration: [
     *       {
     *           cidrMask: 24,
     *           name: 'ingress',
     *           subnetType: SubnetType.Public,
     *       },
     *       {
     *           cidrMask: 24,
     *           name: 'application',
     *           subnetType: SubnetType.Private,
     *       },
     *       {
     *           cidrMask: 28,
     *           name: 'rds',
     *           subnetType: SubnetType.Isolated,
     *       }
     * ]
     * 
     * `cidrMask` is optional and if not provided the IP space in the VPC will be
     * evenly divided between the requested subnets.
     * @default the VPC CIDR will be evenly divided between 1 public and 1 private subnet per AZ
     */
    java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> getSubnetConfiguration();
    /**
     * Configure the subnets to build for each AZ
     * 
     * The subnets are constructed in the context of the VPC so you only need
     * specify the configuration. The VPC details (VPC ID, specific CIDR,
     * specific AZ will be calculated during creation)
     * 
     * For example if you want 1 public subnet, 1 private subnet, and 1 isolated
     * subnet in each AZ provide the following:
     * subnetConfiguration: [
     *       {
     *           cidrMask: 24,
     *           name: 'ingress',
     *           subnetType: SubnetType.Public,
     *       },
     *       {
     *           cidrMask: 24,
     *           name: 'application',
     *           subnetType: SubnetType.Private,
     *       },
     *       {
     *           cidrMask: 28,
     *           name: 'rds',
     *           subnetType: SubnetType.Isolated,
     *       }
     * ]
     * 
     * `cidrMask` is optional and if not provided the IP space in the VPC will be
     * evenly divided between the requested subnets.
     * @default the VPC CIDR will be evenly divided between 1 public and 1 private subnet per AZ
     */
    void setSubnetConfiguration(final java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }

    /**
     * A fluent builder class for {@link VpcNetworkProps}.
     */
    public static final class Builder {
        private Jsii$Pojo instance = new Jsii$Pojo();

        /**
         * The CIDR range to use for the VPC (e.g. '10.0.0.0/16'). Should be a minimum of /28 and maximum size of /16.
         * The range will be split evenly into two subnets per Availability Zone (one public, one private).
         */
        public Builder withCidr(final java.lang.String value) {
            this.instance._cidr = value;
            return this;
        }
        /**
         * Indicates whether the instances launched in the VPC get public DNS hostnames.
         * If this attribute is true, instances in the VPC get public DNS hostnames,
         * but only if the enableDnsSupport attribute is also set to true.
         */
        public Builder withEnableDnsHostnames(final java.lang.Boolean value) {
            this.instance._enableDnsHostnames = value;
            return this;
        }
        /**
         * Indicates whether the DNS resolution is supported for the VPC. If this attribute
         * is false, the Amazon-provided DNS server in the VPC that resolves public DNS hostnames
         * to IP addresses is not enabled. If this attribute is true, queries to the Amazon
         * provided DNS server at the 169.254.169.253 IP address, or the reserved IP address
         * at the base of the VPC IPv4 network range plus two will succeed.
         */
        public Builder withEnableDnsSupport(final java.lang.Boolean value) {
            this.instance._enableDnsSupport = value;
            return this;
        }
        /**
         * The default tenancy of instances launched into the VPC.
         * By default, instances will be launched with default (shared) tenancy.
         * By setting this to dedicated tenancy, instances will be launched on hardware dedicated
         * to a single AWS customer, unless specifically specified at instance launch time.
         * Please note, not all instance types are usable with Dedicated tenancy.
         */
        public Builder withDefaultInstanceTenancy(final software.amazon.awscdk.services.ec2.DefaultInstanceTenancy value) {
            this.instance._defaultInstanceTenancy = value;
            return this;
        }
        /**
         * The AWS resource tags to associate with the VPC.
         */
        public Builder withTags(final java.util.List<software.amazon.awscdk.Tag> value) {
            this.instance._tags = value;
            return this;
        }
        /**
         * Define the maximum number of AZs to use in this region
         * 
         * If the region has more AZs than you want to use (for example, because of EIP limits),
         * pick a lower number here. The AZs will be sorted and picked from the start of the list.
         * @default All AZs in the region
         */
        public Builder withMaxAZs(final java.lang.Number value) {
            this.instance._maxAZs = value;
            return this;
        }
        /**
         * Define the maximum number of NAT Gateways for this VPC
         * 
         * Setting this number enables a VPC to trade availability for the cost of
         * running a NAT Gateway. For example, if set this to 1 and your subnet
         * configuration is for 3 Public subnets with natGateway = `true` then only
         * one of the Public subnets will have a gateway and all Private subnets
         * will route to this NAT Gateway.
         * @default maxAZs
         */
        public Builder withNatGateways(final java.lang.Number value) {
            this.instance._natGateways = value;
            return this;
        }
        /**
         * Configure the subnets to build for each AZ
         * 
         * The subnets are constructed in the context of the VPC so you only need
         * specify the configuration. The VPC details (VPC ID, specific CIDR,
         * specific AZ will be calculated during creation)
         * 
         * For example if you want 1 public subnet, 1 private subnet, and 1 isolated
         * subnet in each AZ provide the following:
         * subnetConfiguration: [
         *       {
         *           cidrMask: 24,
         *           name: 'ingress',
         *           subnetType: SubnetType.Public,
         *       },
         *       {
         *           cidrMask: 24,
         *           name: 'application',
         *           subnetType: SubnetType.Private,
         *       },
         *       {
         *           cidrMask: 28,
         *           name: 'rds',
         *           subnetType: SubnetType.Isolated,
         *       }
         * ]
         * 
         * `cidrMask` is optional and if not provided the IP space in the VPC will be
         * evenly divided between the requested subnets.
         * @default the VPC CIDR will be evenly divided between 1 public and 1 private subnet per AZ
         */
        public Builder withSubnetConfiguration(final java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> value) {
            this.instance._subnetConfiguration = value;
            return this;
        }
        public VpcNetworkProps build() {
            VpcNetworkProps result = this.instance;
            this.instance = new Jsii$Pojo();
            return result;
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link VpcNetworkProps}.
     */
    final class Jsii$Pojo implements VpcNetworkProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.String _cidr;

        public java.lang.String getCidr() {
            return this._cidr;
        }
        public void setCidr(final java.lang.String value) {
            this._cidr = value;
        }

        protected java.lang.Boolean _enableDnsHostnames;

        public java.lang.Boolean getEnableDnsHostnames() {
            return this._enableDnsHostnames;
        }
        public void setEnableDnsHostnames(final java.lang.Boolean value) {
            this._enableDnsHostnames = value;
        }

        protected java.lang.Boolean _enableDnsSupport;

        public java.lang.Boolean getEnableDnsSupport() {
            return this._enableDnsSupport;
        }
        public void setEnableDnsSupport(final java.lang.Boolean value) {
            this._enableDnsSupport = value;
        }

        protected software.amazon.awscdk.services.ec2.DefaultInstanceTenancy _defaultInstanceTenancy;

        public software.amazon.awscdk.services.ec2.DefaultInstanceTenancy getDefaultInstanceTenancy() {
            return this._defaultInstanceTenancy;
        }
        public void setDefaultInstanceTenancy(final software.amazon.awscdk.services.ec2.DefaultInstanceTenancy value) {
            this._defaultInstanceTenancy = value;
        }

        protected java.util.List<software.amazon.awscdk.Tag> _tags;

        public java.util.List<software.amazon.awscdk.Tag> getTags() {
            return this._tags;
        }
        public void setTags(final java.util.List<software.amazon.awscdk.Tag> value) {
            this._tags = value;
        }

        protected java.lang.Number _maxAZs;

        public java.lang.Number getMaxAZs() {
            return this._maxAZs;
        }
        public void setMaxAZs(final java.lang.Number value) {
            this._maxAZs = value;
        }

        protected java.lang.Number _natGateways;

        public java.lang.Number getNatGateways() {
            return this._natGateways;
        }
        public void setNatGateways(final java.lang.Number value) {
            this._natGateways = value;
        }

        protected java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> _subnetConfiguration;

        public java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> getSubnetConfiguration() {
            return this._subnetConfiguration;
        }
        public void setSubnetConfiguration(final java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> value) {
            this._subnetConfiguration = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.VpcNetworkProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * The CIDR range to use for the VPC (e.g. '10.0.0.0/16'). Should be a minimum of /28 and maximum size of /16.
         * The range will be split evenly into two subnets per Availability Zone (one public, one private).
         */
        @javax.annotation.Nullable
        public java.lang.String getCidr() {
            return this.jsiiGet("cidr", java.lang.String.class);
        }
        /**
         * The CIDR range to use for the VPC (e.g. '10.0.0.0/16'). Should be a minimum of /28 and maximum size of /16.
         * The range will be split evenly into two subnets per Availability Zone (one public, one private).
         */
        public void setCidr(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("cidr", value);
        }
        /**
         * Indicates whether the instances launched in the VPC get public DNS hostnames.
         * If this attribute is true, instances in the VPC get public DNS hostnames,
         * but only if the enableDnsSupport attribute is also set to true.
         */
        @javax.annotation.Nullable
        public java.lang.Boolean getEnableDnsHostnames() {
            return this.jsiiGet("enableDnsHostnames", java.lang.Boolean.class);
        }
        /**
         * Indicates whether the instances launched in the VPC get public DNS hostnames.
         * If this attribute is true, instances in the VPC get public DNS hostnames,
         * but only if the enableDnsSupport attribute is also set to true.
         */
        public void setEnableDnsHostnames(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("enableDnsHostnames", value);
        }
        /**
         * Indicates whether the DNS resolution is supported for the VPC. If this attribute
         * is false, the Amazon-provided DNS server in the VPC that resolves public DNS hostnames
         * to IP addresses is not enabled. If this attribute is true, queries to the Amazon
         * provided DNS server at the 169.254.169.253 IP address, or the reserved IP address
         * at the base of the VPC IPv4 network range plus two will succeed.
         */
        @javax.annotation.Nullable
        public java.lang.Boolean getEnableDnsSupport() {
            return this.jsiiGet("enableDnsSupport", java.lang.Boolean.class);
        }
        /**
         * Indicates whether the DNS resolution is supported for the VPC. If this attribute
         * is false, the Amazon-provided DNS server in the VPC that resolves public DNS hostnames
         * to IP addresses is not enabled. If this attribute is true, queries to the Amazon
         * provided DNS server at the 169.254.169.253 IP address, or the reserved IP address
         * at the base of the VPC IPv4 network range plus two will succeed.
         */
        public void setEnableDnsSupport(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("enableDnsSupport", value);
        }
        /**
         * The default tenancy of instances launched into the VPC.
         * By default, instances will be launched with default (shared) tenancy.
         * By setting this to dedicated tenancy, instances will be launched on hardware dedicated
         * to a single AWS customer, unless specifically specified at instance launch time.
         * Please note, not all instance types are usable with Dedicated tenancy.
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.DefaultInstanceTenancy getDefaultInstanceTenancy() {
            return this.jsiiGet("defaultInstanceTenancy", software.amazon.awscdk.services.ec2.DefaultInstanceTenancy.class);
        }
        /**
         * The default tenancy of instances launched into the VPC.
         * By default, instances will be launched with default (shared) tenancy.
         * By setting this to dedicated tenancy, instances will be launched on hardware dedicated
         * to a single AWS customer, unless specifically specified at instance launch time.
         * Please note, not all instance types are usable with Dedicated tenancy.
         */
        public void setDefaultInstanceTenancy(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.DefaultInstanceTenancy value) {
            this.jsiiSet("defaultInstanceTenancy", value);
        }
        /**
         * The AWS resource tags to associate with the VPC.
         */
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.Tag> getTags() {
            return this.jsiiGet("tags", java.util.List.class);
        }
        /**
         * The AWS resource tags to associate with the VPC.
         */
        public void setTags(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.Tag> value) {
            this.jsiiSet("tags", value);
        }
        /**
         * Define the maximum number of AZs to use in this region
         * 
         * If the region has more AZs than you want to use (for example, because of EIP limits),
         * pick a lower number here. The AZs will be sorted and picked from the start of the list.
         * @default All AZs in the region
         */
        @javax.annotation.Nullable
        public java.lang.Number getMaxAZs() {
            return this.jsiiGet("maxAZs", java.lang.Number.class);
        }
        /**
         * Define the maximum number of AZs to use in this region
         * 
         * If the region has more AZs than you want to use (for example, because of EIP limits),
         * pick a lower number here. The AZs will be sorted and picked from the start of the list.
         * @default All AZs in the region
         */
        public void setMaxAZs(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("maxAZs", value);
        }
        /**
         * Define the maximum number of NAT Gateways for this VPC
         * 
         * Setting this number enables a VPC to trade availability for the cost of
         * running a NAT Gateway. For example, if set this to 1 and your subnet
         * configuration is for 3 Public subnets with natGateway = `true` then only
         * one of the Public subnets will have a gateway and all Private subnets
         * will route to this NAT Gateway.
         * @default maxAZs
         */
        @javax.annotation.Nullable
        public java.lang.Number getNatGateways() {
            return this.jsiiGet("natGateways", java.lang.Number.class);
        }
        /**
         * Define the maximum number of NAT Gateways for this VPC
         * 
         * Setting this number enables a VPC to trade availability for the cost of
         * running a NAT Gateway. For example, if set this to 1 and your subnet
         * configuration is for 3 Public subnets with natGateway = `true` then only
         * one of the Public subnets will have a gateway and all Private subnets
         * will route to this NAT Gateway.
         * @default maxAZs
         */
        public void setNatGateways(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("natGateways", value);
        }
        /**
         * Configure the subnets to build for each AZ
         * 
         * The subnets are constructed in the context of the VPC so you only need
         * specify the configuration. The VPC details (VPC ID, specific CIDR,
         * specific AZ will be calculated during creation)
         * 
         * For example if you want 1 public subnet, 1 private subnet, and 1 isolated
         * subnet in each AZ provide the following:
         * subnetConfiguration: [
         *       {
         *           cidrMask: 24,
         *           name: 'ingress',
         *           subnetType: SubnetType.Public,
         *       },
         *       {
         *           cidrMask: 24,
         *           name: 'application',
         *           subnetType: SubnetType.Private,
         *       },
         *       {
         *           cidrMask: 28,
         *           name: 'rds',
         *           subnetType: SubnetType.Isolated,
         *       }
         * ]
         * 
         * `cidrMask` is optional and if not provided the IP space in the VPC will be
         * evenly divided between the requested subnets.
         * @default the VPC CIDR will be evenly divided between 1 public and 1 private subnet per AZ
         */
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> getSubnetConfiguration() {
            return this.jsiiGet("subnetConfiguration", java.util.List.class);
        }
        /**
         * Configure the subnets to build for each AZ
         * 
         * The subnets are constructed in the context of the VPC so you only need
         * specify the configuration. The VPC details (VPC ID, specific CIDR,
         * specific AZ will be calculated during creation)
         * 
         * For example if you want 1 public subnet, 1 private subnet, and 1 isolated
         * subnet in each AZ provide the following:
         * subnetConfiguration: [
         *       {
         *           cidrMask: 24,
         *           name: 'ingress',
         *           subnetType: SubnetType.Public,
         *       },
         *       {
         *           cidrMask: 24,
         *           name: 'application',
         *           subnetType: SubnetType.Private,
         *       },
         *       {
         *           cidrMask: 28,
         *           name: 'rds',
         *           subnetType: SubnetType.Isolated,
         *       }
         * ]
         * 
         * `cidrMask` is optional and if not provided the IP space in the VPC will be
         * evenly divided between the requested subnets.
         * @default the VPC CIDR will be evenly divided between 1 public and 1 private subnet per AZ
         */
        public void setSubnetConfiguration(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> value) {
            this.jsiiSet("subnetConfiguration", value);
        }
    }
}
