package software.amazon.awscdk.services.ec2;
/**
 * Properties that reference an external VpcNetwork
 */
public interface VpcNetworkRefProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * VPC's identifier
     */
    software.amazon.awscdk.services.ec2.VpcNetworkId getVpcId();
    /**
     * VPC's identifier
     */
    void setVpcId(final software.amazon.awscdk.services.ec2.VpcNetworkId value);
    /**
     * List of a availability zones, one for every subnet.
     * 
     * The first half are for the public subnets, the second half are for
     * the private subnets.
     */
    java.util.List<java.lang.String> getAvailabilityZones();
    /**
     * List of a availability zones, one for every subnet.
     * 
     * The first half are for the public subnets, the second half are for
     * the private subnets.
     */
    void setAvailabilityZones(final java.util.List<java.lang.String> value);
    /**
     * List of public subnet IDs, one for every subnet
     * 
     * Must match the availability zones and private subnet ids in length and order.
     */
    java.util.List<software.amazon.awscdk.services.ec2.VpcSubnetId> getPublicSubnetIds();
    /**
     * List of public subnet IDs, one for every subnet
     * 
     * Must match the availability zones and private subnet ids in length and order.
     */
    void setPublicSubnetIds(final java.util.List<software.amazon.awscdk.services.ec2.VpcSubnetId> value);
    /**
     * List of private subnet IDs, one for every subnet
     * 
     * Must match the availability zones and public subnet ids in length and order.
     */
    java.util.List<software.amazon.awscdk.services.ec2.VpcSubnetId> getPrivateSubnetIds();
    /**
     * List of private subnet IDs, one for every subnet
     * 
     * Must match the availability zones and public subnet ids in length and order.
     */
    void setPrivateSubnetIds(final java.util.List<software.amazon.awscdk.services.ec2.VpcSubnetId> value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link VpcNetworkRefProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * VPC's identifier
         */
        public AvailabilityZonesStep withVpcId(final software.amazon.awscdk.services.ec2.VpcNetworkId value) {
            return new FullBuilder().withVpcId(value);
        }

        public interface AvailabilityZonesStep {
            /**
             * List of a availability zones, one for every subnet.
             * 
             * The first half are for the public subnets, the second half are for
             * the private subnets.
             */
            PublicSubnetIdsStep withAvailabilityZones(final java.util.List<java.lang.String> value);
        }

        public interface PublicSubnetIdsStep {
            /**
             * List of public subnet IDs, one for every subnet
             * 
             * Must match the availability zones and private subnet ids in length and order.
             */
            PrivateSubnetIdsStep withPublicSubnetIds(final java.util.List<software.amazon.awscdk.services.ec2.VpcSubnetId> value);
        }

        public interface PrivateSubnetIdsStep {
            /**
             * List of private subnet IDs, one for every subnet
             * 
             * Must match the availability zones and public subnet ids in length and order.
             */
            Build withPrivateSubnetIds(final java.util.List<software.amazon.awscdk.services.ec2.VpcSubnetId> value);
        }

        public interface Build {
            /**
             * @return a new {@link VpcNetworkRefProps} object, initialized with the values set on this builder.
             */
            VpcNetworkRefProps build();
        }

        final class FullBuilder implements AvailabilityZonesStep, PublicSubnetIdsStep, PrivateSubnetIdsStep, Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * VPC's identifier
             */
            public AvailabilityZonesStep withVpcId(final software.amazon.awscdk.services.ec2.VpcNetworkId value) {
                java.util.Objects.requireNonNull(value, "VpcNetworkRefProps#vpcId is required");
                this.instance._vpcId = value;
                return this;
            }
            /**
             * List of a availability zones, one for every subnet.
             * 
             * The first half are for the public subnets, the second half are for
             * the private subnets.
             */
            public PublicSubnetIdsStep withAvailabilityZones(final java.util.List<java.lang.String> value) {
                java.util.Objects.requireNonNull(value, "VpcNetworkRefProps#availabilityZones is required");
                this.instance._availabilityZones = value;
                return this;
            }
            /**
             * List of public subnet IDs, one for every subnet
             * 
             * Must match the availability zones and private subnet ids in length and order.
             */
            public PrivateSubnetIdsStep withPublicSubnetIds(final java.util.List<software.amazon.awscdk.services.ec2.VpcSubnetId> value) {
                java.util.Objects.requireNonNull(value, "VpcNetworkRefProps#publicSubnetIds is required");
                this.instance._publicSubnetIds = value;
                return this;
            }
            /**
             * List of private subnet IDs, one for every subnet
             * 
             * Must match the availability zones and public subnet ids in length and order.
             */
            public Build withPrivateSubnetIds(final java.util.List<software.amazon.awscdk.services.ec2.VpcSubnetId> value) {
                java.util.Objects.requireNonNull(value, "VpcNetworkRefProps#privateSubnetIds is required");
                this.instance._privateSubnetIds = value;
                return this;
            }
            public VpcNetworkRefProps build() {
                VpcNetworkRefProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link VpcNetworkRefProps}.
     */
    final class Jsii$Pojo implements VpcNetworkRefProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected software.amazon.awscdk.services.ec2.VpcNetworkId _vpcId;

        public software.amazon.awscdk.services.ec2.VpcNetworkId getVpcId() {
            return this._vpcId;
        }
        public void setVpcId(final software.amazon.awscdk.services.ec2.VpcNetworkId value) {
            this._vpcId = value;
        }

        protected java.util.List<java.lang.String> _availabilityZones;

        public java.util.List<java.lang.String> getAvailabilityZones() {
            return this._availabilityZones;
        }
        public void setAvailabilityZones(final java.util.List<java.lang.String> value) {
            this._availabilityZones = value;
        }

        protected java.util.List<software.amazon.awscdk.services.ec2.VpcSubnetId> _publicSubnetIds;

        public java.util.List<software.amazon.awscdk.services.ec2.VpcSubnetId> getPublicSubnetIds() {
            return this._publicSubnetIds;
        }
        public void setPublicSubnetIds(final java.util.List<software.amazon.awscdk.services.ec2.VpcSubnetId> value) {
            this._publicSubnetIds = value;
        }

        protected java.util.List<software.amazon.awscdk.services.ec2.VpcSubnetId> _privateSubnetIds;

        public java.util.List<software.amazon.awscdk.services.ec2.VpcSubnetId> getPrivateSubnetIds() {
            return this._privateSubnetIds;
        }
        public void setPrivateSubnetIds(final java.util.List<software.amazon.awscdk.services.ec2.VpcSubnetId> value) {
            this._privateSubnetIds = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.VpcNetworkRefProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * VPC's identifier
         */
        public software.amazon.awscdk.services.ec2.VpcNetworkId getVpcId() {
            return this.jsiiGet("vpcId", software.amazon.awscdk.services.ec2.VpcNetworkId.class);
        }
        /**
         * VPC's identifier
         */
        public void setVpcId(final software.amazon.awscdk.services.ec2.VpcNetworkId value) {
            this.jsiiSet("vpcId", java.util.Objects.requireNonNull(value, "vpcId is required"));
        }
        /**
         * List of a availability zones, one for every subnet.
         * 
         * The first half are for the public subnets, the second half are for
         * the private subnets.
         */
        public java.util.List<java.lang.String> getAvailabilityZones() {
            return this.jsiiGet("availabilityZones", java.util.List.class);
        }
        /**
         * List of a availability zones, one for every subnet.
         * 
         * The first half are for the public subnets, the second half are for
         * the private subnets.
         */
        public void setAvailabilityZones(final java.util.List<java.lang.String> value) {
            this.jsiiSet("availabilityZones", java.util.Objects.requireNonNull(value, "availabilityZones is required"));
        }
        /**
         * List of public subnet IDs, one for every subnet
         * 
         * Must match the availability zones and private subnet ids in length and order.
         */
        public java.util.List<software.amazon.awscdk.services.ec2.VpcSubnetId> getPublicSubnetIds() {
            return this.jsiiGet("publicSubnetIds", java.util.List.class);
        }
        /**
         * List of public subnet IDs, one for every subnet
         * 
         * Must match the availability zones and private subnet ids in length and order.
         */
        public void setPublicSubnetIds(final java.util.List<software.amazon.awscdk.services.ec2.VpcSubnetId> value) {
            this.jsiiSet("publicSubnetIds", java.util.Objects.requireNonNull(value, "publicSubnetIds is required"));
        }
        /**
         * List of private subnet IDs, one for every subnet
         * 
         * Must match the availability zones and public subnet ids in length and order.
         */
        public java.util.List<software.amazon.awscdk.services.ec2.VpcSubnetId> getPrivateSubnetIds() {
            return this.jsiiGet("privateSubnetIds", java.util.List.class);
        }
        /**
         * List of private subnet IDs, one for every subnet
         * 
         * Must match the availability zones and public subnet ids in length and order.
         */
        public void setPrivateSubnetIds(final java.util.List<software.amazon.awscdk.services.ec2.VpcSubnetId> value) {
            this.jsiiSet("privateSubnetIds", java.util.Objects.requireNonNull(value, "privateSubnetIds is required"));
        }
    }
}
