package software.amazon.awscdk.services.ec2.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html
 */
public interface CustomerGatewayResourceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ``AWS::EC2::CustomerGateway.BgpAsn``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-bgpasn
     */
    java.lang.Object getBgpAsn();
    /**
     * ``AWS::EC2::CustomerGateway.BgpAsn``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-bgpasn
     */
    void setBgpAsn(final java.lang.Number value);
    /**
     * ``AWS::EC2::CustomerGateway.BgpAsn``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-bgpasn
     */
    void setBgpAsn(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::CustomerGateway.IpAddress``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-ipaddress
     */
    java.lang.Object getIpAddress();
    /**
     * ``AWS::EC2::CustomerGateway.IpAddress``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-ipaddress
     */
    void setIpAddress(final java.lang.String value);
    /**
     * ``AWS::EC2::CustomerGateway.IpAddress``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-ipaddress
     */
    void setIpAddress(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::CustomerGateway.Type``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-type
     */
    java.lang.Object getType();
    /**
     * ``AWS::EC2::CustomerGateway.Type``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-type
     */
    void setType(final java.lang.String value);
    /**
     * ``AWS::EC2::CustomerGateway.Type``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-type
     */
    void setType(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::CustomerGateway.Tags``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-tags
     */
    java.lang.Object getTags();
    /**
     * ``AWS::EC2::CustomerGateway.Tags``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-tags
     */
    void setTags(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::CustomerGateway.Tags``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-tags
     */
    void setTags(final java.util.List<java.lang.Object> value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link CustomerGatewayResourceProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * ``AWS::EC2::CustomerGateway.BgpAsn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-bgpasn
         */
        public IpAddressStep withBgpAsn(final java.lang.Number value) {
            return new FullBuilder().withBgpAsn(value);
        }
        /**
         * ``AWS::EC2::CustomerGateway.BgpAsn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-bgpasn
         */
        public IpAddressStep withBgpAsn(final software.amazon.awscdk.Token value) {
            return new FullBuilder().withBgpAsn(value);
        }

        public interface IpAddressStep {
            /**
             * ``AWS::EC2::CustomerGateway.IpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-ipaddress
             */
            TypeStep withIpAddress(final java.lang.String value);
            /**
             * ``AWS::EC2::CustomerGateway.IpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-ipaddress
             */
            TypeStep withIpAddress(final software.amazon.awscdk.Token value);
        }

        public interface TypeStep {
            /**
             * ``AWS::EC2::CustomerGateway.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-type
             */
            Build withType(final java.lang.String value);
            /**
             * ``AWS::EC2::CustomerGateway.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-type
             */
            Build withType(final software.amazon.awscdk.Token value);
        }

        public interface Build {
            /**
             * @return a new {@link CustomerGatewayResourceProps} object, initialized with the values set on this builder.
             */
            CustomerGatewayResourceProps build();
            /**
             * ``AWS::EC2::CustomerGateway.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-tags
             */
            Build withTags(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::EC2::CustomerGateway.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-tags
             */
            Build withTags(final java.util.List<java.lang.Object> value);
        }

        final class FullBuilder implements IpAddressStep, TypeStep, Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``AWS::EC2::CustomerGateway.BgpAsn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-bgpasn
             */
            public IpAddressStep withBgpAsn(final java.lang.Number value) {
                java.util.Objects.requireNonNull(value, "CustomerGatewayResourceProps#bgpAsn is required");
                this.instance._bgpAsn = value;
                return this;
            }
            /**
             * ``AWS::EC2::CustomerGateway.BgpAsn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-bgpasn
             */
            public IpAddressStep withBgpAsn(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "CustomerGatewayResourceProps#bgpAsn is required");
                this.instance._bgpAsn = value;
                return this;
            }
            /**
             * ``AWS::EC2::CustomerGateway.IpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-ipaddress
             */
            public TypeStep withIpAddress(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "CustomerGatewayResourceProps#ipAddress is required");
                this.instance._ipAddress = value;
                return this;
            }
            /**
             * ``AWS::EC2::CustomerGateway.IpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-ipaddress
             */
            public TypeStep withIpAddress(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "CustomerGatewayResourceProps#ipAddress is required");
                this.instance._ipAddress = value;
                return this;
            }
            /**
             * ``AWS::EC2::CustomerGateway.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-type
             */
            public Build withType(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "CustomerGatewayResourceProps#type is required");
                this.instance._type = value;
                return this;
            }
            /**
             * ``AWS::EC2::CustomerGateway.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-type
             */
            public Build withType(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "CustomerGatewayResourceProps#type is required");
                this.instance._type = value;
                return this;
            }
            /**
             * ``AWS::EC2::CustomerGateway.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-tags
             */
            public Build withTags(final software.amazon.awscdk.Token value) {
                this.instance._tags = value;
                return this;
            }
            /**
             * ``AWS::EC2::CustomerGateway.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-tags
             */
            public Build withTags(final java.util.List<java.lang.Object> value) {
                this.instance._tags = value;
                return this;
            }
            public CustomerGatewayResourceProps build() {
                CustomerGatewayResourceProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link CustomerGatewayResourceProps}.
     */
    final class Jsii$Pojo implements CustomerGatewayResourceProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Object _bgpAsn;

        public java.lang.Object getBgpAsn() {
            return this._bgpAsn;
        }
        public void setBgpAsn(final java.lang.Number value) {
            this._bgpAsn = value;
        }
        public void setBgpAsn(final software.amazon.awscdk.Token value) {
            this._bgpAsn = value;
        }

        protected java.lang.Object _ipAddress;

        public java.lang.Object getIpAddress() {
            return this._ipAddress;
        }
        public void setIpAddress(final java.lang.String value) {
            this._ipAddress = value;
        }
        public void setIpAddress(final software.amazon.awscdk.Token value) {
            this._ipAddress = value;
        }

        protected java.lang.Object _type;

        public java.lang.Object getType() {
            return this._type;
        }
        public void setType(final java.lang.String value) {
            this._type = value;
        }
        public void setType(final software.amazon.awscdk.Token value) {
            this._type = value;
        }

        protected java.lang.Object _tags;

        public java.lang.Object getTags() {
            return this._tags;
        }
        public void setTags(final software.amazon.awscdk.Token value) {
            this._tags = value;
        }
        public void setTags(final java.util.List<java.lang.Object> value) {
            this._tags = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.CustomerGatewayResourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * ``AWS::EC2::CustomerGateway.BgpAsn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-bgpasn
         */
        public java.lang.Object getBgpAsn() {
            return this.jsiiGet("bgpAsn", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::CustomerGateway.BgpAsn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-bgpasn
         */
        public void setBgpAsn(final java.lang.Number value) {
            this.jsiiSet("bgpAsn", java.util.Objects.requireNonNull(value, "bgpAsn is required"));
        }
        /**
         * ``AWS::EC2::CustomerGateway.BgpAsn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-bgpasn
         */
        public void setBgpAsn(final software.amazon.awscdk.Token value) {
            this.jsiiSet("bgpAsn", java.util.Objects.requireNonNull(value, "bgpAsn is required"));
        }
        /**
         * ``AWS::EC2::CustomerGateway.IpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-ipaddress
         */
        public java.lang.Object getIpAddress() {
            return this.jsiiGet("ipAddress", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::CustomerGateway.IpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-ipaddress
         */
        public void setIpAddress(final java.lang.String value) {
            this.jsiiSet("ipAddress", java.util.Objects.requireNonNull(value, "ipAddress is required"));
        }
        /**
         * ``AWS::EC2::CustomerGateway.IpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-ipaddress
         */
        public void setIpAddress(final software.amazon.awscdk.Token value) {
            this.jsiiSet("ipAddress", java.util.Objects.requireNonNull(value, "ipAddress is required"));
        }
        /**
         * ``AWS::EC2::CustomerGateway.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-type
         */
        public java.lang.Object getType() {
            return this.jsiiGet("type", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::CustomerGateway.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-type
         */
        public void setType(final java.lang.String value) {
            this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
        }
        /**
         * ``AWS::EC2::CustomerGateway.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-type
         */
        public void setType(final software.amazon.awscdk.Token value) {
            this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
        }
        /**
         * ``AWS::EC2::CustomerGateway.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-tags
         */
        @javax.annotation.Nullable
        public java.lang.Object getTags() {
            return this.jsiiGet("tags", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::CustomerGateway.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-tags
         */
        public void setTags(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("tags", value);
        }
        /**
         * ``AWS::EC2::CustomerGateway.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-tags
         */
        public void setTags(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this.jsiiSet("tags", value);
        }
    }
}
