package software.amazon.awscdk.services.ec2.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html
 */
public interface EgressOnlyInternetGatewayResourceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ``AWS::EC2::EgressOnlyInternetGateway.VpcId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html#cfn-ec2-egressonlyinternetgateway-vpcid
     */
    java.lang.Object getVpcId();
    /**
     * ``AWS::EC2::EgressOnlyInternetGateway.VpcId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html#cfn-ec2-egressonlyinternetgateway-vpcid
     */
    void setVpcId(final java.lang.String value);
    /**
     * ``AWS::EC2::EgressOnlyInternetGateway.VpcId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html#cfn-ec2-egressonlyinternetgateway-vpcid
     */
    void setVpcId(final software.amazon.awscdk.Token value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link EgressOnlyInternetGatewayResourceProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * ``AWS::EC2::EgressOnlyInternetGateway.VpcId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html#cfn-ec2-egressonlyinternetgateway-vpcid
         */
        public Build withVpcId(final java.lang.String value) {
            return new FullBuilder().withVpcId(value);
        }
        /**
         * ``AWS::EC2::EgressOnlyInternetGateway.VpcId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html#cfn-ec2-egressonlyinternetgateway-vpcid
         */
        public Build withVpcId(final software.amazon.awscdk.Token value) {
            return new FullBuilder().withVpcId(value);
        }

        public interface Build {
            /**
             * @return a new {@link EgressOnlyInternetGatewayResourceProps} object, initialized with the values set on this builder.
             */
            EgressOnlyInternetGatewayResourceProps build();
        }

        final class FullBuilder implements Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``AWS::EC2::EgressOnlyInternetGateway.VpcId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html#cfn-ec2-egressonlyinternetgateway-vpcid
             */
            public Build withVpcId(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "EgressOnlyInternetGatewayResourceProps#vpcId is required");
                this.instance._vpcId = value;
                return this;
            }
            /**
             * ``AWS::EC2::EgressOnlyInternetGateway.VpcId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html#cfn-ec2-egressonlyinternetgateway-vpcid
             */
            public Build withVpcId(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "EgressOnlyInternetGatewayResourceProps#vpcId is required");
                this.instance._vpcId = value;
                return this;
            }
            public EgressOnlyInternetGatewayResourceProps build() {
                EgressOnlyInternetGatewayResourceProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link EgressOnlyInternetGatewayResourceProps}.
     */
    final class Jsii$Pojo implements EgressOnlyInternetGatewayResourceProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Object _vpcId;

        public java.lang.Object getVpcId() {
            return this._vpcId;
        }
        public void setVpcId(final java.lang.String value) {
            this._vpcId = value;
        }
        public void setVpcId(final software.amazon.awscdk.Token value) {
            this._vpcId = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.EgressOnlyInternetGatewayResourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * ``AWS::EC2::EgressOnlyInternetGateway.VpcId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html#cfn-ec2-egressonlyinternetgateway-vpcid
         */
        public java.lang.Object getVpcId() {
            return this.jsiiGet("vpcId", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::EgressOnlyInternetGateway.VpcId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html#cfn-ec2-egressonlyinternetgateway-vpcid
         */
        public void setVpcId(final java.lang.String value) {
            this.jsiiSet("vpcId", java.util.Objects.requireNonNull(value, "vpcId is required"));
        }
        /**
         * ``AWS::EC2::EgressOnlyInternetGateway.VpcId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html#cfn-ec2-egressonlyinternetgateway-vpcid
         */
        public void setVpcId(final software.amazon.awscdk.Token value) {
            this.jsiiSet("vpcId", java.util.Objects.requireNonNull(value, "vpcId is required"));
        }
    }
}
