package software.amazon.awscdk.services.ec2.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html
 */
public interface NetworkInterfacePermissionResourceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ``AWS::EC2::NetworkInterfacePermission.AwsAccountId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-awsaccountid
     */
    java.lang.Object getAwsAccountId();
    /**
     * ``AWS::EC2::NetworkInterfacePermission.AwsAccountId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-awsaccountid
     */
    void setAwsAccountId(final java.lang.String value);
    /**
     * ``AWS::EC2::NetworkInterfacePermission.AwsAccountId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-awsaccountid
     */
    void setAwsAccountId(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::NetworkInterfacePermission.NetworkInterfaceId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-networkinterfaceid
     */
    java.lang.Object getNetworkInterfaceId();
    /**
     * ``AWS::EC2::NetworkInterfacePermission.NetworkInterfaceId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-networkinterfaceid
     */
    void setNetworkInterfaceId(final java.lang.String value);
    /**
     * ``AWS::EC2::NetworkInterfacePermission.NetworkInterfaceId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-networkinterfaceid
     */
    void setNetworkInterfaceId(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::NetworkInterfacePermission.Permission``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-permission
     */
    java.lang.Object getPermission();
    /**
     * ``AWS::EC2::NetworkInterfacePermission.Permission``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-permission
     */
    void setPermission(final java.lang.String value);
    /**
     * ``AWS::EC2::NetworkInterfacePermission.Permission``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-permission
     */
    void setPermission(final software.amazon.awscdk.Token value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link NetworkInterfacePermissionResourceProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * ``AWS::EC2::NetworkInterfacePermission.AwsAccountId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-awsaccountid
         */
        public NetworkInterfaceIdStep withAwsAccountId(final java.lang.String value) {
            return new FullBuilder().withAwsAccountId(value);
        }
        /**
         * ``AWS::EC2::NetworkInterfacePermission.AwsAccountId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-awsaccountid
         */
        public NetworkInterfaceIdStep withAwsAccountId(final software.amazon.awscdk.Token value) {
            return new FullBuilder().withAwsAccountId(value);
        }

        public interface NetworkInterfaceIdStep {
            /**
             * ``AWS::EC2::NetworkInterfacePermission.NetworkInterfaceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-networkinterfaceid
             */
            PermissionStep withNetworkInterfaceId(final java.lang.String value);
            /**
             * ``AWS::EC2::NetworkInterfacePermission.NetworkInterfaceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-networkinterfaceid
             */
            PermissionStep withNetworkInterfaceId(final software.amazon.awscdk.Token value);
        }

        public interface PermissionStep {
            /**
             * ``AWS::EC2::NetworkInterfacePermission.Permission``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-permission
             */
            Build withPermission(final java.lang.String value);
            /**
             * ``AWS::EC2::NetworkInterfacePermission.Permission``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-permission
             */
            Build withPermission(final software.amazon.awscdk.Token value);
        }

        public interface Build {
            /**
             * @return a new {@link NetworkInterfacePermissionResourceProps} object, initialized with the values set on this builder.
             */
            NetworkInterfacePermissionResourceProps build();
        }

        final class FullBuilder implements NetworkInterfaceIdStep, PermissionStep, Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``AWS::EC2::NetworkInterfacePermission.AwsAccountId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-awsaccountid
             */
            public NetworkInterfaceIdStep withAwsAccountId(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "NetworkInterfacePermissionResourceProps#awsAccountId is required");
                this.instance._awsAccountId = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterfacePermission.AwsAccountId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-awsaccountid
             */
            public NetworkInterfaceIdStep withAwsAccountId(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "NetworkInterfacePermissionResourceProps#awsAccountId is required");
                this.instance._awsAccountId = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterfacePermission.NetworkInterfaceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-networkinterfaceid
             */
            public PermissionStep withNetworkInterfaceId(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "NetworkInterfacePermissionResourceProps#networkInterfaceId is required");
                this.instance._networkInterfaceId = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterfacePermission.NetworkInterfaceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-networkinterfaceid
             */
            public PermissionStep withNetworkInterfaceId(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "NetworkInterfacePermissionResourceProps#networkInterfaceId is required");
                this.instance._networkInterfaceId = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterfacePermission.Permission``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-permission
             */
            public Build withPermission(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "NetworkInterfacePermissionResourceProps#permission is required");
                this.instance._permission = value;
                return this;
            }
            /**
             * ``AWS::EC2::NetworkInterfacePermission.Permission``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-permission
             */
            public Build withPermission(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "NetworkInterfacePermissionResourceProps#permission is required");
                this.instance._permission = value;
                return this;
            }
            public NetworkInterfacePermissionResourceProps build() {
                NetworkInterfacePermissionResourceProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link NetworkInterfacePermissionResourceProps}.
     */
    final class Jsii$Pojo implements NetworkInterfacePermissionResourceProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Object _awsAccountId;

        public java.lang.Object getAwsAccountId() {
            return this._awsAccountId;
        }
        public void setAwsAccountId(final java.lang.String value) {
            this._awsAccountId = value;
        }
        public void setAwsAccountId(final software.amazon.awscdk.Token value) {
            this._awsAccountId = value;
        }

        protected java.lang.Object _networkInterfaceId;

        public java.lang.Object getNetworkInterfaceId() {
            return this._networkInterfaceId;
        }
        public void setNetworkInterfaceId(final java.lang.String value) {
            this._networkInterfaceId = value;
        }
        public void setNetworkInterfaceId(final software.amazon.awscdk.Token value) {
            this._networkInterfaceId = value;
        }

        protected java.lang.Object _permission;

        public java.lang.Object getPermission() {
            return this._permission;
        }
        public void setPermission(final java.lang.String value) {
            this._permission = value;
        }
        public void setPermission(final software.amazon.awscdk.Token value) {
            this._permission = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.NetworkInterfacePermissionResourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * ``AWS::EC2::NetworkInterfacePermission.AwsAccountId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-awsaccountid
         */
        public java.lang.Object getAwsAccountId() {
            return this.jsiiGet("awsAccountId", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::NetworkInterfacePermission.AwsAccountId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-awsaccountid
         */
        public void setAwsAccountId(final java.lang.String value) {
            this.jsiiSet("awsAccountId", java.util.Objects.requireNonNull(value, "awsAccountId is required"));
        }
        /**
         * ``AWS::EC2::NetworkInterfacePermission.AwsAccountId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-awsaccountid
         */
        public void setAwsAccountId(final software.amazon.awscdk.Token value) {
            this.jsiiSet("awsAccountId", java.util.Objects.requireNonNull(value, "awsAccountId is required"));
        }
        /**
         * ``AWS::EC2::NetworkInterfacePermission.NetworkInterfaceId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-networkinterfaceid
         */
        public java.lang.Object getNetworkInterfaceId() {
            return this.jsiiGet("networkInterfaceId", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::NetworkInterfacePermission.NetworkInterfaceId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-networkinterfaceid
         */
        public void setNetworkInterfaceId(final java.lang.String value) {
            this.jsiiSet("networkInterfaceId", java.util.Objects.requireNonNull(value, "networkInterfaceId is required"));
        }
        /**
         * ``AWS::EC2::NetworkInterfacePermission.NetworkInterfaceId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-networkinterfaceid
         */
        public void setNetworkInterfaceId(final software.amazon.awscdk.Token value) {
            this.jsiiSet("networkInterfaceId", java.util.Objects.requireNonNull(value, "networkInterfaceId is required"));
        }
        /**
         * ``AWS::EC2::NetworkInterfacePermission.Permission``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-permission
         */
        public java.lang.Object getPermission() {
            return this.jsiiGet("permission", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::NetworkInterfacePermission.Permission``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-permission
         */
        public void setPermission(final java.lang.String value) {
            this.jsiiSet("permission", java.util.Objects.requireNonNull(value, "permission is required"));
        }
        /**
         * ``AWS::EC2::NetworkInterfacePermission.Permission``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-permission
         */
        public void setPermission(final software.amazon.awscdk.Token value) {
            this.jsiiSet("permission", java.util.Objects.requireNonNull(value, "permission is required"));
        }
    }
}
