package software.amazon.awscdk.services.ec2.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.cloudformation.NetworkInterfaceResource")
public class NetworkInterfaceResource extends software.amazon.awscdk.Resource {
    protected NetworkInterfaceResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.cloudformation.NetworkInterfaceResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::EC2::NetworkInterface``.
     * @param parent the ``cdk.Construct`` this ``NetworkInterfaceResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``NetworkInterfaceResource``
     */
    public NetworkInterfaceResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.ec2.cloudformation.NetworkInterfaceResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @cloudformation_attribute PrimaryPrivateIpAddress
     */
    public software.amazon.awscdk.services.ec2.NetworkInterfacePrimaryPrivateIpAddress getNetworkInterfacePrimaryPrivateIpAddress() {
        return this.jsiiGet("networkInterfacePrimaryPrivateIpAddress", software.amazon.awscdk.services.ec2.NetworkInterfacePrimaryPrivateIpAddress.class);
    }
    /**
     * @cloudformation_attribute SecondaryPrivateIpAddresses
     */
    public software.amazon.awscdk.services.ec2.NetworkInterfaceSecondaryPrivateIpAddresses getNetworkInterfaceSecondaryPrivateIpAddresses() {
        return this.jsiiGet("networkInterfaceSecondaryPrivateIpAddresses", software.amazon.awscdk.services.ec2.NetworkInterfaceSecondaryPrivateIpAddresses.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinterface-instanceipv6address.html
     */
    public static interface InstanceIpv6AddressProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``NetworkInterfaceResource.InstanceIpv6AddressProperty.Ipv6Address``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinterface-instanceipv6address.html#cfn-ec2-networkinterface-instanceipv6address-ipv6address
         */
        java.lang.Object getIpv6Address();
        /**
         * ``NetworkInterfaceResource.InstanceIpv6AddressProperty.Ipv6Address``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinterface-instanceipv6address.html#cfn-ec2-networkinterface-instanceipv6address-ipv6address
         */
        void setIpv6Address(final java.lang.String value);
        /**
         * ``NetworkInterfaceResource.InstanceIpv6AddressProperty.Ipv6Address``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinterface-instanceipv6address.html#cfn-ec2-networkinterface-instanceipv6address-ipv6address
         */
        void setIpv6Address(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link InstanceIpv6AddressProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``NetworkInterfaceResource.InstanceIpv6AddressProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinterface-instanceipv6address.html#cfn-ec2-networkinterface-instanceipv6address-ipv6address
             */
            public Build withIpv6Address(final java.lang.String value) {
                return new FullBuilder().withIpv6Address(value);
            }
            /**
             * ``NetworkInterfaceResource.InstanceIpv6AddressProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinterface-instanceipv6address.html#cfn-ec2-networkinterface-instanceipv6address-ipv6address
             */
            public Build withIpv6Address(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withIpv6Address(value);
            }

            public interface Build {
                /**
                 * @return a new {@link InstanceIpv6AddressProperty} object, initialized with the values set on this builder.
                 */
                InstanceIpv6AddressProperty build();
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``NetworkInterfaceResource.InstanceIpv6AddressProperty.Ipv6Address``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinterface-instanceipv6address.html#cfn-ec2-networkinterface-instanceipv6address-ipv6address
                 */
                public Build withIpv6Address(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "InstanceIpv6AddressProperty#ipv6Address is required");
                    this.instance._ipv6Address = value;
                    return this;
                }
                /**
                 * ``NetworkInterfaceResource.InstanceIpv6AddressProperty.Ipv6Address``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinterface-instanceipv6address.html#cfn-ec2-networkinterface-instanceipv6address-ipv6address
                 */
                public Build withIpv6Address(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "InstanceIpv6AddressProperty#ipv6Address is required");
                    this.instance._ipv6Address = value;
                    return this;
                }
                public InstanceIpv6AddressProperty build() {
                    InstanceIpv6AddressProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link InstanceIpv6AddressProperty}.
         */
        final class Jsii$Pojo implements InstanceIpv6AddressProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _ipv6Address;

            public java.lang.Object getIpv6Address() {
                return this._ipv6Address;
            }
            public void setIpv6Address(final java.lang.String value) {
                this._ipv6Address = value;
            }
            public void setIpv6Address(final software.amazon.awscdk.Token value) {
                this._ipv6Address = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.NetworkInterfaceResource.InstanceIpv6AddressProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``NetworkInterfaceResource.InstanceIpv6AddressProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinterface-instanceipv6address.html#cfn-ec2-networkinterface-instanceipv6address-ipv6address
             */
            public java.lang.Object getIpv6Address() {
                return this.jsiiGet("ipv6Address", java.lang.Object.class);
            }
            /**
             * ``NetworkInterfaceResource.InstanceIpv6AddressProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinterface-instanceipv6address.html#cfn-ec2-networkinterface-instanceipv6address-ipv6address
             */
            public void setIpv6Address(final java.lang.String value) {
                this.jsiiSet("ipv6Address", java.util.Objects.requireNonNull(value, "ipv6Address is required"));
            }
            /**
             * ``NetworkInterfaceResource.InstanceIpv6AddressProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinterface-instanceipv6address.html#cfn-ec2-networkinterface-instanceipv6address-ipv6address
             */
            public void setIpv6Address(final software.amazon.awscdk.Token value) {
                this.jsiiSet("ipv6Address", java.util.Objects.requireNonNull(value, "ipv6Address is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html
     */
    public static interface PrivateIpAddressSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``NetworkInterfaceResource.PrivateIpAddressSpecificationProperty.Primary``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
         */
        java.lang.Object getPrimary();
        /**
         * ``NetworkInterfaceResource.PrivateIpAddressSpecificationProperty.Primary``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
         */
        void setPrimary(final java.lang.Boolean value);
        /**
         * ``NetworkInterfaceResource.PrivateIpAddressSpecificationProperty.Primary``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
         */
        void setPrimary(final software.amazon.awscdk.Token value);
        /**
         * ``NetworkInterfaceResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
         */
        java.lang.Object getPrivateIpAddress();
        /**
         * ``NetworkInterfaceResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
         */
        void setPrivateIpAddress(final java.lang.String value);
        /**
         * ``NetworkInterfaceResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
         */
        void setPrivateIpAddress(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link PrivateIpAddressSpecificationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``NetworkInterfaceResource.PrivateIpAddressSpecificationProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
             */
            public PrivateIpAddressStep withPrimary(final java.lang.Boolean value) {
                return new FullBuilder().withPrimary(value);
            }
            /**
             * ``NetworkInterfaceResource.PrivateIpAddressSpecificationProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
             */
            public PrivateIpAddressStep withPrimary(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withPrimary(value);
            }

            public interface PrivateIpAddressStep {
                /**
                 * ``NetworkInterfaceResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
                 */
                Build withPrivateIpAddress(final java.lang.String value);
                /**
                 * ``NetworkInterfaceResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
                 */
                Build withPrivateIpAddress(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link PrivateIpAddressSpecificationProperty} object, initialized with the values set on this builder.
                 */
                PrivateIpAddressSpecificationProperty build();
            }

            final class FullBuilder implements PrivateIpAddressStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``NetworkInterfaceResource.PrivateIpAddressSpecificationProperty.Primary``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
                 */
                public PrivateIpAddressStep withPrimary(final java.lang.Boolean value) {
                    java.util.Objects.requireNonNull(value, "PrivateIpAddressSpecificationProperty#primary is required");
                    this.instance._primary = value;
                    return this;
                }
                /**
                 * ``NetworkInterfaceResource.PrivateIpAddressSpecificationProperty.Primary``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
                 */
                public PrivateIpAddressStep withPrimary(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "PrivateIpAddressSpecificationProperty#primary is required");
                    this.instance._primary = value;
                    return this;
                }
                /**
                 * ``NetworkInterfaceResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
                 */
                public Build withPrivateIpAddress(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "PrivateIpAddressSpecificationProperty#privateIpAddress is required");
                    this.instance._privateIpAddress = value;
                    return this;
                }
                /**
                 * ``NetworkInterfaceResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
                 */
                public Build withPrivateIpAddress(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "PrivateIpAddressSpecificationProperty#privateIpAddress is required");
                    this.instance._privateIpAddress = value;
                    return this;
                }
                public PrivateIpAddressSpecificationProperty build() {
                    PrivateIpAddressSpecificationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link PrivateIpAddressSpecificationProperty}.
         */
        final class Jsii$Pojo implements PrivateIpAddressSpecificationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _primary;

            public java.lang.Object getPrimary() {
                return this._primary;
            }
            public void setPrimary(final java.lang.Boolean value) {
                this._primary = value;
            }
            public void setPrimary(final software.amazon.awscdk.Token value) {
                this._primary = value;
            }

            protected java.lang.Object _privateIpAddress;

            public java.lang.Object getPrivateIpAddress() {
                return this._privateIpAddress;
            }
            public void setPrivateIpAddress(final java.lang.String value) {
                this._privateIpAddress = value;
            }
            public void setPrivateIpAddress(final software.amazon.awscdk.Token value) {
                this._privateIpAddress = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.NetworkInterfaceResource.PrivateIpAddressSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``NetworkInterfaceResource.PrivateIpAddressSpecificationProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
             */
            public java.lang.Object getPrimary() {
                return this.jsiiGet("primary", java.lang.Object.class);
            }
            /**
             * ``NetworkInterfaceResource.PrivateIpAddressSpecificationProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
             */
            public void setPrimary(final java.lang.Boolean value) {
                this.jsiiSet("primary", java.util.Objects.requireNonNull(value, "primary is required"));
            }
            /**
             * ``NetworkInterfaceResource.PrivateIpAddressSpecificationProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
             */
            public void setPrimary(final software.amazon.awscdk.Token value) {
                this.jsiiSet("primary", java.util.Objects.requireNonNull(value, "primary is required"));
            }
            /**
             * ``NetworkInterfaceResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
             */
            public java.lang.Object getPrivateIpAddress() {
                return this.jsiiGet("privateIpAddress", java.lang.Object.class);
            }
            /**
             * ``NetworkInterfaceResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
             */
            public void setPrivateIpAddress(final java.lang.String value) {
                this.jsiiSet("privateIpAddress", java.util.Objects.requireNonNull(value, "privateIpAddress is required"));
            }
            /**
             * ``NetworkInterfaceResource.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
             */
            public void setPrivateIpAddress(final software.amazon.awscdk.Token value) {
                this.jsiiSet("privateIpAddress", java.util.Objects.requireNonNull(value, "privateIpAddress is required"));
            }
        }
    }
}
