package software.amazon.awscdk.services.ec2.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.cloudformation.SecurityGroupResource")
public class SecurityGroupResource extends software.amazon.awscdk.Resource {
    protected SecurityGroupResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.cloudformation.SecurityGroupResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::EC2::SecurityGroup``.
     * @param parent the ``cdk.Construct`` this ``SecurityGroupResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``SecurityGroupResource``
     */
    public SecurityGroupResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.ec2.cloudformation.SecurityGroupResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @cloudformation_attribute GroupId
     */
    public software.amazon.awscdk.services.ec2.SecurityGroupId getSecurityGroupId() {
        return this.jsiiGet("securityGroupId", software.amazon.awscdk.services.ec2.SecurityGroupId.class);
    }
    /**
     * @cloudformation_attribute VpcId
     */
    public software.amazon.awscdk.services.ec2.SecurityGroupVpcId getSecurityGroupVpcId() {
        return this.jsiiGet("securityGroupVpcId", software.amazon.awscdk.services.ec2.SecurityGroupVpcId.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html
     */
    public static interface EgressProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``SecurityGroupResource.EgressProperty.CidrIp``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         */
        java.lang.Object getCidrIp();
        /**
         * ``SecurityGroupResource.EgressProperty.CidrIp``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         */
        void setCidrIp(final java.lang.String value);
        /**
         * ``SecurityGroupResource.EgressProperty.CidrIp``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         */
        void setCidrIp(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.EgressProperty.CidrIpv6``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         */
        java.lang.Object getCidrIpv6();
        /**
         * ``SecurityGroupResource.EgressProperty.CidrIpv6``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         */
        void setCidrIpv6(final java.lang.String value);
        /**
         * ``SecurityGroupResource.EgressProperty.CidrIpv6``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         */
        void setCidrIpv6(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.EgressProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         */
        java.lang.Object getDescription();
        /**
         * ``SecurityGroupResource.EgressProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         */
        void setDescription(final java.lang.String value);
        /**
         * ``SecurityGroupResource.EgressProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         */
        void setDescription(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.EgressProperty.DestinationPrefixListId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
         */
        java.lang.Object getDestinationPrefixListId();
        /**
         * ``SecurityGroupResource.EgressProperty.DestinationPrefixListId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
         */
        void setDestinationPrefixListId(final java.lang.String value);
        /**
         * ``SecurityGroupResource.EgressProperty.DestinationPrefixListId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
         */
        void setDestinationPrefixListId(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.EgressProperty.DestinationSecurityGroupId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
         */
        java.lang.Object getDestinationSecurityGroupId();
        /**
         * ``SecurityGroupResource.EgressProperty.DestinationSecurityGroupId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
         */
        void setDestinationSecurityGroupId(final java.lang.String value);
        /**
         * ``SecurityGroupResource.EgressProperty.DestinationSecurityGroupId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
         */
        void setDestinationSecurityGroupId(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.EgressProperty.FromPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        java.lang.Object getFromPort();
        /**
         * ``SecurityGroupResource.EgressProperty.FromPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        void setFromPort(final java.lang.Number value);
        /**
         * ``SecurityGroupResource.EgressProperty.FromPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        void setFromPort(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.EgressProperty.IpProtocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         */
        java.lang.Object getIpProtocol();
        /**
         * ``SecurityGroupResource.EgressProperty.IpProtocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         */
        void setIpProtocol(final java.lang.String value);
        /**
         * ``SecurityGroupResource.EgressProperty.IpProtocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         */
        void setIpProtocol(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.EgressProperty.ToPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        java.lang.Object getToPort();
        /**
         * ``SecurityGroupResource.EgressProperty.ToPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        void setToPort(final java.lang.Number value);
        /**
         * ``SecurityGroupResource.EgressProperty.ToPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        void setToPort(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link EgressProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``SecurityGroupResource.EgressProperty.IpProtocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
             */
            public Build withIpProtocol(final java.lang.String value) {
                return new FullBuilder().withIpProtocol(value);
            }
            /**
             * ``SecurityGroupResource.EgressProperty.IpProtocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
             */
            public Build withIpProtocol(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withIpProtocol(value);
            }

            public interface Build {
                /**
                 * @return a new {@link EgressProperty} object, initialized with the values set on this builder.
                 */
                EgressProperty build();
                /**
                 * ``SecurityGroupResource.EgressProperty.CidrIp``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
                 */
                Build withCidrIp(final java.lang.String value);
                /**
                 * ``SecurityGroupResource.EgressProperty.CidrIp``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
                 */
                Build withCidrIp(final software.amazon.awscdk.Token value);
                /**
                 * ``SecurityGroupResource.EgressProperty.CidrIpv6``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
                 */
                Build withCidrIpv6(final java.lang.String value);
                /**
                 * ``SecurityGroupResource.EgressProperty.CidrIpv6``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
                 */
                Build withCidrIpv6(final software.amazon.awscdk.Token value);
                /**
                 * ``SecurityGroupResource.EgressProperty.Description``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
                 */
                Build withDescription(final java.lang.String value);
                /**
                 * ``SecurityGroupResource.EgressProperty.Description``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
                 */
                Build withDescription(final software.amazon.awscdk.Token value);
                /**
                 * ``SecurityGroupResource.EgressProperty.DestinationPrefixListId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
                 */
                Build withDestinationPrefixListId(final java.lang.String value);
                /**
                 * ``SecurityGroupResource.EgressProperty.DestinationPrefixListId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
                 */
                Build withDestinationPrefixListId(final software.amazon.awscdk.Token value);
                /**
                 * ``SecurityGroupResource.EgressProperty.DestinationSecurityGroupId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
                 */
                Build withDestinationSecurityGroupId(final java.lang.String value);
                /**
                 * ``SecurityGroupResource.EgressProperty.DestinationSecurityGroupId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
                 */
                Build withDestinationSecurityGroupId(final software.amazon.awscdk.Token value);
                /**
                 * ``SecurityGroupResource.EgressProperty.FromPort``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
                 */
                Build withFromPort(final java.lang.Number value);
                /**
                 * ``SecurityGroupResource.EgressProperty.FromPort``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
                 */
                Build withFromPort(final software.amazon.awscdk.Token value);
                /**
                 * ``SecurityGroupResource.EgressProperty.ToPort``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
                 */
                Build withToPort(final java.lang.Number value);
                /**
                 * ``SecurityGroupResource.EgressProperty.ToPort``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
                 */
                Build withToPort(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``SecurityGroupResource.EgressProperty.CidrIp``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
                 */
                public Build withCidrIp(final java.lang.String value) {
                    this.instance._cidrIp = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.EgressProperty.CidrIp``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
                 */
                public Build withCidrIp(final software.amazon.awscdk.Token value) {
                    this.instance._cidrIp = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.EgressProperty.CidrIpv6``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
                 */
                public Build withCidrIpv6(final java.lang.String value) {
                    this.instance._cidrIpv6 = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.EgressProperty.CidrIpv6``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
                 */
                public Build withCidrIpv6(final software.amazon.awscdk.Token value) {
                    this.instance._cidrIpv6 = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.EgressProperty.Description``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
                 */
                public Build withDescription(final java.lang.String value) {
                    this.instance._description = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.EgressProperty.Description``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
                 */
                public Build withDescription(final software.amazon.awscdk.Token value) {
                    this.instance._description = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.EgressProperty.DestinationPrefixListId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
                 */
                public Build withDestinationPrefixListId(final java.lang.String value) {
                    this.instance._destinationPrefixListId = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.EgressProperty.DestinationPrefixListId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
                 */
                public Build withDestinationPrefixListId(final software.amazon.awscdk.Token value) {
                    this.instance._destinationPrefixListId = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.EgressProperty.DestinationSecurityGroupId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
                 */
                public Build withDestinationSecurityGroupId(final java.lang.String value) {
                    this.instance._destinationSecurityGroupId = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.EgressProperty.DestinationSecurityGroupId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
                 */
                public Build withDestinationSecurityGroupId(final software.amazon.awscdk.Token value) {
                    this.instance._destinationSecurityGroupId = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.EgressProperty.FromPort``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
                 */
                public Build withFromPort(final java.lang.Number value) {
                    this.instance._fromPort = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.EgressProperty.FromPort``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
                 */
                public Build withFromPort(final software.amazon.awscdk.Token value) {
                    this.instance._fromPort = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.EgressProperty.IpProtocol``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
                 */
                public Build withIpProtocol(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "EgressProperty#ipProtocol is required");
                    this.instance._ipProtocol = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.EgressProperty.IpProtocol``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
                 */
                public Build withIpProtocol(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "EgressProperty#ipProtocol is required");
                    this.instance._ipProtocol = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.EgressProperty.ToPort``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
                 */
                public Build withToPort(final java.lang.Number value) {
                    this.instance._toPort = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.EgressProperty.ToPort``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
                 */
                public Build withToPort(final software.amazon.awscdk.Token value) {
                    this.instance._toPort = value;
                    return this;
                }
                public EgressProperty build() {
                    EgressProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link EgressProperty}.
         */
        final class Jsii$Pojo implements EgressProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _cidrIp;

            public java.lang.Object getCidrIp() {
                return this._cidrIp;
            }
            public void setCidrIp(final java.lang.String value) {
                this._cidrIp = value;
            }
            public void setCidrIp(final software.amazon.awscdk.Token value) {
                this._cidrIp = value;
            }

            protected java.lang.Object _cidrIpv6;

            public java.lang.Object getCidrIpv6() {
                return this._cidrIpv6;
            }
            public void setCidrIpv6(final java.lang.String value) {
                this._cidrIpv6 = value;
            }
            public void setCidrIpv6(final software.amazon.awscdk.Token value) {
                this._cidrIpv6 = value;
            }

            protected java.lang.Object _description;

            public java.lang.Object getDescription() {
                return this._description;
            }
            public void setDescription(final java.lang.String value) {
                this._description = value;
            }
            public void setDescription(final software.amazon.awscdk.Token value) {
                this._description = value;
            }

            protected java.lang.Object _destinationPrefixListId;

            public java.lang.Object getDestinationPrefixListId() {
                return this._destinationPrefixListId;
            }
            public void setDestinationPrefixListId(final java.lang.String value) {
                this._destinationPrefixListId = value;
            }
            public void setDestinationPrefixListId(final software.amazon.awscdk.Token value) {
                this._destinationPrefixListId = value;
            }

            protected java.lang.Object _destinationSecurityGroupId;

            public java.lang.Object getDestinationSecurityGroupId() {
                return this._destinationSecurityGroupId;
            }
            public void setDestinationSecurityGroupId(final java.lang.String value) {
                this._destinationSecurityGroupId = value;
            }
            public void setDestinationSecurityGroupId(final software.amazon.awscdk.Token value) {
                this._destinationSecurityGroupId = value;
            }

            protected java.lang.Object _fromPort;

            public java.lang.Object getFromPort() {
                return this._fromPort;
            }
            public void setFromPort(final java.lang.Number value) {
                this._fromPort = value;
            }
            public void setFromPort(final software.amazon.awscdk.Token value) {
                this._fromPort = value;
            }

            protected java.lang.Object _ipProtocol;

            public java.lang.Object getIpProtocol() {
                return this._ipProtocol;
            }
            public void setIpProtocol(final java.lang.String value) {
                this._ipProtocol = value;
            }
            public void setIpProtocol(final software.amazon.awscdk.Token value) {
                this._ipProtocol = value;
            }

            protected java.lang.Object _toPort;

            public java.lang.Object getToPort() {
                return this._toPort;
            }
            public void setToPort(final java.lang.Number value) {
                this._toPort = value;
            }
            public void setToPort(final software.amazon.awscdk.Token value) {
                this._toPort = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.SecurityGroupResource.EgressProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``SecurityGroupResource.EgressProperty.CidrIp``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
             */
            @javax.annotation.Nullable
            public java.lang.Object getCidrIp() {
                return this.jsiiGet("cidrIp", java.lang.Object.class);
            }
            /**
             * ``SecurityGroupResource.EgressProperty.CidrIp``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
             */
            public void setCidrIp(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("cidrIp", value);
            }
            /**
             * ``SecurityGroupResource.EgressProperty.CidrIp``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
             */
            public void setCidrIp(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cidrIp", value);
            }
            /**
             * ``SecurityGroupResource.EgressProperty.CidrIpv6``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
             */
            @javax.annotation.Nullable
            public java.lang.Object getCidrIpv6() {
                return this.jsiiGet("cidrIpv6", java.lang.Object.class);
            }
            /**
             * ``SecurityGroupResource.EgressProperty.CidrIpv6``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
             */
            public void setCidrIpv6(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("cidrIpv6", value);
            }
            /**
             * ``SecurityGroupResource.EgressProperty.CidrIpv6``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
             */
            public void setCidrIpv6(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cidrIpv6", value);
            }
            /**
             * ``SecurityGroupResource.EgressProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
             */
            @javax.annotation.Nullable
            public java.lang.Object getDescription() {
                return this.jsiiGet("description", java.lang.Object.class);
            }
            /**
             * ``SecurityGroupResource.EgressProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
             */
            public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("description", value);
            }
            /**
             * ``SecurityGroupResource.EgressProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
             */
            public void setDescription(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("description", value);
            }
            /**
             * ``SecurityGroupResource.EgressProperty.DestinationPrefixListId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
             */
            @javax.annotation.Nullable
            public java.lang.Object getDestinationPrefixListId() {
                return this.jsiiGet("destinationPrefixListId", java.lang.Object.class);
            }
            /**
             * ``SecurityGroupResource.EgressProperty.DestinationPrefixListId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
             */
            public void setDestinationPrefixListId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("destinationPrefixListId", value);
            }
            /**
             * ``SecurityGroupResource.EgressProperty.DestinationPrefixListId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
             */
            public void setDestinationPrefixListId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("destinationPrefixListId", value);
            }
            /**
             * ``SecurityGroupResource.EgressProperty.DestinationSecurityGroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
             */
            @javax.annotation.Nullable
            public java.lang.Object getDestinationSecurityGroupId() {
                return this.jsiiGet("destinationSecurityGroupId", java.lang.Object.class);
            }
            /**
             * ``SecurityGroupResource.EgressProperty.DestinationSecurityGroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
             */
            public void setDestinationSecurityGroupId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("destinationSecurityGroupId", value);
            }
            /**
             * ``SecurityGroupResource.EgressProperty.DestinationSecurityGroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
             */
            public void setDestinationSecurityGroupId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("destinationSecurityGroupId", value);
            }
            /**
             * ``SecurityGroupResource.EgressProperty.FromPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
             */
            @javax.annotation.Nullable
            public java.lang.Object getFromPort() {
                return this.jsiiGet("fromPort", java.lang.Object.class);
            }
            /**
             * ``SecurityGroupResource.EgressProperty.FromPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
             */
            public void setFromPort(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("fromPort", value);
            }
            /**
             * ``SecurityGroupResource.EgressProperty.FromPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
             */
            public void setFromPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("fromPort", value);
            }
            /**
             * ``SecurityGroupResource.EgressProperty.IpProtocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
             */
            public java.lang.Object getIpProtocol() {
                return this.jsiiGet("ipProtocol", java.lang.Object.class);
            }
            /**
             * ``SecurityGroupResource.EgressProperty.IpProtocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
             */
            public void setIpProtocol(final java.lang.String value) {
                this.jsiiSet("ipProtocol", java.util.Objects.requireNonNull(value, "ipProtocol is required"));
            }
            /**
             * ``SecurityGroupResource.EgressProperty.IpProtocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
             */
            public void setIpProtocol(final software.amazon.awscdk.Token value) {
                this.jsiiSet("ipProtocol", java.util.Objects.requireNonNull(value, "ipProtocol is required"));
            }
            /**
             * ``SecurityGroupResource.EgressProperty.ToPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
             */
            @javax.annotation.Nullable
            public java.lang.Object getToPort() {
                return this.jsiiGet("toPort", java.lang.Object.class);
            }
            /**
             * ``SecurityGroupResource.EgressProperty.ToPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
             */
            public void setToPort(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("toPort", value);
            }
            /**
             * ``SecurityGroupResource.EgressProperty.ToPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
             */
            public void setToPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("toPort", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html
     */
    public static interface IngressProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``SecurityGroupResource.IngressProperty.CidrIp``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         */
        java.lang.Object getCidrIp();
        /**
         * ``SecurityGroupResource.IngressProperty.CidrIp``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         */
        void setCidrIp(final java.lang.String value);
        /**
         * ``SecurityGroupResource.IngressProperty.CidrIp``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         */
        void setCidrIp(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.IngressProperty.CidrIpv6``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         */
        java.lang.Object getCidrIpv6();
        /**
         * ``SecurityGroupResource.IngressProperty.CidrIpv6``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         */
        void setCidrIpv6(final java.lang.String value);
        /**
         * ``SecurityGroupResource.IngressProperty.CidrIpv6``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         */
        void setCidrIpv6(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.IngressProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         */
        java.lang.Object getDescription();
        /**
         * ``SecurityGroupResource.IngressProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         */
        void setDescription(final java.lang.String value);
        /**
         * ``SecurityGroupResource.IngressProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         */
        void setDescription(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.IngressProperty.FromPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        java.lang.Object getFromPort();
        /**
         * ``SecurityGroupResource.IngressProperty.FromPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        void setFromPort(final java.lang.Number value);
        /**
         * ``SecurityGroupResource.IngressProperty.FromPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        void setFromPort(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.IngressProperty.IpProtocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         */
        java.lang.Object getIpProtocol();
        /**
         * ``SecurityGroupResource.IngressProperty.IpProtocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         */
        void setIpProtocol(final java.lang.String value);
        /**
         * ``SecurityGroupResource.IngressProperty.IpProtocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         */
        void setIpProtocol(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
         */
        java.lang.Object getSourceSecurityGroupId();
        /**
         * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
         */
        void setSourceSecurityGroupId(final java.lang.String value);
        /**
         * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
         */
        void setSourceSecurityGroupId(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
         */
        java.lang.Object getSourceSecurityGroupName();
        /**
         * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
         */
        void setSourceSecurityGroupName(final java.lang.String value);
        /**
         * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
         */
        void setSourceSecurityGroupName(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupOwnerId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
         */
        java.lang.Object getSourceSecurityGroupOwnerId();
        /**
         * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupOwnerId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
         */
        void setSourceSecurityGroupOwnerId(final java.lang.String value);
        /**
         * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupOwnerId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
         */
        void setSourceSecurityGroupOwnerId(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.IngressProperty.ToPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        java.lang.Object getToPort();
        /**
         * ``SecurityGroupResource.IngressProperty.ToPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        void setToPort(final java.lang.Number value);
        /**
         * ``SecurityGroupResource.IngressProperty.ToPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        void setToPort(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link IngressProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``SecurityGroupResource.IngressProperty.IpProtocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
             */
            public Build withIpProtocol(final java.lang.String value) {
                return new FullBuilder().withIpProtocol(value);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.IpProtocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
             */
            public Build withIpProtocol(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withIpProtocol(value);
            }

            public interface Build {
                /**
                 * @return a new {@link IngressProperty} object, initialized with the values set on this builder.
                 */
                IngressProperty build();
                /**
                 * ``SecurityGroupResource.IngressProperty.CidrIp``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
                 */
                Build withCidrIp(final java.lang.String value);
                /**
                 * ``SecurityGroupResource.IngressProperty.CidrIp``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
                 */
                Build withCidrIp(final software.amazon.awscdk.Token value);
                /**
                 * ``SecurityGroupResource.IngressProperty.CidrIpv6``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
                 */
                Build withCidrIpv6(final java.lang.String value);
                /**
                 * ``SecurityGroupResource.IngressProperty.CidrIpv6``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
                 */
                Build withCidrIpv6(final software.amazon.awscdk.Token value);
                /**
                 * ``SecurityGroupResource.IngressProperty.Description``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
                 */
                Build withDescription(final java.lang.String value);
                /**
                 * ``SecurityGroupResource.IngressProperty.Description``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
                 */
                Build withDescription(final software.amazon.awscdk.Token value);
                /**
                 * ``SecurityGroupResource.IngressProperty.FromPort``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
                 */
                Build withFromPort(final java.lang.Number value);
                /**
                 * ``SecurityGroupResource.IngressProperty.FromPort``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
                 */
                Build withFromPort(final software.amazon.awscdk.Token value);
                /**
                 * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
                 */
                Build withSourceSecurityGroupId(final java.lang.String value);
                /**
                 * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
                 */
                Build withSourceSecurityGroupId(final software.amazon.awscdk.Token value);
                /**
                 * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
                 */
                Build withSourceSecurityGroupName(final java.lang.String value);
                /**
                 * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
                 */
                Build withSourceSecurityGroupName(final software.amazon.awscdk.Token value);
                /**
                 * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupOwnerId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
                 */
                Build withSourceSecurityGroupOwnerId(final java.lang.String value);
                /**
                 * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupOwnerId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
                 */
                Build withSourceSecurityGroupOwnerId(final software.amazon.awscdk.Token value);
                /**
                 * ``SecurityGroupResource.IngressProperty.ToPort``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
                 */
                Build withToPort(final java.lang.Number value);
                /**
                 * ``SecurityGroupResource.IngressProperty.ToPort``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
                 */
                Build withToPort(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``SecurityGroupResource.IngressProperty.CidrIp``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
                 */
                public Build withCidrIp(final java.lang.String value) {
                    this.instance._cidrIp = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.IngressProperty.CidrIp``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
                 */
                public Build withCidrIp(final software.amazon.awscdk.Token value) {
                    this.instance._cidrIp = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.IngressProperty.CidrIpv6``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
                 */
                public Build withCidrIpv6(final java.lang.String value) {
                    this.instance._cidrIpv6 = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.IngressProperty.CidrIpv6``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
                 */
                public Build withCidrIpv6(final software.amazon.awscdk.Token value) {
                    this.instance._cidrIpv6 = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.IngressProperty.Description``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
                 */
                public Build withDescription(final java.lang.String value) {
                    this.instance._description = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.IngressProperty.Description``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
                 */
                public Build withDescription(final software.amazon.awscdk.Token value) {
                    this.instance._description = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.IngressProperty.FromPort``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
                 */
                public Build withFromPort(final java.lang.Number value) {
                    this.instance._fromPort = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.IngressProperty.FromPort``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
                 */
                public Build withFromPort(final software.amazon.awscdk.Token value) {
                    this.instance._fromPort = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.IngressProperty.IpProtocol``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
                 */
                public Build withIpProtocol(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "IngressProperty#ipProtocol is required");
                    this.instance._ipProtocol = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.IngressProperty.IpProtocol``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
                 */
                public Build withIpProtocol(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "IngressProperty#ipProtocol is required");
                    this.instance._ipProtocol = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
                 */
                public Build withSourceSecurityGroupId(final java.lang.String value) {
                    this.instance._sourceSecurityGroupId = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
                 */
                public Build withSourceSecurityGroupId(final software.amazon.awscdk.Token value) {
                    this.instance._sourceSecurityGroupId = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
                 */
                public Build withSourceSecurityGroupName(final java.lang.String value) {
                    this.instance._sourceSecurityGroupName = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
                 */
                public Build withSourceSecurityGroupName(final software.amazon.awscdk.Token value) {
                    this.instance._sourceSecurityGroupName = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupOwnerId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
                 */
                public Build withSourceSecurityGroupOwnerId(final java.lang.String value) {
                    this.instance._sourceSecurityGroupOwnerId = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupOwnerId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
                 */
                public Build withSourceSecurityGroupOwnerId(final software.amazon.awscdk.Token value) {
                    this.instance._sourceSecurityGroupOwnerId = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.IngressProperty.ToPort``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
                 */
                public Build withToPort(final java.lang.Number value) {
                    this.instance._toPort = value;
                    return this;
                }
                /**
                 * ``SecurityGroupResource.IngressProperty.ToPort``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
                 */
                public Build withToPort(final software.amazon.awscdk.Token value) {
                    this.instance._toPort = value;
                    return this;
                }
                public IngressProperty build() {
                    IngressProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link IngressProperty}.
         */
        final class Jsii$Pojo implements IngressProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _cidrIp;

            public java.lang.Object getCidrIp() {
                return this._cidrIp;
            }
            public void setCidrIp(final java.lang.String value) {
                this._cidrIp = value;
            }
            public void setCidrIp(final software.amazon.awscdk.Token value) {
                this._cidrIp = value;
            }

            protected java.lang.Object _cidrIpv6;

            public java.lang.Object getCidrIpv6() {
                return this._cidrIpv6;
            }
            public void setCidrIpv6(final java.lang.String value) {
                this._cidrIpv6 = value;
            }
            public void setCidrIpv6(final software.amazon.awscdk.Token value) {
                this._cidrIpv6 = value;
            }

            protected java.lang.Object _description;

            public java.lang.Object getDescription() {
                return this._description;
            }
            public void setDescription(final java.lang.String value) {
                this._description = value;
            }
            public void setDescription(final software.amazon.awscdk.Token value) {
                this._description = value;
            }

            protected java.lang.Object _fromPort;

            public java.lang.Object getFromPort() {
                return this._fromPort;
            }
            public void setFromPort(final java.lang.Number value) {
                this._fromPort = value;
            }
            public void setFromPort(final software.amazon.awscdk.Token value) {
                this._fromPort = value;
            }

            protected java.lang.Object _ipProtocol;

            public java.lang.Object getIpProtocol() {
                return this._ipProtocol;
            }
            public void setIpProtocol(final java.lang.String value) {
                this._ipProtocol = value;
            }
            public void setIpProtocol(final software.amazon.awscdk.Token value) {
                this._ipProtocol = value;
            }

            protected java.lang.Object _sourceSecurityGroupId;

            public java.lang.Object getSourceSecurityGroupId() {
                return this._sourceSecurityGroupId;
            }
            public void setSourceSecurityGroupId(final java.lang.String value) {
                this._sourceSecurityGroupId = value;
            }
            public void setSourceSecurityGroupId(final software.amazon.awscdk.Token value) {
                this._sourceSecurityGroupId = value;
            }

            protected java.lang.Object _sourceSecurityGroupName;

            public java.lang.Object getSourceSecurityGroupName() {
                return this._sourceSecurityGroupName;
            }
            public void setSourceSecurityGroupName(final java.lang.String value) {
                this._sourceSecurityGroupName = value;
            }
            public void setSourceSecurityGroupName(final software.amazon.awscdk.Token value) {
                this._sourceSecurityGroupName = value;
            }

            protected java.lang.Object _sourceSecurityGroupOwnerId;

            public java.lang.Object getSourceSecurityGroupOwnerId() {
                return this._sourceSecurityGroupOwnerId;
            }
            public void setSourceSecurityGroupOwnerId(final java.lang.String value) {
                this._sourceSecurityGroupOwnerId = value;
            }
            public void setSourceSecurityGroupOwnerId(final software.amazon.awscdk.Token value) {
                this._sourceSecurityGroupOwnerId = value;
            }

            protected java.lang.Object _toPort;

            public java.lang.Object getToPort() {
                return this._toPort;
            }
            public void setToPort(final java.lang.Number value) {
                this._toPort = value;
            }
            public void setToPort(final software.amazon.awscdk.Token value) {
                this._toPort = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.SecurityGroupResource.IngressProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.CidrIp``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
             */
            @javax.annotation.Nullable
            public java.lang.Object getCidrIp() {
                return this.jsiiGet("cidrIp", java.lang.Object.class);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.CidrIp``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
             */
            public void setCidrIp(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("cidrIp", value);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.CidrIp``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
             */
            public void setCidrIp(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cidrIp", value);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.CidrIpv6``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
             */
            @javax.annotation.Nullable
            public java.lang.Object getCidrIpv6() {
                return this.jsiiGet("cidrIpv6", java.lang.Object.class);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.CidrIpv6``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
             */
            public void setCidrIpv6(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("cidrIpv6", value);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.CidrIpv6``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
             */
            public void setCidrIpv6(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cidrIpv6", value);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
             */
            @javax.annotation.Nullable
            public java.lang.Object getDescription() {
                return this.jsiiGet("description", java.lang.Object.class);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
             */
            public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("description", value);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
             */
            public void setDescription(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("description", value);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.FromPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
             */
            @javax.annotation.Nullable
            public java.lang.Object getFromPort() {
                return this.jsiiGet("fromPort", java.lang.Object.class);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.FromPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
             */
            public void setFromPort(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("fromPort", value);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.FromPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
             */
            public void setFromPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("fromPort", value);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.IpProtocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
             */
            public java.lang.Object getIpProtocol() {
                return this.jsiiGet("ipProtocol", java.lang.Object.class);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.IpProtocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
             */
            public void setIpProtocol(final java.lang.String value) {
                this.jsiiSet("ipProtocol", java.util.Objects.requireNonNull(value, "ipProtocol is required"));
            }
            /**
             * ``SecurityGroupResource.IngressProperty.IpProtocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
             */
            public void setIpProtocol(final software.amazon.awscdk.Token value) {
                this.jsiiSet("ipProtocol", java.util.Objects.requireNonNull(value, "ipProtocol is required"));
            }
            /**
             * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
             */
            @javax.annotation.Nullable
            public java.lang.Object getSourceSecurityGroupId() {
                return this.jsiiGet("sourceSecurityGroupId", java.lang.Object.class);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
             */
            public void setSourceSecurityGroupId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("sourceSecurityGroupId", value);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
             */
            public void setSourceSecurityGroupId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("sourceSecurityGroupId", value);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
             */
            @javax.annotation.Nullable
            public java.lang.Object getSourceSecurityGroupName() {
                return this.jsiiGet("sourceSecurityGroupName", java.lang.Object.class);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
             */
            public void setSourceSecurityGroupName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("sourceSecurityGroupName", value);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
             */
            public void setSourceSecurityGroupName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("sourceSecurityGroupName", value);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupOwnerId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
             */
            @javax.annotation.Nullable
            public java.lang.Object getSourceSecurityGroupOwnerId() {
                return this.jsiiGet("sourceSecurityGroupOwnerId", java.lang.Object.class);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupOwnerId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
             */
            public void setSourceSecurityGroupOwnerId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("sourceSecurityGroupOwnerId", value);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupOwnerId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
             */
            public void setSourceSecurityGroupOwnerId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("sourceSecurityGroupOwnerId", value);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.ToPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
             */
            @javax.annotation.Nullable
            public java.lang.Object getToPort() {
                return this.jsiiGet("toPort", java.lang.Object.class);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.ToPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
             */
            public void setToPort(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("toPort", value);
            }
            /**
             * ``SecurityGroupResource.IngressProperty.ToPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
             */
            public void setToPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("toPort", value);
            }
        }
    }
}
