package software.amazon.awscdk.services.ec2.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html
 */
public interface SubnetRouteTableAssociationResourceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ``AWS::EC2::SubnetRouteTableAssociation.RouteTableId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-routetableid
     */
    java.lang.Object getRouteTableId();
    /**
     * ``AWS::EC2::SubnetRouteTableAssociation.RouteTableId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-routetableid
     */
    void setRouteTableId(final java.lang.String value);
    /**
     * ``AWS::EC2::SubnetRouteTableAssociation.RouteTableId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-routetableid
     */
    void setRouteTableId(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::SubnetRouteTableAssociation.SubnetId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-subnetid
     */
    java.lang.Object getSubnetId();
    /**
     * ``AWS::EC2::SubnetRouteTableAssociation.SubnetId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-subnetid
     */
    void setSubnetId(final java.lang.String value);
    /**
     * ``AWS::EC2::SubnetRouteTableAssociation.SubnetId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-subnetid
     */
    void setSubnetId(final software.amazon.awscdk.Token value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link SubnetRouteTableAssociationResourceProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * ``AWS::EC2::SubnetRouteTableAssociation.RouteTableId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-routetableid
         */
        public SubnetIdStep withRouteTableId(final java.lang.String value) {
            return new FullBuilder().withRouteTableId(value);
        }
        /**
         * ``AWS::EC2::SubnetRouteTableAssociation.RouteTableId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-routetableid
         */
        public SubnetIdStep withRouteTableId(final software.amazon.awscdk.Token value) {
            return new FullBuilder().withRouteTableId(value);
        }

        public interface SubnetIdStep {
            /**
             * ``AWS::EC2::SubnetRouteTableAssociation.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-subnetid
             */
            Build withSubnetId(final java.lang.String value);
            /**
             * ``AWS::EC2::SubnetRouteTableAssociation.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-subnetid
             */
            Build withSubnetId(final software.amazon.awscdk.Token value);
        }

        public interface Build {
            /**
             * @return a new {@link SubnetRouteTableAssociationResourceProps} object, initialized with the values set on this builder.
             */
            SubnetRouteTableAssociationResourceProps build();
        }

        final class FullBuilder implements SubnetIdStep, Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``AWS::EC2::SubnetRouteTableAssociation.RouteTableId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-routetableid
             */
            public SubnetIdStep withRouteTableId(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "SubnetRouteTableAssociationResourceProps#routeTableId is required");
                this.instance._routeTableId = value;
                return this;
            }
            /**
             * ``AWS::EC2::SubnetRouteTableAssociation.RouteTableId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-routetableid
             */
            public SubnetIdStep withRouteTableId(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "SubnetRouteTableAssociationResourceProps#routeTableId is required");
                this.instance._routeTableId = value;
                return this;
            }
            /**
             * ``AWS::EC2::SubnetRouteTableAssociation.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-subnetid
             */
            public Build withSubnetId(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "SubnetRouteTableAssociationResourceProps#subnetId is required");
                this.instance._subnetId = value;
                return this;
            }
            /**
             * ``AWS::EC2::SubnetRouteTableAssociation.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-subnetid
             */
            public Build withSubnetId(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "SubnetRouteTableAssociationResourceProps#subnetId is required");
                this.instance._subnetId = value;
                return this;
            }
            public SubnetRouteTableAssociationResourceProps build() {
                SubnetRouteTableAssociationResourceProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link SubnetRouteTableAssociationResourceProps}.
     */
    final class Jsii$Pojo implements SubnetRouteTableAssociationResourceProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Object _routeTableId;

        public java.lang.Object getRouteTableId() {
            return this._routeTableId;
        }
        public void setRouteTableId(final java.lang.String value) {
            this._routeTableId = value;
        }
        public void setRouteTableId(final software.amazon.awscdk.Token value) {
            this._routeTableId = value;
        }

        protected java.lang.Object _subnetId;

        public java.lang.Object getSubnetId() {
            return this._subnetId;
        }
        public void setSubnetId(final java.lang.String value) {
            this._subnetId = value;
        }
        public void setSubnetId(final software.amazon.awscdk.Token value) {
            this._subnetId = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.SubnetRouteTableAssociationResourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * ``AWS::EC2::SubnetRouteTableAssociation.RouteTableId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-routetableid
         */
        public java.lang.Object getRouteTableId() {
            return this.jsiiGet("routeTableId", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::SubnetRouteTableAssociation.RouteTableId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-routetableid
         */
        public void setRouteTableId(final java.lang.String value) {
            this.jsiiSet("routeTableId", java.util.Objects.requireNonNull(value, "routeTableId is required"));
        }
        /**
         * ``AWS::EC2::SubnetRouteTableAssociation.RouteTableId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-routetableid
         */
        public void setRouteTableId(final software.amazon.awscdk.Token value) {
            this.jsiiSet("routeTableId", java.util.Objects.requireNonNull(value, "routeTableId is required"));
        }
        /**
         * ``AWS::EC2::SubnetRouteTableAssociation.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-subnetid
         */
        public java.lang.Object getSubnetId() {
            return this.jsiiGet("subnetId", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::SubnetRouteTableAssociation.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-subnetid
         */
        public void setSubnetId(final java.lang.String value) {
            this.jsiiSet("subnetId", java.util.Objects.requireNonNull(value, "subnetId is required"));
        }
        /**
         * ``AWS::EC2::SubnetRouteTableAssociation.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-subnetid
         */
        public void setSubnetId(final software.amazon.awscdk.Token value) {
            this.jsiiSet("subnetId", java.util.Objects.requireNonNull(value, "subnetId is required"));
        }
    }
}
