package software.amazon.awscdk.services.ec2.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.cloudformation.VPNConnectionResource")
public class VPNConnectionResource extends software.amazon.awscdk.Resource {
    protected VPNConnectionResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.cloudformation.VPNConnectionResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::EC2::VPNConnection``.
     * @param parent the ``cdk.Construct`` this ``VPNConnectionResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``VPNConnectionResource``
     */
    public VPNConnectionResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.ec2.cloudformation.VPNConnectionResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html
     */
    public static interface VpnTunnelOptionsSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.PreSharedKey``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-presharedkey
         */
        java.lang.Object getPreSharedKey();
        /**
         * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.PreSharedKey``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-presharedkey
         */
        void setPreSharedKey(final java.lang.String value);
        /**
         * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.PreSharedKey``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-presharedkey
         */
        void setPreSharedKey(final software.amazon.awscdk.Token value);
        /**
         * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.TunnelInsideCidr``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-tunnelinsidecidr
         */
        java.lang.Object getTunnelInsideCidr();
        /**
         * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.TunnelInsideCidr``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-tunnelinsidecidr
         */
        void setTunnelInsideCidr(final java.lang.String value);
        /**
         * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.TunnelInsideCidr``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-tunnelinsidecidr
         */
        void setTunnelInsideCidr(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link VpnTunnelOptionsSpecificationProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.PreSharedKey``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-presharedkey
             */
            public Builder withPreSharedKey(final java.lang.String value) {
                this.instance._preSharedKey = value;
                return this;
            }
            /**
             * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.PreSharedKey``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-presharedkey
             */
            public Builder withPreSharedKey(final software.amazon.awscdk.Token value) {
                this.instance._preSharedKey = value;
                return this;
            }
            /**
             * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.TunnelInsideCidr``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-tunnelinsidecidr
             */
            public Builder withTunnelInsideCidr(final java.lang.String value) {
                this.instance._tunnelInsideCidr = value;
                return this;
            }
            /**
             * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.TunnelInsideCidr``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-tunnelinsidecidr
             */
            public Builder withTunnelInsideCidr(final software.amazon.awscdk.Token value) {
                this.instance._tunnelInsideCidr = value;
                return this;
            }
            public VpnTunnelOptionsSpecificationProperty build() {
                VpnTunnelOptionsSpecificationProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link VpnTunnelOptionsSpecificationProperty}.
         */
        final class Jsii$Pojo implements VpnTunnelOptionsSpecificationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _preSharedKey;

            public java.lang.Object getPreSharedKey() {
                return this._preSharedKey;
            }
            public void setPreSharedKey(final java.lang.String value) {
                this._preSharedKey = value;
            }
            public void setPreSharedKey(final software.amazon.awscdk.Token value) {
                this._preSharedKey = value;
            }

            protected java.lang.Object _tunnelInsideCidr;

            public java.lang.Object getTunnelInsideCidr() {
                return this._tunnelInsideCidr;
            }
            public void setTunnelInsideCidr(final java.lang.String value) {
                this._tunnelInsideCidr = value;
            }
            public void setTunnelInsideCidr(final software.amazon.awscdk.Token value) {
                this._tunnelInsideCidr = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.VPNConnectionResource.VpnTunnelOptionsSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.PreSharedKey``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-presharedkey
             */
            @javax.annotation.Nullable
            public java.lang.Object getPreSharedKey() {
                return this.jsiiGet("preSharedKey", java.lang.Object.class);
            }
            /**
             * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.PreSharedKey``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-presharedkey
             */
            public void setPreSharedKey(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("preSharedKey", value);
            }
            /**
             * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.PreSharedKey``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-presharedkey
             */
            public void setPreSharedKey(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("preSharedKey", value);
            }
            /**
             * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.TunnelInsideCidr``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-tunnelinsidecidr
             */
            @javax.annotation.Nullable
            public java.lang.Object getTunnelInsideCidr() {
                return this.jsiiGet("tunnelInsideCidr", java.lang.Object.class);
            }
            /**
             * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.TunnelInsideCidr``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-tunnelinsidecidr
             */
            public void setTunnelInsideCidr(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("tunnelInsideCidr", value);
            }
            /**
             * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.TunnelInsideCidr``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-tunnelinsidecidr
             */
            public void setTunnelInsideCidr(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("tunnelInsideCidr", value);
            }
        }
    }
}
