package software.amazon.awscdk.services.ec2.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html
 */
public interface VPNConnectionRouteResourceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ``AWS::EC2::VPNConnectionRoute.DestinationCidrBlock``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-cidrblock
     */
    java.lang.Object getDestinationCidrBlock();
    /**
     * ``AWS::EC2::VPNConnectionRoute.DestinationCidrBlock``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-cidrblock
     */
    void setDestinationCidrBlock(final java.lang.String value);
    /**
     * ``AWS::EC2::VPNConnectionRoute.DestinationCidrBlock``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-cidrblock
     */
    void setDestinationCidrBlock(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::EC2::VPNConnectionRoute.VpnConnectionId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-connectionid
     */
    java.lang.Object getVpnConnectionId();
    /**
     * ``AWS::EC2::VPNConnectionRoute.VpnConnectionId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-connectionid
     */
    void setVpnConnectionId(final java.lang.String value);
    /**
     * ``AWS::EC2::VPNConnectionRoute.VpnConnectionId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-connectionid
     */
    void setVpnConnectionId(final software.amazon.awscdk.Token value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link VPNConnectionRouteResourceProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * ``AWS::EC2::VPNConnectionRoute.DestinationCidrBlock``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-cidrblock
         */
        public VpnConnectionIdStep withDestinationCidrBlock(final java.lang.String value) {
            return new FullBuilder().withDestinationCidrBlock(value);
        }
        /**
         * ``AWS::EC2::VPNConnectionRoute.DestinationCidrBlock``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-cidrblock
         */
        public VpnConnectionIdStep withDestinationCidrBlock(final software.amazon.awscdk.Token value) {
            return new FullBuilder().withDestinationCidrBlock(value);
        }

        public interface VpnConnectionIdStep {
            /**
             * ``AWS::EC2::VPNConnectionRoute.VpnConnectionId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-connectionid
             */
            Build withVpnConnectionId(final java.lang.String value);
            /**
             * ``AWS::EC2::VPNConnectionRoute.VpnConnectionId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-connectionid
             */
            Build withVpnConnectionId(final software.amazon.awscdk.Token value);
        }

        public interface Build {
            /**
             * @return a new {@link VPNConnectionRouteResourceProps} object, initialized with the values set on this builder.
             */
            VPNConnectionRouteResourceProps build();
        }

        final class FullBuilder implements VpnConnectionIdStep, Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``AWS::EC2::VPNConnectionRoute.DestinationCidrBlock``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-cidrblock
             */
            public VpnConnectionIdStep withDestinationCidrBlock(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "VPNConnectionRouteResourceProps#destinationCidrBlock is required");
                this.instance._destinationCidrBlock = value;
                return this;
            }
            /**
             * ``AWS::EC2::VPNConnectionRoute.DestinationCidrBlock``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-cidrblock
             */
            public VpnConnectionIdStep withDestinationCidrBlock(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "VPNConnectionRouteResourceProps#destinationCidrBlock is required");
                this.instance._destinationCidrBlock = value;
                return this;
            }
            /**
             * ``AWS::EC2::VPNConnectionRoute.VpnConnectionId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-connectionid
             */
            public Build withVpnConnectionId(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "VPNConnectionRouteResourceProps#vpnConnectionId is required");
                this.instance._vpnConnectionId = value;
                return this;
            }
            /**
             * ``AWS::EC2::VPNConnectionRoute.VpnConnectionId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-connectionid
             */
            public Build withVpnConnectionId(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "VPNConnectionRouteResourceProps#vpnConnectionId is required");
                this.instance._vpnConnectionId = value;
                return this;
            }
            public VPNConnectionRouteResourceProps build() {
                VPNConnectionRouteResourceProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link VPNConnectionRouteResourceProps}.
     */
    final class Jsii$Pojo implements VPNConnectionRouteResourceProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Object _destinationCidrBlock;

        public java.lang.Object getDestinationCidrBlock() {
            return this._destinationCidrBlock;
        }
        public void setDestinationCidrBlock(final java.lang.String value) {
            this._destinationCidrBlock = value;
        }
        public void setDestinationCidrBlock(final software.amazon.awscdk.Token value) {
            this._destinationCidrBlock = value;
        }

        protected java.lang.Object _vpnConnectionId;

        public java.lang.Object getVpnConnectionId() {
            return this._vpnConnectionId;
        }
        public void setVpnConnectionId(final java.lang.String value) {
            this._vpnConnectionId = value;
        }
        public void setVpnConnectionId(final software.amazon.awscdk.Token value) {
            this._vpnConnectionId = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.VPNConnectionRouteResourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * ``AWS::EC2::VPNConnectionRoute.DestinationCidrBlock``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-cidrblock
         */
        public java.lang.Object getDestinationCidrBlock() {
            return this.jsiiGet("destinationCidrBlock", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::VPNConnectionRoute.DestinationCidrBlock``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-cidrblock
         */
        public void setDestinationCidrBlock(final java.lang.String value) {
            this.jsiiSet("destinationCidrBlock", java.util.Objects.requireNonNull(value, "destinationCidrBlock is required"));
        }
        /**
         * ``AWS::EC2::VPNConnectionRoute.DestinationCidrBlock``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-cidrblock
         */
        public void setDestinationCidrBlock(final software.amazon.awscdk.Token value) {
            this.jsiiSet("destinationCidrBlock", java.util.Objects.requireNonNull(value, "destinationCidrBlock is required"));
        }
        /**
         * ``AWS::EC2::VPNConnectionRoute.VpnConnectionId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-connectionid
         */
        public java.lang.Object getVpnConnectionId() {
            return this.jsiiGet("vpnConnectionId", java.lang.Object.class);
        }
        /**
         * ``AWS::EC2::VPNConnectionRoute.VpnConnectionId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-connectionid
         */
        public void setVpnConnectionId(final java.lang.String value) {
            this.jsiiSet("vpnConnectionId", java.util.Objects.requireNonNull(value, "vpnConnectionId is required"));
        }
        /**
         * ``AWS::EC2::VPNConnectionRoute.VpnConnectionId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-connectionid
         */
        public void setVpnConnectionId(final software.amazon.awscdk.Token value) {
            this.jsiiSet("vpnConnectionId", java.util.Objects.requireNonNull(value, "vpnConnectionId is required"));
        }
    }
}
