package software.amazon.awscdk.services.ec2;

/**
 * Reference to a listener's port just created.
 * 
 * This implements IConnectable with a default port (the port that an ELB
 * listener was just created on) for a given security group so that it can be
 * conveniently used just like any Connectable. E.g:
 * 
 *       const listener = elb.addListener(...);
 * 
 *       listener.connections.allowDefaultPortFromAnyIPv4();
 *       // or
 *       instance.connections.allowToDefaultPort(listener);
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.4 (build e80a889)", date = "2018-09-11T09:56:33.230Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.ClassicListenerPort")
public class ClassicListenerPort extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IConnectable {
    protected ClassicListenerPort(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public ClassicListenerPort(final software.amazon.awscdk.services.ec2.SecurityGroupRef securityGroup, final software.amazon.awscdk.services.ec2.IPortRange defaultPortRange) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(securityGroup, "securityGroup is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(defaultPortRange, "defaultPortRange is required"))).toArray());
    }

    @Override
    public software.amazon.awscdk.services.ec2.Connections getConnections() {
        return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
    }
}
