package software.amazon.awscdk.services.ec2;

/**
 * Add a backend to the load balancer
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.4 (build e80a889)", date = "2018-09-11T09:56:33.232Z")
public interface ClassicLoadBalancerListener extends software.amazon.jsii.JsiiSerializable {
    /**
     * External listening port
     */
    java.lang.Number getExternalPort();
    /**
     * External listening port
     */
    void setExternalPort(final java.lang.Number value);
    /**
     * Allow connections to the load balancer from the given set of connection peers
     * 
     * By default, connections will be allowed from anywhere. Set this to an empty list
     * to deny connections, or supply a custom list of peers to allow connections from
     * (IP ranges or security groups).
     * @default Anywhere
     */
    java.util.List<software.amazon.awscdk.services.ec2.IConnectable> getAllowConnectionsFrom();
    /**
     * Allow connections to the load balancer from the given set of connection peers
     * 
     * By default, connections will be allowed from anywhere. Set this to an empty list
     * to deny connections, or supply a custom list of peers to allow connections from
     * (IP ranges or security groups).
     * @default Anywhere
     */
    void setAllowConnectionsFrom(final java.util.List<software.amazon.awscdk.services.ec2.IConnectable> value);
    /**
     * What public protocol to use for load balancing
     * 
     * Either 'tcp', 'ssl', 'http' or 'https'.
     * 
     * May be omitted if the external port is either 80 or 443.
     */
    software.amazon.awscdk.services.ec2.LoadBalancingProtocol getExternalProtocol();
    /**
     * What public protocol to use for load balancing
     * 
     * Either 'tcp', 'ssl', 'http' or 'https'.
     * 
     * May be omitted if the external port is either 80 or 443.
     */
    void setExternalProtocol(final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value);
    /**
     * Instance listening port
     * 
     * Same as the externalPort if not specified.
     * @default externalPort
     */
    java.lang.Number getInternalPort();
    /**
     * Instance listening port
     * 
     * Same as the externalPort if not specified.
     * @default externalPort
     */
    void setInternalPort(final java.lang.Number value);
    /**
     * What public protocol to use for load balancing
     * 
     * Either 'tcp', 'ssl', 'http' or 'https'.
     * 
     * May be omitted if the internal port is either 80 or 443.
     * 
     * The instance protocol is 'tcp' if the front-end protocol
     * is 'tcp' or 'ssl', the instance protocol is 'http' if the
     * front-end protocol is 'https'.
     */
    software.amazon.awscdk.services.ec2.LoadBalancingProtocol getInternalProtocol();
    /**
     * What public protocol to use for load balancing
     * 
     * Either 'tcp', 'ssl', 'http' or 'https'.
     * 
     * May be omitted if the internal port is either 80 or 443.
     * 
     * The instance protocol is 'tcp' if the front-end protocol
     * is 'tcp' or 'ssl', the instance protocol is 'http' if the
     * front-end protocol is 'https'.
     */
    void setInternalProtocol(final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value);
    /**
     * SSL policy names
     */
    java.util.List<java.lang.String> getPolicyNames();
    /**
     * SSL policy names
     */
    void setPolicyNames(final java.util.List<java.lang.String> value);
    /**
     * ID of SSL certificate
     */
    software.amazon.awscdk.Arn getSslCertificateId();
    /**
     * ID of SSL certificate
     */
    void setSslCertificateId(final software.amazon.awscdk.Arn value);

    /**
     * @return a {@link Builder} of {@link ClassicLoadBalancerListener}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ClassicLoadBalancerListener}
     */
    final class Builder {
        private java.lang.Number _externalPort;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.ec2.IConnectable> _allowConnectionsFrom;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.LoadBalancingProtocol _externalProtocol;
        @javax.annotation.Nullable
        private java.lang.Number _internalPort;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.LoadBalancingProtocol _internalProtocol;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _policyNames;
        @javax.annotation.Nullable
        private software.amazon.awscdk.Arn _sslCertificateId;

        /**
         * Sets the value of ExternalPort
         * @param value External listening port
         * @return {@code this}
         */
        public Builder withExternalPort(final java.lang.Number value) {
            this._externalPort = java.util.Objects.requireNonNull(value, "externalPort is required");
            return this;
        }
        /**
         * Sets the value of AllowConnectionsFrom
         * @param value Allow connections to the load balancer from the given set of connection peers

By default, connections will be allowed from anywhere. Set this to an empty list
to deny connections, or supply a custom list of peers to allow connections from
(IP ranges or security groups).
         * @return {@code this}
         */
        public Builder withAllowConnectionsFrom(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.IConnectable> value) {
            this._allowConnectionsFrom = value;
            return this;
        }
        /**
         * Sets the value of ExternalProtocol
         * @param value What public protocol to use for load balancing

Either 'tcp', 'ssl', 'http' or 'https'.

May be omitted if the external port is either 80 or 443.
         * @return {@code this}
         */
        public Builder withExternalProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value) {
            this._externalProtocol = value;
            return this;
        }
        /**
         * Sets the value of InternalPort
         * @param value Instance listening port

Same as the externalPort if not specified.
         * @return {@code this}
         */
        public Builder withInternalPort(@javax.annotation.Nullable final java.lang.Number value) {
            this._internalPort = value;
            return this;
        }
        /**
         * Sets the value of InternalProtocol
         * @param value What public protocol to use for load balancing

Either 'tcp', 'ssl', 'http' or 'https'.

May be omitted if the internal port is either 80 or 443.

The instance protocol is 'tcp' if the front-end protocol
is 'tcp' or 'ssl', the instance protocol is 'http' if the
front-end protocol is 'https'.
         * @return {@code this}
         */
        public Builder withInternalProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value) {
            this._internalProtocol = value;
            return this;
        }
        /**
         * Sets the value of PolicyNames
         * @param value SSL policy names
         * @return {@code this}
         */
        public Builder withPolicyNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._policyNames = value;
            return this;
        }
        /**
         * Sets the value of SslCertificateId
         * @param value ID of SSL certificate
         * @return {@code this}
         */
        public Builder withSslCertificateId(@javax.annotation.Nullable final software.amazon.awscdk.Arn value) {
            this._sslCertificateId = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ClassicLoadBalancerListener}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ClassicLoadBalancerListener build() {
            return new ClassicLoadBalancerListener() {
                private java.lang.Number $externalPort = java.util.Objects.requireNonNull(_externalPort, "externalPort is required");
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.ec2.IConnectable> $allowConnectionsFrom = _allowConnectionsFrom;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.ec2.LoadBalancingProtocol $externalProtocol = _externalProtocol;
                @javax.annotation.Nullable
                private java.lang.Number $internalPort = _internalPort;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.ec2.LoadBalancingProtocol $internalProtocol = _internalProtocol;
                @javax.annotation.Nullable
                private java.util.List<java.lang.String> $policyNames = _policyNames;
                @javax.annotation.Nullable
                private software.amazon.awscdk.Arn $sslCertificateId = _sslCertificateId;

                @Override
                public java.lang.Number getExternalPort() {
                    return this.$externalPort;
                }

                @Override
                public void setExternalPort(final java.lang.Number value) {
                    this.$externalPort = java.util.Objects.requireNonNull(value, "externalPort is required");
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.ec2.IConnectable> getAllowConnectionsFrom() {
                    return this.$allowConnectionsFrom;
                }

                @Override
                public void setAllowConnectionsFrom(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.IConnectable> value) {
                    this.$allowConnectionsFrom = value;
                }

                @Override
                public software.amazon.awscdk.services.ec2.LoadBalancingProtocol getExternalProtocol() {
                    return this.$externalProtocol;
                }

                @Override
                public void setExternalProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value) {
                    this.$externalProtocol = value;
                }

                @Override
                public java.lang.Number getInternalPort() {
                    return this.$internalPort;
                }

                @Override
                public void setInternalPort(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$internalPort = value;
                }

                @Override
                public software.amazon.awscdk.services.ec2.LoadBalancingProtocol getInternalProtocol() {
                    return this.$internalProtocol;
                }

                @Override
                public void setInternalProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value) {
                    this.$internalProtocol = value;
                }

                @Override
                public java.util.List<java.lang.String> getPolicyNames() {
                    return this.$policyNames;
                }

                @Override
                public void setPolicyNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                    this.$policyNames = value;
                }

                @Override
                public software.amazon.awscdk.Arn getSslCertificateId() {
                    return this.$sslCertificateId;
                }

                @Override
                public void setSslCertificateId(@javax.annotation.Nullable final software.amazon.awscdk.Arn value) {
                    this.$sslCertificateId = value;
                }

            };
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.ClassicLoadBalancerListener {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * External listening port
         */
        @Override
        public java.lang.Number getExternalPort() {
            return this.jsiiGet("externalPort", java.lang.Number.class);
        }

        /**
         * External listening port
         */
        @Override
        public void setExternalPort(final java.lang.Number value) {
            this.jsiiSet("externalPort", java.util.Objects.requireNonNull(value, "externalPort is required"));
        }

        /**
         * Allow connections to the load balancer from the given set of connection peers
         * 
         * By default, connections will be allowed from anywhere. Set this to an empty list
         * to deny connections, or supply a custom list of peers to allow connections from
         * (IP ranges or security groups).
         * @default Anywhere
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.ec2.IConnectable> getAllowConnectionsFrom() {
            return this.jsiiGet("allowConnectionsFrom", java.util.List.class);
        }

        /**
         * Allow connections to the load balancer from the given set of connection peers
         * 
         * By default, connections will be allowed from anywhere. Set this to an empty list
         * to deny connections, or supply a custom list of peers to allow connections from
         * (IP ranges or security groups).
         * @default Anywhere
         */
        @Override
        public void setAllowConnectionsFrom(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.IConnectable> value) {
            this.jsiiSet("allowConnectionsFrom", value);
        }

        /**
         * What public protocol to use for load balancing
         * 
         * Either 'tcp', 'ssl', 'http' or 'https'.
         * 
         * May be omitted if the external port is either 80 or 443.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.LoadBalancingProtocol getExternalProtocol() {
            return this.jsiiGet("externalProtocol", software.amazon.awscdk.services.ec2.LoadBalancingProtocol.class);
        }

        /**
         * What public protocol to use for load balancing
         * 
         * Either 'tcp', 'ssl', 'http' or 'https'.
         * 
         * May be omitted if the external port is either 80 or 443.
         */
        @Override
        public void setExternalProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value) {
            this.jsiiSet("externalProtocol", value);
        }

        /**
         * Instance listening port
         * 
         * Same as the externalPort if not specified.
         * @default externalPort
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getInternalPort() {
            return this.jsiiGet("internalPort", java.lang.Number.class);
        }

        /**
         * Instance listening port
         * 
         * Same as the externalPort if not specified.
         * @default externalPort
         */
        @Override
        public void setInternalPort(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("internalPort", value);
        }

        /**
         * What public protocol to use for load balancing
         * 
         * Either 'tcp', 'ssl', 'http' or 'https'.
         * 
         * May be omitted if the internal port is either 80 or 443.
         * 
         * The instance protocol is 'tcp' if the front-end protocol
         * is 'tcp' or 'ssl', the instance protocol is 'http' if the
         * front-end protocol is 'https'.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.LoadBalancingProtocol getInternalProtocol() {
            return this.jsiiGet("internalProtocol", software.amazon.awscdk.services.ec2.LoadBalancingProtocol.class);
        }

        /**
         * What public protocol to use for load balancing
         * 
         * Either 'tcp', 'ssl', 'http' or 'https'.
         * 
         * May be omitted if the internal port is either 80 or 443.
         * 
         * The instance protocol is 'tcp' if the front-end protocol
         * is 'tcp' or 'ssl', the instance protocol is 'http' if the
         * front-end protocol is 'https'.
         */
        @Override
        public void setInternalProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value) {
            this.jsiiSet("internalProtocol", value);
        }

        /**
         * SSL policy names
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getPolicyNames() {
            return this.jsiiGet("policyNames", java.util.List.class);
        }

        /**
         * SSL policy names
         */
        @Override
        public void setPolicyNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this.jsiiSet("policyNames", value);
        }

        /**
         * ID of SSL certificate
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.Arn getSslCertificateId() {
            return this.jsiiGet("sslCertificateId", software.amazon.awscdk.Arn.class);
        }

        /**
         * ID of SSL certificate
         */
        @Override
        public void setSslCertificateId(@javax.annotation.Nullable final software.amazon.awscdk.Arn value) {
            this.jsiiSet("sslCertificateId", value);
        }
    }
}
