package software.amazon.awscdk.services.ec2;

/**
 * Construction properties for a ClassicLoadBalancer
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.4 (build e80a889)", date = "2018-09-11T09:56:33.234Z")
public interface ClassicLoadBalancerProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * VPC network of the fleet instances
     */
    software.amazon.awscdk.services.ec2.VpcNetworkRef getVpc();
    /**
     * VPC network of the fleet instances
     */
    void setVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value);
    /**
     * Health check settings for the load balancing targets.
     * 
     * Not required but recommended.
     */
    software.amazon.awscdk.services.ec2.HealthCheck getHealthCheck();
    /**
     * Health check settings for the load balancing targets.
     * 
     * Not required but recommended.
     */
    void setHealthCheck(final software.amazon.awscdk.services.ec2.HealthCheck value);
    /**
     * Whether this is an internet-facing Load Balancer
     * 
     * This controls whether the LB has a public IP address assigned. It does
     * not open up the Load Balancer's security groups to public internet access.
     * @default false
     */
    java.lang.Boolean getInternetFacing();
    /**
     * Whether this is an internet-facing Load Balancer
     * 
     * This controls whether the LB has a public IP address assigned. It does
     * not open up the Load Balancer's security groups to public internet access.
     * @default false
     */
    void setInternetFacing(final java.lang.Boolean value);
    /**
     * What listeners to set up for the load balancer.
     * 
     * Can also be added by .addListener()
     */
    java.util.List<software.amazon.awscdk.services.ec2.ClassicLoadBalancerListener> getListeners();
    /**
     * What listeners to set up for the load balancer.
     * 
     * Can also be added by .addListener()
     */
    void setListeners(final java.util.List<software.amazon.awscdk.services.ec2.ClassicLoadBalancerListener> value);
    /**
     * What targets to load balance to.
     * 
     * Can also be added by .addTarget()
     */
    java.util.List<software.amazon.awscdk.services.ec2.IClassicLoadBalancerTarget> getTargets();
    /**
     * What targets to load balance to.
     * 
     * Can also be added by .addTarget()
     */
    void setTargets(final java.util.List<software.amazon.awscdk.services.ec2.IClassicLoadBalancerTarget> value);

    /**
     * @return a {@link Builder} of {@link ClassicLoadBalancerProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ClassicLoadBalancerProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.ec2.VpcNetworkRef _vpc;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.HealthCheck _healthCheck;
        @javax.annotation.Nullable
        private java.lang.Boolean _internetFacing;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.ec2.ClassicLoadBalancerListener> _listeners;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.ec2.IClassicLoadBalancerTarget> _targets;

        /**
         * Sets the value of Vpc
         * @param value VPC network of the fleet instances
         * @return {@code this}
         */
        public Builder withVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
            this._vpc = java.util.Objects.requireNonNull(value, "vpc is required");
            return this;
        }
        /**
         * Sets the value of HealthCheck
         * @param value Health check settings for the load balancing targets.

Not required but recommended.
         * @return {@code this}
         */
        public Builder withHealthCheck(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.HealthCheck value) {
            this._healthCheck = value;
            return this;
        }
        /**
         * Sets the value of InternetFacing
         * @param value Whether this is an internet-facing Load Balancer

This controls whether the LB has a public IP address assigned. It does
not open up the Load Balancer's security groups to public internet access.
         * @return {@code this}
         */
        public Builder withInternetFacing(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._internetFacing = value;
            return this;
        }
        /**
         * Sets the value of Listeners
         * @param value What listeners to set up for the load balancer.

Can also be added by .addListener()
         * @return {@code this}
         */
        public Builder withListeners(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.ClassicLoadBalancerListener> value) {
            this._listeners = value;
            return this;
        }
        /**
         * Sets the value of Targets
         * @param value What targets to load balance to.

Can also be added by .addTarget()
         * @return {@code this}
         */
        public Builder withTargets(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.IClassicLoadBalancerTarget> value) {
            this._targets = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ClassicLoadBalancerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ClassicLoadBalancerProps build() {
            return new ClassicLoadBalancerProps() {
                private software.amazon.awscdk.services.ec2.VpcNetworkRef $vpc = java.util.Objects.requireNonNull(_vpc, "vpc is required");
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.ec2.HealthCheck $healthCheck = _healthCheck;
                @javax.annotation.Nullable
                private java.lang.Boolean $internetFacing = _internetFacing;
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.ec2.ClassicLoadBalancerListener> $listeners = _listeners;
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.ec2.IClassicLoadBalancerTarget> $targets = _targets;

                @Override
                public software.amazon.awscdk.services.ec2.VpcNetworkRef getVpc() {
                    return this.$vpc;
                }

                @Override
                public void setVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
                    this.$vpc = java.util.Objects.requireNonNull(value, "vpc is required");
                }

                @Override
                public software.amazon.awscdk.services.ec2.HealthCheck getHealthCheck() {
                    return this.$healthCheck;
                }

                @Override
                public void setHealthCheck(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.HealthCheck value) {
                    this.$healthCheck = value;
                }

                @Override
                public java.lang.Boolean getInternetFacing() {
                    return this.$internetFacing;
                }

                @Override
                public void setInternetFacing(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$internetFacing = value;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.ec2.ClassicLoadBalancerListener> getListeners() {
                    return this.$listeners;
                }

                @Override
                public void setListeners(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.ClassicLoadBalancerListener> value) {
                    this.$listeners = value;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.ec2.IClassicLoadBalancerTarget> getTargets() {
                    return this.$targets;
                }

                @Override
                public void setTargets(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.IClassicLoadBalancerTarget> value) {
                    this.$targets = value;
                }

            };
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.ClassicLoadBalancerProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * VPC network of the fleet instances
         */
        @Override
        public software.amazon.awscdk.services.ec2.VpcNetworkRef getVpc() {
            return this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.VpcNetworkRef.class);
        }

        /**
         * VPC network of the fleet instances
         */
        @Override
        public void setVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
            this.jsiiSet("vpc", java.util.Objects.requireNonNull(value, "vpc is required"));
        }

        /**
         * Health check settings for the load balancing targets.
         * 
         * Not required but recommended.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.HealthCheck getHealthCheck() {
            return this.jsiiGet("healthCheck", software.amazon.awscdk.services.ec2.HealthCheck.class);
        }

        /**
         * Health check settings for the load balancing targets.
         * 
         * Not required but recommended.
         */
        @Override
        public void setHealthCheck(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.HealthCheck value) {
            this.jsiiSet("healthCheck", value);
        }

        /**
         * Whether this is an internet-facing Load Balancer
         * 
         * This controls whether the LB has a public IP address assigned. It does
         * not open up the Load Balancer's security groups to public internet access.
         * @default false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getInternetFacing() {
            return this.jsiiGet("internetFacing", java.lang.Boolean.class);
        }

        /**
         * Whether this is an internet-facing Load Balancer
         * 
         * This controls whether the LB has a public IP address assigned. It does
         * not open up the Load Balancer's security groups to public internet access.
         * @default false
         */
        @Override
        public void setInternetFacing(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("internetFacing", value);
        }

        /**
         * What listeners to set up for the load balancer.
         * 
         * Can also be added by .addListener()
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.ec2.ClassicLoadBalancerListener> getListeners() {
            return this.jsiiGet("listeners", java.util.List.class);
        }

        /**
         * What listeners to set up for the load balancer.
         * 
         * Can also be added by .addListener()
         */
        @Override
        public void setListeners(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.ClassicLoadBalancerListener> value) {
            this.jsiiSet("listeners", value);
        }

        /**
         * What targets to load balance to.
         * 
         * Can also be added by .addTarget()
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.ec2.IClassicLoadBalancerTarget> getTargets() {
            return this.jsiiGet("targets", java.util.List.class);
        }

        /**
         * What targets to load balance to.
         * 
         * Can also be added by .addTarget()
         */
        @Override
        public void setTargets(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.IClassicLoadBalancerTarget> value) {
            this.jsiiSet("targets", value);
        }
    }
}
