package software.amazon.awscdk.services.ec2;

/**
 * Describe the health check to a load balancer
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.4 (build e80a889)", date = "2018-09-11T09:56:33.240Z")
public interface HealthCheck extends software.amazon.jsii.JsiiSerializable {
    /**
     * What port number to health check on
     */
    java.lang.Number getPort();
    /**
     * What port number to health check on
     */
    void setPort(final java.lang.Number value);
    /**
     * After how many successful checks is an instance considered healthy
     * @default 2
     */
    java.lang.Number getHealthyThreshold();
    /**
     * After how many successful checks is an instance considered healthy
     * @default 2
     */
    void setHealthyThreshold(final java.lang.Number value);
    /**
     * Number of seconds between health checks
     * @default 30
     */
    java.lang.Number getInterval();
    /**
     * Number of seconds between health checks
     * @default 30
     */
    void setInterval(final java.lang.Number value);
    /**
     * What path to use for HTTP or HTTPS health check (must return 200)
     * 
     * For SSL and TCP health checks, accepting connections is enough to be considered
     * healthy.
     * @default "/"
     */
    java.lang.String getPath();
    /**
     * What path to use for HTTP or HTTPS health check (must return 200)
     * 
     * For SSL and TCP health checks, accepting connections is enough to be considered
     * healthy.
     * @default "/"
     */
    void setPath(final java.lang.String value);
    /**
     * What protocol to use for health checking
     * 
     * The protocol is automatically determined from the port if it's not supplied.
     * @default Automatic
     */
    software.amazon.awscdk.services.ec2.LoadBalancingProtocol getProtocol();
    /**
     * What protocol to use for health checking
     * 
     * The protocol is automatically determined from the port if it's not supplied.
     * @default Automatic
     */
    void setProtocol(final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value);
    /**
     * Health check timeout
     * @default 5
     */
    java.lang.Number getTimeout();
    /**
     * Health check timeout
     * @default 5
     */
    void setTimeout(final java.lang.Number value);
    /**
     * After how many unsuccessful checks is an instance considered unhealthy
     * @default 5
     */
    java.lang.Number getUnhealthyThreshold();
    /**
     * After how many unsuccessful checks is an instance considered unhealthy
     * @default 5
     */
    void setUnhealthyThreshold(final java.lang.Number value);

    /**
     * @return a {@link Builder} of {@link HealthCheck}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link HealthCheck}
     */
    final class Builder {
        private java.lang.Number _port;
        @javax.annotation.Nullable
        private java.lang.Number _healthyThreshold;
        @javax.annotation.Nullable
        private java.lang.Number _interval;
        @javax.annotation.Nullable
        private java.lang.String _path;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.LoadBalancingProtocol _protocol;
        @javax.annotation.Nullable
        private java.lang.Number _timeout;
        @javax.annotation.Nullable
        private java.lang.Number _unhealthyThreshold;

        /**
         * Sets the value of Port
         * @param value What port number to health check on
         * @return {@code this}
         */
        public Builder withPort(final java.lang.Number value) {
            this._port = java.util.Objects.requireNonNull(value, "port is required");
            return this;
        }
        /**
         * Sets the value of HealthyThreshold
         * @param value After how many successful checks is an instance considered healthy
         * @return {@code this}
         */
        public Builder withHealthyThreshold(@javax.annotation.Nullable final java.lang.Number value) {
            this._healthyThreshold = value;
            return this;
        }
        /**
         * Sets the value of Interval
         * @param value Number of seconds between health checks
         * @return {@code this}
         */
        public Builder withInterval(@javax.annotation.Nullable final java.lang.Number value) {
            this._interval = value;
            return this;
        }
        /**
         * Sets the value of Path
         * @param value What path to use for HTTP or HTTPS health check (must return 200)

For SSL and TCP health checks, accepting connections is enough to be considered
healthy.
         * @return {@code this}
         */
        public Builder withPath(@javax.annotation.Nullable final java.lang.String value) {
            this._path = value;
            return this;
        }
        /**
         * Sets the value of Protocol
         * @param value What protocol to use for health checking

The protocol is automatically determined from the port if it's not supplied.
         * @return {@code this}
         */
        public Builder withProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value) {
            this._protocol = value;
            return this;
        }
        /**
         * Sets the value of Timeout
         * @param value Health check timeout
         * @return {@code this}
         */
        public Builder withTimeout(@javax.annotation.Nullable final java.lang.Number value) {
            this._timeout = value;
            return this;
        }
        /**
         * Sets the value of UnhealthyThreshold
         * @param value After how many unsuccessful checks is an instance considered unhealthy
         * @return {@code this}
         */
        public Builder withUnhealthyThreshold(@javax.annotation.Nullable final java.lang.Number value) {
            this._unhealthyThreshold = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HealthCheck}
         * @throws NullPointerException if any required attribute was not provided
         */
        public HealthCheck build() {
            return new HealthCheck() {
                private java.lang.Number $port = java.util.Objects.requireNonNull(_port, "port is required");
                @javax.annotation.Nullable
                private java.lang.Number $healthyThreshold = _healthyThreshold;
                @javax.annotation.Nullable
                private java.lang.Number $interval = _interval;
                @javax.annotation.Nullable
                private java.lang.String $path = _path;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.ec2.LoadBalancingProtocol $protocol = _protocol;
                @javax.annotation.Nullable
                private java.lang.Number $timeout = _timeout;
                @javax.annotation.Nullable
                private java.lang.Number $unhealthyThreshold = _unhealthyThreshold;

                @Override
                public java.lang.Number getPort() {
                    return this.$port;
                }

                @Override
                public void setPort(final java.lang.Number value) {
                    this.$port = java.util.Objects.requireNonNull(value, "port is required");
                }

                @Override
                public java.lang.Number getHealthyThreshold() {
                    return this.$healthyThreshold;
                }

                @Override
                public void setHealthyThreshold(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$healthyThreshold = value;
                }

                @Override
                public java.lang.Number getInterval() {
                    return this.$interval;
                }

                @Override
                public void setInterval(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$interval = value;
                }

                @Override
                public java.lang.String getPath() {
                    return this.$path;
                }

                @Override
                public void setPath(@javax.annotation.Nullable final java.lang.String value) {
                    this.$path = value;
                }

                @Override
                public software.amazon.awscdk.services.ec2.LoadBalancingProtocol getProtocol() {
                    return this.$protocol;
                }

                @Override
                public void setProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value) {
                    this.$protocol = value;
                }

                @Override
                public java.lang.Number getTimeout() {
                    return this.$timeout;
                }

                @Override
                public void setTimeout(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$timeout = value;
                }

                @Override
                public java.lang.Number getUnhealthyThreshold() {
                    return this.$unhealthyThreshold;
                }

                @Override
                public void setUnhealthyThreshold(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$unhealthyThreshold = value;
                }

            };
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.HealthCheck {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * What port number to health check on
         */
        @Override
        public java.lang.Number getPort() {
            return this.jsiiGet("port", java.lang.Number.class);
        }

        /**
         * What port number to health check on
         */
        @Override
        public void setPort(final java.lang.Number value) {
            this.jsiiSet("port", java.util.Objects.requireNonNull(value, "port is required"));
        }

        /**
         * After how many successful checks is an instance considered healthy
         * @default 2
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getHealthyThreshold() {
            return this.jsiiGet("healthyThreshold", java.lang.Number.class);
        }

        /**
         * After how many successful checks is an instance considered healthy
         * @default 2
         */
        @Override
        public void setHealthyThreshold(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("healthyThreshold", value);
        }

        /**
         * Number of seconds between health checks
         * @default 30
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getInterval() {
            return this.jsiiGet("interval", java.lang.Number.class);
        }

        /**
         * Number of seconds between health checks
         * @default 30
         */
        @Override
        public void setInterval(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("interval", value);
        }

        /**
         * What path to use for HTTP or HTTPS health check (must return 200)
         * 
         * For SSL and TCP health checks, accepting connections is enough to be considered
         * healthy.
         * @default "/"
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getPath() {
            return this.jsiiGet("path", java.lang.String.class);
        }

        /**
         * What path to use for HTTP or HTTPS health check (must return 200)
         * 
         * For SSL and TCP health checks, accepting connections is enough to be considered
         * healthy.
         * @default "/"
         */
        @Override
        public void setPath(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("path", value);
        }

        /**
         * What protocol to use for health checking
         * 
         * The protocol is automatically determined from the port if it's not supplied.
         * @default Automatic
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.LoadBalancingProtocol getProtocol() {
            return this.jsiiGet("protocol", software.amazon.awscdk.services.ec2.LoadBalancingProtocol.class);
        }

        /**
         * What protocol to use for health checking
         * 
         * The protocol is automatically determined from the port if it's not supplied.
         * @default Automatic
         */
        @Override
        public void setProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.LoadBalancingProtocol value) {
            this.jsiiSet("protocol", value);
        }

        /**
         * Health check timeout
         * @default 5
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getTimeout() {
            return this.jsiiGet("timeout", java.lang.Number.class);
        }

        /**
         * Health check timeout
         * @default 5
         */
        @Override
        public void setTimeout(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("timeout", value);
        }

        /**
         * After how many unsuccessful checks is an instance considered unhealthy
         * @default 5
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getUnhealthyThreshold() {
            return this.jsiiGet("unhealthyThreshold", java.lang.Number.class);
        }

        /**
         * After how many unsuccessful checks is an instance considered unhealthy
         * @default 5
         */
        @Override
        public void setUnhealthyThreshold(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("unhealthyThreshold", value);
        }
    }
}
