package software.amazon.awscdk.services.ec2;

/**
 * Creates an Amazon EC2 security group within a VPC.
 * 
 * This class has an additional optimization over SecurityGroupRef that it can also create
 * inline ingress and egress rule (which saves on the total number of resources inside
 * the template).
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.5 (build 845cc48)", date = "2018-09-14T09:16:47.066Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.SecurityGroup")
public class SecurityGroup extends software.amazon.awscdk.services.ec2.SecurityGroupRef {
    protected SecurityGroup(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public SecurityGroup(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.ec2.SecurityGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    @Override
    public void addEgressRule(final software.amazon.awscdk.services.ec2.ISecurityGroupRule peer, final software.amazon.awscdk.services.ec2.IPortRange connection, final java.lang.String description) {
        this.jsiiCall("addEgressRule", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(peer, "peer is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(connection, "connection is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(description, "description is required"))).toArray());
    }

    @Override
    public void addIngressRule(final software.amazon.awscdk.services.ec2.ISecurityGroupRule peer, final software.amazon.awscdk.services.ec2.IPortRange connection, final java.lang.String description) {
        this.jsiiCall("addIngressRule", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(peer, "peer is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(connection, "connection is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(description, "description is required"))).toArray());
    }

    /**
     * An attribute that represents the security group name.
     */
    public software.amazon.awscdk.services.ec2.SecurityGroupName getGroupName() {
        return this.jsiiGet("groupName", software.amazon.awscdk.services.ec2.SecurityGroupName.class);
    }

    /**
     * The ID of the security group
     */
    @Override
    public software.amazon.awscdk.services.ec2.SecurityGroupId getSecurityGroupId() {
        return this.jsiiGet("securityGroupId", software.amazon.awscdk.services.ec2.SecurityGroupId.class);
    }

    /**
     * An attribute that represents the physical VPC ID this security group is part of.
     */
    public software.amazon.awscdk.services.ec2.SecurityGroupVpcId getVpcId() {
        return this.jsiiGet("vpcId", software.amazon.awscdk.services.ec2.SecurityGroupVpcId.class);
    }
}
