/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2.cloudformation;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import software.amazon.awscdk.CloudFormationToken;
import software.amazon.awscdk.Construct;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.ec2.;
import software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResourceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.cloudformation.LaunchTemplateResource")
public class LaunchTemplateResource
extends Resource {
    public static final String RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(LaunchTemplateResource.class, (String)"resourceTypeName", String.class);

    protected LaunchTemplateResource(JsiiObject.InitializationMode mode) {
        super(mode);
    }

    public LaunchTemplateResource(Construct parent, String name, @Nullable LaunchTemplateResourceProps properties) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, Stream.concat(Stream.concat(Stream.of(Objects.requireNonNull(parent, "parent is required")), Stream.of(Objects.requireNonNull(name, "name is required"))), Stream.of(properties)).toArray());
    }

    public LaunchTemplateResource(Construct parent, String name) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, Stream.concat(Stream.of(Objects.requireNonNull(parent, "parent is required")), Stream.of(Objects.requireNonNull(name, "name is required"))).toArray());
    }

    protected Map<String, Object> renderProperties() {
        return (Map)this.jsiiCall("renderProperties", Map.class, new Object[0]);
    }

    public String getLaunchTemplateDefaultVersionNumber() {
        return (String)this.jsiiGet("launchTemplateDefaultVersionNumber", String.class);
    }

    public String getLaunchTemplateId() {
        return (String)this.jsiiGet("launchTemplateId", String.class);
    }

    public String getLaunchTemplateLatestVersionNumber() {
        return (String)this.jsiiGet("launchTemplateLatestVersionNumber", String.class);
    }

    public static interface TagSpecificationProperty
    extends JsiiSerializable {
        public Object getResourceType();

        public void setResourceType(String var1);

        public void setResourceType(CloudFormationToken var1);

        public Object getTags();

        public void setTags(CloudFormationToken var1);

        public void setTags(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _resourceType;
            @Nullable
            private Object _tags;

            public Builder withResourceType(@Nullable String value) {
                this._resourceType = value;
                return this;
            }

            public Builder withResourceType(@Nullable CloudFormationToken value) {
                this._resourceType = value;
                return this;
            }

            public Builder withTags(@Nullable CloudFormationToken value) {
                this._tags = value;
                return this;
            }

            public Builder withTags(@Nullable List<Object> value) {
                this._tags = value;
                return this;
            }

            public TagSpecificationProperty build() {
                return new TagSpecificationProperty(){
                    @Nullable
                    private Object $resourceType;
                    @Nullable
                    private Object $tags;
                    {
                        this.$resourceType = _resourceType;
                        this.$tags = _tags;
                    }

                    @Override
                    public Object getResourceType() {
                        return this.$resourceType;
                    }

                    @Override
                    public void setResourceType(@Nullable String value) {
                        this.$resourceType = value;
                    }

                    @Override
                    public void setResourceType(@Nullable CloudFormationToken value) {
                        this.$resourceType = value;
                    }

                    @Override
                    public Object getTags() {
                        return this.$tags;
                    }

                    @Override
                    public void setTags(@Nullable CloudFormationToken value) {
                        this.$tags = value;
                    }

                    @Override
                    public void setTags(@Nullable List<Object> value) {
                        this.$tags = value;
                    }
                };
            }
        }
    }

    public static interface SpotOptionsProperty
    extends JsiiSerializable {
        public Object getInstanceInterruptionBehavior();

        public void setInstanceInterruptionBehavior(String var1);

        public void setInstanceInterruptionBehavior(CloudFormationToken var1);

        public Object getMaxPrice();

        public void setMaxPrice(String var1);

        public void setMaxPrice(CloudFormationToken var1);

        public Object getSpotInstanceType();

        public void setSpotInstanceType(String var1);

        public void setSpotInstanceType(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _instanceInterruptionBehavior;
            @Nullable
            private Object _maxPrice;
            @Nullable
            private Object _spotInstanceType;

            public Builder withInstanceInterruptionBehavior(@Nullable String value) {
                this._instanceInterruptionBehavior = value;
                return this;
            }

            public Builder withInstanceInterruptionBehavior(@Nullable CloudFormationToken value) {
                this._instanceInterruptionBehavior = value;
                return this;
            }

            public Builder withMaxPrice(@Nullable String value) {
                this._maxPrice = value;
                return this;
            }

            public Builder withMaxPrice(@Nullable CloudFormationToken value) {
                this._maxPrice = value;
                return this;
            }

            public Builder withSpotInstanceType(@Nullable String value) {
                this._spotInstanceType = value;
                return this;
            }

            public Builder withSpotInstanceType(@Nullable CloudFormationToken value) {
                this._spotInstanceType = value;
                return this;
            }

            public SpotOptionsProperty build() {
                return new SpotOptionsProperty(){
                    @Nullable
                    private Object $instanceInterruptionBehavior;
                    @Nullable
                    private Object $maxPrice;
                    @Nullable
                    private Object $spotInstanceType;
                    {
                        this.$instanceInterruptionBehavior = _instanceInterruptionBehavior;
                        this.$maxPrice = _maxPrice;
                        this.$spotInstanceType = _spotInstanceType;
                    }

                    @Override
                    public Object getInstanceInterruptionBehavior() {
                        return this.$instanceInterruptionBehavior;
                    }

                    @Override
                    public void setInstanceInterruptionBehavior(@Nullable String value) {
                        this.$instanceInterruptionBehavior = value;
                    }

                    @Override
                    public void setInstanceInterruptionBehavior(@Nullable CloudFormationToken value) {
                        this.$instanceInterruptionBehavior = value;
                    }

                    @Override
                    public Object getMaxPrice() {
                        return this.$maxPrice;
                    }

                    @Override
                    public void setMaxPrice(@Nullable String value) {
                        this.$maxPrice = value;
                    }

                    @Override
                    public void setMaxPrice(@Nullable CloudFormationToken value) {
                        this.$maxPrice = value;
                    }

                    @Override
                    public Object getSpotInstanceType() {
                        return this.$spotInstanceType;
                    }

                    @Override
                    public void setSpotInstanceType(@Nullable String value) {
                        this.$spotInstanceType = value;
                    }

                    @Override
                    public void setSpotInstanceType(@Nullable CloudFormationToken value) {
                        this.$spotInstanceType = value;
                    }
                };
            }
        }
    }

    public static interface PrivateIpAddProperty
    extends JsiiSerializable {
        public Object getPrimary();

        public void setPrimary(Boolean var1);

        public void setPrimary(CloudFormationToken var1);

        public Object getPrivateIpAddress();

        public void setPrivateIpAddress(String var1);

        public void setPrivateIpAddress(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _primary;
            @Nullable
            private Object _privateIpAddress;

            public Builder withPrimary(@Nullable Boolean value) {
                this._primary = value;
                return this;
            }

            public Builder withPrimary(@Nullable CloudFormationToken value) {
                this._primary = value;
                return this;
            }

            public Builder withPrivateIpAddress(@Nullable String value) {
                this._privateIpAddress = value;
                return this;
            }

            public Builder withPrivateIpAddress(@Nullable CloudFormationToken value) {
                this._privateIpAddress = value;
                return this;
            }

            public PrivateIpAddProperty build() {
                return new PrivateIpAddProperty(){
                    @Nullable
                    private Object $primary;
                    @Nullable
                    private Object $privateIpAddress;
                    {
                        this.$primary = _primary;
                        this.$privateIpAddress = _privateIpAddress;
                    }

                    @Override
                    public Object getPrimary() {
                        return this.$primary;
                    }

                    @Override
                    public void setPrimary(@Nullable Boolean value) {
                        this.$primary = value;
                    }

                    @Override
                    public void setPrimary(@Nullable CloudFormationToken value) {
                        this.$primary = value;
                    }

                    @Override
                    public Object getPrivateIpAddress() {
                        return this.$privateIpAddress;
                    }

                    @Override
                    public void setPrivateIpAddress(@Nullable String value) {
                        this.$privateIpAddress = value;
                    }

                    @Override
                    public void setPrivateIpAddress(@Nullable CloudFormationToken value) {
                        this.$privateIpAddress = value;
                    }
                };
            }
        }
    }

    public static interface PlacementProperty
    extends JsiiSerializable {
        public Object getAffinity();

        public void setAffinity(String var1);

        public void setAffinity(CloudFormationToken var1);

        public Object getAvailabilityZone();

        public void setAvailabilityZone(String var1);

        public void setAvailabilityZone(CloudFormationToken var1);

        public Object getGroupName();

        public void setGroupName(String var1);

        public void setGroupName(CloudFormationToken var1);

        public Object getHostId();

        public void setHostId(String var1);

        public void setHostId(CloudFormationToken var1);

        public Object getTenancy();

        public void setTenancy(String var1);

        public void setTenancy(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _affinity;
            @Nullable
            private Object _availabilityZone;
            @Nullable
            private Object _groupName;
            @Nullable
            private Object _hostId;
            @Nullable
            private Object _tenancy;

            public Builder withAffinity(@Nullable String value) {
                this._affinity = value;
                return this;
            }

            public Builder withAffinity(@Nullable CloudFormationToken value) {
                this._affinity = value;
                return this;
            }

            public Builder withAvailabilityZone(@Nullable String value) {
                this._availabilityZone = value;
                return this;
            }

            public Builder withAvailabilityZone(@Nullable CloudFormationToken value) {
                this._availabilityZone = value;
                return this;
            }

            public Builder withGroupName(@Nullable String value) {
                this._groupName = value;
                return this;
            }

            public Builder withGroupName(@Nullable CloudFormationToken value) {
                this._groupName = value;
                return this;
            }

            public Builder withHostId(@Nullable String value) {
                this._hostId = value;
                return this;
            }

            public Builder withHostId(@Nullable CloudFormationToken value) {
                this._hostId = value;
                return this;
            }

            public Builder withTenancy(@Nullable String value) {
                this._tenancy = value;
                return this;
            }

            public Builder withTenancy(@Nullable CloudFormationToken value) {
                this._tenancy = value;
                return this;
            }

            public PlacementProperty build() {
                return new PlacementProperty(){
                    @Nullable
                    private Object $affinity;
                    @Nullable
                    private Object $availabilityZone;
                    @Nullable
                    private Object $groupName;
                    @Nullable
                    private Object $hostId;
                    @Nullable
                    private Object $tenancy;
                    {
                        this.$affinity = _affinity;
                        this.$availabilityZone = _availabilityZone;
                        this.$groupName = _groupName;
                        this.$hostId = _hostId;
                        this.$tenancy = _tenancy;
                    }

                    @Override
                    public Object getAffinity() {
                        return this.$affinity;
                    }

                    @Override
                    public void setAffinity(@Nullable String value) {
                        this.$affinity = value;
                    }

                    @Override
                    public void setAffinity(@Nullable CloudFormationToken value) {
                        this.$affinity = value;
                    }

                    @Override
                    public Object getAvailabilityZone() {
                        return this.$availabilityZone;
                    }

                    @Override
                    public void setAvailabilityZone(@Nullable String value) {
                        this.$availabilityZone = value;
                    }

                    @Override
                    public void setAvailabilityZone(@Nullable CloudFormationToken value) {
                        this.$availabilityZone = value;
                    }

                    @Override
                    public Object getGroupName() {
                        return this.$groupName;
                    }

                    @Override
                    public void setGroupName(@Nullable String value) {
                        this.$groupName = value;
                    }

                    @Override
                    public void setGroupName(@Nullable CloudFormationToken value) {
                        this.$groupName = value;
                    }

                    @Override
                    public Object getHostId() {
                        return this.$hostId;
                    }

                    @Override
                    public void setHostId(@Nullable String value) {
                        this.$hostId = value;
                    }

                    @Override
                    public void setHostId(@Nullable CloudFormationToken value) {
                        this.$hostId = value;
                    }

                    @Override
                    public Object getTenancy() {
                        return this.$tenancy;
                    }

                    @Override
                    public void setTenancy(@Nullable String value) {
                        this.$tenancy = value;
                    }

                    @Override
                    public void setTenancy(@Nullable CloudFormationToken value) {
                        this.$tenancy = value;
                    }
                };
            }
        }
    }

    public static interface NetworkInterfaceProperty
    extends JsiiSerializable {
        public Object getAssociatePublicIpAddress();

        public void setAssociatePublicIpAddress(Boolean var1);

        public void setAssociatePublicIpAddress(CloudFormationToken var1);

        public Object getDeleteOnTermination();

        public void setDeleteOnTermination(Boolean var1);

        public void setDeleteOnTermination(CloudFormationToken var1);

        public Object getDescription();

        public void setDescription(String var1);

        public void setDescription(CloudFormationToken var1);

        public Object getDeviceIndex();

        public void setDeviceIndex(Number var1);

        public void setDeviceIndex(CloudFormationToken var1);

        public Object getGroups();

        public void setGroups(CloudFormationToken var1);

        public void setGroups(List<Object> var1);

        public Object getIpv6AddressCount();

        public void setIpv6AddressCount(Number var1);

        public void setIpv6AddressCount(CloudFormationToken var1);

        public Object getIpv6Addresses();

        public void setIpv6Addresses(CloudFormationToken var1);

        public void setIpv6Addresses(List<Object> var1);

        public Object getNetworkInterfaceId();

        public void setNetworkInterfaceId(String var1);

        public void setNetworkInterfaceId(CloudFormationToken var1);

        public Object getPrivateIpAddress();

        public void setPrivateIpAddress(String var1);

        public void setPrivateIpAddress(CloudFormationToken var1);

        public Object getPrivateIpAddresses();

        public void setPrivateIpAddresses(CloudFormationToken var1);

        public void setPrivateIpAddresses(List<Object> var1);

        public Object getSecondaryPrivateIpAddressCount();

        public void setSecondaryPrivateIpAddressCount(Number var1);

        public void setSecondaryPrivateIpAddressCount(CloudFormationToken var1);

        public Object getSubnetId();

        public void setSubnetId(String var1);

        public void setSubnetId(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _associatePublicIpAddress;
            @Nullable
            private Object _deleteOnTermination;
            @Nullable
            private Object _description;
            @Nullable
            private Object _deviceIndex;
            @Nullable
            private Object _groups;
            @Nullable
            private Object _ipv6AddressCount;
            @Nullable
            private Object _ipv6Addresses;
            @Nullable
            private Object _networkInterfaceId;
            @Nullable
            private Object _privateIpAddress;
            @Nullable
            private Object _privateIpAddresses;
            @Nullable
            private Object _secondaryPrivateIpAddressCount;
            @Nullable
            private Object _subnetId;

            public Builder withAssociatePublicIpAddress(@Nullable Boolean value) {
                this._associatePublicIpAddress = value;
                return this;
            }

            public Builder withAssociatePublicIpAddress(@Nullable CloudFormationToken value) {
                this._associatePublicIpAddress = value;
                return this;
            }

            public Builder withDeleteOnTermination(@Nullable Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }

            public Builder withDeleteOnTermination(@Nullable CloudFormationToken value) {
                this._deleteOnTermination = value;
                return this;
            }

            public Builder withDescription(@Nullable String value) {
                this._description = value;
                return this;
            }

            public Builder withDescription(@Nullable CloudFormationToken value) {
                this._description = value;
                return this;
            }

            public Builder withDeviceIndex(@Nullable Number value) {
                this._deviceIndex = value;
                return this;
            }

            public Builder withDeviceIndex(@Nullable CloudFormationToken value) {
                this._deviceIndex = value;
                return this;
            }

            public Builder withGroups(@Nullable CloudFormationToken value) {
                this._groups = value;
                return this;
            }

            public Builder withGroups(@Nullable List<Object> value) {
                this._groups = value;
                return this;
            }

            public Builder withIpv6AddressCount(@Nullable Number value) {
                this._ipv6AddressCount = value;
                return this;
            }

            public Builder withIpv6AddressCount(@Nullable CloudFormationToken value) {
                this._ipv6AddressCount = value;
                return this;
            }

            public Builder withIpv6Addresses(@Nullable CloudFormationToken value) {
                this._ipv6Addresses = value;
                return this;
            }

            public Builder withIpv6Addresses(@Nullable List<Object> value) {
                this._ipv6Addresses = value;
                return this;
            }

            public Builder withNetworkInterfaceId(@Nullable String value) {
                this._networkInterfaceId = value;
                return this;
            }

            public Builder withNetworkInterfaceId(@Nullable CloudFormationToken value) {
                this._networkInterfaceId = value;
                return this;
            }

            public Builder withPrivateIpAddress(@Nullable String value) {
                this._privateIpAddress = value;
                return this;
            }

            public Builder withPrivateIpAddress(@Nullable CloudFormationToken value) {
                this._privateIpAddress = value;
                return this;
            }

            public Builder withPrivateIpAddresses(@Nullable CloudFormationToken value) {
                this._privateIpAddresses = value;
                return this;
            }

            public Builder withPrivateIpAddresses(@Nullable List<Object> value) {
                this._privateIpAddresses = value;
                return this;
            }

            public Builder withSecondaryPrivateIpAddressCount(@Nullable Number value) {
                this._secondaryPrivateIpAddressCount = value;
                return this;
            }

            public Builder withSecondaryPrivateIpAddressCount(@Nullable CloudFormationToken value) {
                this._secondaryPrivateIpAddressCount = value;
                return this;
            }

            public Builder withSubnetId(@Nullable String value) {
                this._subnetId = value;
                return this;
            }

            public Builder withSubnetId(@Nullable CloudFormationToken value) {
                this._subnetId = value;
                return this;
            }

            public NetworkInterfaceProperty build() {
                return new NetworkInterfaceProperty(){
                    @Nullable
                    private Object $associatePublicIpAddress;
                    @Nullable
                    private Object $deleteOnTermination;
                    @Nullable
                    private Object $description;
                    @Nullable
                    private Object $deviceIndex;
                    @Nullable
                    private Object $groups;
                    @Nullable
                    private Object $ipv6AddressCount;
                    @Nullable
                    private Object $ipv6Addresses;
                    @Nullable
                    private Object $networkInterfaceId;
                    @Nullable
                    private Object $privateIpAddress;
                    @Nullable
                    private Object $privateIpAddresses;
                    @Nullable
                    private Object $secondaryPrivateIpAddressCount;
                    @Nullable
                    private Object $subnetId;
                    {
                        this.$associatePublicIpAddress = _associatePublicIpAddress;
                        this.$deleteOnTermination = _deleteOnTermination;
                        this.$description = _description;
                        this.$deviceIndex = _deviceIndex;
                        this.$groups = _groups;
                        this.$ipv6AddressCount = _ipv6AddressCount;
                        this.$ipv6Addresses = _ipv6Addresses;
                        this.$networkInterfaceId = _networkInterfaceId;
                        this.$privateIpAddress = _privateIpAddress;
                        this.$privateIpAddresses = _privateIpAddresses;
                        this.$secondaryPrivateIpAddressCount = _secondaryPrivateIpAddressCount;
                        this.$subnetId = _subnetId;
                    }

                    @Override
                    public Object getAssociatePublicIpAddress() {
                        return this.$associatePublicIpAddress;
                    }

                    @Override
                    public void setAssociatePublicIpAddress(@Nullable Boolean value) {
                        this.$associatePublicIpAddress = value;
                    }

                    @Override
                    public void setAssociatePublicIpAddress(@Nullable CloudFormationToken value) {
                        this.$associatePublicIpAddress = value;
                    }

                    @Override
                    public Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public void setDeleteOnTermination(@Nullable Boolean value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public void setDeleteOnTermination(@Nullable CloudFormationToken value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public Object getDescription() {
                        return this.$description;
                    }

                    @Override
                    public void setDescription(@Nullable String value) {
                        this.$description = value;
                    }

                    @Override
                    public void setDescription(@Nullable CloudFormationToken value) {
                        this.$description = value;
                    }

                    @Override
                    public Object getDeviceIndex() {
                        return this.$deviceIndex;
                    }

                    @Override
                    public void setDeviceIndex(@Nullable Number value) {
                        this.$deviceIndex = value;
                    }

                    @Override
                    public void setDeviceIndex(@Nullable CloudFormationToken value) {
                        this.$deviceIndex = value;
                    }

                    @Override
                    public Object getGroups() {
                        return this.$groups;
                    }

                    @Override
                    public void setGroups(@Nullable CloudFormationToken value) {
                        this.$groups = value;
                    }

                    @Override
                    public void setGroups(@Nullable List<Object> value) {
                        this.$groups = value;
                    }

                    @Override
                    public Object getIpv6AddressCount() {
                        return this.$ipv6AddressCount;
                    }

                    @Override
                    public void setIpv6AddressCount(@Nullable Number value) {
                        this.$ipv6AddressCount = value;
                    }

                    @Override
                    public void setIpv6AddressCount(@Nullable CloudFormationToken value) {
                        this.$ipv6AddressCount = value;
                    }

                    @Override
                    public Object getIpv6Addresses() {
                        return this.$ipv6Addresses;
                    }

                    @Override
                    public void setIpv6Addresses(@Nullable CloudFormationToken value) {
                        this.$ipv6Addresses = value;
                    }

                    @Override
                    public void setIpv6Addresses(@Nullable List<Object> value) {
                        this.$ipv6Addresses = value;
                    }

                    @Override
                    public Object getNetworkInterfaceId() {
                        return this.$networkInterfaceId;
                    }

                    @Override
                    public void setNetworkInterfaceId(@Nullable String value) {
                        this.$networkInterfaceId = value;
                    }

                    @Override
                    public void setNetworkInterfaceId(@Nullable CloudFormationToken value) {
                        this.$networkInterfaceId = value;
                    }

                    @Override
                    public Object getPrivateIpAddress() {
                        return this.$privateIpAddress;
                    }

                    @Override
                    public void setPrivateIpAddress(@Nullable String value) {
                        this.$privateIpAddress = value;
                    }

                    @Override
                    public void setPrivateIpAddress(@Nullable CloudFormationToken value) {
                        this.$privateIpAddress = value;
                    }

                    @Override
                    public Object getPrivateIpAddresses() {
                        return this.$privateIpAddresses;
                    }

                    @Override
                    public void setPrivateIpAddresses(@Nullable CloudFormationToken value) {
                        this.$privateIpAddresses = value;
                    }

                    @Override
                    public void setPrivateIpAddresses(@Nullable List<Object> value) {
                        this.$privateIpAddresses = value;
                    }

                    @Override
                    public Object getSecondaryPrivateIpAddressCount() {
                        return this.$secondaryPrivateIpAddressCount;
                    }

                    @Override
                    public void setSecondaryPrivateIpAddressCount(@Nullable Number value) {
                        this.$secondaryPrivateIpAddressCount = value;
                    }

                    @Override
                    public void setSecondaryPrivateIpAddressCount(@Nullable CloudFormationToken value) {
                        this.$secondaryPrivateIpAddressCount = value;
                    }

                    @Override
                    public Object getSubnetId() {
                        return this.$subnetId;
                    }

                    @Override
                    public void setSubnetId(@Nullable String value) {
                        this.$subnetId = value;
                    }

                    @Override
                    public void setSubnetId(@Nullable CloudFormationToken value) {
                        this.$subnetId = value;
                    }
                };
            }
        }
    }

    public static interface MonitoringProperty
    extends JsiiSerializable {
        public Object getEnabled();

        public void setEnabled(Boolean var1);

        public void setEnabled(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _enabled;

            public Builder withEnabled(@Nullable Boolean value) {
                this._enabled = value;
                return this;
            }

            public Builder withEnabled(@Nullable CloudFormationToken value) {
                this._enabled = value;
                return this;
            }

            public MonitoringProperty build() {
                return new MonitoringProperty(){
                    @Nullable
                    private Object $enabled;
                    {
                        this.$enabled = _enabled;
                    }

                    @Override
                    public Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public void setEnabled(@Nullable Boolean value) {
                        this.$enabled = value;
                    }

                    @Override
                    public void setEnabled(@Nullable CloudFormationToken value) {
                        this.$enabled = value;
                    }
                };
            }
        }
    }

    public static interface LaunchTemplateDataProperty
    extends JsiiSerializable {
        public Object getBlockDeviceMappings();

        public void setBlockDeviceMappings(CloudFormationToken var1);

        public void setBlockDeviceMappings(List<Object> var1);

        public Object getCreditSpecification();

        public void setCreditSpecification(CloudFormationToken var1);

        public void setCreditSpecification(CreditSpecificationProperty var1);

        public Object getDisableApiTermination();

        public void setDisableApiTermination(Boolean var1);

        public void setDisableApiTermination(CloudFormationToken var1);

        public Object getEbsOptimized();

        public void setEbsOptimized(Boolean var1);

        public void setEbsOptimized(CloudFormationToken var1);

        public Object getElasticGpuSpecifications();

        public void setElasticGpuSpecifications(CloudFormationToken var1);

        public void setElasticGpuSpecifications(List<Object> var1);

        public Object getIamInstanceProfile();

        public void setIamInstanceProfile(CloudFormationToken var1);

        public void setIamInstanceProfile(IamInstanceProfileProperty var1);

        public Object getImageId();

        public void setImageId(String var1);

        public void setImageId(CloudFormationToken var1);

        public Object getInstanceInitiatedShutdownBehavior();

        public void setInstanceInitiatedShutdownBehavior(String var1);

        public void setInstanceInitiatedShutdownBehavior(CloudFormationToken var1);

        public Object getInstanceMarketOptions();

        public void setInstanceMarketOptions(CloudFormationToken var1);

        public void setInstanceMarketOptions(InstanceMarketOptionsProperty var1);

        public Object getInstanceType();

        public void setInstanceType(String var1);

        public void setInstanceType(CloudFormationToken var1);

        public Object getKernelId();

        public void setKernelId(String var1);

        public void setKernelId(CloudFormationToken var1);

        public Object getKeyName();

        public void setKeyName(String var1);

        public void setKeyName(CloudFormationToken var1);

        public Object getMonitoring();

        public void setMonitoring(CloudFormationToken var1);

        public void setMonitoring(MonitoringProperty var1);

        public Object getNetworkInterfaces();

        public void setNetworkInterfaces(CloudFormationToken var1);

        public void setNetworkInterfaces(List<Object> var1);

        public Object getPlacement();

        public void setPlacement(CloudFormationToken var1);

        public void setPlacement(PlacementProperty var1);

        public Object getRamDiskId();

        public void setRamDiskId(String var1);

        public void setRamDiskId(CloudFormationToken var1);

        public Object getSecurityGroupIds();

        public void setSecurityGroupIds(CloudFormationToken var1);

        public void setSecurityGroupIds(List<Object> var1);

        public Object getSecurityGroups();

        public void setSecurityGroups(CloudFormationToken var1);

        public void setSecurityGroups(List<Object> var1);

        public Object getTagSpecifications();

        public void setTagSpecifications(CloudFormationToken var1);

        public void setTagSpecifications(List<Object> var1);

        public Object getUserData();

        public void setUserData(String var1);

        public void setUserData(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _blockDeviceMappings;
            @Nullable
            private Object _creditSpecification;
            @Nullable
            private Object _disableApiTermination;
            @Nullable
            private Object _ebsOptimized;
            @Nullable
            private Object _elasticGpuSpecifications;
            @Nullable
            private Object _iamInstanceProfile;
            @Nullable
            private Object _imageId;
            @Nullable
            private Object _instanceInitiatedShutdownBehavior;
            @Nullable
            private Object _instanceMarketOptions;
            @Nullable
            private Object _instanceType;
            @Nullable
            private Object _kernelId;
            @Nullable
            private Object _keyName;
            @Nullable
            private Object _monitoring;
            @Nullable
            private Object _networkInterfaces;
            @Nullable
            private Object _placement;
            @Nullable
            private Object _ramDiskId;
            @Nullable
            private Object _securityGroupIds;
            @Nullable
            private Object _securityGroups;
            @Nullable
            private Object _tagSpecifications;
            @Nullable
            private Object _userData;

            public Builder withBlockDeviceMappings(@Nullable CloudFormationToken value) {
                this._blockDeviceMappings = value;
                return this;
            }

            public Builder withBlockDeviceMappings(@Nullable List<Object> value) {
                this._blockDeviceMappings = value;
                return this;
            }

            public Builder withCreditSpecification(@Nullable CloudFormationToken value) {
                this._creditSpecification = value;
                return this;
            }

            public Builder withCreditSpecification(@Nullable CreditSpecificationProperty value) {
                this._creditSpecification = value;
                return this;
            }

            public Builder withDisableApiTermination(@Nullable Boolean value) {
                this._disableApiTermination = value;
                return this;
            }

            public Builder withDisableApiTermination(@Nullable CloudFormationToken value) {
                this._disableApiTermination = value;
                return this;
            }

            public Builder withEbsOptimized(@Nullable Boolean value) {
                this._ebsOptimized = value;
                return this;
            }

            public Builder withEbsOptimized(@Nullable CloudFormationToken value) {
                this._ebsOptimized = value;
                return this;
            }

            public Builder withElasticGpuSpecifications(@Nullable CloudFormationToken value) {
                this._elasticGpuSpecifications = value;
                return this;
            }

            public Builder withElasticGpuSpecifications(@Nullable List<Object> value) {
                this._elasticGpuSpecifications = value;
                return this;
            }

            public Builder withIamInstanceProfile(@Nullable CloudFormationToken value) {
                this._iamInstanceProfile = value;
                return this;
            }

            public Builder withIamInstanceProfile(@Nullable IamInstanceProfileProperty value) {
                this._iamInstanceProfile = value;
                return this;
            }

            public Builder withImageId(@Nullable String value) {
                this._imageId = value;
                return this;
            }

            public Builder withImageId(@Nullable CloudFormationToken value) {
                this._imageId = value;
                return this;
            }

            public Builder withInstanceInitiatedShutdownBehavior(@Nullable String value) {
                this._instanceInitiatedShutdownBehavior = value;
                return this;
            }

            public Builder withInstanceInitiatedShutdownBehavior(@Nullable CloudFormationToken value) {
                this._instanceInitiatedShutdownBehavior = value;
                return this;
            }

            public Builder withInstanceMarketOptions(@Nullable CloudFormationToken value) {
                this._instanceMarketOptions = value;
                return this;
            }

            public Builder withInstanceMarketOptions(@Nullable InstanceMarketOptionsProperty value) {
                this._instanceMarketOptions = value;
                return this;
            }

            public Builder withInstanceType(@Nullable String value) {
                this._instanceType = value;
                return this;
            }

            public Builder withInstanceType(@Nullable CloudFormationToken value) {
                this._instanceType = value;
                return this;
            }

            public Builder withKernelId(@Nullable String value) {
                this._kernelId = value;
                return this;
            }

            public Builder withKernelId(@Nullable CloudFormationToken value) {
                this._kernelId = value;
                return this;
            }

            public Builder withKeyName(@Nullable String value) {
                this._keyName = value;
                return this;
            }

            public Builder withKeyName(@Nullable CloudFormationToken value) {
                this._keyName = value;
                return this;
            }

            public Builder withMonitoring(@Nullable CloudFormationToken value) {
                this._monitoring = value;
                return this;
            }

            public Builder withMonitoring(@Nullable MonitoringProperty value) {
                this._monitoring = value;
                return this;
            }

            public Builder withNetworkInterfaces(@Nullable CloudFormationToken value) {
                this._networkInterfaces = value;
                return this;
            }

            public Builder withNetworkInterfaces(@Nullable List<Object> value) {
                this._networkInterfaces = value;
                return this;
            }

            public Builder withPlacement(@Nullable CloudFormationToken value) {
                this._placement = value;
                return this;
            }

            public Builder withPlacement(@Nullable PlacementProperty value) {
                this._placement = value;
                return this;
            }

            public Builder withRamDiskId(@Nullable String value) {
                this._ramDiskId = value;
                return this;
            }

            public Builder withRamDiskId(@Nullable CloudFormationToken value) {
                this._ramDiskId = value;
                return this;
            }

            public Builder withSecurityGroupIds(@Nullable CloudFormationToken value) {
                this._securityGroupIds = value;
                return this;
            }

            public Builder withSecurityGroupIds(@Nullable List<Object> value) {
                this._securityGroupIds = value;
                return this;
            }

            public Builder withSecurityGroups(@Nullable CloudFormationToken value) {
                this._securityGroups = value;
                return this;
            }

            public Builder withSecurityGroups(@Nullable List<Object> value) {
                this._securityGroups = value;
                return this;
            }

            public Builder withTagSpecifications(@Nullable CloudFormationToken value) {
                this._tagSpecifications = value;
                return this;
            }

            public Builder withTagSpecifications(@Nullable List<Object> value) {
                this._tagSpecifications = value;
                return this;
            }

            public Builder withUserData(@Nullable String value) {
                this._userData = value;
                return this;
            }

            public Builder withUserData(@Nullable CloudFormationToken value) {
                this._userData = value;
                return this;
            }

            public LaunchTemplateDataProperty build() {
                return new LaunchTemplateDataProperty(){
                    @Nullable
                    private Object $blockDeviceMappings;
                    @Nullable
                    private Object $creditSpecification;
                    @Nullable
                    private Object $disableApiTermination;
                    @Nullable
                    private Object $ebsOptimized;
                    @Nullable
                    private Object $elasticGpuSpecifications;
                    @Nullable
                    private Object $iamInstanceProfile;
                    @Nullable
                    private Object $imageId;
                    @Nullable
                    private Object $instanceInitiatedShutdownBehavior;
                    @Nullable
                    private Object $instanceMarketOptions;
                    @Nullable
                    private Object $instanceType;
                    @Nullable
                    private Object $kernelId;
                    @Nullable
                    private Object $keyName;
                    @Nullable
                    private Object $monitoring;
                    @Nullable
                    private Object $networkInterfaces;
                    @Nullable
                    private Object $placement;
                    @Nullable
                    private Object $ramDiskId;
                    @Nullable
                    private Object $securityGroupIds;
                    @Nullable
                    private Object $securityGroups;
                    @Nullable
                    private Object $tagSpecifications;
                    @Nullable
                    private Object $userData;
                    {
                        this.$blockDeviceMappings = _blockDeviceMappings;
                        this.$creditSpecification = _creditSpecification;
                        this.$disableApiTermination = _disableApiTermination;
                        this.$ebsOptimized = _ebsOptimized;
                        this.$elasticGpuSpecifications = _elasticGpuSpecifications;
                        this.$iamInstanceProfile = _iamInstanceProfile;
                        this.$imageId = _imageId;
                        this.$instanceInitiatedShutdownBehavior = _instanceInitiatedShutdownBehavior;
                        this.$instanceMarketOptions = _instanceMarketOptions;
                        this.$instanceType = _instanceType;
                        this.$kernelId = _kernelId;
                        this.$keyName = _keyName;
                        this.$monitoring = _monitoring;
                        this.$networkInterfaces = _networkInterfaces;
                        this.$placement = _placement;
                        this.$ramDiskId = _ramDiskId;
                        this.$securityGroupIds = _securityGroupIds;
                        this.$securityGroups = _securityGroups;
                        this.$tagSpecifications = _tagSpecifications;
                        this.$userData = _userData;
                    }

                    @Override
                    public Object getBlockDeviceMappings() {
                        return this.$blockDeviceMappings;
                    }

                    @Override
                    public void setBlockDeviceMappings(@Nullable CloudFormationToken value) {
                        this.$blockDeviceMappings = value;
                    }

                    @Override
                    public void setBlockDeviceMappings(@Nullable List<Object> value) {
                        this.$blockDeviceMappings = value;
                    }

                    @Override
                    public Object getCreditSpecification() {
                        return this.$creditSpecification;
                    }

                    @Override
                    public void setCreditSpecification(@Nullable CloudFormationToken value) {
                        this.$creditSpecification = value;
                    }

                    @Override
                    public void setCreditSpecification(@Nullable CreditSpecificationProperty value) {
                        this.$creditSpecification = value;
                    }

                    @Override
                    public Object getDisableApiTermination() {
                        return this.$disableApiTermination;
                    }

                    @Override
                    public void setDisableApiTermination(@Nullable Boolean value) {
                        this.$disableApiTermination = value;
                    }

                    @Override
                    public void setDisableApiTermination(@Nullable CloudFormationToken value) {
                        this.$disableApiTermination = value;
                    }

                    @Override
                    public Object getEbsOptimized() {
                        return this.$ebsOptimized;
                    }

                    @Override
                    public void setEbsOptimized(@Nullable Boolean value) {
                        this.$ebsOptimized = value;
                    }

                    @Override
                    public void setEbsOptimized(@Nullable CloudFormationToken value) {
                        this.$ebsOptimized = value;
                    }

                    @Override
                    public Object getElasticGpuSpecifications() {
                        return this.$elasticGpuSpecifications;
                    }

                    @Override
                    public void setElasticGpuSpecifications(@Nullable CloudFormationToken value) {
                        this.$elasticGpuSpecifications = value;
                    }

                    @Override
                    public void setElasticGpuSpecifications(@Nullable List<Object> value) {
                        this.$elasticGpuSpecifications = value;
                    }

                    @Override
                    public Object getIamInstanceProfile() {
                        return this.$iamInstanceProfile;
                    }

                    @Override
                    public void setIamInstanceProfile(@Nullable CloudFormationToken value) {
                        this.$iamInstanceProfile = value;
                    }

                    @Override
                    public void setIamInstanceProfile(@Nullable IamInstanceProfileProperty value) {
                        this.$iamInstanceProfile = value;
                    }

                    @Override
                    public Object getImageId() {
                        return this.$imageId;
                    }

                    @Override
                    public void setImageId(@Nullable String value) {
                        this.$imageId = value;
                    }

                    @Override
                    public void setImageId(@Nullable CloudFormationToken value) {
                        this.$imageId = value;
                    }

                    @Override
                    public Object getInstanceInitiatedShutdownBehavior() {
                        return this.$instanceInitiatedShutdownBehavior;
                    }

                    @Override
                    public void setInstanceInitiatedShutdownBehavior(@Nullable String value) {
                        this.$instanceInitiatedShutdownBehavior = value;
                    }

                    @Override
                    public void setInstanceInitiatedShutdownBehavior(@Nullable CloudFormationToken value) {
                        this.$instanceInitiatedShutdownBehavior = value;
                    }

                    @Override
                    public Object getInstanceMarketOptions() {
                        return this.$instanceMarketOptions;
                    }

                    @Override
                    public void setInstanceMarketOptions(@Nullable CloudFormationToken value) {
                        this.$instanceMarketOptions = value;
                    }

                    @Override
                    public void setInstanceMarketOptions(@Nullable InstanceMarketOptionsProperty value) {
                        this.$instanceMarketOptions = value;
                    }

                    @Override
                    public Object getInstanceType() {
                        return this.$instanceType;
                    }

                    @Override
                    public void setInstanceType(@Nullable String value) {
                        this.$instanceType = value;
                    }

                    @Override
                    public void setInstanceType(@Nullable CloudFormationToken value) {
                        this.$instanceType = value;
                    }

                    @Override
                    public Object getKernelId() {
                        return this.$kernelId;
                    }

                    @Override
                    public void setKernelId(@Nullable String value) {
                        this.$kernelId = value;
                    }

                    @Override
                    public void setKernelId(@Nullable CloudFormationToken value) {
                        this.$kernelId = value;
                    }

                    @Override
                    public Object getKeyName() {
                        return this.$keyName;
                    }

                    @Override
                    public void setKeyName(@Nullable String value) {
                        this.$keyName = value;
                    }

                    @Override
                    public void setKeyName(@Nullable CloudFormationToken value) {
                        this.$keyName = value;
                    }

                    @Override
                    public Object getMonitoring() {
                        return this.$monitoring;
                    }

                    @Override
                    public void setMonitoring(@Nullable CloudFormationToken value) {
                        this.$monitoring = value;
                    }

                    @Override
                    public void setMonitoring(@Nullable MonitoringProperty value) {
                        this.$monitoring = value;
                    }

                    @Override
                    public Object getNetworkInterfaces() {
                        return this.$networkInterfaces;
                    }

                    @Override
                    public void setNetworkInterfaces(@Nullable CloudFormationToken value) {
                        this.$networkInterfaces = value;
                    }

                    @Override
                    public void setNetworkInterfaces(@Nullable List<Object> value) {
                        this.$networkInterfaces = value;
                    }

                    @Override
                    public Object getPlacement() {
                        return this.$placement;
                    }

                    @Override
                    public void setPlacement(@Nullable CloudFormationToken value) {
                        this.$placement = value;
                    }

                    @Override
                    public void setPlacement(@Nullable PlacementProperty value) {
                        this.$placement = value;
                    }

                    @Override
                    public Object getRamDiskId() {
                        return this.$ramDiskId;
                    }

                    @Override
                    public void setRamDiskId(@Nullable String value) {
                        this.$ramDiskId = value;
                    }

                    @Override
                    public void setRamDiskId(@Nullable CloudFormationToken value) {
                        this.$ramDiskId = value;
                    }

                    @Override
                    public Object getSecurityGroupIds() {
                        return this.$securityGroupIds;
                    }

                    @Override
                    public void setSecurityGroupIds(@Nullable CloudFormationToken value) {
                        this.$securityGroupIds = value;
                    }

                    @Override
                    public void setSecurityGroupIds(@Nullable List<Object> value) {
                        this.$securityGroupIds = value;
                    }

                    @Override
                    public Object getSecurityGroups() {
                        return this.$securityGroups;
                    }

                    @Override
                    public void setSecurityGroups(@Nullable CloudFormationToken value) {
                        this.$securityGroups = value;
                    }

                    @Override
                    public void setSecurityGroups(@Nullable List<Object> value) {
                        this.$securityGroups = value;
                    }

                    @Override
                    public Object getTagSpecifications() {
                        return this.$tagSpecifications;
                    }

                    @Override
                    public void setTagSpecifications(@Nullable CloudFormationToken value) {
                        this.$tagSpecifications = value;
                    }

                    @Override
                    public void setTagSpecifications(@Nullable List<Object> value) {
                        this.$tagSpecifications = value;
                    }

                    @Override
                    public Object getUserData() {
                        return this.$userData;
                    }

                    @Override
                    public void setUserData(@Nullable String value) {
                        this.$userData = value;
                    }

                    @Override
                    public void setUserData(@Nullable CloudFormationToken value) {
                        this.$userData = value;
                    }
                };
            }
        }
    }

    public static interface Ipv6AddProperty
    extends JsiiSerializable {
        public Object getIpv6Address();

        public void setIpv6Address(String var1);

        public void setIpv6Address(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _ipv6Address;

            public Builder withIpv6Address(@Nullable String value) {
                this._ipv6Address = value;
                return this;
            }

            public Builder withIpv6Address(@Nullable CloudFormationToken value) {
                this._ipv6Address = value;
                return this;
            }

            public Ipv6AddProperty build() {
                return new Ipv6AddProperty(){
                    @Nullable
                    private Object $ipv6Address;
                    {
                        this.$ipv6Address = _ipv6Address;
                    }

                    @Override
                    public Object getIpv6Address() {
                        return this.$ipv6Address;
                    }

                    @Override
                    public void setIpv6Address(@Nullable String value) {
                        this.$ipv6Address = value;
                    }

                    @Override
                    public void setIpv6Address(@Nullable CloudFormationToken value) {
                        this.$ipv6Address = value;
                    }
                };
            }
        }
    }

    public static interface InstanceMarketOptionsProperty
    extends JsiiSerializable {
        public Object getMarketType();

        public void setMarketType(String var1);

        public void setMarketType(CloudFormationToken var1);

        public Object getSpotOptions();

        public void setSpotOptions(CloudFormationToken var1);

        public void setSpotOptions(SpotOptionsProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _marketType;
            @Nullable
            private Object _spotOptions;

            public Builder withMarketType(@Nullable String value) {
                this._marketType = value;
                return this;
            }

            public Builder withMarketType(@Nullable CloudFormationToken value) {
                this._marketType = value;
                return this;
            }

            public Builder withSpotOptions(@Nullable CloudFormationToken value) {
                this._spotOptions = value;
                return this;
            }

            public Builder withSpotOptions(@Nullable SpotOptionsProperty value) {
                this._spotOptions = value;
                return this;
            }

            public InstanceMarketOptionsProperty build() {
                return new InstanceMarketOptionsProperty(){
                    @Nullable
                    private Object $marketType;
                    @Nullable
                    private Object $spotOptions;
                    {
                        this.$marketType = _marketType;
                        this.$spotOptions = _spotOptions;
                    }

                    @Override
                    public Object getMarketType() {
                        return this.$marketType;
                    }

                    @Override
                    public void setMarketType(@Nullable String value) {
                        this.$marketType = value;
                    }

                    @Override
                    public void setMarketType(@Nullable CloudFormationToken value) {
                        this.$marketType = value;
                    }

                    @Override
                    public Object getSpotOptions() {
                        return this.$spotOptions;
                    }

                    @Override
                    public void setSpotOptions(@Nullable CloudFormationToken value) {
                        this.$spotOptions = value;
                    }

                    @Override
                    public void setSpotOptions(@Nullable SpotOptionsProperty value) {
                        this.$spotOptions = value;
                    }
                };
            }
        }
    }

    public static interface IamInstanceProfileProperty
    extends JsiiSerializable {
        public Object getArn();

        public void setArn(String var1);

        public void setArn(CloudFormationToken var1);

        public Object getName();

        public void setName(String var1);

        public void setName(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _arn;
            @Nullable
            private Object _name;

            public Builder withArn(@Nullable String value) {
                this._arn = value;
                return this;
            }

            public Builder withArn(@Nullable CloudFormationToken value) {
                this._arn = value;
                return this;
            }

            public Builder withName(@Nullable String value) {
                this._name = value;
                return this;
            }

            public Builder withName(@Nullable CloudFormationToken value) {
                this._name = value;
                return this;
            }

            public IamInstanceProfileProperty build() {
                return new IamInstanceProfileProperty(){
                    @Nullable
                    private Object $arn;
                    @Nullable
                    private Object $name;
                    {
                        this.$arn = _arn;
                        this.$name = _name;
                    }

                    @Override
                    public Object getArn() {
                        return this.$arn;
                    }

                    @Override
                    public void setArn(@Nullable String value) {
                        this.$arn = value;
                    }

                    @Override
                    public void setArn(@Nullable CloudFormationToken value) {
                        this.$arn = value;
                    }

                    @Override
                    public Object getName() {
                        return this.$name;
                    }

                    @Override
                    public void setName(@Nullable String value) {
                        this.$name = value;
                    }

                    @Override
                    public void setName(@Nullable CloudFormationToken value) {
                        this.$name = value;
                    }
                };
            }
        }
    }

    public static interface ElasticGpuSpecificationProperty
    extends JsiiSerializable {
        public Object getType();

        public void setType(String var1);

        public void setType(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _type;

            public Builder withType(@Nullable String value) {
                this._type = value;
                return this;
            }

            public Builder withType(@Nullable CloudFormationToken value) {
                this._type = value;
                return this;
            }

            public ElasticGpuSpecificationProperty build() {
                return new ElasticGpuSpecificationProperty(){
                    @Nullable
                    private Object $type;
                    {
                        this.$type = _type;
                    }

                    @Override
                    public Object getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(@Nullable String value) {
                        this.$type = value;
                    }

                    @Override
                    public void setType(@Nullable CloudFormationToken value) {
                        this.$type = value;
                    }
                };
            }
        }
    }

    public static interface EbsProperty
    extends JsiiSerializable {
        public Object getDeleteOnTermination();

        public void setDeleteOnTermination(Boolean var1);

        public void setDeleteOnTermination(CloudFormationToken var1);

        public Object getEncrypted();

        public void setEncrypted(Boolean var1);

        public void setEncrypted(CloudFormationToken var1);

        public Object getIops();

        public void setIops(Number var1);

        public void setIops(CloudFormationToken var1);

        public Object getKmsKeyId();

        public void setKmsKeyId(String var1);

        public void setKmsKeyId(CloudFormationToken var1);

        public Object getSnapshotId();

        public void setSnapshotId(String var1);

        public void setSnapshotId(CloudFormationToken var1);

        public Object getVolumeSize();

        public void setVolumeSize(Number var1);

        public void setVolumeSize(CloudFormationToken var1);

        public Object getVolumeType();

        public void setVolumeType(String var1);

        public void setVolumeType(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _deleteOnTermination;
            @Nullable
            private Object _encrypted;
            @Nullable
            private Object _iops;
            @Nullable
            private Object _kmsKeyId;
            @Nullable
            private Object _snapshotId;
            @Nullable
            private Object _volumeSize;
            @Nullable
            private Object _volumeType;

            public Builder withDeleteOnTermination(@Nullable Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }

            public Builder withDeleteOnTermination(@Nullable CloudFormationToken value) {
                this._deleteOnTermination = value;
                return this;
            }

            public Builder withEncrypted(@Nullable Boolean value) {
                this._encrypted = value;
                return this;
            }

            public Builder withEncrypted(@Nullable CloudFormationToken value) {
                this._encrypted = value;
                return this;
            }

            public Builder withIops(@Nullable Number value) {
                this._iops = value;
                return this;
            }

            public Builder withIops(@Nullable CloudFormationToken value) {
                this._iops = value;
                return this;
            }

            public Builder withKmsKeyId(@Nullable String value) {
                this._kmsKeyId = value;
                return this;
            }

            public Builder withKmsKeyId(@Nullable CloudFormationToken value) {
                this._kmsKeyId = value;
                return this;
            }

            public Builder withSnapshotId(@Nullable String value) {
                this._snapshotId = value;
                return this;
            }

            public Builder withSnapshotId(@Nullable CloudFormationToken value) {
                this._snapshotId = value;
                return this;
            }

            public Builder withVolumeSize(@Nullable Number value) {
                this._volumeSize = value;
                return this;
            }

            public Builder withVolumeSize(@Nullable CloudFormationToken value) {
                this._volumeSize = value;
                return this;
            }

            public Builder withVolumeType(@Nullable String value) {
                this._volumeType = value;
                return this;
            }

            public Builder withVolumeType(@Nullable CloudFormationToken value) {
                this._volumeType = value;
                return this;
            }

            public EbsProperty build() {
                return new EbsProperty(){
                    @Nullable
                    private Object $deleteOnTermination;
                    @Nullable
                    private Object $encrypted;
                    @Nullable
                    private Object $iops;
                    @Nullable
                    private Object $kmsKeyId;
                    @Nullable
                    private Object $snapshotId;
                    @Nullable
                    private Object $volumeSize;
                    @Nullable
                    private Object $volumeType;
                    {
                        this.$deleteOnTermination = _deleteOnTermination;
                        this.$encrypted = _encrypted;
                        this.$iops = _iops;
                        this.$kmsKeyId = _kmsKeyId;
                        this.$snapshotId = _snapshotId;
                        this.$volumeSize = _volumeSize;
                        this.$volumeType = _volumeType;
                    }

                    @Override
                    public Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public void setDeleteOnTermination(@Nullable Boolean value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public void setDeleteOnTermination(@Nullable CloudFormationToken value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public Object getEncrypted() {
                        return this.$encrypted;
                    }

                    @Override
                    public void setEncrypted(@Nullable Boolean value) {
                        this.$encrypted = value;
                    }

                    @Override
                    public void setEncrypted(@Nullable CloudFormationToken value) {
                        this.$encrypted = value;
                    }

                    @Override
                    public Object getIops() {
                        return this.$iops;
                    }

                    @Override
                    public void setIops(@Nullable Number value) {
                        this.$iops = value;
                    }

                    @Override
                    public void setIops(@Nullable CloudFormationToken value) {
                        this.$iops = value;
                    }

                    @Override
                    public Object getKmsKeyId() {
                        return this.$kmsKeyId;
                    }

                    @Override
                    public void setKmsKeyId(@Nullable String value) {
                        this.$kmsKeyId = value;
                    }

                    @Override
                    public void setKmsKeyId(@Nullable CloudFormationToken value) {
                        this.$kmsKeyId = value;
                    }

                    @Override
                    public Object getSnapshotId() {
                        return this.$snapshotId;
                    }

                    @Override
                    public void setSnapshotId(@Nullable String value) {
                        this.$snapshotId = value;
                    }

                    @Override
                    public void setSnapshotId(@Nullable CloudFormationToken value) {
                        this.$snapshotId = value;
                    }

                    @Override
                    public Object getVolumeSize() {
                        return this.$volumeSize;
                    }

                    @Override
                    public void setVolumeSize(@Nullable Number value) {
                        this.$volumeSize = value;
                    }

                    @Override
                    public void setVolumeSize(@Nullable CloudFormationToken value) {
                        this.$volumeSize = value;
                    }

                    @Override
                    public Object getVolumeType() {
                        return this.$volumeType;
                    }

                    @Override
                    public void setVolumeType(@Nullable String value) {
                        this.$volumeType = value;
                    }

                    @Override
                    public void setVolumeType(@Nullable CloudFormationToken value) {
                        this.$volumeType = value;
                    }
                };
            }
        }
    }

    public static interface CreditSpecificationProperty
    extends JsiiSerializable {
        public Object getCpuCredits();

        public void setCpuCredits(String var1);

        public void setCpuCredits(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _cpuCredits;

            public Builder withCpuCredits(@Nullable String value) {
                this._cpuCredits = value;
                return this;
            }

            public Builder withCpuCredits(@Nullable CloudFormationToken value) {
                this._cpuCredits = value;
                return this;
            }

            public CreditSpecificationProperty build() {
                return new CreditSpecificationProperty(){
                    @Nullable
                    private Object $cpuCredits;
                    {
                        this.$cpuCredits = _cpuCredits;
                    }

                    @Override
                    public Object getCpuCredits() {
                        return this.$cpuCredits;
                    }

                    @Override
                    public void setCpuCredits(@Nullable String value) {
                        this.$cpuCredits = value;
                    }

                    @Override
                    public void setCpuCredits(@Nullable CloudFormationToken value) {
                        this.$cpuCredits = value;
                    }
                };
            }
        }
    }

    public static interface BlockDeviceMappingProperty
    extends JsiiSerializable {
        public Object getDeviceName();

        public void setDeviceName(String var1);

        public void setDeviceName(CloudFormationToken var1);

        public Object getEbs();

        public void setEbs(CloudFormationToken var1);

        public void setEbs(EbsProperty var1);

        public Object getNoDevice();

        public void setNoDevice(String var1);

        public void setNoDevice(CloudFormationToken var1);

        public Object getVirtualName();

        public void setVirtualName(String var1);

        public void setVirtualName(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _deviceName;
            @Nullable
            private Object _ebs;
            @Nullable
            private Object _noDevice;
            @Nullable
            private Object _virtualName;

            public Builder withDeviceName(@Nullable String value) {
                this._deviceName = value;
                return this;
            }

            public Builder withDeviceName(@Nullable CloudFormationToken value) {
                this._deviceName = value;
                return this;
            }

            public Builder withEbs(@Nullable CloudFormationToken value) {
                this._ebs = value;
                return this;
            }

            public Builder withEbs(@Nullable EbsProperty value) {
                this._ebs = value;
                return this;
            }

            public Builder withNoDevice(@Nullable String value) {
                this._noDevice = value;
                return this;
            }

            public Builder withNoDevice(@Nullable CloudFormationToken value) {
                this._noDevice = value;
                return this;
            }

            public Builder withVirtualName(@Nullable String value) {
                this._virtualName = value;
                return this;
            }

            public Builder withVirtualName(@Nullable CloudFormationToken value) {
                this._virtualName = value;
                return this;
            }

            public BlockDeviceMappingProperty build() {
                return new BlockDeviceMappingProperty(){
                    @Nullable
                    private Object $deviceName;
                    @Nullable
                    private Object $ebs;
                    @Nullable
                    private Object $noDevice;
                    @Nullable
                    private Object $virtualName;
                    {
                        this.$deviceName = _deviceName;
                        this.$ebs = _ebs;
                        this.$noDevice = _noDevice;
                        this.$virtualName = _virtualName;
                    }

                    @Override
                    public Object getDeviceName() {
                        return this.$deviceName;
                    }

                    @Override
                    public void setDeviceName(@Nullable String value) {
                        this.$deviceName = value;
                    }

                    @Override
                    public void setDeviceName(@Nullable CloudFormationToken value) {
                        this.$deviceName = value;
                    }

                    @Override
                    public Object getEbs() {
                        return this.$ebs;
                    }

                    @Override
                    public void setEbs(@Nullable CloudFormationToken value) {
                        this.$ebs = value;
                    }

                    @Override
                    public void setEbs(@Nullable EbsProperty value) {
                        this.$ebs = value;
                    }

                    @Override
                    public Object getNoDevice() {
                        return this.$noDevice;
                    }

                    @Override
                    public void setNoDevice(@Nullable String value) {
                        this.$noDevice = value;
                    }

                    @Override
                    public void setNoDevice(@Nullable CloudFormationToken value) {
                        this.$noDevice = value;
                    }

                    @Override
                    public Object getVirtualName() {
                        return this.$virtualName;
                    }

                    @Override
                    public void setVirtualName(@Nullable String value) {
                        this.$virtualName = value;
                    }

                    @Override
                    public void setVirtualName(@Nullable CloudFormationToken value) {
                        this.$virtualName = value;
                    }
                };
            }
        }
    }
}

