/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2.cloudformation;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import software.amazon.awscdk.CloudFormationToken;
import software.amazon.awscdk.Construct;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.ec2.;
import software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResourceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.cloudformation.SpotFleetResource")
public class SpotFleetResource
extends Resource {
    public static final String RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(SpotFleetResource.class, (String)"resourceTypeName", String.class);

    protected SpotFleetResource(JsiiObject.InitializationMode mode) {
        super(mode);
    }

    public SpotFleetResource(Construct parent, String name, SpotFleetResourceProps properties) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, Stream.concat(Stream.concat(Stream.of(Objects.requireNonNull(parent, "parent is required")), Stream.of(Objects.requireNonNull(name, "name is required"))), Stream.of(Objects.requireNonNull(properties, "properties is required"))).toArray());
    }

    protected Map<String, Object> renderProperties() {
        return (Map)this.jsiiCall("renderProperties", Map.class, new Object[0]);
    }

    public String getSpotFleetName() {
        return (String)this.jsiiGet("spotFleetName", String.class);
    }

    public static interface SpotPlacementProperty
    extends JsiiSerializable {
        public Object getAvailabilityZone();

        public void setAvailabilityZone(String var1);

        public void setAvailabilityZone(CloudFormationToken var1);

        public Object getGroupName();

        public void setGroupName(String var1);

        public void setGroupName(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _availabilityZone;
            @Nullable
            private Object _groupName;

            public Builder withAvailabilityZone(@Nullable String value) {
                this._availabilityZone = value;
                return this;
            }

            public Builder withAvailabilityZone(@Nullable CloudFormationToken value) {
                this._availabilityZone = value;
                return this;
            }

            public Builder withGroupName(@Nullable String value) {
                this._groupName = value;
                return this;
            }

            public Builder withGroupName(@Nullable CloudFormationToken value) {
                this._groupName = value;
                return this;
            }

            public SpotPlacementProperty build() {
                return new SpotPlacementProperty(){
                    @Nullable
                    private Object $availabilityZone;
                    @Nullable
                    private Object $groupName;
                    {
                        this.$availabilityZone = _availabilityZone;
                        this.$groupName = _groupName;
                    }

                    @Override
                    public Object getAvailabilityZone() {
                        return this.$availabilityZone;
                    }

                    @Override
                    public void setAvailabilityZone(@Nullable String value) {
                        this.$availabilityZone = value;
                    }

                    @Override
                    public void setAvailabilityZone(@Nullable CloudFormationToken value) {
                        this.$availabilityZone = value;
                    }

                    @Override
                    public Object getGroupName() {
                        return this.$groupName;
                    }

                    @Override
                    public void setGroupName(@Nullable String value) {
                        this.$groupName = value;
                    }

                    @Override
                    public void setGroupName(@Nullable CloudFormationToken value) {
                        this.$groupName = value;
                    }
                };
            }
        }
    }

    public static interface SpotFleetTagSpecificationProperty
    extends JsiiSerializable {
        public Object getResourceType();

        public void setResourceType(String var1);

        public void setResourceType(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _resourceType;

            public Builder withResourceType(@Nullable String value) {
                this._resourceType = value;
                return this;
            }

            public Builder withResourceType(@Nullable CloudFormationToken value) {
                this._resourceType = value;
                return this;
            }

            public SpotFleetTagSpecificationProperty build() {
                return new SpotFleetTagSpecificationProperty(){
                    @Nullable
                    private Object $resourceType;
                    {
                        this.$resourceType = _resourceType;
                    }

                    @Override
                    public Object getResourceType() {
                        return this.$resourceType;
                    }

                    @Override
                    public void setResourceType(@Nullable String value) {
                        this.$resourceType = value;
                    }

                    @Override
                    public void setResourceType(@Nullable CloudFormationToken value) {
                        this.$resourceType = value;
                    }
                };
            }
        }
    }

    public static interface SpotFleetRequestConfigDataProperty
    extends JsiiSerializable {
        public Object getIamFleetRole();

        public void setIamFleetRole(String var1);

        public void setIamFleetRole(CloudFormationToken var1);

        public Object getTargetCapacity();

        public void setTargetCapacity(Number var1);

        public void setTargetCapacity(CloudFormationToken var1);

        public Object getAllocationStrategy();

        public void setAllocationStrategy(String var1);

        public void setAllocationStrategy(CloudFormationToken var1);

        public Object getExcessCapacityTerminationPolicy();

        public void setExcessCapacityTerminationPolicy(String var1);

        public void setExcessCapacityTerminationPolicy(CloudFormationToken var1);

        public Object getLaunchSpecifications();

        public void setLaunchSpecifications(CloudFormationToken var1);

        public void setLaunchSpecifications(List<Object> var1);

        public Object getReplaceUnhealthyInstances();

        public void setReplaceUnhealthyInstances(Boolean var1);

        public void setReplaceUnhealthyInstances(CloudFormationToken var1);

        public Object getSpotPrice();

        public void setSpotPrice(String var1);

        public void setSpotPrice(CloudFormationToken var1);

        public Object getTerminateInstancesWithExpiration();

        public void setTerminateInstancesWithExpiration(Boolean var1);

        public void setTerminateInstancesWithExpiration(CloudFormationToken var1);

        public Object getType();

        public void setType(String var1);

        public void setType(CloudFormationToken var1);

        public Object getValidFrom();

        public void setValidFrom(String var1);

        public void setValidFrom(CloudFormationToken var1);

        public Object getValidUntil();

        public void setValidUntil(String var1);

        public void setValidUntil(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _iamFleetRole;
            private Object _targetCapacity;
            @Nullable
            private Object _allocationStrategy;
            @Nullable
            private Object _excessCapacityTerminationPolicy;
            @Nullable
            private Object _launchSpecifications;
            @Nullable
            private Object _replaceUnhealthyInstances;
            @Nullable
            private Object _spotPrice;
            @Nullable
            private Object _terminateInstancesWithExpiration;
            @Nullable
            private Object _type;
            @Nullable
            private Object _validFrom;
            @Nullable
            private Object _validUntil;

            public Builder withIamFleetRole(String value) {
                this._iamFleetRole = Objects.requireNonNull(value, "iamFleetRole is required");
                return this;
            }

            public Builder withIamFleetRole(CloudFormationToken value) {
                this._iamFleetRole = Objects.requireNonNull(value, "iamFleetRole is required");
                return this;
            }

            public Builder withTargetCapacity(Number value) {
                this._targetCapacity = Objects.requireNonNull(value, "targetCapacity is required");
                return this;
            }

            public Builder withTargetCapacity(CloudFormationToken value) {
                this._targetCapacity = Objects.requireNonNull(value, "targetCapacity is required");
                return this;
            }

            public Builder withAllocationStrategy(@Nullable String value) {
                this._allocationStrategy = value;
                return this;
            }

            public Builder withAllocationStrategy(@Nullable CloudFormationToken value) {
                this._allocationStrategy = value;
                return this;
            }

            public Builder withExcessCapacityTerminationPolicy(@Nullable String value) {
                this._excessCapacityTerminationPolicy = value;
                return this;
            }

            public Builder withExcessCapacityTerminationPolicy(@Nullable CloudFormationToken value) {
                this._excessCapacityTerminationPolicy = value;
                return this;
            }

            public Builder withLaunchSpecifications(@Nullable CloudFormationToken value) {
                this._launchSpecifications = value;
                return this;
            }

            public Builder withLaunchSpecifications(@Nullable List<Object> value) {
                this._launchSpecifications = value;
                return this;
            }

            public Builder withReplaceUnhealthyInstances(@Nullable Boolean value) {
                this._replaceUnhealthyInstances = value;
                return this;
            }

            public Builder withReplaceUnhealthyInstances(@Nullable CloudFormationToken value) {
                this._replaceUnhealthyInstances = value;
                return this;
            }

            public Builder withSpotPrice(@Nullable String value) {
                this._spotPrice = value;
                return this;
            }

            public Builder withSpotPrice(@Nullable CloudFormationToken value) {
                this._spotPrice = value;
                return this;
            }

            public Builder withTerminateInstancesWithExpiration(@Nullable Boolean value) {
                this._terminateInstancesWithExpiration = value;
                return this;
            }

            public Builder withTerminateInstancesWithExpiration(@Nullable CloudFormationToken value) {
                this._terminateInstancesWithExpiration = value;
                return this;
            }

            public Builder withType(@Nullable String value) {
                this._type = value;
                return this;
            }

            public Builder withType(@Nullable CloudFormationToken value) {
                this._type = value;
                return this;
            }

            public Builder withValidFrom(@Nullable String value) {
                this._validFrom = value;
                return this;
            }

            public Builder withValidFrom(@Nullable CloudFormationToken value) {
                this._validFrom = value;
                return this;
            }

            public Builder withValidUntil(@Nullable String value) {
                this._validUntil = value;
                return this;
            }

            public Builder withValidUntil(@Nullable CloudFormationToken value) {
                this._validUntil = value;
                return this;
            }

            public SpotFleetRequestConfigDataProperty build() {
                return new SpotFleetRequestConfigDataProperty(){
                    private Object $iamFleetRole;
                    private Object $targetCapacity;
                    @Nullable
                    private Object $allocationStrategy;
                    @Nullable
                    private Object $excessCapacityTerminationPolicy;
                    @Nullable
                    private Object $launchSpecifications;
                    @Nullable
                    private Object $replaceUnhealthyInstances;
                    @Nullable
                    private Object $spotPrice;
                    @Nullable
                    private Object $terminateInstancesWithExpiration;
                    @Nullable
                    private Object $type;
                    @Nullable
                    private Object $validFrom;
                    @Nullable
                    private Object $validUntil;
                    {
                        this.$iamFleetRole = Objects.requireNonNull(_iamFleetRole, "iamFleetRole is required");
                        this.$targetCapacity = Objects.requireNonNull(_targetCapacity, "targetCapacity is required");
                        this.$allocationStrategy = _allocationStrategy;
                        this.$excessCapacityTerminationPolicy = _excessCapacityTerminationPolicy;
                        this.$launchSpecifications = _launchSpecifications;
                        this.$replaceUnhealthyInstances = _replaceUnhealthyInstances;
                        this.$spotPrice = _spotPrice;
                        this.$terminateInstancesWithExpiration = _terminateInstancesWithExpiration;
                        this.$type = _type;
                        this.$validFrom = _validFrom;
                        this.$validUntil = _validUntil;
                    }

                    @Override
                    public Object getIamFleetRole() {
                        return this.$iamFleetRole;
                    }

                    @Override
                    public void setIamFleetRole(String value) {
                        this.$iamFleetRole = Objects.requireNonNull(value, "iamFleetRole is required");
                    }

                    @Override
                    public void setIamFleetRole(CloudFormationToken value) {
                        this.$iamFleetRole = Objects.requireNonNull(value, "iamFleetRole is required");
                    }

                    @Override
                    public Object getTargetCapacity() {
                        return this.$targetCapacity;
                    }

                    @Override
                    public void setTargetCapacity(Number value) {
                        this.$targetCapacity = Objects.requireNonNull(value, "targetCapacity is required");
                    }

                    @Override
                    public void setTargetCapacity(CloudFormationToken value) {
                        this.$targetCapacity = Objects.requireNonNull(value, "targetCapacity is required");
                    }

                    @Override
                    public Object getAllocationStrategy() {
                        return this.$allocationStrategy;
                    }

                    @Override
                    public void setAllocationStrategy(@Nullable String value) {
                        this.$allocationStrategy = value;
                    }

                    @Override
                    public void setAllocationStrategy(@Nullable CloudFormationToken value) {
                        this.$allocationStrategy = value;
                    }

                    @Override
                    public Object getExcessCapacityTerminationPolicy() {
                        return this.$excessCapacityTerminationPolicy;
                    }

                    @Override
                    public void setExcessCapacityTerminationPolicy(@Nullable String value) {
                        this.$excessCapacityTerminationPolicy = value;
                    }

                    @Override
                    public void setExcessCapacityTerminationPolicy(@Nullable CloudFormationToken value) {
                        this.$excessCapacityTerminationPolicy = value;
                    }

                    @Override
                    public Object getLaunchSpecifications() {
                        return this.$launchSpecifications;
                    }

                    @Override
                    public void setLaunchSpecifications(@Nullable CloudFormationToken value) {
                        this.$launchSpecifications = value;
                    }

                    @Override
                    public void setLaunchSpecifications(@Nullable List<Object> value) {
                        this.$launchSpecifications = value;
                    }

                    @Override
                    public Object getReplaceUnhealthyInstances() {
                        return this.$replaceUnhealthyInstances;
                    }

                    @Override
                    public void setReplaceUnhealthyInstances(@Nullable Boolean value) {
                        this.$replaceUnhealthyInstances = value;
                    }

                    @Override
                    public void setReplaceUnhealthyInstances(@Nullable CloudFormationToken value) {
                        this.$replaceUnhealthyInstances = value;
                    }

                    @Override
                    public Object getSpotPrice() {
                        return this.$spotPrice;
                    }

                    @Override
                    public void setSpotPrice(@Nullable String value) {
                        this.$spotPrice = value;
                    }

                    @Override
                    public void setSpotPrice(@Nullable CloudFormationToken value) {
                        this.$spotPrice = value;
                    }

                    @Override
                    public Object getTerminateInstancesWithExpiration() {
                        return this.$terminateInstancesWithExpiration;
                    }

                    @Override
                    public void setTerminateInstancesWithExpiration(@Nullable Boolean value) {
                        this.$terminateInstancesWithExpiration = value;
                    }

                    @Override
                    public void setTerminateInstancesWithExpiration(@Nullable CloudFormationToken value) {
                        this.$terminateInstancesWithExpiration = value;
                    }

                    @Override
                    public Object getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(@Nullable String value) {
                        this.$type = value;
                    }

                    @Override
                    public void setType(@Nullable CloudFormationToken value) {
                        this.$type = value;
                    }

                    @Override
                    public Object getValidFrom() {
                        return this.$validFrom;
                    }

                    @Override
                    public void setValidFrom(@Nullable String value) {
                        this.$validFrom = value;
                    }

                    @Override
                    public void setValidFrom(@Nullable CloudFormationToken value) {
                        this.$validFrom = value;
                    }

                    @Override
                    public Object getValidUntil() {
                        return this.$validUntil;
                    }

                    @Override
                    public void setValidUntil(@Nullable String value) {
                        this.$validUntil = value;
                    }

                    @Override
                    public void setValidUntil(@Nullable CloudFormationToken value) {
                        this.$validUntil = value;
                    }
                };
            }
        }
    }

    public static interface SpotFleetMonitoringProperty
    extends JsiiSerializable {
        public Object getEnabled();

        public void setEnabled(Boolean var1);

        public void setEnabled(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _enabled;

            public Builder withEnabled(@Nullable Boolean value) {
                this._enabled = value;
                return this;
            }

            public Builder withEnabled(@Nullable CloudFormationToken value) {
                this._enabled = value;
                return this;
            }

            public SpotFleetMonitoringProperty build() {
                return new SpotFleetMonitoringProperty(){
                    @Nullable
                    private Object $enabled;
                    {
                        this.$enabled = _enabled;
                    }

                    @Override
                    public Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public void setEnabled(@Nullable Boolean value) {
                        this.$enabled = value;
                    }

                    @Override
                    public void setEnabled(@Nullable CloudFormationToken value) {
                        this.$enabled = value;
                    }
                };
            }
        }
    }

    public static interface SpotFleetLaunchSpecificationProperty
    extends JsiiSerializable {
        public Object getImageId();

        public void setImageId(String var1);

        public void setImageId(CloudFormationToken var1);

        public Object getInstanceType();

        public void setInstanceType(String var1);

        public void setInstanceType(CloudFormationToken var1);

        public Object getBlockDeviceMappings();

        public void setBlockDeviceMappings(CloudFormationToken var1);

        public void setBlockDeviceMappings(List<Object> var1);

        public Object getEbsOptimized();

        public void setEbsOptimized(Boolean var1);

        public void setEbsOptimized(CloudFormationToken var1);

        public Object getIamInstanceProfile();

        public void setIamInstanceProfile(CloudFormationToken var1);

        public void setIamInstanceProfile(IamInstanceProfileSpecificationProperty var1);

        public Object getKernelId();

        public void setKernelId(String var1);

        public void setKernelId(CloudFormationToken var1);

        public Object getKeyName();

        public void setKeyName(String var1);

        public void setKeyName(CloudFormationToken var1);

        public Object getMonitoring();

        public void setMonitoring(CloudFormationToken var1);

        public void setMonitoring(SpotFleetMonitoringProperty var1);

        public Object getNetworkInterfaces();

        public void setNetworkInterfaces(CloudFormationToken var1);

        public void setNetworkInterfaces(List<Object> var1);

        public Object getPlacement();

        public void setPlacement(CloudFormationToken var1);

        public void setPlacement(SpotPlacementProperty var1);

        public Object getRamdiskId();

        public void setRamdiskId(String var1);

        public void setRamdiskId(CloudFormationToken var1);

        public Object getSecurityGroups();

        public void setSecurityGroups(CloudFormationToken var1);

        public void setSecurityGroups(List<Object> var1);

        public Object getSpotPrice();

        public void setSpotPrice(String var1);

        public void setSpotPrice(CloudFormationToken var1);

        public Object getSubnetId();

        public void setSubnetId(String var1);

        public void setSubnetId(CloudFormationToken var1);

        public Object getTagSpecifications();

        public void setTagSpecifications(CloudFormationToken var1);

        public void setTagSpecifications(List<Object> var1);

        public Object getUserData();

        public void setUserData(String var1);

        public void setUserData(CloudFormationToken var1);

        public Object getWeightedCapacity();

        public void setWeightedCapacity(Number var1);

        public void setWeightedCapacity(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _imageId;
            private Object _instanceType;
            @Nullable
            private Object _blockDeviceMappings;
            @Nullable
            private Object _ebsOptimized;
            @Nullable
            private Object _iamInstanceProfile;
            @Nullable
            private Object _kernelId;
            @Nullable
            private Object _keyName;
            @Nullable
            private Object _monitoring;
            @Nullable
            private Object _networkInterfaces;
            @Nullable
            private Object _placement;
            @Nullable
            private Object _ramdiskId;
            @Nullable
            private Object _securityGroups;
            @Nullable
            private Object _spotPrice;
            @Nullable
            private Object _subnetId;
            @Nullable
            private Object _tagSpecifications;
            @Nullable
            private Object _userData;
            @Nullable
            private Object _weightedCapacity;

            public Builder withImageId(String value) {
                this._imageId = Objects.requireNonNull(value, "imageId is required");
                return this;
            }

            public Builder withImageId(CloudFormationToken value) {
                this._imageId = Objects.requireNonNull(value, "imageId is required");
                return this;
            }

            public Builder withInstanceType(String value) {
                this._instanceType = Objects.requireNonNull(value, "instanceType is required");
                return this;
            }

            public Builder withInstanceType(CloudFormationToken value) {
                this._instanceType = Objects.requireNonNull(value, "instanceType is required");
                return this;
            }

            public Builder withBlockDeviceMappings(@Nullable CloudFormationToken value) {
                this._blockDeviceMappings = value;
                return this;
            }

            public Builder withBlockDeviceMappings(@Nullable List<Object> value) {
                this._blockDeviceMappings = value;
                return this;
            }

            public Builder withEbsOptimized(@Nullable Boolean value) {
                this._ebsOptimized = value;
                return this;
            }

            public Builder withEbsOptimized(@Nullable CloudFormationToken value) {
                this._ebsOptimized = value;
                return this;
            }

            public Builder withIamInstanceProfile(@Nullable CloudFormationToken value) {
                this._iamInstanceProfile = value;
                return this;
            }

            public Builder withIamInstanceProfile(@Nullable IamInstanceProfileSpecificationProperty value) {
                this._iamInstanceProfile = value;
                return this;
            }

            public Builder withKernelId(@Nullable String value) {
                this._kernelId = value;
                return this;
            }

            public Builder withKernelId(@Nullable CloudFormationToken value) {
                this._kernelId = value;
                return this;
            }

            public Builder withKeyName(@Nullable String value) {
                this._keyName = value;
                return this;
            }

            public Builder withKeyName(@Nullable CloudFormationToken value) {
                this._keyName = value;
                return this;
            }

            public Builder withMonitoring(@Nullable CloudFormationToken value) {
                this._monitoring = value;
                return this;
            }

            public Builder withMonitoring(@Nullable SpotFleetMonitoringProperty value) {
                this._monitoring = value;
                return this;
            }

            public Builder withNetworkInterfaces(@Nullable CloudFormationToken value) {
                this._networkInterfaces = value;
                return this;
            }

            public Builder withNetworkInterfaces(@Nullable List<Object> value) {
                this._networkInterfaces = value;
                return this;
            }

            public Builder withPlacement(@Nullable CloudFormationToken value) {
                this._placement = value;
                return this;
            }

            public Builder withPlacement(@Nullable SpotPlacementProperty value) {
                this._placement = value;
                return this;
            }

            public Builder withRamdiskId(@Nullable String value) {
                this._ramdiskId = value;
                return this;
            }

            public Builder withRamdiskId(@Nullable CloudFormationToken value) {
                this._ramdiskId = value;
                return this;
            }

            public Builder withSecurityGroups(@Nullable CloudFormationToken value) {
                this._securityGroups = value;
                return this;
            }

            public Builder withSecurityGroups(@Nullable List<Object> value) {
                this._securityGroups = value;
                return this;
            }

            public Builder withSpotPrice(@Nullable String value) {
                this._spotPrice = value;
                return this;
            }

            public Builder withSpotPrice(@Nullable CloudFormationToken value) {
                this._spotPrice = value;
                return this;
            }

            public Builder withSubnetId(@Nullable String value) {
                this._subnetId = value;
                return this;
            }

            public Builder withSubnetId(@Nullable CloudFormationToken value) {
                this._subnetId = value;
                return this;
            }

            public Builder withTagSpecifications(@Nullable CloudFormationToken value) {
                this._tagSpecifications = value;
                return this;
            }

            public Builder withTagSpecifications(@Nullable List<Object> value) {
                this._tagSpecifications = value;
                return this;
            }

            public Builder withUserData(@Nullable String value) {
                this._userData = value;
                return this;
            }

            public Builder withUserData(@Nullable CloudFormationToken value) {
                this._userData = value;
                return this;
            }

            public Builder withWeightedCapacity(@Nullable Number value) {
                this._weightedCapacity = value;
                return this;
            }

            public Builder withWeightedCapacity(@Nullable CloudFormationToken value) {
                this._weightedCapacity = value;
                return this;
            }

            public SpotFleetLaunchSpecificationProperty build() {
                return new SpotFleetLaunchSpecificationProperty(){
                    private Object $imageId;
                    private Object $instanceType;
                    @Nullable
                    private Object $blockDeviceMappings;
                    @Nullable
                    private Object $ebsOptimized;
                    @Nullable
                    private Object $iamInstanceProfile;
                    @Nullable
                    private Object $kernelId;
                    @Nullable
                    private Object $keyName;
                    @Nullable
                    private Object $monitoring;
                    @Nullable
                    private Object $networkInterfaces;
                    @Nullable
                    private Object $placement;
                    @Nullable
                    private Object $ramdiskId;
                    @Nullable
                    private Object $securityGroups;
                    @Nullable
                    private Object $spotPrice;
                    @Nullable
                    private Object $subnetId;
                    @Nullable
                    private Object $tagSpecifications;
                    @Nullable
                    private Object $userData;
                    @Nullable
                    private Object $weightedCapacity;
                    {
                        this.$imageId = Objects.requireNonNull(_imageId, "imageId is required");
                        this.$instanceType = Objects.requireNonNull(_instanceType, "instanceType is required");
                        this.$blockDeviceMappings = _blockDeviceMappings;
                        this.$ebsOptimized = _ebsOptimized;
                        this.$iamInstanceProfile = _iamInstanceProfile;
                        this.$kernelId = _kernelId;
                        this.$keyName = _keyName;
                        this.$monitoring = _monitoring;
                        this.$networkInterfaces = _networkInterfaces;
                        this.$placement = _placement;
                        this.$ramdiskId = _ramdiskId;
                        this.$securityGroups = _securityGroups;
                        this.$spotPrice = _spotPrice;
                        this.$subnetId = _subnetId;
                        this.$tagSpecifications = _tagSpecifications;
                        this.$userData = _userData;
                        this.$weightedCapacity = _weightedCapacity;
                    }

                    @Override
                    public Object getImageId() {
                        return this.$imageId;
                    }

                    @Override
                    public void setImageId(String value) {
                        this.$imageId = Objects.requireNonNull(value, "imageId is required");
                    }

                    @Override
                    public void setImageId(CloudFormationToken value) {
                        this.$imageId = Objects.requireNonNull(value, "imageId is required");
                    }

                    @Override
                    public Object getInstanceType() {
                        return this.$instanceType;
                    }

                    @Override
                    public void setInstanceType(String value) {
                        this.$instanceType = Objects.requireNonNull(value, "instanceType is required");
                    }

                    @Override
                    public void setInstanceType(CloudFormationToken value) {
                        this.$instanceType = Objects.requireNonNull(value, "instanceType is required");
                    }

                    @Override
                    public Object getBlockDeviceMappings() {
                        return this.$blockDeviceMappings;
                    }

                    @Override
                    public void setBlockDeviceMappings(@Nullable CloudFormationToken value) {
                        this.$blockDeviceMappings = value;
                    }

                    @Override
                    public void setBlockDeviceMappings(@Nullable List<Object> value) {
                        this.$blockDeviceMappings = value;
                    }

                    @Override
                    public Object getEbsOptimized() {
                        return this.$ebsOptimized;
                    }

                    @Override
                    public void setEbsOptimized(@Nullable Boolean value) {
                        this.$ebsOptimized = value;
                    }

                    @Override
                    public void setEbsOptimized(@Nullable CloudFormationToken value) {
                        this.$ebsOptimized = value;
                    }

                    @Override
                    public Object getIamInstanceProfile() {
                        return this.$iamInstanceProfile;
                    }

                    @Override
                    public void setIamInstanceProfile(@Nullable CloudFormationToken value) {
                        this.$iamInstanceProfile = value;
                    }

                    @Override
                    public void setIamInstanceProfile(@Nullable IamInstanceProfileSpecificationProperty value) {
                        this.$iamInstanceProfile = value;
                    }

                    @Override
                    public Object getKernelId() {
                        return this.$kernelId;
                    }

                    @Override
                    public void setKernelId(@Nullable String value) {
                        this.$kernelId = value;
                    }

                    @Override
                    public void setKernelId(@Nullable CloudFormationToken value) {
                        this.$kernelId = value;
                    }

                    @Override
                    public Object getKeyName() {
                        return this.$keyName;
                    }

                    @Override
                    public void setKeyName(@Nullable String value) {
                        this.$keyName = value;
                    }

                    @Override
                    public void setKeyName(@Nullable CloudFormationToken value) {
                        this.$keyName = value;
                    }

                    @Override
                    public Object getMonitoring() {
                        return this.$monitoring;
                    }

                    @Override
                    public void setMonitoring(@Nullable CloudFormationToken value) {
                        this.$monitoring = value;
                    }

                    @Override
                    public void setMonitoring(@Nullable SpotFleetMonitoringProperty value) {
                        this.$monitoring = value;
                    }

                    @Override
                    public Object getNetworkInterfaces() {
                        return this.$networkInterfaces;
                    }

                    @Override
                    public void setNetworkInterfaces(@Nullable CloudFormationToken value) {
                        this.$networkInterfaces = value;
                    }

                    @Override
                    public void setNetworkInterfaces(@Nullable List<Object> value) {
                        this.$networkInterfaces = value;
                    }

                    @Override
                    public Object getPlacement() {
                        return this.$placement;
                    }

                    @Override
                    public void setPlacement(@Nullable CloudFormationToken value) {
                        this.$placement = value;
                    }

                    @Override
                    public void setPlacement(@Nullable SpotPlacementProperty value) {
                        this.$placement = value;
                    }

                    @Override
                    public Object getRamdiskId() {
                        return this.$ramdiskId;
                    }

                    @Override
                    public void setRamdiskId(@Nullable String value) {
                        this.$ramdiskId = value;
                    }

                    @Override
                    public void setRamdiskId(@Nullable CloudFormationToken value) {
                        this.$ramdiskId = value;
                    }

                    @Override
                    public Object getSecurityGroups() {
                        return this.$securityGroups;
                    }

                    @Override
                    public void setSecurityGroups(@Nullable CloudFormationToken value) {
                        this.$securityGroups = value;
                    }

                    @Override
                    public void setSecurityGroups(@Nullable List<Object> value) {
                        this.$securityGroups = value;
                    }

                    @Override
                    public Object getSpotPrice() {
                        return this.$spotPrice;
                    }

                    @Override
                    public void setSpotPrice(@Nullable String value) {
                        this.$spotPrice = value;
                    }

                    @Override
                    public void setSpotPrice(@Nullable CloudFormationToken value) {
                        this.$spotPrice = value;
                    }

                    @Override
                    public Object getSubnetId() {
                        return this.$subnetId;
                    }

                    @Override
                    public void setSubnetId(@Nullable String value) {
                        this.$subnetId = value;
                    }

                    @Override
                    public void setSubnetId(@Nullable CloudFormationToken value) {
                        this.$subnetId = value;
                    }

                    @Override
                    public Object getTagSpecifications() {
                        return this.$tagSpecifications;
                    }

                    @Override
                    public void setTagSpecifications(@Nullable CloudFormationToken value) {
                        this.$tagSpecifications = value;
                    }

                    @Override
                    public void setTagSpecifications(@Nullable List<Object> value) {
                        this.$tagSpecifications = value;
                    }

                    @Override
                    public Object getUserData() {
                        return this.$userData;
                    }

                    @Override
                    public void setUserData(@Nullable String value) {
                        this.$userData = value;
                    }

                    @Override
                    public void setUserData(@Nullable CloudFormationToken value) {
                        this.$userData = value;
                    }

                    @Override
                    public Object getWeightedCapacity() {
                        return this.$weightedCapacity;
                    }

                    @Override
                    public void setWeightedCapacity(@Nullable Number value) {
                        this.$weightedCapacity = value;
                    }

                    @Override
                    public void setWeightedCapacity(@Nullable CloudFormationToken value) {
                        this.$weightedCapacity = value;
                    }
                };
            }
        }
    }

    public static interface PrivateIpAddressSpecificationProperty
    extends JsiiSerializable {
        public Object getPrivateIpAddress();

        public void setPrivateIpAddress(String var1);

        public void setPrivateIpAddress(CloudFormationToken var1);

        public Object getPrimary();

        public void setPrimary(Boolean var1);

        public void setPrimary(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _privateIpAddress;
            @Nullable
            private Object _primary;

            public Builder withPrivateIpAddress(String value) {
                this._privateIpAddress = Objects.requireNonNull(value, "privateIpAddress is required");
                return this;
            }

            public Builder withPrivateIpAddress(CloudFormationToken value) {
                this._privateIpAddress = Objects.requireNonNull(value, "privateIpAddress is required");
                return this;
            }

            public Builder withPrimary(@Nullable Boolean value) {
                this._primary = value;
                return this;
            }

            public Builder withPrimary(@Nullable CloudFormationToken value) {
                this._primary = value;
                return this;
            }

            public PrivateIpAddressSpecificationProperty build() {
                return new PrivateIpAddressSpecificationProperty(){
                    private Object $privateIpAddress;
                    @Nullable
                    private Object $primary;
                    {
                        this.$privateIpAddress = Objects.requireNonNull(_privateIpAddress, "privateIpAddress is required");
                        this.$primary = _primary;
                    }

                    @Override
                    public Object getPrivateIpAddress() {
                        return this.$privateIpAddress;
                    }

                    @Override
                    public void setPrivateIpAddress(String value) {
                        this.$privateIpAddress = Objects.requireNonNull(value, "privateIpAddress is required");
                    }

                    @Override
                    public void setPrivateIpAddress(CloudFormationToken value) {
                        this.$privateIpAddress = Objects.requireNonNull(value, "privateIpAddress is required");
                    }

                    @Override
                    public Object getPrimary() {
                        return this.$primary;
                    }

                    @Override
                    public void setPrimary(@Nullable Boolean value) {
                        this.$primary = value;
                    }

                    @Override
                    public void setPrimary(@Nullable CloudFormationToken value) {
                        this.$primary = value;
                    }
                };
            }
        }
    }

    public static interface InstanceNetworkInterfaceSpecificationProperty
    extends JsiiSerializable {
        public Object getAssociatePublicIpAddress();

        public void setAssociatePublicIpAddress(Boolean var1);

        public void setAssociatePublicIpAddress(CloudFormationToken var1);

        public Object getDeleteOnTermination();

        public void setDeleteOnTermination(Boolean var1);

        public void setDeleteOnTermination(CloudFormationToken var1);

        public Object getDescription();

        public void setDescription(String var1);

        public void setDescription(CloudFormationToken var1);

        public Object getDeviceIndex();

        public void setDeviceIndex(Number var1);

        public void setDeviceIndex(CloudFormationToken var1);

        public Object getGroups();

        public void setGroups(CloudFormationToken var1);

        public void setGroups(List<Object> var1);

        public Object getIpv6AddressCount();

        public void setIpv6AddressCount(Number var1);

        public void setIpv6AddressCount(CloudFormationToken var1);

        public Object getIpv6Addresses();

        public void setIpv6Addresses(CloudFormationToken var1);

        public void setIpv6Addresses(List<Object> var1);

        public Object getNetworkInterfaceId();

        public void setNetworkInterfaceId(String var1);

        public void setNetworkInterfaceId(CloudFormationToken var1);

        public Object getPrivateIpAddresses();

        public void setPrivateIpAddresses(CloudFormationToken var1);

        public void setPrivateIpAddresses(List<Object> var1);

        public Object getSecondaryPrivateIpAddressCount();

        public void setSecondaryPrivateIpAddressCount(Number var1);

        public void setSecondaryPrivateIpAddressCount(CloudFormationToken var1);

        public Object getSubnetId();

        public void setSubnetId(String var1);

        public void setSubnetId(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _associatePublicIpAddress;
            @Nullable
            private Object _deleteOnTermination;
            @Nullable
            private Object _description;
            @Nullable
            private Object _deviceIndex;
            @Nullable
            private Object _groups;
            @Nullable
            private Object _ipv6AddressCount;
            @Nullable
            private Object _ipv6Addresses;
            @Nullable
            private Object _networkInterfaceId;
            @Nullable
            private Object _privateIpAddresses;
            @Nullable
            private Object _secondaryPrivateIpAddressCount;
            @Nullable
            private Object _subnetId;

            public Builder withAssociatePublicIpAddress(@Nullable Boolean value) {
                this._associatePublicIpAddress = value;
                return this;
            }

            public Builder withAssociatePublicIpAddress(@Nullable CloudFormationToken value) {
                this._associatePublicIpAddress = value;
                return this;
            }

            public Builder withDeleteOnTermination(@Nullable Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }

            public Builder withDeleteOnTermination(@Nullable CloudFormationToken value) {
                this._deleteOnTermination = value;
                return this;
            }

            public Builder withDescription(@Nullable String value) {
                this._description = value;
                return this;
            }

            public Builder withDescription(@Nullable CloudFormationToken value) {
                this._description = value;
                return this;
            }

            public Builder withDeviceIndex(@Nullable Number value) {
                this._deviceIndex = value;
                return this;
            }

            public Builder withDeviceIndex(@Nullable CloudFormationToken value) {
                this._deviceIndex = value;
                return this;
            }

            public Builder withGroups(@Nullable CloudFormationToken value) {
                this._groups = value;
                return this;
            }

            public Builder withGroups(@Nullable List<Object> value) {
                this._groups = value;
                return this;
            }

            public Builder withIpv6AddressCount(@Nullable Number value) {
                this._ipv6AddressCount = value;
                return this;
            }

            public Builder withIpv6AddressCount(@Nullable CloudFormationToken value) {
                this._ipv6AddressCount = value;
                return this;
            }

            public Builder withIpv6Addresses(@Nullable CloudFormationToken value) {
                this._ipv6Addresses = value;
                return this;
            }

            public Builder withIpv6Addresses(@Nullable List<Object> value) {
                this._ipv6Addresses = value;
                return this;
            }

            public Builder withNetworkInterfaceId(@Nullable String value) {
                this._networkInterfaceId = value;
                return this;
            }

            public Builder withNetworkInterfaceId(@Nullable CloudFormationToken value) {
                this._networkInterfaceId = value;
                return this;
            }

            public Builder withPrivateIpAddresses(@Nullable CloudFormationToken value) {
                this._privateIpAddresses = value;
                return this;
            }

            public Builder withPrivateIpAddresses(@Nullable List<Object> value) {
                this._privateIpAddresses = value;
                return this;
            }

            public Builder withSecondaryPrivateIpAddressCount(@Nullable Number value) {
                this._secondaryPrivateIpAddressCount = value;
                return this;
            }

            public Builder withSecondaryPrivateIpAddressCount(@Nullable CloudFormationToken value) {
                this._secondaryPrivateIpAddressCount = value;
                return this;
            }

            public Builder withSubnetId(@Nullable String value) {
                this._subnetId = value;
                return this;
            }

            public Builder withSubnetId(@Nullable CloudFormationToken value) {
                this._subnetId = value;
                return this;
            }

            public InstanceNetworkInterfaceSpecificationProperty build() {
                return new InstanceNetworkInterfaceSpecificationProperty(){
                    @Nullable
                    private Object $associatePublicIpAddress;
                    @Nullable
                    private Object $deleteOnTermination;
                    @Nullable
                    private Object $description;
                    @Nullable
                    private Object $deviceIndex;
                    @Nullable
                    private Object $groups;
                    @Nullable
                    private Object $ipv6AddressCount;
                    @Nullable
                    private Object $ipv6Addresses;
                    @Nullable
                    private Object $networkInterfaceId;
                    @Nullable
                    private Object $privateIpAddresses;
                    @Nullable
                    private Object $secondaryPrivateIpAddressCount;
                    @Nullable
                    private Object $subnetId;
                    {
                        this.$associatePublicIpAddress = _associatePublicIpAddress;
                        this.$deleteOnTermination = _deleteOnTermination;
                        this.$description = _description;
                        this.$deviceIndex = _deviceIndex;
                        this.$groups = _groups;
                        this.$ipv6AddressCount = _ipv6AddressCount;
                        this.$ipv6Addresses = _ipv6Addresses;
                        this.$networkInterfaceId = _networkInterfaceId;
                        this.$privateIpAddresses = _privateIpAddresses;
                        this.$secondaryPrivateIpAddressCount = _secondaryPrivateIpAddressCount;
                        this.$subnetId = _subnetId;
                    }

                    @Override
                    public Object getAssociatePublicIpAddress() {
                        return this.$associatePublicIpAddress;
                    }

                    @Override
                    public void setAssociatePublicIpAddress(@Nullable Boolean value) {
                        this.$associatePublicIpAddress = value;
                    }

                    @Override
                    public void setAssociatePublicIpAddress(@Nullable CloudFormationToken value) {
                        this.$associatePublicIpAddress = value;
                    }

                    @Override
                    public Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public void setDeleteOnTermination(@Nullable Boolean value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public void setDeleteOnTermination(@Nullable CloudFormationToken value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public Object getDescription() {
                        return this.$description;
                    }

                    @Override
                    public void setDescription(@Nullable String value) {
                        this.$description = value;
                    }

                    @Override
                    public void setDescription(@Nullable CloudFormationToken value) {
                        this.$description = value;
                    }

                    @Override
                    public Object getDeviceIndex() {
                        return this.$deviceIndex;
                    }

                    @Override
                    public void setDeviceIndex(@Nullable Number value) {
                        this.$deviceIndex = value;
                    }

                    @Override
                    public void setDeviceIndex(@Nullable CloudFormationToken value) {
                        this.$deviceIndex = value;
                    }

                    @Override
                    public Object getGroups() {
                        return this.$groups;
                    }

                    @Override
                    public void setGroups(@Nullable CloudFormationToken value) {
                        this.$groups = value;
                    }

                    @Override
                    public void setGroups(@Nullable List<Object> value) {
                        this.$groups = value;
                    }

                    @Override
                    public Object getIpv6AddressCount() {
                        return this.$ipv6AddressCount;
                    }

                    @Override
                    public void setIpv6AddressCount(@Nullable Number value) {
                        this.$ipv6AddressCount = value;
                    }

                    @Override
                    public void setIpv6AddressCount(@Nullable CloudFormationToken value) {
                        this.$ipv6AddressCount = value;
                    }

                    @Override
                    public Object getIpv6Addresses() {
                        return this.$ipv6Addresses;
                    }

                    @Override
                    public void setIpv6Addresses(@Nullable CloudFormationToken value) {
                        this.$ipv6Addresses = value;
                    }

                    @Override
                    public void setIpv6Addresses(@Nullable List<Object> value) {
                        this.$ipv6Addresses = value;
                    }

                    @Override
                    public Object getNetworkInterfaceId() {
                        return this.$networkInterfaceId;
                    }

                    @Override
                    public void setNetworkInterfaceId(@Nullable String value) {
                        this.$networkInterfaceId = value;
                    }

                    @Override
                    public void setNetworkInterfaceId(@Nullable CloudFormationToken value) {
                        this.$networkInterfaceId = value;
                    }

                    @Override
                    public Object getPrivateIpAddresses() {
                        return this.$privateIpAddresses;
                    }

                    @Override
                    public void setPrivateIpAddresses(@Nullable CloudFormationToken value) {
                        this.$privateIpAddresses = value;
                    }

                    @Override
                    public void setPrivateIpAddresses(@Nullable List<Object> value) {
                        this.$privateIpAddresses = value;
                    }

                    @Override
                    public Object getSecondaryPrivateIpAddressCount() {
                        return this.$secondaryPrivateIpAddressCount;
                    }

                    @Override
                    public void setSecondaryPrivateIpAddressCount(@Nullable Number value) {
                        this.$secondaryPrivateIpAddressCount = value;
                    }

                    @Override
                    public void setSecondaryPrivateIpAddressCount(@Nullable CloudFormationToken value) {
                        this.$secondaryPrivateIpAddressCount = value;
                    }

                    @Override
                    public Object getSubnetId() {
                        return this.$subnetId;
                    }

                    @Override
                    public void setSubnetId(@Nullable String value) {
                        this.$subnetId = value;
                    }

                    @Override
                    public void setSubnetId(@Nullable CloudFormationToken value) {
                        this.$subnetId = value;
                    }
                };
            }
        }
    }

    public static interface InstanceIpv6AddressProperty
    extends JsiiSerializable {
        public Object getIpv6Address();

        public void setIpv6Address(String var1);

        public void setIpv6Address(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _ipv6Address;

            public Builder withIpv6Address(String value) {
                this._ipv6Address = Objects.requireNonNull(value, "ipv6Address is required");
                return this;
            }

            public Builder withIpv6Address(CloudFormationToken value) {
                this._ipv6Address = Objects.requireNonNull(value, "ipv6Address is required");
                return this;
            }

            public InstanceIpv6AddressProperty build() {
                return new InstanceIpv6AddressProperty(){
                    private Object $ipv6Address;
                    {
                        this.$ipv6Address = Objects.requireNonNull(_ipv6Address, "ipv6Address is required");
                    }

                    @Override
                    public Object getIpv6Address() {
                        return this.$ipv6Address;
                    }

                    @Override
                    public void setIpv6Address(String value) {
                        this.$ipv6Address = Objects.requireNonNull(value, "ipv6Address is required");
                    }

                    @Override
                    public void setIpv6Address(CloudFormationToken value) {
                        this.$ipv6Address = Objects.requireNonNull(value, "ipv6Address is required");
                    }
                };
            }
        }
    }

    public static interface IamInstanceProfileSpecificationProperty
    extends JsiiSerializable {
        public Object getArn();

        public void setArn(String var1);

        public void setArn(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _arn;

            public Builder withArn(@Nullable String value) {
                this._arn = value;
                return this;
            }

            public Builder withArn(@Nullable CloudFormationToken value) {
                this._arn = value;
                return this;
            }

            public IamInstanceProfileSpecificationProperty build() {
                return new IamInstanceProfileSpecificationProperty(){
                    @Nullable
                    private Object $arn;
                    {
                        this.$arn = _arn;
                    }

                    @Override
                    public Object getArn() {
                        return this.$arn;
                    }

                    @Override
                    public void setArn(@Nullable String value) {
                        this.$arn = value;
                    }

                    @Override
                    public void setArn(@Nullable CloudFormationToken value) {
                        this.$arn = value;
                    }
                };
            }
        }
    }

    public static interface GroupIdentifierProperty
    extends JsiiSerializable {
        public Object getGroupId();

        public void setGroupId(String var1);

        public void setGroupId(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _groupId;

            public Builder withGroupId(String value) {
                this._groupId = Objects.requireNonNull(value, "groupId is required");
                return this;
            }

            public Builder withGroupId(CloudFormationToken value) {
                this._groupId = Objects.requireNonNull(value, "groupId is required");
                return this;
            }

            public GroupIdentifierProperty build() {
                return new GroupIdentifierProperty(){
                    private Object $groupId;
                    {
                        this.$groupId = Objects.requireNonNull(_groupId, "groupId is required");
                    }

                    @Override
                    public Object getGroupId() {
                        return this.$groupId;
                    }

                    @Override
                    public void setGroupId(String value) {
                        this.$groupId = Objects.requireNonNull(value, "groupId is required");
                    }

                    @Override
                    public void setGroupId(CloudFormationToken value) {
                        this.$groupId = Objects.requireNonNull(value, "groupId is required");
                    }
                };
            }
        }
    }

    public static interface EbsBlockDeviceProperty
    extends JsiiSerializable {
        public Object getDeleteOnTermination();

        public void setDeleteOnTermination(Boolean var1);

        public void setDeleteOnTermination(CloudFormationToken var1);

        public Object getEncrypted();

        public void setEncrypted(Boolean var1);

        public void setEncrypted(CloudFormationToken var1);

        public Object getIops();

        public void setIops(Number var1);

        public void setIops(CloudFormationToken var1);

        public Object getSnapshotId();

        public void setSnapshotId(String var1);

        public void setSnapshotId(CloudFormationToken var1);

        public Object getVolumeSize();

        public void setVolumeSize(Number var1);

        public void setVolumeSize(CloudFormationToken var1);

        public Object getVolumeType();

        public void setVolumeType(String var1);

        public void setVolumeType(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _deleteOnTermination;
            @Nullable
            private Object _encrypted;
            @Nullable
            private Object _iops;
            @Nullable
            private Object _snapshotId;
            @Nullable
            private Object _volumeSize;
            @Nullable
            private Object _volumeType;

            public Builder withDeleteOnTermination(@Nullable Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }

            public Builder withDeleteOnTermination(@Nullable CloudFormationToken value) {
                this._deleteOnTermination = value;
                return this;
            }

            public Builder withEncrypted(@Nullable Boolean value) {
                this._encrypted = value;
                return this;
            }

            public Builder withEncrypted(@Nullable CloudFormationToken value) {
                this._encrypted = value;
                return this;
            }

            public Builder withIops(@Nullable Number value) {
                this._iops = value;
                return this;
            }

            public Builder withIops(@Nullable CloudFormationToken value) {
                this._iops = value;
                return this;
            }

            public Builder withSnapshotId(@Nullable String value) {
                this._snapshotId = value;
                return this;
            }

            public Builder withSnapshotId(@Nullable CloudFormationToken value) {
                this._snapshotId = value;
                return this;
            }

            public Builder withVolumeSize(@Nullable Number value) {
                this._volumeSize = value;
                return this;
            }

            public Builder withVolumeSize(@Nullable CloudFormationToken value) {
                this._volumeSize = value;
                return this;
            }

            public Builder withVolumeType(@Nullable String value) {
                this._volumeType = value;
                return this;
            }

            public Builder withVolumeType(@Nullable CloudFormationToken value) {
                this._volumeType = value;
                return this;
            }

            public EbsBlockDeviceProperty build() {
                return new EbsBlockDeviceProperty(){
                    @Nullable
                    private Object $deleteOnTermination;
                    @Nullable
                    private Object $encrypted;
                    @Nullable
                    private Object $iops;
                    @Nullable
                    private Object $snapshotId;
                    @Nullable
                    private Object $volumeSize;
                    @Nullable
                    private Object $volumeType;
                    {
                        this.$deleteOnTermination = _deleteOnTermination;
                        this.$encrypted = _encrypted;
                        this.$iops = _iops;
                        this.$snapshotId = _snapshotId;
                        this.$volumeSize = _volumeSize;
                        this.$volumeType = _volumeType;
                    }

                    @Override
                    public Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public void setDeleteOnTermination(@Nullable Boolean value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public void setDeleteOnTermination(@Nullable CloudFormationToken value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public Object getEncrypted() {
                        return this.$encrypted;
                    }

                    @Override
                    public void setEncrypted(@Nullable Boolean value) {
                        this.$encrypted = value;
                    }

                    @Override
                    public void setEncrypted(@Nullable CloudFormationToken value) {
                        this.$encrypted = value;
                    }

                    @Override
                    public Object getIops() {
                        return this.$iops;
                    }

                    @Override
                    public void setIops(@Nullable Number value) {
                        this.$iops = value;
                    }

                    @Override
                    public void setIops(@Nullable CloudFormationToken value) {
                        this.$iops = value;
                    }

                    @Override
                    public Object getSnapshotId() {
                        return this.$snapshotId;
                    }

                    @Override
                    public void setSnapshotId(@Nullable String value) {
                        this.$snapshotId = value;
                    }

                    @Override
                    public void setSnapshotId(@Nullable CloudFormationToken value) {
                        this.$snapshotId = value;
                    }

                    @Override
                    public Object getVolumeSize() {
                        return this.$volumeSize;
                    }

                    @Override
                    public void setVolumeSize(@Nullable Number value) {
                        this.$volumeSize = value;
                    }

                    @Override
                    public void setVolumeSize(@Nullable CloudFormationToken value) {
                        this.$volumeSize = value;
                    }

                    @Override
                    public Object getVolumeType() {
                        return this.$volumeType;
                    }

                    @Override
                    public void setVolumeType(@Nullable String value) {
                        this.$volumeType = value;
                    }

                    @Override
                    public void setVolumeType(@Nullable CloudFormationToken value) {
                        this.$volumeType = value;
                    }
                };
            }
        }
    }

    public static interface BlockDeviceMappingProperty
    extends JsiiSerializable {
        public Object getDeviceName();

        public void setDeviceName(String var1);

        public void setDeviceName(CloudFormationToken var1);

        public Object getEbs();

        public void setEbs(CloudFormationToken var1);

        public void setEbs(EbsBlockDeviceProperty var1);

        public Object getNoDevice();

        public void setNoDevice(String var1);

        public void setNoDevice(CloudFormationToken var1);

        public Object getVirtualName();

        public void setVirtualName(String var1);

        public void setVirtualName(CloudFormationToken var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _deviceName;
            @Nullable
            private Object _ebs;
            @Nullable
            private Object _noDevice;
            @Nullable
            private Object _virtualName;

            public Builder withDeviceName(String value) {
                this._deviceName = Objects.requireNonNull(value, "deviceName is required");
                return this;
            }

            public Builder withDeviceName(CloudFormationToken value) {
                this._deviceName = Objects.requireNonNull(value, "deviceName is required");
                return this;
            }

            public Builder withEbs(@Nullable CloudFormationToken value) {
                this._ebs = value;
                return this;
            }

            public Builder withEbs(@Nullable EbsBlockDeviceProperty value) {
                this._ebs = value;
                return this;
            }

            public Builder withNoDevice(@Nullable String value) {
                this._noDevice = value;
                return this;
            }

            public Builder withNoDevice(@Nullable CloudFormationToken value) {
                this._noDevice = value;
                return this;
            }

            public Builder withVirtualName(@Nullable String value) {
                this._virtualName = value;
                return this;
            }

            public Builder withVirtualName(@Nullable CloudFormationToken value) {
                this._virtualName = value;
                return this;
            }

            public BlockDeviceMappingProperty build() {
                return new BlockDeviceMappingProperty(){
                    private Object $deviceName;
                    @Nullable
                    private Object $ebs;
                    @Nullable
                    private Object $noDevice;
                    @Nullable
                    private Object $virtualName;
                    {
                        this.$deviceName = Objects.requireNonNull(_deviceName, "deviceName is required");
                        this.$ebs = _ebs;
                        this.$noDevice = _noDevice;
                        this.$virtualName = _virtualName;
                    }

                    @Override
                    public Object getDeviceName() {
                        return this.$deviceName;
                    }

                    @Override
                    public void setDeviceName(String value) {
                        this.$deviceName = Objects.requireNonNull(value, "deviceName is required");
                    }

                    @Override
                    public void setDeviceName(CloudFormationToken value) {
                        this.$deviceName = Objects.requireNonNull(value, "deviceName is required");
                    }

                    @Override
                    public Object getEbs() {
                        return this.$ebs;
                    }

                    @Override
                    public void setEbs(@Nullable CloudFormationToken value) {
                        this.$ebs = value;
                    }

                    @Override
                    public void setEbs(@Nullable EbsBlockDeviceProperty value) {
                        this.$ebs = value;
                    }

                    @Override
                    public Object getNoDevice() {
                        return this.$noDevice;
                    }

                    @Override
                    public void setNoDevice(@Nullable String value) {
                        this.$noDevice = value;
                    }

                    @Override
                    public void setNoDevice(@Nullable CloudFormationToken value) {
                        this.$noDevice = value;
                    }

                    @Override
                    public Object getVirtualName() {
                        return this.$virtualName;
                    }

                    @Override
                    public void setVirtualName(@Nullable String value) {
                        this.$virtualName = value;
                    }

                    @Override
                    public void setVirtualName(@Nullable CloudFormationToken value) {
                        this.$virtualName = value;
                    }
                };
            }
        }
    }
}

