package software.amazon.awscdk.services.ec2;

/**
 * What class and generation of instance to use.
 * 
 * We have both symbolic and concrete enums for every type.
 * 
 * The first are for people that want to specify by purpose,
 * the second one are for people who already know exactly what
 * 'R4' means.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-11T14:13:21.683Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.InstanceClass")
public enum InstanceClass {
    /**
     * Standard instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD3,
    /**
     * Standard instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD4,
    /**
     * Standard instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5,
    /**
     * Memory optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY3,
    /**
     * Memory optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY4,
    /**
     * Compute optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE3,
    /**
     * Compute optimized instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE4,
    /**
     * Compute optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE5,
    /**
     * Storage-optimized instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STORAGE2,
    /**
     * Storage/compute balanced instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STORAGE_COMPUTE_1,
    /**
     * I/O-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IO3,
    /**
     * Burstable instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BURSTABLE2,
    /**
     * Burstable instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BURSTABLE3,
    /**
     * Memory-intensive instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY_INTENSIVE_1,
    /**
     * Memory-intensive instances, extended, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY_INTENSIVE_1_EXTENDED,
    /**
     * Instances with customizable hardware acceleration, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FPGA1,
    /**
     * Graphics-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GRAPHICS3,
    /**
     * Parallel-processing optimized instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PARALLEL2,
    /**
     * Parallel-processing optimized instances, 3nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PARALLEL3,
}
