package software.amazon.awscdk.services.ec2;

/**
 * Options to add an interface endpoint to a VPC.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-11T14:13:21.685Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InterfaceVpcEndpointOptions extends software.amazon.jsii.JsiiSerializable {
    /**
     * The service to use for this interface VPC endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService getService();
    /**
     * Whether to associate a private hosted zone with the specified VPC.
     * 
     * This
     * allows you to make requests to the service using its default DNS hostname.
     * 
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getPrivateDnsEnabled();
    /**
     * The subnets in which to create an endpoint network interface.
     * 
     * At most one
     * per availability zone.
     * 
     * Default: private subnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.SubnetSelection getSubnets();

    /**
     * @return a {@link Builder} of {@link InterfaceVpcEndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link InterfaceVpcEndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService _service;
        @javax.annotation.Nullable
        private java.lang.Boolean _privateDnsEnabled;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.SubnetSelection _subnets;

        /**
         * Sets the value of Service
         * @param value The service to use for this interface VPC endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withService(final software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService value) {
            this._service = java.util.Objects.requireNonNull(value, "service is required");
            return this;
        }
        /**
         * Sets the value of PrivateDnsEnabled
         * @param value Whether to associate a private hosted zone with the specified VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPrivateDnsEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._privateDnsEnabled = value;
            return this;
        }
        /**
         * Sets the value of Subnets
         * @param value The subnets in which to create an endpoint network interface.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withSubnets(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.SubnetSelection value) {
            this._subnets = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InterfaceVpcEndpointOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public InterfaceVpcEndpointOptions build() {
            return new InterfaceVpcEndpointOptions() {
                private final software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService $service = java.util.Objects.requireNonNull(_service, "service is required");
                @javax.annotation.Nullable
                private final java.lang.Boolean $privateDnsEnabled = _privateDnsEnabled;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.SubnetSelection $subnets = _subnets;

                @Override
                public software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService getService() {
                    return this.$service;
                }

                @Override
                public java.lang.Boolean getPrivateDnsEnabled() {
                    return this.$privateDnsEnabled;
                }

                @Override
                public software.amazon.awscdk.services.ec2.SubnetSelection getSubnets() {
                    return this.$subnets;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("service", om.valueToTree(this.getService()));
                    if (this.getPrivateDnsEnabled() != null) {
                        obj.set("privateDnsEnabled", om.valueToTree(this.getPrivateDnsEnabled()));
                    }
                    if (this.getSubnets() != null) {
                        obj.set("subnets", om.valueToTree(this.getSubnets()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.InterfaceVpcEndpointOptions {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The service to use for this interface VPC endpoint.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService getService() {
            return this.jsiiGet("service", software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService.class);
        }

        /**
         * Whether to associate a private hosted zone with the specified VPC.
         * 
         * This
         * allows you to make requests to the service using its default DNS hostname.
         * 
         * Default: true
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getPrivateDnsEnabled() {
            return this.jsiiGet("privateDnsEnabled", java.lang.Boolean.class);
        }

        /**
         * The subnets in which to create an endpoint network interface.
         * 
         * At most one
         * per availability zone.
         * 
         * Default: private subnets
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.SubnetSelection getSubnets() {
            return this.jsiiGet("subnets", software.amazon.awscdk.services.ec2.SubnetSelection.class);
        }
    }
}
