/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.ec2.CfnNetworkAclEntry;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnNetworkAclEntryProps
extends JsiiSerializable {
    public String getNetworkAclId();

    public Number getProtocol();

    public String getRuleAction();

    public Number getRuleNumber();

    public String getCidrBlock();

    public Object getEgress();

    public Object getIcmp();

    public String getIpv6CidrBlock();

    public Object getPortRange();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _networkAclId;
        private Number _protocol;
        private String _ruleAction;
        private Number _ruleNumber;
        @Nullable
        private String _cidrBlock;
        @Nullable
        private Object _egress;
        @Nullable
        private Object _icmp;
        @Nullable
        private String _ipv6CidrBlock;
        @Nullable
        private Object _portRange;

        public Builder withNetworkAclId(String value) {
            this._networkAclId = Objects.requireNonNull(value, "networkAclId is required");
            return this;
        }

        public Builder withProtocol(Number value) {
            this._protocol = Objects.requireNonNull(value, "protocol is required");
            return this;
        }

        public Builder withRuleAction(String value) {
            this._ruleAction = Objects.requireNonNull(value, "ruleAction is required");
            return this;
        }

        public Builder withRuleNumber(Number value) {
            this._ruleNumber = Objects.requireNonNull(value, "ruleNumber is required");
            return this;
        }

        public Builder withCidrBlock(@Nullable String value) {
            this._cidrBlock = value;
            return this;
        }

        public Builder withEgress(@Nullable Boolean value) {
            this._egress = value;
            return this;
        }

        public Builder withEgress(@Nullable IResolvable value) {
            this._egress = value;
            return this;
        }

        public Builder withIcmp(@Nullable IResolvable value) {
            this._icmp = value;
            return this;
        }

        public Builder withIcmp(@Nullable CfnNetworkAclEntry.IcmpProperty value) {
            this._icmp = value;
            return this;
        }

        public Builder withIpv6CidrBlock(@Nullable String value) {
            this._ipv6CidrBlock = value;
            return this;
        }

        public Builder withPortRange(@Nullable IResolvable value) {
            this._portRange = value;
            return this;
        }

        public Builder withPortRange(@Nullable CfnNetworkAclEntry.PortRangeProperty value) {
            this._portRange = value;
            return this;
        }

        public CfnNetworkAclEntryProps build() {
            return new CfnNetworkAclEntryProps(){
                private final String $networkAclId;
                private final Number $protocol;
                private final String $ruleAction;
                private final Number $ruleNumber;
                @Nullable
                private final String $cidrBlock;
                @Nullable
                private final Object $egress;
                @Nullable
                private final Object $icmp;
                @Nullable
                private final String $ipv6CidrBlock;
                @Nullable
                private final Object $portRange;
                {
                    this.$networkAclId = Objects.requireNonNull(_networkAclId, "networkAclId is required");
                    this.$protocol = Objects.requireNonNull(_protocol, "protocol is required");
                    this.$ruleAction = Objects.requireNonNull(_ruleAction, "ruleAction is required");
                    this.$ruleNumber = Objects.requireNonNull(_ruleNumber, "ruleNumber is required");
                    this.$cidrBlock = _cidrBlock;
                    this.$egress = _egress;
                    this.$icmp = _icmp;
                    this.$ipv6CidrBlock = _ipv6CidrBlock;
                    this.$portRange = _portRange;
                }

                @Override
                public String getNetworkAclId() {
                    return this.$networkAclId;
                }

                @Override
                public Number getProtocol() {
                    return this.$protocol;
                }

                @Override
                public String getRuleAction() {
                    return this.$ruleAction;
                }

                @Override
                public Number getRuleNumber() {
                    return this.$ruleNumber;
                }

                @Override
                public String getCidrBlock() {
                    return this.$cidrBlock;
                }

                @Override
                public Object getEgress() {
                    return this.$egress;
                }

                @Override
                public Object getIcmp() {
                    return this.$icmp;
                }

                @Override
                public String getIpv6CidrBlock() {
                    return this.$ipv6CidrBlock;
                }

                @Override
                public Object getPortRange() {
                    return this.$portRange;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("networkAclId", om.valueToTree((Object)this.getNetworkAclId()));
                    obj.set("protocol", om.valueToTree((Object)this.getProtocol()));
                    obj.set("ruleAction", om.valueToTree((Object)this.getRuleAction()));
                    obj.set("ruleNumber", om.valueToTree((Object)this.getRuleNumber()));
                    if (this.getCidrBlock() != null) {
                        obj.set("cidrBlock", om.valueToTree((Object)this.getCidrBlock()));
                    }
                    if (this.getEgress() != null) {
                        obj.set("egress", om.valueToTree(this.getEgress()));
                    }
                    if (this.getIcmp() != null) {
                        obj.set("icmp", om.valueToTree(this.getIcmp()));
                    }
                    if (this.getIpv6CidrBlock() != null) {
                        obj.set("ipv6CidrBlock", om.valueToTree((Object)this.getIpv6CidrBlock()));
                    }
                    if (this.getPortRange() != null) {
                        obj.set("portRange", om.valueToTree(this.getPortRange()));
                    }
                    return obj;
                }
            };
        }
    }
}

