/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.Protocol;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface PortProps
extends JsiiSerializable {
    public Protocol getProtocol();

    public String getStringRepresentation();

    public Number getFromPort();

    public Number getToPort();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Protocol _protocol;
        private String _stringRepresentation;
        @Nullable
        private Number _fromPort;
        @Nullable
        private Number _toPort;

        public Builder withProtocol(Protocol value) {
            this._protocol = Objects.requireNonNull(value, "protocol is required");
            return this;
        }

        public Builder withStringRepresentation(String value) {
            this._stringRepresentation = Objects.requireNonNull(value, "stringRepresentation is required");
            return this;
        }

        public Builder withFromPort(@Nullable Number value) {
            this._fromPort = value;
            return this;
        }

        public Builder withToPort(@Nullable Number value) {
            this._toPort = value;
            return this;
        }

        public PortProps build() {
            return new PortProps(){
                private final Protocol $protocol;
                private final String $stringRepresentation;
                @Nullable
                private final Number $fromPort;
                @Nullable
                private final Number $toPort;
                {
                    this.$protocol = Objects.requireNonNull(_protocol, "protocol is required");
                    this.$stringRepresentation = Objects.requireNonNull(_stringRepresentation, "stringRepresentation is required");
                    this.$fromPort = _fromPort;
                    this.$toPort = _toPort;
                }

                @Override
                public Protocol getProtocol() {
                    return this.$protocol;
                }

                @Override
                public String getStringRepresentation() {
                    return this.$stringRepresentation;
                }

                @Override
                public Number getFromPort() {
                    return this.$fromPort;
                }

                @Override
                public Number getToPort() {
                    return this.$toPort;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("protocol", om.valueToTree((Object)this.getProtocol()));
                    obj.set("stringRepresentation", om.valueToTree((Object)this.getStringRepresentation()));
                    if (this.getFromPort() != null) {
                        obj.set("fromPort", om.valueToTree((Object)this.getFromPort()));
                    }
                    if (this.getToPort() != null) {
                        obj.set("toPort", om.valueToTree((Object)this.getToPort()));
                    }
                    return obj;
                }
            };
        }
    }
}

