package software.amazon.awscdk.services.ec2;

/**
 * Amazon Linux image properties.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.2 (build e881f16)", date = "2019-07-19T19:06:47.474Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AmazonLinuxImageProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * What edition of Amazon Linux to use.
     * 
     * Default: Standard
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.AmazonLinuxEdition getEdition();
    /**
     * What generation of Amazon Linux to use.
     * 
     * Default: AmazonLinux
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.AmazonLinuxGeneration getGeneration();
    /**
     * What storage backed image to use.
     * 
     * Default: GeneralPurpose
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.AmazonLinuxStorage getStorage();
    /**
     * Initial user data.
     * 
     * Default: - Empty UserData for Linux machines
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.UserData getUserData();
    /**
     * Virtualization type.
     * 
     * Default: HVM
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.AmazonLinuxVirt getVirtualization();

    /**
     * @return a {@link Builder} of {@link AmazonLinuxImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link AmazonLinuxImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.AmazonLinuxEdition _edition;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.AmazonLinuxGeneration _generation;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.AmazonLinuxStorage _storage;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.UserData _userData;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.AmazonLinuxVirt _virtualization;

        /**
         * Sets the value of Edition
         * @param value What edition of Amazon Linux to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withEdition(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.AmazonLinuxEdition value) {
            this._edition = value;
            return this;
        }
        /**
         * Sets the value of Generation
         * @param value What generation of Amazon Linux to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withGeneration(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.AmazonLinuxGeneration value) {
            this._generation = value;
            return this;
        }
        /**
         * Sets the value of Storage
         * @param value What storage backed image to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withStorage(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.AmazonLinuxStorage value) {
            this._storage = value;
            return this;
        }
        /**
         * Sets the value of UserData
         * @param value Initial user data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withUserData(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.UserData value) {
            this._userData = value;
            return this;
        }
        /**
         * Sets the value of Virtualization
         * @param value Virtualization type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withVirtualization(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.AmazonLinuxVirt value) {
            this._virtualization = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AmazonLinuxImageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public AmazonLinuxImageProps build() {
            return new AmazonLinuxImageProps() {
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.AmazonLinuxEdition $edition = _edition;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.AmazonLinuxGeneration $generation = _generation;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.AmazonLinuxStorage $storage = _storage;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.UserData $userData = _userData;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.AmazonLinuxVirt $virtualization = _virtualization;

                @Override
                public software.amazon.awscdk.services.ec2.AmazonLinuxEdition getEdition() {
                    return this.$edition;
                }

                @Override
                public software.amazon.awscdk.services.ec2.AmazonLinuxGeneration getGeneration() {
                    return this.$generation;
                }

                @Override
                public software.amazon.awscdk.services.ec2.AmazonLinuxStorage getStorage() {
                    return this.$storage;
                }

                @Override
                public software.amazon.awscdk.services.ec2.UserData getUserData() {
                    return this.$userData;
                }

                @Override
                public software.amazon.awscdk.services.ec2.AmazonLinuxVirt getVirtualization() {
                    return this.$virtualization;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getEdition() != null) {
                        obj.set("edition", om.valueToTree(this.getEdition()));
                    }
                    if (this.getGeneration() != null) {
                        obj.set("generation", om.valueToTree(this.getGeneration()));
                    }
                    if (this.getStorage() != null) {
                        obj.set("storage", om.valueToTree(this.getStorage()));
                    }
                    if (this.getUserData() != null) {
                        obj.set("userData", om.valueToTree(this.getUserData()));
                    }
                    if (this.getVirtualization() != null) {
                        obj.set("virtualization", om.valueToTree(this.getVirtualization()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.AmazonLinuxImageProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * What edition of Amazon Linux to use.
         * 
         * Default: Standard
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.AmazonLinuxEdition getEdition() {
            return this.jsiiGet("edition", software.amazon.awscdk.services.ec2.AmazonLinuxEdition.class);
        }

        /**
         * What generation of Amazon Linux to use.
         * 
         * Default: AmazonLinux
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.AmazonLinuxGeneration getGeneration() {
            return this.jsiiGet("generation", software.amazon.awscdk.services.ec2.AmazonLinuxGeneration.class);
        }

        /**
         * What storage backed image to use.
         * 
         * Default: GeneralPurpose
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.AmazonLinuxStorage getStorage() {
            return this.jsiiGet("storage", software.amazon.awscdk.services.ec2.AmazonLinuxStorage.class);
        }

        /**
         * Initial user data.
         * 
         * Default: - Empty UserData for Linux machines
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.UserData getUserData() {
            return this.jsiiGet("userData", software.amazon.awscdk.services.ec2.UserData.class);
        }

        /**
         * Virtualization type.
         * 
         * Default: HVM
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.AmazonLinuxVirt getVirtualization() {
            return this.jsiiGet("virtualization", software.amazon.awscdk.services.ec2.AmazonLinuxVirt.class);
        }
    }
}
