package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::CapacityReservation`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.2 (build e881f16)", date = "2019-07-19T19:06:47.481Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnCapacityReservationProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::EC2::CapacityReservation.AvailabilityZone`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-availabilityzone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getAvailabilityZone();
    /**
     * `AWS::EC2::CapacityReservation.InstanceCount`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancecount
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Number getInstanceCount();
    /**
     * `AWS::EC2::CapacityReservation.InstancePlatform`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instanceplatform
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getInstancePlatform();
    /**
     * `AWS::EC2::CapacityReservation.InstanceType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancetype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getInstanceType();
    /**
     * `AWS::EC2::CapacityReservation.EbsOptimized`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-ebsoptimized
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getEbsOptimized();
    /**
     * `AWS::EC2::CapacityReservation.EndDate`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-enddate
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getEndDate();
    /**
     * `AWS::EC2::CapacityReservation.EndDateType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-enddatetype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getEndDateType();
    /**
     * `AWS::EC2::CapacityReservation.EphemeralStorage`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-ephemeralstorage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getEphemeralStorage();
    /**
     * `AWS::EC2::CapacityReservation.InstanceMatchCriteria`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancematchcriteria
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getInstanceMatchCriteria();
    /**
     * `AWS::EC2::CapacityReservation.TagSpecifications`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-tagspecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getTagSpecifications();
    /**
     * `AWS::EC2::CapacityReservation.Tenancy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-tenancy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getTenancy();

    /**
     * @return a {@link Builder} of {@link CfnCapacityReservationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnCapacityReservationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Builder {
        private java.lang.String _availabilityZone;
        private java.lang.Number _instanceCount;
        private java.lang.String _instancePlatform;
        private java.lang.String _instanceType;
        @javax.annotation.Nullable
        private java.lang.Object _ebsOptimized;
        @javax.annotation.Nullable
        private java.lang.String _endDate;
        @javax.annotation.Nullable
        private java.lang.String _endDateType;
        @javax.annotation.Nullable
        private java.lang.Object _ephemeralStorage;
        @javax.annotation.Nullable
        private java.lang.String _instanceMatchCriteria;
        @javax.annotation.Nullable
        private java.lang.Object _tagSpecifications;
        @javax.annotation.Nullable
        private java.lang.String _tenancy;

        /**
         * Sets the value of AvailabilityZone
         * @param value `AWS::EC2::CapacityReservation.AvailabilityZone`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder withAvailabilityZone(final java.lang.String value) {
            this._availabilityZone = java.util.Objects.requireNonNull(value, "availabilityZone is required");
            return this;
        }
        /**
         * Sets the value of InstanceCount
         * @param value `AWS::EC2::CapacityReservation.InstanceCount`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder withInstanceCount(final java.lang.Number value) {
            this._instanceCount = java.util.Objects.requireNonNull(value, "instanceCount is required");
            return this;
        }
        /**
         * Sets the value of InstancePlatform
         * @param value `AWS::EC2::CapacityReservation.InstancePlatform`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder withInstancePlatform(final java.lang.String value) {
            this._instancePlatform = java.util.Objects.requireNonNull(value, "instancePlatform is required");
            return this;
        }
        /**
         * Sets the value of InstanceType
         * @param value `AWS::EC2::CapacityReservation.InstanceType`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder withInstanceType(final java.lang.String value) {
            this._instanceType = java.util.Objects.requireNonNull(value, "instanceType is required");
            return this;
        }
        /**
         * Sets the value of EbsOptimized
         * @param value `AWS::EC2::CapacityReservation.EbsOptimized`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder withEbsOptimized(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._ebsOptimized = value;
            return this;
        }
        /**
         * Sets the value of EbsOptimized
         * @param value `AWS::EC2::CapacityReservation.EbsOptimized`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder withEbsOptimized(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
            this._ebsOptimized = value;
            return this;
        }
        /**
         * Sets the value of EndDate
         * @param value `AWS::EC2::CapacityReservation.EndDate`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder withEndDate(@javax.annotation.Nullable final java.lang.String value) {
            this._endDate = value;
            return this;
        }
        /**
         * Sets the value of EndDateType
         * @param value `AWS::EC2::CapacityReservation.EndDateType`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder withEndDateType(@javax.annotation.Nullable final java.lang.String value) {
            this._endDateType = value;
            return this;
        }
        /**
         * Sets the value of EphemeralStorage
         * @param value `AWS::EC2::CapacityReservation.EphemeralStorage`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder withEphemeralStorage(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._ephemeralStorage = value;
            return this;
        }
        /**
         * Sets the value of EphemeralStorage
         * @param value `AWS::EC2::CapacityReservation.EphemeralStorage`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder withEphemeralStorage(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
            this._ephemeralStorage = value;
            return this;
        }
        /**
         * Sets the value of InstanceMatchCriteria
         * @param value `AWS::EC2::CapacityReservation.InstanceMatchCriteria`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder withInstanceMatchCriteria(@javax.annotation.Nullable final java.lang.String value) {
            this._instanceMatchCriteria = value;
            return this;
        }
        /**
         * Sets the value of TagSpecifications
         * @param value `AWS::EC2::CapacityReservation.TagSpecifications`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder withTagSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
            this._tagSpecifications = value;
            return this;
        }
        /**
         * Sets the value of TagSpecifications
         * @param value `AWS::EC2::CapacityReservation.TagSpecifications`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder withTagSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this._tagSpecifications = value;
            return this;
        }
        /**
         * Sets the value of Tenancy
         * @param value `AWS::EC2::CapacityReservation.Tenancy`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder withTenancy(@javax.annotation.Nullable final java.lang.String value) {
            this._tenancy = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCapacityReservationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnCapacityReservationProps build() {
            return new CfnCapacityReservationProps() {
                private final java.lang.String $availabilityZone = java.util.Objects.requireNonNull(_availabilityZone, "availabilityZone is required");
                private final java.lang.Number $instanceCount = java.util.Objects.requireNonNull(_instanceCount, "instanceCount is required");
                private final java.lang.String $instancePlatform = java.util.Objects.requireNonNull(_instancePlatform, "instancePlatform is required");
                private final java.lang.String $instanceType = java.util.Objects.requireNonNull(_instanceType, "instanceType is required");
                @javax.annotation.Nullable
                private final java.lang.Object $ebsOptimized = _ebsOptimized;
                @javax.annotation.Nullable
                private final java.lang.String $endDate = _endDate;
                @javax.annotation.Nullable
                private final java.lang.String $endDateType = _endDateType;
                @javax.annotation.Nullable
                private final java.lang.Object $ephemeralStorage = _ephemeralStorage;
                @javax.annotation.Nullable
                private final java.lang.String $instanceMatchCriteria = _instanceMatchCriteria;
                @javax.annotation.Nullable
                private final java.lang.Object $tagSpecifications = _tagSpecifications;
                @javax.annotation.Nullable
                private final java.lang.String $tenancy = _tenancy;

                @Override
                public java.lang.String getAvailabilityZone() {
                    return this.$availabilityZone;
                }

                @Override
                public java.lang.Number getInstanceCount() {
                    return this.$instanceCount;
                }

                @Override
                public java.lang.String getInstancePlatform() {
                    return this.$instancePlatform;
                }

                @Override
                public java.lang.String getInstanceType() {
                    return this.$instanceType;
                }

                @Override
                public java.lang.Object getEbsOptimized() {
                    return this.$ebsOptimized;
                }

                @Override
                public java.lang.String getEndDate() {
                    return this.$endDate;
                }

                @Override
                public java.lang.String getEndDateType() {
                    return this.$endDateType;
                }

                @Override
                public java.lang.Object getEphemeralStorage() {
                    return this.$ephemeralStorage;
                }

                @Override
                public java.lang.String getInstanceMatchCriteria() {
                    return this.$instanceMatchCriteria;
                }

                @Override
                public java.lang.Object getTagSpecifications() {
                    return this.$tagSpecifications;
                }

                @Override
                public java.lang.String getTenancy() {
                    return this.$tenancy;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                    obj.set("instanceCount", om.valueToTree(this.getInstanceCount()));
                    obj.set("instancePlatform", om.valueToTree(this.getInstancePlatform()));
                    obj.set("instanceType", om.valueToTree(this.getInstanceType()));
                    if (this.getEbsOptimized() != null) {
                        obj.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
                    }
                    if (this.getEndDate() != null) {
                        obj.set("endDate", om.valueToTree(this.getEndDate()));
                    }
                    if (this.getEndDateType() != null) {
                        obj.set("endDateType", om.valueToTree(this.getEndDateType()));
                    }
                    if (this.getEphemeralStorage() != null) {
                        obj.set("ephemeralStorage", om.valueToTree(this.getEphemeralStorage()));
                    }
                    if (this.getInstanceMatchCriteria() != null) {
                        obj.set("instanceMatchCriteria", om.valueToTree(this.getInstanceMatchCriteria()));
                    }
                    if (this.getTagSpecifications() != null) {
                        obj.set("tagSpecifications", om.valueToTree(this.getTagSpecifications()));
                    }
                    if (this.getTenancy() != null) {
                        obj.set("tenancy", om.valueToTree(this.getTenancy()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnCapacityReservationProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * `AWS::EC2::CapacityReservation.AvailabilityZone`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-availabilityzone
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public java.lang.String getAvailabilityZone() {
            return this.jsiiGet("availabilityZone", java.lang.String.class);
        }

        /**
         * `AWS::EC2::CapacityReservation.InstanceCount`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancecount
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public java.lang.Number getInstanceCount() {
            return this.jsiiGet("instanceCount", java.lang.Number.class);
        }

        /**
         * `AWS::EC2::CapacityReservation.InstancePlatform`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instanceplatform
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public java.lang.String getInstancePlatform() {
            return this.jsiiGet("instancePlatform", java.lang.String.class);
        }

        /**
         * `AWS::EC2::CapacityReservation.InstanceType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancetype
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public java.lang.String getInstanceType() {
            return this.jsiiGet("instanceType", java.lang.String.class);
        }

        /**
         * `AWS::EC2::CapacityReservation.EbsOptimized`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-ebsoptimized
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @javax.annotation.Nullable
        public java.lang.Object getEbsOptimized() {
            return this.jsiiGet("ebsOptimized", java.lang.Object.class);
        }

        /**
         * `AWS::EC2::CapacityReservation.EndDate`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-enddate
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @javax.annotation.Nullable
        public java.lang.String getEndDate() {
            return this.jsiiGet("endDate", java.lang.String.class);
        }

        /**
         * `AWS::EC2::CapacityReservation.EndDateType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-enddatetype
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @javax.annotation.Nullable
        public java.lang.String getEndDateType() {
            return this.jsiiGet("endDateType", java.lang.String.class);
        }

        /**
         * `AWS::EC2::CapacityReservation.EphemeralStorage`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-ephemeralstorage
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @javax.annotation.Nullable
        public java.lang.Object getEphemeralStorage() {
            return this.jsiiGet("ephemeralStorage", java.lang.Object.class);
        }

        /**
         * `AWS::EC2::CapacityReservation.InstanceMatchCriteria`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancematchcriteria
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @javax.annotation.Nullable
        public java.lang.String getInstanceMatchCriteria() {
            return this.jsiiGet("instanceMatchCriteria", java.lang.String.class);
        }

        /**
         * `AWS::EC2::CapacityReservation.TagSpecifications`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-tagspecifications
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @javax.annotation.Nullable
        public java.lang.Object getTagSpecifications() {
            return this.jsiiGet("tagSpecifications", java.lang.Object.class);
        }

        /**
         * `AWS::EC2::CapacityReservation.Tenancy`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-tenancy
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @javax.annotation.Nullable
        public java.lang.String getTenancy() {
            return this.jsiiGet("tenancy", java.lang.String.class);
        }
    }
}
