package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.2 (build e881f16)", date = "2019-07-19T19:06:47.519Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate")
public class CfnLaunchTemplate extends software.amazon.awscdk.core.CfnResource {
    protected CfnLaunchTemplate(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }
    /**
     * Create a new `AWS::EC2::LaunchTemplate`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnLaunchTemplate(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnLaunchTemplateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }
    /**
     * Create a new `AWS::EC2::LaunchTemplate`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnLaunchTemplate(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrDefaultVersionNumber() {
        return this.jsiiGet("attrDefaultVersionNumber", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrLatestVersionNumber() {
        return this.jsiiGet("attrLatestVersionNumber", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return this.jsiiGet("cfnProperties", java.util.Map.class);
    }

    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateData`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatedata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getLaunchTemplateData() {
        return this.jsiiGet("launchTemplateData", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateData`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatedata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLaunchTemplateData(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("launchTemplateData", value);
    }

    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateData`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatedata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLaunchTemplateData(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.LaunchTemplateDataProperty value) {
        this.jsiiSet("launchTemplateData", value);
    }

    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getLaunchTemplateName() {
        return this.jsiiGet("launchTemplateName", java.lang.String.class);
    }

    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLaunchTemplateName(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("launchTemplateName", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface BlockDeviceMappingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.DeviceName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-devicename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDeviceName();
        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.Ebs`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEbs();
        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.NoDevice`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-nodevice
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getNoDevice();
        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.VirtualName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-virtualname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getVirtualName();

        /**
         * @return a {@link Builder} of {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _deviceName;
            @javax.annotation.Nullable
            private java.lang.Object _ebs;
            @javax.annotation.Nullable
            private java.lang.String _noDevice;
            @javax.annotation.Nullable
            private java.lang.String _virtualName;

            /**
             * Sets the value of DeviceName
             * @param value `CfnLaunchTemplate.BlockDeviceMappingProperty.DeviceName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDeviceName(@javax.annotation.Nullable final java.lang.String value) {
                this._deviceName = value;
                return this;
            }
            /**
             * Sets the value of Ebs
             * @param value `CfnLaunchTemplate.BlockDeviceMappingProperty.Ebs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withEbs(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._ebs = value;
                return this;
            }
            /**
             * Sets the value of Ebs
             * @param value `CfnLaunchTemplate.BlockDeviceMappingProperty.Ebs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withEbs(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.EbsProperty value) {
                this._ebs = value;
                return this;
            }
            /**
             * Sets the value of NoDevice
             * @param value `CfnLaunchTemplate.BlockDeviceMappingProperty.NoDevice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withNoDevice(@javax.annotation.Nullable final java.lang.String value) {
                this._noDevice = value;
                return this;
            }
            /**
             * Sets the value of VirtualName
             * @param value `CfnLaunchTemplate.BlockDeviceMappingProperty.VirtualName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withVirtualName(@javax.annotation.Nullable final java.lang.String value) {
                this._virtualName = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlockDeviceMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public BlockDeviceMappingProperty build() {
                return new BlockDeviceMappingProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $deviceName = _deviceName;
                    @javax.annotation.Nullable
                    private final java.lang.Object $ebs = _ebs;
                    @javax.annotation.Nullable
                    private final java.lang.String $noDevice = _noDevice;
                    @javax.annotation.Nullable
                    private final java.lang.String $virtualName = _virtualName;

                    @Override
                    public java.lang.String getDeviceName() {
                        return this.$deviceName;
                    }

                    @Override
                    public java.lang.Object getEbs() {
                        return this.$ebs;
                    }

                    @Override
                    public java.lang.String getNoDevice() {
                        return this.$noDevice;
                    }

                    @Override
                    public java.lang.String getVirtualName() {
                        return this.$virtualName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getDeviceName() != null) {
                            obj.set("deviceName", om.valueToTree(this.getDeviceName()));
                        }
                        if (this.getEbs() != null) {
                            obj.set("ebs", om.valueToTree(this.getEbs()));
                        }
                        if (this.getNoDevice() != null) {
                            obj.set("noDevice", om.valueToTree(this.getNoDevice()));
                        }
                        if (this.getVirtualName() != null) {
                            obj.set("virtualName", om.valueToTree(this.getVirtualName()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.BlockDeviceMappingProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.BlockDeviceMappingProperty.DeviceName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-devicename
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getDeviceName() {
                return this.jsiiGet("deviceName", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.BlockDeviceMappingProperty.Ebs`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getEbs() {
                return this.jsiiGet("ebs", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.BlockDeviceMappingProperty.NoDevice`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-nodevice
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getNoDevice() {
                return this.jsiiGet("noDevice", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.BlockDeviceMappingProperty.VirtualName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-virtualname
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getVirtualName() {
                return this.jsiiGet("virtualName", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CapacityReservationSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationPreference`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification-capacityreservationpreference
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCapacityReservationPreference();
        /**
         * `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationTarget`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification-capacityreservationtarget
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getCapacityReservationTarget();

        /**
         * @return a {@link Builder} of {@link CapacityReservationSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CapacityReservationSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _capacityReservationPreference;
            @javax.annotation.Nullable
            private java.lang.Object _capacityReservationTarget;

            /**
             * Sets the value of CapacityReservationPreference
             * @param value `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationPreference`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withCapacityReservationPreference(@javax.annotation.Nullable final java.lang.String value) {
                this._capacityReservationPreference = value;
                return this;
            }
            /**
             * Sets the value of CapacityReservationTarget
             * @param value `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationTarget`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withCapacityReservationTarget(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._capacityReservationTarget = value;
                return this;
            }
            /**
             * Sets the value of CapacityReservationTarget
             * @param value `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationTarget`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withCapacityReservationTarget(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CapacityReservationTargetProperty value) {
                this._capacityReservationTarget = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityReservationSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CapacityReservationSpecificationProperty build() {
                return new CapacityReservationSpecificationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $capacityReservationPreference = _capacityReservationPreference;
                    @javax.annotation.Nullable
                    private final java.lang.Object $capacityReservationTarget = _capacityReservationTarget;

                    @Override
                    public java.lang.String getCapacityReservationPreference() {
                        return this.$capacityReservationPreference;
                    }

                    @Override
                    public java.lang.Object getCapacityReservationTarget() {
                        return this.$capacityReservationTarget;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getCapacityReservationPreference() != null) {
                            obj.set("capacityReservationPreference", om.valueToTree(this.getCapacityReservationPreference()));
                        }
                        if (this.getCapacityReservationTarget() != null) {
                            obj.set("capacityReservationTarget", om.valueToTree(this.getCapacityReservationTarget()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CapacityReservationSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationPreference`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification-capacityreservationpreference
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getCapacityReservationPreference() {
                return this.jsiiGet("capacityReservationPreference", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationTarget`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification-capacityreservationtarget
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getCapacityReservationTarget() {
                return this.jsiiGet("capacityReservationTarget", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-capacityreservationtarget.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CapacityReservationTargetProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.CapacityReservationTargetProperty.CapacityReservationId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-capacityreservationtarget.html#cfn-ec2-launchtemplate-capacityreservationtarget-capacityreservationid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCapacityReservationId();

        /**
         * @return a {@link Builder} of {@link CapacityReservationTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CapacityReservationTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _capacityReservationId;

            /**
             * Sets the value of CapacityReservationId
             * @param value `CfnLaunchTemplate.CapacityReservationTargetProperty.CapacityReservationId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withCapacityReservationId(@javax.annotation.Nullable final java.lang.String value) {
                this._capacityReservationId = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityReservationTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CapacityReservationTargetProperty build() {
                return new CapacityReservationTargetProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $capacityReservationId = _capacityReservationId;

                    @Override
                    public java.lang.String getCapacityReservationId() {
                        return this.$capacityReservationId;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getCapacityReservationId() != null) {
                            obj.set("capacityReservationId", om.valueToTree(this.getCapacityReservationId()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CapacityReservationTargetProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.CapacityReservationTargetProperty.CapacityReservationId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-capacityreservationtarget.html#cfn-ec2-launchtemplate-capacityreservationtarget-capacityreservationid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getCapacityReservationId() {
                return this.jsiiGet("capacityReservationId", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CpuOptionsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.CpuOptionsProperty.CoreCount`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions-corecount
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getCoreCount();
        /**
         * `CfnLaunchTemplate.CpuOptionsProperty.ThreadsPerCore`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions-threadspercore
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getThreadsPerCore();

        /**
         * @return a {@link Builder} of {@link CpuOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CpuOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Number _coreCount;
            @javax.annotation.Nullable
            private java.lang.Number _threadsPerCore;

            /**
             * Sets the value of CoreCount
             * @param value `CfnLaunchTemplate.CpuOptionsProperty.CoreCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withCoreCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._coreCount = value;
                return this;
            }
            /**
             * Sets the value of ThreadsPerCore
             * @param value `CfnLaunchTemplate.CpuOptionsProperty.ThreadsPerCore`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withThreadsPerCore(@javax.annotation.Nullable final java.lang.Number value) {
                this._threadsPerCore = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CpuOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CpuOptionsProperty build() {
                return new CpuOptionsProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Number $coreCount = _coreCount;
                    @javax.annotation.Nullable
                    private final java.lang.Number $threadsPerCore = _threadsPerCore;

                    @Override
                    public java.lang.Number getCoreCount() {
                        return this.$coreCount;
                    }

                    @Override
                    public java.lang.Number getThreadsPerCore() {
                        return this.$threadsPerCore;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getCoreCount() != null) {
                            obj.set("coreCount", om.valueToTree(this.getCoreCount()));
                        }
                        if (this.getThreadsPerCore() != null) {
                            obj.set("threadsPerCore", om.valueToTree(this.getThreadsPerCore()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CpuOptionsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.CpuOptionsProperty.CoreCount`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions-corecount
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Number getCoreCount() {
                return this.jsiiGet("coreCount", java.lang.Number.class);
            }

            /**
             * `CfnLaunchTemplate.CpuOptionsProperty.ThreadsPerCore`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions-threadspercore
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Number getThreadsPerCore() {
                return this.jsiiGet("threadsPerCore", java.lang.Number.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CreditSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.CreditSpecificationProperty.CpuCredits`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification-cpucredits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCpuCredits();

        /**
         * @return a {@link Builder} of {@link CreditSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CreditSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _cpuCredits;

            /**
             * Sets the value of CpuCredits
             * @param value `CfnLaunchTemplate.CreditSpecificationProperty.CpuCredits`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withCpuCredits(@javax.annotation.Nullable final java.lang.String value) {
                this._cpuCredits = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CreditSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CreditSpecificationProperty build() {
                return new CreditSpecificationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $cpuCredits = _cpuCredits;

                    @Override
                    public java.lang.String getCpuCredits() {
                        return this.$cpuCredits;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getCpuCredits() != null) {
                            obj.set("cpuCredits", om.valueToTree(this.getCpuCredits()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CreditSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.CreditSpecificationProperty.CpuCredits`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification-cpucredits
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getCpuCredits() {
                return this.jsiiGet("cpuCredits", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface EbsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.EbsProperty.DeleteOnTermination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-deleteontermination
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getDeleteOnTermination();
        /**
         * `CfnLaunchTemplate.EbsProperty.Encrypted`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-encrypted
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEncrypted();
        /**
         * `CfnLaunchTemplate.EbsProperty.Iops`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-iops
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getIops();
        /**
         * `CfnLaunchTemplate.EbsProperty.KmsKeyId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-kmskeyid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getKmsKeyId();
        /**
         * `CfnLaunchTemplate.EbsProperty.SnapshotId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-snapshotid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSnapshotId();
        /**
         * `CfnLaunchTemplate.EbsProperty.VolumeSize`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumesize
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getVolumeSize();
        /**
         * `CfnLaunchTemplate.EbsProperty.VolumeType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getVolumeType();

        /**
         * @return a {@link Builder} of {@link EbsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EbsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _deleteOnTermination;
            @javax.annotation.Nullable
            private java.lang.Object _encrypted;
            @javax.annotation.Nullable
            private java.lang.Number _iops;
            @javax.annotation.Nullable
            private java.lang.String _kmsKeyId;
            @javax.annotation.Nullable
            private java.lang.String _snapshotId;
            @javax.annotation.Nullable
            private java.lang.Number _volumeSize;
            @javax.annotation.Nullable
            private java.lang.String _volumeType;

            /**
             * Sets the value of DeleteOnTermination
             * @param value `CfnLaunchTemplate.EbsProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of DeleteOnTermination
             * @param value `CfnLaunchTemplate.EbsProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of Encrypted
             * @param value `CfnLaunchTemplate.EbsProperty.Encrypted`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._encrypted = value;
                return this;
            }
            /**
             * Sets the value of Encrypted
             * @param value `CfnLaunchTemplate.EbsProperty.Encrypted`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withEncrypted(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._encrypted = value;
                return this;
            }
            /**
             * Sets the value of Iops
             * @param value `CfnLaunchTemplate.EbsProperty.Iops`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withIops(@javax.annotation.Nullable final java.lang.Number value) {
                this._iops = value;
                return this;
            }
            /**
             * Sets the value of KmsKeyId
             * @param value `CfnLaunchTemplate.EbsProperty.KmsKeyId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withKmsKeyId(@javax.annotation.Nullable final java.lang.String value) {
                this._kmsKeyId = value;
                return this;
            }
            /**
             * Sets the value of SnapshotId
             * @param value `CfnLaunchTemplate.EbsProperty.SnapshotId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSnapshotId(@javax.annotation.Nullable final java.lang.String value) {
                this._snapshotId = value;
                return this;
            }
            /**
             * Sets the value of VolumeSize
             * @param value `CfnLaunchTemplate.EbsProperty.VolumeSize`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withVolumeSize(@javax.annotation.Nullable final java.lang.Number value) {
                this._volumeSize = value;
                return this;
            }
            /**
             * Sets the value of VolumeType
             * @param value `CfnLaunchTemplate.EbsProperty.VolumeType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withVolumeType(@javax.annotation.Nullable final java.lang.String value) {
                this._volumeType = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public EbsProperty build() {
                return new EbsProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $deleteOnTermination = _deleteOnTermination;
                    @javax.annotation.Nullable
                    private final java.lang.Object $encrypted = _encrypted;
                    @javax.annotation.Nullable
                    private final java.lang.Number $iops = _iops;
                    @javax.annotation.Nullable
                    private final java.lang.String $kmsKeyId = _kmsKeyId;
                    @javax.annotation.Nullable
                    private final java.lang.String $snapshotId = _snapshotId;
                    @javax.annotation.Nullable
                    private final java.lang.Number $volumeSize = _volumeSize;
                    @javax.annotation.Nullable
                    private final java.lang.String $volumeType = _volumeType;

                    @Override
                    public java.lang.Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public java.lang.Object getEncrypted() {
                        return this.$encrypted;
                    }

                    @Override
                    public java.lang.Number getIops() {
                        return this.$iops;
                    }

                    @Override
                    public java.lang.String getKmsKeyId() {
                        return this.$kmsKeyId;
                    }

                    @Override
                    public java.lang.String getSnapshotId() {
                        return this.$snapshotId;
                    }

                    @Override
                    public java.lang.Number getVolumeSize() {
                        return this.$volumeSize;
                    }

                    @Override
                    public java.lang.String getVolumeType() {
                        return this.$volumeType;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getDeleteOnTermination() != null) {
                            obj.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                        }
                        if (this.getEncrypted() != null) {
                            obj.set("encrypted", om.valueToTree(this.getEncrypted()));
                        }
                        if (this.getIops() != null) {
                            obj.set("iops", om.valueToTree(this.getIops()));
                        }
                        if (this.getKmsKeyId() != null) {
                            obj.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                        }
                        if (this.getSnapshotId() != null) {
                            obj.set("snapshotId", om.valueToTree(this.getSnapshotId()));
                        }
                        if (this.getVolumeSize() != null) {
                            obj.set("volumeSize", om.valueToTree(this.getVolumeSize()));
                        }
                        if (this.getVolumeType() != null) {
                            obj.set("volumeType", om.valueToTree(this.getVolumeType()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.EbsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.EbsProperty.DeleteOnTermination`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-deleteontermination
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getDeleteOnTermination() {
                return this.jsiiGet("deleteOnTermination", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.EbsProperty.Encrypted`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-encrypted
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getEncrypted() {
                return this.jsiiGet("encrypted", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.EbsProperty.Iops`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-iops
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Number getIops() {
                return this.jsiiGet("iops", java.lang.Number.class);
            }

            /**
             * `CfnLaunchTemplate.EbsProperty.KmsKeyId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-kmskeyid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getKmsKeyId() {
                return this.jsiiGet("kmsKeyId", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.EbsProperty.SnapshotId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-snapshotid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getSnapshotId() {
                return this.jsiiGet("snapshotId", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.EbsProperty.VolumeSize`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumesize
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Number getVolumeSize() {
                return this.jsiiGet("volumeSize", java.lang.Number.class);
            }

            /**
             * `CfnLaunchTemplate.EbsProperty.VolumeType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumetype
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getVolumeType() {
                return this.jsiiGet("volumeType", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ElasticGpuSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.ElasticGpuSpecificationProperty.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html#cfn-ec2-launchtemplate-elasticgpuspecification-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link ElasticGpuSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ElasticGpuSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _type;

            /**
             * Sets the value of Type
             * @param value `CfnLaunchTemplate.ElasticGpuSpecificationProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withType(@javax.annotation.Nullable final java.lang.String value) {
                this._type = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticGpuSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ElasticGpuSpecificationProperty build() {
                return new ElasticGpuSpecificationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $type = _type;

                    @Override
                    public java.lang.String getType() {
                        return this.$type;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getType() != null) {
                            obj.set("type", om.valueToTree(this.getType()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.ElasticGpuSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.ElasticGpuSpecificationProperty.Type`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html#cfn-ec2-launchtemplate-elasticgpuspecification-type
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getType() {
                return this.jsiiGet("type", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-hibernationoptions.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface HibernationOptionsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.HibernationOptionsProperty.Configured`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-hibernationoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-hibernationoptions-configured
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getConfigured();

        /**
         * @return a {@link Builder} of {@link HibernationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link HibernationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _configured;

            /**
             * Sets the value of Configured
             * @param value `CfnLaunchTemplate.HibernationOptionsProperty.Configured`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withConfigured(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._configured = value;
                return this;
            }
            /**
             * Sets the value of Configured
             * @param value `CfnLaunchTemplate.HibernationOptionsProperty.Configured`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withConfigured(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._configured = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HibernationOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public HibernationOptionsProperty build() {
                return new HibernationOptionsProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $configured = _configured;

                    @Override
                    public java.lang.Object getConfigured() {
                        return this.$configured;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getConfigured() != null) {
                            obj.set("configured", om.valueToTree(this.getConfigured()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.HibernationOptionsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.HibernationOptionsProperty.Configured`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-hibernationoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-hibernationoptions-configured
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getConfigured() {
                return this.jsiiGet("configured", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface IamInstanceProfileProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.IamInstanceProfileProperty.Arn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-arn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getArn();
        /**
         * `CfnLaunchTemplate.IamInstanceProfileProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link IamInstanceProfileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link IamInstanceProfileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _arn;
            @javax.annotation.Nullable
            private java.lang.String _name;

            /**
             * Sets the value of Arn
             * @param value `CfnLaunchTemplate.IamInstanceProfileProperty.Arn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withArn(@javax.annotation.Nullable final java.lang.String value) {
                this._arn = value;
                return this;
            }
            /**
             * Sets the value of Name
             * @param value `CfnLaunchTemplate.IamInstanceProfileProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withName(@javax.annotation.Nullable final java.lang.String value) {
                this._name = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IamInstanceProfileProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public IamInstanceProfileProperty build() {
                return new IamInstanceProfileProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $arn = _arn;
                    @javax.annotation.Nullable
                    private final java.lang.String $name = _name;

                    @Override
                    public java.lang.String getArn() {
                        return this.$arn;
                    }

                    @Override
                    public java.lang.String getName() {
                        return this.$name;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getArn() != null) {
                            obj.set("arn", om.valueToTree(this.getArn()));
                        }
                        if (this.getName() != null) {
                            obj.set("name", om.valueToTree(this.getName()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.IamInstanceProfileProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.IamInstanceProfileProperty.Arn`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-arn
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getArn() {
                return this.jsiiGet("arn", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.IamInstanceProfileProperty.Name`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-name
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getName() {
                return this.jsiiGet("name", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface InstanceMarketOptionsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.InstanceMarketOptionsProperty.MarketType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-markettype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getMarketType();
        /**
         * `CfnLaunchTemplate.InstanceMarketOptionsProperty.SpotOptions`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getSpotOptions();

        /**
         * @return a {@link Builder} of {@link InstanceMarketOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InstanceMarketOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _marketType;
            @javax.annotation.Nullable
            private java.lang.Object _spotOptions;

            /**
             * Sets the value of MarketType
             * @param value `CfnLaunchTemplate.InstanceMarketOptionsProperty.MarketType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withMarketType(@javax.annotation.Nullable final java.lang.String value) {
                this._marketType = value;
                return this;
            }
            /**
             * Sets the value of SpotOptions
             * @param value `CfnLaunchTemplate.InstanceMarketOptionsProperty.SpotOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSpotOptions(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._spotOptions = value;
                return this;
            }
            /**
             * Sets the value of SpotOptions
             * @param value `CfnLaunchTemplate.InstanceMarketOptionsProperty.SpotOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSpotOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.SpotOptionsProperty value) {
                this._spotOptions = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceMarketOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public InstanceMarketOptionsProperty build() {
                return new InstanceMarketOptionsProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $marketType = _marketType;
                    @javax.annotation.Nullable
                    private final java.lang.Object $spotOptions = _spotOptions;

                    @Override
                    public java.lang.String getMarketType() {
                        return this.$marketType;
                    }

                    @Override
                    public java.lang.Object getSpotOptions() {
                        return this.$spotOptions;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getMarketType() != null) {
                            obj.set("marketType", om.valueToTree(this.getMarketType()));
                        }
                        if (this.getSpotOptions() != null) {
                            obj.set("spotOptions", om.valueToTree(this.getSpotOptions()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.InstanceMarketOptionsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.InstanceMarketOptionsProperty.MarketType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-markettype
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getMarketType() {
                return this.jsiiGet("marketType", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.InstanceMarketOptionsProperty.SpotOptions`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getSpotOptions() {
                return this.jsiiGet("spotOptions", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface Ipv6AddProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.Ipv6AddProperty.Ipv6Address`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html#cfn-ec2-launchtemplate-ipv6add-ipv6address
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getIpv6Address();

        /**
         * @return a {@link Builder} of {@link Ipv6AddProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link Ipv6AddProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _ipv6Address;

            /**
             * Sets the value of Ipv6Address
             * @param value `CfnLaunchTemplate.Ipv6AddProperty.Ipv6Address`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withIpv6Address(@javax.annotation.Nullable final java.lang.String value) {
                this._ipv6Address = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Ipv6AddProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Ipv6AddProperty build() {
                return new Ipv6AddProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $ipv6Address = _ipv6Address;

                    @Override
                    public java.lang.String getIpv6Address() {
                        return this.$ipv6Address;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getIpv6Address() != null) {
                            obj.set("ipv6Address", om.valueToTree(this.getIpv6Address()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.Ipv6AddProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.Ipv6AddProperty.Ipv6Address`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html#cfn-ec2-launchtemplate-ipv6add-ipv6address
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getIpv6Address() {
                return this.jsiiGet("ipv6Address", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface LaunchTemplateDataProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.BlockDeviceMappings`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-blockdevicemappings
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getBlockDeviceMappings();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.CapacityReservationSpecification`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getCapacityReservationSpecification();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.CpuOptions`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getCpuOptions();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.CreditSpecification`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getCreditSpecification();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.DisableApiTermination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-disableapitermination
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getDisableApiTermination();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.EbsOptimized`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ebsoptimized
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEbsOptimized();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticGpuSpecifications`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticgpuspecifications
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getElasticGpuSpecifications();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticInferenceAccelerators`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticinferenceaccelerators
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getElasticInferenceAccelerators();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.HibernationOptions`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-hibernationoptions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getHibernationOptions();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.IamInstanceProfile`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getIamInstanceProfile();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.ImageId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-imageid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getImageId();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instanceinitiatedshutdownbehavior
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getInstanceInitiatedShutdownBehavior();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceMarketOptions`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getInstanceMarketOptions();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getInstanceType();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.KernelId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-kernelid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getKernelId();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.KeyName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-keyname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getKeyName();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.LicenseSpecifications`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-licensespecifications
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getLicenseSpecifications();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.Monitoring`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getMonitoring();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.NetworkInterfaces`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-networkinterfaces
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getNetworkInterfaces();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.Placement`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-placement
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getPlacement();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.RamDiskId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ramdiskid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getRamDiskId();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroupIds`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroupids
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getSecurityGroupIds();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroups`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroups
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getSecurityGroups();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.TagSpecifications`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getTagSpecifications();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.UserData`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-userdata
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getUserData();

        /**
         * @return a {@link Builder} of {@link LaunchTemplateDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LaunchTemplateDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _blockDeviceMappings;
            @javax.annotation.Nullable
            private java.lang.Object _capacityReservationSpecification;
            @javax.annotation.Nullable
            private java.lang.Object _cpuOptions;
            @javax.annotation.Nullable
            private java.lang.Object _creditSpecification;
            @javax.annotation.Nullable
            private java.lang.Object _disableApiTermination;
            @javax.annotation.Nullable
            private java.lang.Object _ebsOptimized;
            @javax.annotation.Nullable
            private java.lang.Object _elasticGpuSpecifications;
            @javax.annotation.Nullable
            private java.lang.Object _elasticInferenceAccelerators;
            @javax.annotation.Nullable
            private java.lang.Object _hibernationOptions;
            @javax.annotation.Nullable
            private java.lang.Object _iamInstanceProfile;
            @javax.annotation.Nullable
            private java.lang.String _imageId;
            @javax.annotation.Nullable
            private java.lang.String _instanceInitiatedShutdownBehavior;
            @javax.annotation.Nullable
            private java.lang.Object _instanceMarketOptions;
            @javax.annotation.Nullable
            private java.lang.String _instanceType;
            @javax.annotation.Nullable
            private java.lang.String _kernelId;
            @javax.annotation.Nullable
            private java.lang.String _keyName;
            @javax.annotation.Nullable
            private java.lang.Object _licenseSpecifications;
            @javax.annotation.Nullable
            private java.lang.Object _monitoring;
            @javax.annotation.Nullable
            private java.lang.Object _networkInterfaces;
            @javax.annotation.Nullable
            private java.lang.Object _placement;
            @javax.annotation.Nullable
            private java.lang.String _ramDiskId;
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _securityGroupIds;
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _securityGroups;
            @javax.annotation.Nullable
            private java.lang.Object _tagSpecifications;
            @javax.annotation.Nullable
            private java.lang.String _userData;

            /**
             * Sets the value of BlockDeviceMappings
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.BlockDeviceMappings`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withBlockDeviceMappings(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._blockDeviceMappings = value;
                return this;
            }
            /**
             * Sets the value of BlockDeviceMappings
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.BlockDeviceMappings`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withBlockDeviceMappings(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._blockDeviceMappings = value;
                return this;
            }
            /**
             * Sets the value of CapacityReservationSpecification
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.CapacityReservationSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withCapacityReservationSpecification(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._capacityReservationSpecification = value;
                return this;
            }
            /**
             * Sets the value of CapacityReservationSpecification
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.CapacityReservationSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withCapacityReservationSpecification(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CapacityReservationSpecificationProperty value) {
                this._capacityReservationSpecification = value;
                return this;
            }
            /**
             * Sets the value of CpuOptions
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.CpuOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withCpuOptions(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._cpuOptions = value;
                return this;
            }
            /**
             * Sets the value of CpuOptions
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.CpuOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withCpuOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CpuOptionsProperty value) {
                this._cpuOptions = value;
                return this;
            }
            /**
             * Sets the value of CreditSpecification
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.CreditSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withCreditSpecification(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._creditSpecification = value;
                return this;
            }
            /**
             * Sets the value of CreditSpecification
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.CreditSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withCreditSpecification(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CreditSpecificationProperty value) {
                this._creditSpecification = value;
                return this;
            }
            /**
             * Sets the value of DisableApiTermination
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.DisableApiTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDisableApiTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._disableApiTermination = value;
                return this;
            }
            /**
             * Sets the value of DisableApiTermination
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.DisableApiTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDisableApiTermination(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._disableApiTermination = value;
                return this;
            }
            /**
             * Sets the value of EbsOptimized
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.EbsOptimized`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withEbsOptimized(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._ebsOptimized = value;
                return this;
            }
            /**
             * Sets the value of EbsOptimized
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.EbsOptimized`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withEbsOptimized(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._ebsOptimized = value;
                return this;
            }
            /**
             * Sets the value of ElasticGpuSpecifications
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticGpuSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withElasticGpuSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._elasticGpuSpecifications = value;
                return this;
            }
            /**
             * Sets the value of ElasticGpuSpecifications
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticGpuSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withElasticGpuSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._elasticGpuSpecifications = value;
                return this;
            }
            /**
             * Sets the value of ElasticInferenceAccelerators
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticInferenceAccelerators`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withElasticInferenceAccelerators(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._elasticInferenceAccelerators = value;
                return this;
            }
            /**
             * Sets the value of ElasticInferenceAccelerators
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticInferenceAccelerators`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withElasticInferenceAccelerators(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._elasticInferenceAccelerators = value;
                return this;
            }
            /**
             * Sets the value of HibernationOptions
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.HibernationOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withHibernationOptions(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._hibernationOptions = value;
                return this;
            }
            /**
             * Sets the value of HibernationOptions
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.HibernationOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withHibernationOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.HibernationOptionsProperty value) {
                this._hibernationOptions = value;
                return this;
            }
            /**
             * Sets the value of IamInstanceProfile
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.IamInstanceProfile`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withIamInstanceProfile(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._iamInstanceProfile = value;
                return this;
            }
            /**
             * Sets the value of IamInstanceProfile
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.IamInstanceProfile`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withIamInstanceProfile(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.IamInstanceProfileProperty value) {
                this._iamInstanceProfile = value;
                return this;
            }
            /**
             * Sets the value of ImageId
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.ImageId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withImageId(@javax.annotation.Nullable final java.lang.String value) {
                this._imageId = value;
                return this;
            }
            /**
             * Sets the value of InstanceInitiatedShutdownBehavior
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withInstanceInitiatedShutdownBehavior(@javax.annotation.Nullable final java.lang.String value) {
                this._instanceInitiatedShutdownBehavior = value;
                return this;
            }
            /**
             * Sets the value of InstanceMarketOptions
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceMarketOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withInstanceMarketOptions(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._instanceMarketOptions = value;
                return this;
            }
            /**
             * Sets the value of InstanceMarketOptions
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceMarketOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withInstanceMarketOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.InstanceMarketOptionsProperty value) {
                this._instanceMarketOptions = value;
                return this;
            }
            /**
             * Sets the value of InstanceType
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withInstanceType(@javax.annotation.Nullable final java.lang.String value) {
                this._instanceType = value;
                return this;
            }
            /**
             * Sets the value of KernelId
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.KernelId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withKernelId(@javax.annotation.Nullable final java.lang.String value) {
                this._kernelId = value;
                return this;
            }
            /**
             * Sets the value of KeyName
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.KeyName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withKeyName(@javax.annotation.Nullable final java.lang.String value) {
                this._keyName = value;
                return this;
            }
            /**
             * Sets the value of LicenseSpecifications
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.LicenseSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withLicenseSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._licenseSpecifications = value;
                return this;
            }
            /**
             * Sets the value of LicenseSpecifications
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.LicenseSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withLicenseSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._licenseSpecifications = value;
                return this;
            }
            /**
             * Sets the value of Monitoring
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.Monitoring`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withMonitoring(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._monitoring = value;
                return this;
            }
            /**
             * Sets the value of Monitoring
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.Monitoring`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withMonitoring(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.MonitoringProperty value) {
                this._monitoring = value;
                return this;
            }
            /**
             * Sets the value of NetworkInterfaces
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.NetworkInterfaces`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withNetworkInterfaces(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._networkInterfaces = value;
                return this;
            }
            /**
             * Sets the value of NetworkInterfaces
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.NetworkInterfaces`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withNetworkInterfaces(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._networkInterfaces = value;
                return this;
            }
            /**
             * Sets the value of Placement
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.Placement`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withPlacement(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._placement = value;
                return this;
            }
            /**
             * Sets the value of Placement
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.Placement`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withPlacement(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.PlacementProperty value) {
                this._placement = value;
                return this;
            }
            /**
             * Sets the value of RamDiskId
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.RamDiskId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withRamDiskId(@javax.annotation.Nullable final java.lang.String value) {
                this._ramDiskId = value;
                return this;
            }
            /**
             * Sets the value of SecurityGroupIds
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroupIds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSecurityGroupIds(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._securityGroupIds = value;
                return this;
            }
            /**
             * Sets the value of SecurityGroups
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSecurityGroups(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._securityGroups = value;
                return this;
            }
            /**
             * Sets the value of TagSpecifications
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.TagSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withTagSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._tagSpecifications = value;
                return this;
            }
            /**
             * Sets the value of TagSpecifications
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.TagSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withTagSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._tagSpecifications = value;
                return this;
            }
            /**
             * Sets the value of UserData
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.UserData`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withUserData(@javax.annotation.Nullable final java.lang.String value) {
                this._userData = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateDataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public LaunchTemplateDataProperty build() {
                return new LaunchTemplateDataProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $blockDeviceMappings = _blockDeviceMappings;
                    @javax.annotation.Nullable
                    private final java.lang.Object $capacityReservationSpecification = _capacityReservationSpecification;
                    @javax.annotation.Nullable
                    private final java.lang.Object $cpuOptions = _cpuOptions;
                    @javax.annotation.Nullable
                    private final java.lang.Object $creditSpecification = _creditSpecification;
                    @javax.annotation.Nullable
                    private final java.lang.Object $disableApiTermination = _disableApiTermination;
                    @javax.annotation.Nullable
                    private final java.lang.Object $ebsOptimized = _ebsOptimized;
                    @javax.annotation.Nullable
                    private final java.lang.Object $elasticGpuSpecifications = _elasticGpuSpecifications;
                    @javax.annotation.Nullable
                    private final java.lang.Object $elasticInferenceAccelerators = _elasticInferenceAccelerators;
                    @javax.annotation.Nullable
                    private final java.lang.Object $hibernationOptions = _hibernationOptions;
                    @javax.annotation.Nullable
                    private final java.lang.Object $iamInstanceProfile = _iamInstanceProfile;
                    @javax.annotation.Nullable
                    private final java.lang.String $imageId = _imageId;
                    @javax.annotation.Nullable
                    private final java.lang.String $instanceInitiatedShutdownBehavior = _instanceInitiatedShutdownBehavior;
                    @javax.annotation.Nullable
                    private final java.lang.Object $instanceMarketOptions = _instanceMarketOptions;
                    @javax.annotation.Nullable
                    private final java.lang.String $instanceType = _instanceType;
                    @javax.annotation.Nullable
                    private final java.lang.String $kernelId = _kernelId;
                    @javax.annotation.Nullable
                    private final java.lang.String $keyName = _keyName;
                    @javax.annotation.Nullable
                    private final java.lang.Object $licenseSpecifications = _licenseSpecifications;
                    @javax.annotation.Nullable
                    private final java.lang.Object $monitoring = _monitoring;
                    @javax.annotation.Nullable
                    private final java.lang.Object $networkInterfaces = _networkInterfaces;
                    @javax.annotation.Nullable
                    private final java.lang.Object $placement = _placement;
                    @javax.annotation.Nullable
                    private final java.lang.String $ramDiskId = _ramDiskId;
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $securityGroupIds = _securityGroupIds;
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $securityGroups = _securityGroups;
                    @javax.annotation.Nullable
                    private final java.lang.Object $tagSpecifications = _tagSpecifications;
                    @javax.annotation.Nullable
                    private final java.lang.String $userData = _userData;

                    @Override
                    public java.lang.Object getBlockDeviceMappings() {
                        return this.$blockDeviceMappings;
                    }

                    @Override
                    public java.lang.Object getCapacityReservationSpecification() {
                        return this.$capacityReservationSpecification;
                    }

                    @Override
                    public java.lang.Object getCpuOptions() {
                        return this.$cpuOptions;
                    }

                    @Override
                    public java.lang.Object getCreditSpecification() {
                        return this.$creditSpecification;
                    }

                    @Override
                    public java.lang.Object getDisableApiTermination() {
                        return this.$disableApiTermination;
                    }

                    @Override
                    public java.lang.Object getEbsOptimized() {
                        return this.$ebsOptimized;
                    }

                    @Override
                    public java.lang.Object getElasticGpuSpecifications() {
                        return this.$elasticGpuSpecifications;
                    }

                    @Override
                    public java.lang.Object getElasticInferenceAccelerators() {
                        return this.$elasticInferenceAccelerators;
                    }

                    @Override
                    public java.lang.Object getHibernationOptions() {
                        return this.$hibernationOptions;
                    }

                    @Override
                    public java.lang.Object getIamInstanceProfile() {
                        return this.$iamInstanceProfile;
                    }

                    @Override
                    public java.lang.String getImageId() {
                        return this.$imageId;
                    }

                    @Override
                    public java.lang.String getInstanceInitiatedShutdownBehavior() {
                        return this.$instanceInitiatedShutdownBehavior;
                    }

                    @Override
                    public java.lang.Object getInstanceMarketOptions() {
                        return this.$instanceMarketOptions;
                    }

                    @Override
                    public java.lang.String getInstanceType() {
                        return this.$instanceType;
                    }

                    @Override
                    public java.lang.String getKernelId() {
                        return this.$kernelId;
                    }

                    @Override
                    public java.lang.String getKeyName() {
                        return this.$keyName;
                    }

                    @Override
                    public java.lang.Object getLicenseSpecifications() {
                        return this.$licenseSpecifications;
                    }

                    @Override
                    public java.lang.Object getMonitoring() {
                        return this.$monitoring;
                    }

                    @Override
                    public java.lang.Object getNetworkInterfaces() {
                        return this.$networkInterfaces;
                    }

                    @Override
                    public java.lang.Object getPlacement() {
                        return this.$placement;
                    }

                    @Override
                    public java.lang.String getRamDiskId() {
                        return this.$ramDiskId;
                    }

                    @Override
                    public java.util.List<java.lang.String> getSecurityGroupIds() {
                        return this.$securityGroupIds;
                    }

                    @Override
                    public java.util.List<java.lang.String> getSecurityGroups() {
                        return this.$securityGroups;
                    }

                    @Override
                    public java.lang.Object getTagSpecifications() {
                        return this.$tagSpecifications;
                    }

                    @Override
                    public java.lang.String getUserData() {
                        return this.$userData;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getBlockDeviceMappings() != null) {
                            obj.set("blockDeviceMappings", om.valueToTree(this.getBlockDeviceMappings()));
                        }
                        if (this.getCapacityReservationSpecification() != null) {
                            obj.set("capacityReservationSpecification", om.valueToTree(this.getCapacityReservationSpecification()));
                        }
                        if (this.getCpuOptions() != null) {
                            obj.set("cpuOptions", om.valueToTree(this.getCpuOptions()));
                        }
                        if (this.getCreditSpecification() != null) {
                            obj.set("creditSpecification", om.valueToTree(this.getCreditSpecification()));
                        }
                        if (this.getDisableApiTermination() != null) {
                            obj.set("disableApiTermination", om.valueToTree(this.getDisableApiTermination()));
                        }
                        if (this.getEbsOptimized() != null) {
                            obj.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
                        }
                        if (this.getElasticGpuSpecifications() != null) {
                            obj.set("elasticGpuSpecifications", om.valueToTree(this.getElasticGpuSpecifications()));
                        }
                        if (this.getElasticInferenceAccelerators() != null) {
                            obj.set("elasticInferenceAccelerators", om.valueToTree(this.getElasticInferenceAccelerators()));
                        }
                        if (this.getHibernationOptions() != null) {
                            obj.set("hibernationOptions", om.valueToTree(this.getHibernationOptions()));
                        }
                        if (this.getIamInstanceProfile() != null) {
                            obj.set("iamInstanceProfile", om.valueToTree(this.getIamInstanceProfile()));
                        }
                        if (this.getImageId() != null) {
                            obj.set("imageId", om.valueToTree(this.getImageId()));
                        }
                        if (this.getInstanceInitiatedShutdownBehavior() != null) {
                            obj.set("instanceInitiatedShutdownBehavior", om.valueToTree(this.getInstanceInitiatedShutdownBehavior()));
                        }
                        if (this.getInstanceMarketOptions() != null) {
                            obj.set("instanceMarketOptions", om.valueToTree(this.getInstanceMarketOptions()));
                        }
                        if (this.getInstanceType() != null) {
                            obj.set("instanceType", om.valueToTree(this.getInstanceType()));
                        }
                        if (this.getKernelId() != null) {
                            obj.set("kernelId", om.valueToTree(this.getKernelId()));
                        }
                        if (this.getKeyName() != null) {
                            obj.set("keyName", om.valueToTree(this.getKeyName()));
                        }
                        if (this.getLicenseSpecifications() != null) {
                            obj.set("licenseSpecifications", om.valueToTree(this.getLicenseSpecifications()));
                        }
                        if (this.getMonitoring() != null) {
                            obj.set("monitoring", om.valueToTree(this.getMonitoring()));
                        }
                        if (this.getNetworkInterfaces() != null) {
                            obj.set("networkInterfaces", om.valueToTree(this.getNetworkInterfaces()));
                        }
                        if (this.getPlacement() != null) {
                            obj.set("placement", om.valueToTree(this.getPlacement()));
                        }
                        if (this.getRamDiskId() != null) {
                            obj.set("ramDiskId", om.valueToTree(this.getRamDiskId()));
                        }
                        if (this.getSecurityGroupIds() != null) {
                            obj.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                        }
                        if (this.getSecurityGroups() != null) {
                            obj.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                        }
                        if (this.getTagSpecifications() != null) {
                            obj.set("tagSpecifications", om.valueToTree(this.getTagSpecifications()));
                        }
                        if (this.getUserData() != null) {
                            obj.set("userData", om.valueToTree(this.getUserData()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.LaunchTemplateDataProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.BlockDeviceMappings`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-blockdevicemappings
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getBlockDeviceMappings() {
                return this.jsiiGet("blockDeviceMappings", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.CapacityReservationSpecification`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getCapacityReservationSpecification() {
                return this.jsiiGet("capacityReservationSpecification", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.CpuOptions`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getCpuOptions() {
                return this.jsiiGet("cpuOptions", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.CreditSpecification`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getCreditSpecification() {
                return this.jsiiGet("creditSpecification", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.DisableApiTermination`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-disableapitermination
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getDisableApiTermination() {
                return this.jsiiGet("disableApiTermination", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.EbsOptimized`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ebsoptimized
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getEbsOptimized() {
                return this.jsiiGet("ebsOptimized", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticGpuSpecifications`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticgpuspecifications
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getElasticGpuSpecifications() {
                return this.jsiiGet("elasticGpuSpecifications", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticInferenceAccelerators`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticinferenceaccelerators
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getElasticInferenceAccelerators() {
                return this.jsiiGet("elasticInferenceAccelerators", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.HibernationOptions`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-hibernationoptions
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getHibernationOptions() {
                return this.jsiiGet("hibernationOptions", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.IamInstanceProfile`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getIamInstanceProfile() {
                return this.jsiiGet("iamInstanceProfile", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.ImageId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-imageid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getImageId() {
                return this.jsiiGet("imageId", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instanceinitiatedshutdownbehavior
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getInstanceInitiatedShutdownBehavior() {
                return this.jsiiGet("instanceInitiatedShutdownBehavior", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceMarketOptions`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getInstanceMarketOptions() {
                return this.jsiiGet("instanceMarketOptions", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancetype
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getInstanceType() {
                return this.jsiiGet("instanceType", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.KernelId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-kernelid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getKernelId() {
                return this.jsiiGet("kernelId", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.KeyName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-keyname
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getKeyName() {
                return this.jsiiGet("keyName", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.LicenseSpecifications`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-licensespecifications
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getLicenseSpecifications() {
                return this.jsiiGet("licenseSpecifications", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.Monitoring`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getMonitoring() {
                return this.jsiiGet("monitoring", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.NetworkInterfaces`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-networkinterfaces
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getNetworkInterfaces() {
                return this.jsiiGet("networkInterfaces", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.Placement`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-placement
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getPlacement() {
                return this.jsiiGet("placement", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.RamDiskId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ramdiskid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getRamDiskId() {
                return this.jsiiGet("ramDiskId", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroupIds`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroupids
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.jsiiGet("securityGroupIds", java.util.List.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroups`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroups
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getSecurityGroups() {
                return this.jsiiGet("securityGroups", java.util.List.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.TagSpecifications`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getTagSpecifications() {
                return this.jsiiGet("tagSpecifications", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.UserData`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-userdata
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getUserData() {
                return this.jsiiGet("userData", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface LaunchTemplateElasticInferenceAcceleratorProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator.html#cfn-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link LaunchTemplateElasticInferenceAcceleratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LaunchTemplateElasticInferenceAcceleratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _type;

            /**
             * Sets the value of Type
             * @param value `CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withType(@javax.annotation.Nullable final java.lang.String value) {
                this._type = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateElasticInferenceAcceleratorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public LaunchTemplateElasticInferenceAcceleratorProperty build() {
                return new LaunchTemplateElasticInferenceAcceleratorProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $type = _type;

                    @Override
                    public java.lang.String getType() {
                        return this.$type;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getType() != null) {
                            obj.set("type", om.valueToTree(this.getType()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty.Type`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator.html#cfn-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator-type
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getType() {
                return this.jsiiGet("type", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-licensespecification.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface LicenseSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.LicenseSpecificationProperty.LicenseConfigurationArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-licensespecification.html#cfn-ec2-launchtemplate-licensespecification-licenseconfigurationarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getLicenseConfigurationArn();

        /**
         * @return a {@link Builder} of {@link LicenseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LicenseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _licenseConfigurationArn;

            /**
             * Sets the value of LicenseConfigurationArn
             * @param value `CfnLaunchTemplate.LicenseSpecificationProperty.LicenseConfigurationArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withLicenseConfigurationArn(@javax.annotation.Nullable final java.lang.String value) {
                this._licenseConfigurationArn = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LicenseSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public LicenseSpecificationProperty build() {
                return new LicenseSpecificationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $licenseConfigurationArn = _licenseConfigurationArn;

                    @Override
                    public java.lang.String getLicenseConfigurationArn() {
                        return this.$licenseConfigurationArn;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getLicenseConfigurationArn() != null) {
                            obj.set("licenseConfigurationArn", om.valueToTree(this.getLicenseConfigurationArn()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.LicenseSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.LicenseSpecificationProperty.LicenseConfigurationArn`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-licensespecification.html#cfn-ec2-launchtemplate-licensespecification-licenseconfigurationarn
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getLicenseConfigurationArn() {
                return this.jsiiGet("licenseConfigurationArn", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface MonitoringProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.MonitoringProperty.Enabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring-enabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link MonitoringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link MonitoringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _enabled;

            /**
             * Sets the value of Enabled
             * @param value `CfnLaunchTemplate.MonitoringProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnLaunchTemplate.MonitoringProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withEnabled(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._enabled = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public MonitoringProperty build() {
                return new MonitoringProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $enabled = _enabled;

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getEnabled() != null) {
                            obj.set("enabled", om.valueToTree(this.getEnabled()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.MonitoringProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.MonitoringProperty.Enabled`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring-enabled
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface NetworkInterfaceProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.AssociatePublicIpAddress`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatepublicipaddress
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getAssociatePublicIpAddress();
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.DeleteOnTermination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deleteontermination
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getDeleteOnTermination();
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Description`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-description
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDescription();
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.DeviceIndex`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deviceindex
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getDeviceIndex();
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Groups`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-groups
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getGroups();
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.InterfaceType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-interfacetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getInterfaceType();
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6AddressCount`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresscount
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getIpv6AddressCount();
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6Addresses`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresses
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getIpv6Addresses();
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.NetworkInterfaceId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkinterfaceid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getNetworkInterfaceId();
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddress`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddress
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPrivateIpAddress();
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddresses`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddresses
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getPrivateIpAddresses();
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-secondaryprivateipaddresscount
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getSecondaryPrivateIpAddressCount();
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.SubnetId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-subnetid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSubnetId();

        /**
         * @return a {@link Builder} of {@link NetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link NetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _associatePublicIpAddress;
            @javax.annotation.Nullable
            private java.lang.Object _deleteOnTermination;
            @javax.annotation.Nullable
            private java.lang.String _description;
            @javax.annotation.Nullable
            private java.lang.Number _deviceIndex;
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _groups;
            @javax.annotation.Nullable
            private java.lang.String _interfaceType;
            @javax.annotation.Nullable
            private java.lang.Number _ipv6AddressCount;
            @javax.annotation.Nullable
            private java.lang.Object _ipv6Addresses;
            @javax.annotation.Nullable
            private java.lang.String _networkInterfaceId;
            @javax.annotation.Nullable
            private java.lang.String _privateIpAddress;
            @javax.annotation.Nullable
            private java.lang.Object _privateIpAddresses;
            @javax.annotation.Nullable
            private java.lang.Number _secondaryPrivateIpAddressCount;
            @javax.annotation.Nullable
            private java.lang.String _subnetId;

            /**
             * Sets the value of AssociatePublicIpAddress
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.AssociatePublicIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withAssociatePublicIpAddress(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._associatePublicIpAddress = value;
                return this;
            }
            /**
             * Sets the value of AssociatePublicIpAddress
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.AssociatePublicIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withAssociatePublicIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._associatePublicIpAddress = value;
                return this;
            }
            /**
             * Sets the value of DeleteOnTermination
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of DeleteOnTermination
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of Description
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.Description`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
                this._description = value;
                return this;
            }
            /**
             * Sets the value of DeviceIndex
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.DeviceIndex`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDeviceIndex(@javax.annotation.Nullable final java.lang.Number value) {
                this._deviceIndex = value;
                return this;
            }
            /**
             * Sets the value of Groups
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.Groups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withGroups(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._groups = value;
                return this;
            }
            /**
             * Sets the value of InterfaceType
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.InterfaceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withInterfaceType(@javax.annotation.Nullable final java.lang.String value) {
                this._interfaceType = value;
                return this;
            }
            /**
             * Sets the value of Ipv6AddressCount
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6AddressCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withIpv6AddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._ipv6AddressCount = value;
                return this;
            }
            /**
             * Sets the value of Ipv6Addresses
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6Addresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withIpv6Addresses(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._ipv6Addresses = value;
                return this;
            }
            /**
             * Sets the value of Ipv6Addresses
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6Addresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withIpv6Addresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._ipv6Addresses = value;
                return this;
            }
            /**
             * Sets the value of NetworkInterfaceId
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.NetworkInterfaceId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withNetworkInterfaceId(@javax.annotation.Nullable final java.lang.String value) {
                this._networkInterfaceId = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddress
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withPrivateIpAddress(@javax.annotation.Nullable final java.lang.String value) {
                this._privateIpAddress = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddresses
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withPrivateIpAddresses(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._privateIpAddresses = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddresses
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withPrivateIpAddresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._privateIpAddresses = value;
                return this;
            }
            /**
             * Sets the value of SecondaryPrivateIpAddressCount
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._secondaryPrivateIpAddressCount = value;
                return this;
            }
            /**
             * Sets the value of SubnetId
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.SubnetId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                this._subnetId = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkInterfaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public NetworkInterfaceProperty build() {
                return new NetworkInterfaceProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $associatePublicIpAddress = _associatePublicIpAddress;
                    @javax.annotation.Nullable
                    private final java.lang.Object $deleteOnTermination = _deleteOnTermination;
                    @javax.annotation.Nullable
                    private final java.lang.String $description = _description;
                    @javax.annotation.Nullable
                    private final java.lang.Number $deviceIndex = _deviceIndex;
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $groups = _groups;
                    @javax.annotation.Nullable
                    private final java.lang.String $interfaceType = _interfaceType;
                    @javax.annotation.Nullable
                    private final java.lang.Number $ipv6AddressCount = _ipv6AddressCount;
                    @javax.annotation.Nullable
                    private final java.lang.Object $ipv6Addresses = _ipv6Addresses;
                    @javax.annotation.Nullable
                    private final java.lang.String $networkInterfaceId = _networkInterfaceId;
                    @javax.annotation.Nullable
                    private final java.lang.String $privateIpAddress = _privateIpAddress;
                    @javax.annotation.Nullable
                    private final java.lang.Object $privateIpAddresses = _privateIpAddresses;
                    @javax.annotation.Nullable
                    private final java.lang.Number $secondaryPrivateIpAddressCount = _secondaryPrivateIpAddressCount;
                    @javax.annotation.Nullable
                    private final java.lang.String $subnetId = _subnetId;

                    @Override
                    public java.lang.Object getAssociatePublicIpAddress() {
                        return this.$associatePublicIpAddress;
                    }

                    @Override
                    public java.lang.Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public java.lang.String getDescription() {
                        return this.$description;
                    }

                    @Override
                    public java.lang.Number getDeviceIndex() {
                        return this.$deviceIndex;
                    }

                    @Override
                    public java.util.List<java.lang.String> getGroups() {
                        return this.$groups;
                    }

                    @Override
                    public java.lang.String getInterfaceType() {
                        return this.$interfaceType;
                    }

                    @Override
                    public java.lang.Number getIpv6AddressCount() {
                        return this.$ipv6AddressCount;
                    }

                    @Override
                    public java.lang.Object getIpv6Addresses() {
                        return this.$ipv6Addresses;
                    }

                    @Override
                    public java.lang.String getNetworkInterfaceId() {
                        return this.$networkInterfaceId;
                    }

                    @Override
                    public java.lang.String getPrivateIpAddress() {
                        return this.$privateIpAddress;
                    }

                    @Override
                    public java.lang.Object getPrivateIpAddresses() {
                        return this.$privateIpAddresses;
                    }

                    @Override
                    public java.lang.Number getSecondaryPrivateIpAddressCount() {
                        return this.$secondaryPrivateIpAddressCount;
                    }

                    @Override
                    public java.lang.String getSubnetId() {
                        return this.$subnetId;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getAssociatePublicIpAddress() != null) {
                            obj.set("associatePublicIpAddress", om.valueToTree(this.getAssociatePublicIpAddress()));
                        }
                        if (this.getDeleteOnTermination() != null) {
                            obj.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                        }
                        if (this.getDescription() != null) {
                            obj.set("description", om.valueToTree(this.getDescription()));
                        }
                        if (this.getDeviceIndex() != null) {
                            obj.set("deviceIndex", om.valueToTree(this.getDeviceIndex()));
                        }
                        if (this.getGroups() != null) {
                            obj.set("groups", om.valueToTree(this.getGroups()));
                        }
                        if (this.getInterfaceType() != null) {
                            obj.set("interfaceType", om.valueToTree(this.getInterfaceType()));
                        }
                        if (this.getIpv6AddressCount() != null) {
                            obj.set("ipv6AddressCount", om.valueToTree(this.getIpv6AddressCount()));
                        }
                        if (this.getIpv6Addresses() != null) {
                            obj.set("ipv6Addresses", om.valueToTree(this.getIpv6Addresses()));
                        }
                        if (this.getNetworkInterfaceId() != null) {
                            obj.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
                        }
                        if (this.getPrivateIpAddress() != null) {
                            obj.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
                        }
                        if (this.getPrivateIpAddresses() != null) {
                            obj.set("privateIpAddresses", om.valueToTree(this.getPrivateIpAddresses()));
                        }
                        if (this.getSecondaryPrivateIpAddressCount() != null) {
                            obj.set("secondaryPrivateIpAddressCount", om.valueToTree(this.getSecondaryPrivateIpAddressCount()));
                        }
                        if (this.getSubnetId() != null) {
                            obj.set("subnetId", om.valueToTree(this.getSubnetId()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.NetworkInterfaceProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.NetworkInterfaceProperty.AssociatePublicIpAddress`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatepublicipaddress
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getAssociatePublicIpAddress() {
                return this.jsiiGet("associatePublicIpAddress", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.NetworkInterfaceProperty.DeleteOnTermination`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deleteontermination
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getDeleteOnTermination() {
                return this.jsiiGet("deleteOnTermination", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.NetworkInterfaceProperty.Description`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-description
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getDescription() {
                return this.jsiiGet("description", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.NetworkInterfaceProperty.DeviceIndex`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deviceindex
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Number getDeviceIndex() {
                return this.jsiiGet("deviceIndex", java.lang.Number.class);
            }

            /**
             * `CfnLaunchTemplate.NetworkInterfaceProperty.Groups`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-groups
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getGroups() {
                return this.jsiiGet("groups", java.util.List.class);
            }

            /**
             * `CfnLaunchTemplate.NetworkInterfaceProperty.InterfaceType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-interfacetype
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getInterfaceType() {
                return this.jsiiGet("interfaceType", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6AddressCount`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresscount
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Number getIpv6AddressCount() {
                return this.jsiiGet("ipv6AddressCount", java.lang.Number.class);
            }

            /**
             * `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6Addresses`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresses
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getIpv6Addresses() {
                return this.jsiiGet("ipv6Addresses", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.NetworkInterfaceProperty.NetworkInterfaceId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkinterfaceid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getNetworkInterfaceId() {
                return this.jsiiGet("networkInterfaceId", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddress`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddress
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getPrivateIpAddress() {
                return this.jsiiGet("privateIpAddress", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddresses`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddresses
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getPrivateIpAddresses() {
                return this.jsiiGet("privateIpAddresses", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-secondaryprivateipaddresscount
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Number getSecondaryPrivateIpAddressCount() {
                return this.jsiiGet("secondaryPrivateIpAddressCount", java.lang.Number.class);
            }

            /**
             * `CfnLaunchTemplate.NetworkInterfaceProperty.SubnetId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-subnetid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getSubnetId() {
                return this.jsiiGet("subnetId", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface PlacementProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.PlacementProperty.Affinity`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-affinity
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getAffinity();
        /**
         * `CfnLaunchTemplate.PlacementProperty.AvailabilityZone`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-availabilityzone
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getAvailabilityZone();
        /**
         * `CfnLaunchTemplate.PlacementProperty.GroupName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-groupname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getGroupName();
        /**
         * `CfnLaunchTemplate.PlacementProperty.HostId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getHostId();
        /**
         * `CfnLaunchTemplate.PlacementProperty.Tenancy`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-tenancy
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getTenancy();

        /**
         * @return a {@link Builder} of {@link PlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _affinity;
            @javax.annotation.Nullable
            private java.lang.String _availabilityZone;
            @javax.annotation.Nullable
            private java.lang.String _groupName;
            @javax.annotation.Nullable
            private java.lang.String _hostId;
            @javax.annotation.Nullable
            private java.lang.String _tenancy;

            /**
             * Sets the value of Affinity
             * @param value `CfnLaunchTemplate.PlacementProperty.Affinity`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withAffinity(@javax.annotation.Nullable final java.lang.String value) {
                this._affinity = value;
                return this;
            }
            /**
             * Sets the value of AvailabilityZone
             * @param value `CfnLaunchTemplate.PlacementProperty.AvailabilityZone`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withAvailabilityZone(@javax.annotation.Nullable final java.lang.String value) {
                this._availabilityZone = value;
                return this;
            }
            /**
             * Sets the value of GroupName
             * @param value `CfnLaunchTemplate.PlacementProperty.GroupName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withGroupName(@javax.annotation.Nullable final java.lang.String value) {
                this._groupName = value;
                return this;
            }
            /**
             * Sets the value of HostId
             * @param value `CfnLaunchTemplate.PlacementProperty.HostId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withHostId(@javax.annotation.Nullable final java.lang.String value) {
                this._hostId = value;
                return this;
            }
            /**
             * Sets the value of Tenancy
             * @param value `CfnLaunchTemplate.PlacementProperty.Tenancy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withTenancy(@javax.annotation.Nullable final java.lang.String value) {
                this._tenancy = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PlacementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public PlacementProperty build() {
                return new PlacementProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $affinity = _affinity;
                    @javax.annotation.Nullable
                    private final java.lang.String $availabilityZone = _availabilityZone;
                    @javax.annotation.Nullable
                    private final java.lang.String $groupName = _groupName;
                    @javax.annotation.Nullable
                    private final java.lang.String $hostId = _hostId;
                    @javax.annotation.Nullable
                    private final java.lang.String $tenancy = _tenancy;

                    @Override
                    public java.lang.String getAffinity() {
                        return this.$affinity;
                    }

                    @Override
                    public java.lang.String getAvailabilityZone() {
                        return this.$availabilityZone;
                    }

                    @Override
                    public java.lang.String getGroupName() {
                        return this.$groupName;
                    }

                    @Override
                    public java.lang.String getHostId() {
                        return this.$hostId;
                    }

                    @Override
                    public java.lang.String getTenancy() {
                        return this.$tenancy;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getAffinity() != null) {
                            obj.set("affinity", om.valueToTree(this.getAffinity()));
                        }
                        if (this.getAvailabilityZone() != null) {
                            obj.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                        }
                        if (this.getGroupName() != null) {
                            obj.set("groupName", om.valueToTree(this.getGroupName()));
                        }
                        if (this.getHostId() != null) {
                            obj.set("hostId", om.valueToTree(this.getHostId()));
                        }
                        if (this.getTenancy() != null) {
                            obj.set("tenancy", om.valueToTree(this.getTenancy()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.PlacementProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.PlacementProperty.Affinity`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-affinity
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getAffinity() {
                return this.jsiiGet("affinity", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.PlacementProperty.AvailabilityZone`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-availabilityzone
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getAvailabilityZone() {
                return this.jsiiGet("availabilityZone", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.PlacementProperty.GroupName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-groupname
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getGroupName() {
                return this.jsiiGet("groupName", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.PlacementProperty.HostId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getHostId() {
                return this.jsiiGet("hostId", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.PlacementProperty.Tenancy`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-tenancy
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getTenancy() {
                return this.jsiiGet("tenancy", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface PrivateIpAddProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.PrivateIpAddProperty.Primary`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-primary
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getPrimary();
        /**
         * `CfnLaunchTemplate.PrivateIpAddProperty.PrivateIpAddress`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-privateipaddress
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPrivateIpAddress();

        /**
         * @return a {@link Builder} of {@link PrivateIpAddProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PrivateIpAddProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _primary;
            @javax.annotation.Nullable
            private java.lang.String _privateIpAddress;

            /**
             * Sets the value of Primary
             * @param value `CfnLaunchTemplate.PrivateIpAddProperty.Primary`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withPrimary(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._primary = value;
                return this;
            }
            /**
             * Sets the value of Primary
             * @param value `CfnLaunchTemplate.PrivateIpAddProperty.Primary`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withPrimary(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._primary = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddress
             * @param value `CfnLaunchTemplate.PrivateIpAddProperty.PrivateIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withPrivateIpAddress(@javax.annotation.Nullable final java.lang.String value) {
                this._privateIpAddress = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrivateIpAddProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public PrivateIpAddProperty build() {
                return new PrivateIpAddProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $primary = _primary;
                    @javax.annotation.Nullable
                    private final java.lang.String $privateIpAddress = _privateIpAddress;

                    @Override
                    public java.lang.Object getPrimary() {
                        return this.$primary;
                    }

                    @Override
                    public java.lang.String getPrivateIpAddress() {
                        return this.$privateIpAddress;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getPrimary() != null) {
                            obj.set("primary", om.valueToTree(this.getPrimary()));
                        }
                        if (this.getPrivateIpAddress() != null) {
                            obj.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.PrivateIpAddProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.PrivateIpAddProperty.Primary`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-primary
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getPrimary() {
                return this.jsiiGet("primary", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.PrivateIpAddProperty.PrivateIpAddress`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-privateipaddress
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getPrivateIpAddress() {
                return this.jsiiGet("privateIpAddress", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface SpotOptionsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.InstanceInterruptionBehavior`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-instanceinterruptionbehavior
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getInstanceInterruptionBehavior();
        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.MaxPrice`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-maxprice
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getMaxPrice();
        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.SpotInstanceType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-spotinstancetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSpotInstanceType();

        /**
         * @return a {@link Builder} of {@link SpotOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SpotOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _instanceInterruptionBehavior;
            @javax.annotation.Nullable
            private java.lang.String _maxPrice;
            @javax.annotation.Nullable
            private java.lang.String _spotInstanceType;

            /**
             * Sets the value of InstanceInterruptionBehavior
             * @param value `CfnLaunchTemplate.SpotOptionsProperty.InstanceInterruptionBehavior`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withInstanceInterruptionBehavior(@javax.annotation.Nullable final java.lang.String value) {
                this._instanceInterruptionBehavior = value;
                return this;
            }
            /**
             * Sets the value of MaxPrice
             * @param value `CfnLaunchTemplate.SpotOptionsProperty.MaxPrice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withMaxPrice(@javax.annotation.Nullable final java.lang.String value) {
                this._maxPrice = value;
                return this;
            }
            /**
             * Sets the value of SpotInstanceType
             * @param value `CfnLaunchTemplate.SpotOptionsProperty.SpotInstanceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSpotInstanceType(@javax.annotation.Nullable final java.lang.String value) {
                this._spotInstanceType = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public SpotOptionsProperty build() {
                return new SpotOptionsProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $instanceInterruptionBehavior = _instanceInterruptionBehavior;
                    @javax.annotation.Nullable
                    private final java.lang.String $maxPrice = _maxPrice;
                    @javax.annotation.Nullable
                    private final java.lang.String $spotInstanceType = _spotInstanceType;

                    @Override
                    public java.lang.String getInstanceInterruptionBehavior() {
                        return this.$instanceInterruptionBehavior;
                    }

                    @Override
                    public java.lang.String getMaxPrice() {
                        return this.$maxPrice;
                    }

                    @Override
                    public java.lang.String getSpotInstanceType() {
                        return this.$spotInstanceType;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getInstanceInterruptionBehavior() != null) {
                            obj.set("instanceInterruptionBehavior", om.valueToTree(this.getInstanceInterruptionBehavior()));
                        }
                        if (this.getMaxPrice() != null) {
                            obj.set("maxPrice", om.valueToTree(this.getMaxPrice()));
                        }
                        if (this.getSpotInstanceType() != null) {
                            obj.set("spotInstanceType", om.valueToTree(this.getSpotInstanceType()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.SpotOptionsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.SpotOptionsProperty.InstanceInterruptionBehavior`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-instanceinterruptionbehavior
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getInstanceInterruptionBehavior() {
                return this.jsiiGet("instanceInterruptionBehavior", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.SpotOptionsProperty.MaxPrice`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-maxprice
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getMaxPrice() {
                return this.jsiiGet("maxPrice", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.SpotOptionsProperty.SpotInstanceType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-spotinstancetype
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getSpotInstanceType() {
                return this.jsiiGet("spotInstanceType", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface TagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.TagSpecificationProperty.ResourceType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-resourcetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getResourceType();
        /**
         * `CfnLaunchTemplate.TagSpecificationProperty.Tags`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-tags
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<software.amazon.awscdk.core.CfnTag> getTags();

        /**
         * @return a {@link Builder} of {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _resourceType;
            @javax.annotation.Nullable
            private java.util.List<software.amazon.awscdk.core.CfnTag> _tags;

            /**
             * Sets the value of ResourceType
             * @param value `CfnLaunchTemplate.TagSpecificationProperty.ResourceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withResourceType(@javax.annotation.Nullable final java.lang.String value) {
                this._resourceType = value;
                return this;
            }
            /**
             * Sets the value of Tags
             * @param value `CfnLaunchTemplate.TagSpecificationProperty.Tags`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withTags(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.core.CfnTag> value) {
                this._tags = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public TagSpecificationProperty build() {
                return new TagSpecificationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $resourceType = _resourceType;
                    @javax.annotation.Nullable
                    private final java.util.List<software.amazon.awscdk.core.CfnTag> $tags = _tags;

                    @Override
                    public java.lang.String getResourceType() {
                        return this.$resourceType;
                    }

                    @Override
                    public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
                        return this.$tags;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getResourceType() != null) {
                            obj.set("resourceType", om.valueToTree(this.getResourceType()));
                        }
                        if (this.getTags() != null) {
                            obj.set("tags", om.valueToTree(this.getTags()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.TagSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.TagSpecificationProperty.ResourceType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-resourcetype
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getResourceType() {
                return this.jsiiGet("resourceType", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.TagSpecificationProperty.Tags`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-tags
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
                return this.jsiiGet("tags", java.util.List.class);
            }
        }
    }
}
