package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::SecurityGroup`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.2 (build e881f16)", date = "2019-07-19T19:06:47.547Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSecurityGroup")
public class CfnSecurityGroup extends software.amazon.awscdk.core.CfnResource {
    protected CfnSecurityGroup(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnSecurityGroup.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }
    /**
     * Create a new `AWS::EC2::SecurityGroup`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnSecurityGroup(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.CfnSecurityGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrGroupId() {
        return this.jsiiGet("attrGroupId", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrVpcId() {
        return this.jsiiGet("attrVpcId", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return this.jsiiGet("cfnProperties", java.util.Map.class);
    }

    /**
     * `AWS::EC2::SecurityGroup.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::EC2::SecurityGroup.GroupDescription`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupdescription
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getGroupDescription() {
        return this.jsiiGet("groupDescription", java.lang.String.class);
    }

    /**
     * `AWS::EC2::SecurityGroup.GroupDescription`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupdescription
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setGroupDescription(final java.lang.String value) {
        this.jsiiSet("groupDescription", java.util.Objects.requireNonNull(value, "groupDescription is required"));
    }

    /**
     * `AWS::EC2::SecurityGroup.GroupName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getGroupName() {
        return this.jsiiGet("groupName", java.lang.String.class);
    }

    /**
     * `AWS::EC2::SecurityGroup.GroupName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setGroupName(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("groupName", value);
    }

    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupEgress`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getSecurityGroupEgress() {
        return this.jsiiGet("securityGroupEgress", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupEgress`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSecurityGroupEgress(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("securityGroupEgress", value);
    }

    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupEgress`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSecurityGroupEgress(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
        this.jsiiSet("securityGroupEgress", value);
    }

    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupIngress`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getSecurityGroupIngress() {
        return this.jsiiGet("securityGroupIngress", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupIngress`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSecurityGroupIngress(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("securityGroupIngress", value);
    }

    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupIngress`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSecurityGroupIngress(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
        this.jsiiSet("securityGroupIngress", value);
    }

    /**
     * `AWS::EC2::SecurityGroup.VpcId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-vpcid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getVpcId() {
        return this.jsiiGet("vpcId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::SecurityGroup.VpcId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-vpcid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setVpcId(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("vpcId", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface EgressProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSecurityGroup.EgressProperty.IpProtocol`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getIpProtocol();
        /**
         * `CfnSecurityGroup.EgressProperty.CidrIp`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCidrIp();
        /**
         * `CfnSecurityGroup.EgressProperty.CidrIpv6`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCidrIpv6();
        /**
         * `CfnSecurityGroup.EgressProperty.Description`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDescription();
        /**
         * `CfnSecurityGroup.EgressProperty.DestinationPrefixListId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDestinationPrefixListId();
        /**
         * `CfnSecurityGroup.EgressProperty.DestinationSecurityGroupId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDestinationSecurityGroupId();
        /**
         * `CfnSecurityGroup.EgressProperty.FromPort`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getFromPort();
        /**
         * `CfnSecurityGroup.EgressProperty.ToPort`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getToPort();

        /**
         * @return a {@link Builder} of {@link EgressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EgressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _ipProtocol;
            @javax.annotation.Nullable
            private java.lang.String _cidrIp;
            @javax.annotation.Nullable
            private java.lang.String _cidrIpv6;
            @javax.annotation.Nullable
            private java.lang.String _description;
            @javax.annotation.Nullable
            private java.lang.String _destinationPrefixListId;
            @javax.annotation.Nullable
            private java.lang.String _destinationSecurityGroupId;
            @javax.annotation.Nullable
            private java.lang.Number _fromPort;
            @javax.annotation.Nullable
            private java.lang.Number _toPort;

            /**
             * Sets the value of IpProtocol
             * @param value `CfnSecurityGroup.EgressProperty.IpProtocol`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withIpProtocol(final java.lang.String value) {
                this._ipProtocol = java.util.Objects.requireNonNull(value, "ipProtocol is required");
                return this;
            }
            /**
             * Sets the value of CidrIp
             * @param value `CfnSecurityGroup.EgressProperty.CidrIp`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withCidrIp(@javax.annotation.Nullable final java.lang.String value) {
                this._cidrIp = value;
                return this;
            }
            /**
             * Sets the value of CidrIpv6
             * @param value `CfnSecurityGroup.EgressProperty.CidrIpv6`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withCidrIpv6(@javax.annotation.Nullable final java.lang.String value) {
                this._cidrIpv6 = value;
                return this;
            }
            /**
             * Sets the value of Description
             * @param value `CfnSecurityGroup.EgressProperty.Description`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
                this._description = value;
                return this;
            }
            /**
             * Sets the value of DestinationPrefixListId
             * @param value `CfnSecurityGroup.EgressProperty.DestinationPrefixListId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDestinationPrefixListId(@javax.annotation.Nullable final java.lang.String value) {
                this._destinationPrefixListId = value;
                return this;
            }
            /**
             * Sets the value of DestinationSecurityGroupId
             * @param value `CfnSecurityGroup.EgressProperty.DestinationSecurityGroupId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDestinationSecurityGroupId(@javax.annotation.Nullable final java.lang.String value) {
                this._destinationSecurityGroupId = value;
                return this;
            }
            /**
             * Sets the value of FromPort
             * @param value `CfnSecurityGroup.EgressProperty.FromPort`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withFromPort(@javax.annotation.Nullable final java.lang.Number value) {
                this._fromPort = value;
                return this;
            }
            /**
             * Sets the value of ToPort
             * @param value `CfnSecurityGroup.EgressProperty.ToPort`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withToPort(@javax.annotation.Nullable final java.lang.Number value) {
                this._toPort = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EgressProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public EgressProperty build() {
                return new EgressProperty() {
                    private final java.lang.String $ipProtocol = java.util.Objects.requireNonNull(_ipProtocol, "ipProtocol is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $cidrIp = _cidrIp;
                    @javax.annotation.Nullable
                    private final java.lang.String $cidrIpv6 = _cidrIpv6;
                    @javax.annotation.Nullable
                    private final java.lang.String $description = _description;
                    @javax.annotation.Nullable
                    private final java.lang.String $destinationPrefixListId = _destinationPrefixListId;
                    @javax.annotation.Nullable
                    private final java.lang.String $destinationSecurityGroupId = _destinationSecurityGroupId;
                    @javax.annotation.Nullable
                    private final java.lang.Number $fromPort = _fromPort;
                    @javax.annotation.Nullable
                    private final java.lang.Number $toPort = _toPort;

                    @Override
                    public java.lang.String getIpProtocol() {
                        return this.$ipProtocol;
                    }

                    @Override
                    public java.lang.String getCidrIp() {
                        return this.$cidrIp;
                    }

                    @Override
                    public java.lang.String getCidrIpv6() {
                        return this.$cidrIpv6;
                    }

                    @Override
                    public java.lang.String getDescription() {
                        return this.$description;
                    }

                    @Override
                    public java.lang.String getDestinationPrefixListId() {
                        return this.$destinationPrefixListId;
                    }

                    @Override
                    public java.lang.String getDestinationSecurityGroupId() {
                        return this.$destinationSecurityGroupId;
                    }

                    @Override
                    public java.lang.Number getFromPort() {
                        return this.$fromPort;
                    }

                    @Override
                    public java.lang.Number getToPort() {
                        return this.$toPort;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("ipProtocol", om.valueToTree(this.getIpProtocol()));
                        if (this.getCidrIp() != null) {
                            obj.set("cidrIp", om.valueToTree(this.getCidrIp()));
                        }
                        if (this.getCidrIpv6() != null) {
                            obj.set("cidrIpv6", om.valueToTree(this.getCidrIpv6()));
                        }
                        if (this.getDescription() != null) {
                            obj.set("description", om.valueToTree(this.getDescription()));
                        }
                        if (this.getDestinationPrefixListId() != null) {
                            obj.set("destinationPrefixListId", om.valueToTree(this.getDestinationPrefixListId()));
                        }
                        if (this.getDestinationSecurityGroupId() != null) {
                            obj.set("destinationSecurityGroupId", om.valueToTree(this.getDestinationSecurityGroupId()));
                        }
                        if (this.getFromPort() != null) {
                            obj.set("fromPort", om.valueToTree(this.getFromPort()));
                        }
                        if (this.getToPort() != null) {
                            obj.set("toPort", om.valueToTree(this.getToPort()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSecurityGroup.EgressProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSecurityGroup.EgressProperty.IpProtocol`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getIpProtocol() {
                return this.jsiiGet("ipProtocol", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.EgressProperty.CidrIp`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getCidrIp() {
                return this.jsiiGet("cidrIp", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.EgressProperty.CidrIpv6`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getCidrIpv6() {
                return this.jsiiGet("cidrIpv6", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.EgressProperty.Description`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getDescription() {
                return this.jsiiGet("description", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.EgressProperty.DestinationPrefixListId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getDestinationPrefixListId() {
                return this.jsiiGet("destinationPrefixListId", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.EgressProperty.DestinationSecurityGroupId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getDestinationSecurityGroupId() {
                return this.jsiiGet("destinationSecurityGroupId", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.EgressProperty.FromPort`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Number getFromPort() {
                return this.jsiiGet("fromPort", java.lang.Number.class);
            }

            /**
             * `CfnSecurityGroup.EgressProperty.ToPort`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Number getToPort() {
                return this.jsiiGet("toPort", java.lang.Number.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface IngressProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSecurityGroup.IngressProperty.IpProtocol`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getIpProtocol();
        /**
         * `CfnSecurityGroup.IngressProperty.CidrIp`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCidrIp();
        /**
         * `CfnSecurityGroup.IngressProperty.CidrIpv6`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCidrIpv6();
        /**
         * `CfnSecurityGroup.IngressProperty.Description`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDescription();
        /**
         * `CfnSecurityGroup.IngressProperty.FromPort`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getFromPort();
        /**
         * `CfnSecurityGroup.IngressProperty.SourcePrefixListId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-securitygroup-ingress-sourceprefixlistid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSourcePrefixListId();
        /**
         * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSourceSecurityGroupId();
        /**
         * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSourceSecurityGroupName();
        /**
         * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupOwnerId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSourceSecurityGroupOwnerId();
        /**
         * `CfnSecurityGroup.IngressProperty.ToPort`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getToPort();

        /**
         * @return a {@link Builder} of {@link IngressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link IngressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _ipProtocol;
            @javax.annotation.Nullable
            private java.lang.String _cidrIp;
            @javax.annotation.Nullable
            private java.lang.String _cidrIpv6;
            @javax.annotation.Nullable
            private java.lang.String _description;
            @javax.annotation.Nullable
            private java.lang.Number _fromPort;
            @javax.annotation.Nullable
            private java.lang.String _sourcePrefixListId;
            @javax.annotation.Nullable
            private java.lang.String _sourceSecurityGroupId;
            @javax.annotation.Nullable
            private java.lang.String _sourceSecurityGroupName;
            @javax.annotation.Nullable
            private java.lang.String _sourceSecurityGroupOwnerId;
            @javax.annotation.Nullable
            private java.lang.Number _toPort;

            /**
             * Sets the value of IpProtocol
             * @param value `CfnSecurityGroup.IngressProperty.IpProtocol`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withIpProtocol(final java.lang.String value) {
                this._ipProtocol = java.util.Objects.requireNonNull(value, "ipProtocol is required");
                return this;
            }
            /**
             * Sets the value of CidrIp
             * @param value `CfnSecurityGroup.IngressProperty.CidrIp`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withCidrIp(@javax.annotation.Nullable final java.lang.String value) {
                this._cidrIp = value;
                return this;
            }
            /**
             * Sets the value of CidrIpv6
             * @param value `CfnSecurityGroup.IngressProperty.CidrIpv6`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withCidrIpv6(@javax.annotation.Nullable final java.lang.String value) {
                this._cidrIpv6 = value;
                return this;
            }
            /**
             * Sets the value of Description
             * @param value `CfnSecurityGroup.IngressProperty.Description`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
                this._description = value;
                return this;
            }
            /**
             * Sets the value of FromPort
             * @param value `CfnSecurityGroup.IngressProperty.FromPort`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withFromPort(@javax.annotation.Nullable final java.lang.Number value) {
                this._fromPort = value;
                return this;
            }
            /**
             * Sets the value of SourcePrefixListId
             * @param value `CfnSecurityGroup.IngressProperty.SourcePrefixListId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSourcePrefixListId(@javax.annotation.Nullable final java.lang.String value) {
                this._sourcePrefixListId = value;
                return this;
            }
            /**
             * Sets the value of SourceSecurityGroupId
             * @param value `CfnSecurityGroup.IngressProperty.SourceSecurityGroupId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSourceSecurityGroupId(@javax.annotation.Nullable final java.lang.String value) {
                this._sourceSecurityGroupId = value;
                return this;
            }
            /**
             * Sets the value of SourceSecurityGroupName
             * @param value `CfnSecurityGroup.IngressProperty.SourceSecurityGroupName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSourceSecurityGroupName(@javax.annotation.Nullable final java.lang.String value) {
                this._sourceSecurityGroupName = value;
                return this;
            }
            /**
             * Sets the value of SourceSecurityGroupOwnerId
             * @param value `CfnSecurityGroup.IngressProperty.SourceSecurityGroupOwnerId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSourceSecurityGroupOwnerId(@javax.annotation.Nullable final java.lang.String value) {
                this._sourceSecurityGroupOwnerId = value;
                return this;
            }
            /**
             * Sets the value of ToPort
             * @param value `CfnSecurityGroup.IngressProperty.ToPort`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withToPort(@javax.annotation.Nullable final java.lang.Number value) {
                this._toPort = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IngressProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public IngressProperty build() {
                return new IngressProperty() {
                    private final java.lang.String $ipProtocol = java.util.Objects.requireNonNull(_ipProtocol, "ipProtocol is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $cidrIp = _cidrIp;
                    @javax.annotation.Nullable
                    private final java.lang.String $cidrIpv6 = _cidrIpv6;
                    @javax.annotation.Nullable
                    private final java.lang.String $description = _description;
                    @javax.annotation.Nullable
                    private final java.lang.Number $fromPort = _fromPort;
                    @javax.annotation.Nullable
                    private final java.lang.String $sourcePrefixListId = _sourcePrefixListId;
                    @javax.annotation.Nullable
                    private final java.lang.String $sourceSecurityGroupId = _sourceSecurityGroupId;
                    @javax.annotation.Nullable
                    private final java.lang.String $sourceSecurityGroupName = _sourceSecurityGroupName;
                    @javax.annotation.Nullable
                    private final java.lang.String $sourceSecurityGroupOwnerId = _sourceSecurityGroupOwnerId;
                    @javax.annotation.Nullable
                    private final java.lang.Number $toPort = _toPort;

                    @Override
                    public java.lang.String getIpProtocol() {
                        return this.$ipProtocol;
                    }

                    @Override
                    public java.lang.String getCidrIp() {
                        return this.$cidrIp;
                    }

                    @Override
                    public java.lang.String getCidrIpv6() {
                        return this.$cidrIpv6;
                    }

                    @Override
                    public java.lang.String getDescription() {
                        return this.$description;
                    }

                    @Override
                    public java.lang.Number getFromPort() {
                        return this.$fromPort;
                    }

                    @Override
                    public java.lang.String getSourcePrefixListId() {
                        return this.$sourcePrefixListId;
                    }

                    @Override
                    public java.lang.String getSourceSecurityGroupId() {
                        return this.$sourceSecurityGroupId;
                    }

                    @Override
                    public java.lang.String getSourceSecurityGroupName() {
                        return this.$sourceSecurityGroupName;
                    }

                    @Override
                    public java.lang.String getSourceSecurityGroupOwnerId() {
                        return this.$sourceSecurityGroupOwnerId;
                    }

                    @Override
                    public java.lang.Number getToPort() {
                        return this.$toPort;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("ipProtocol", om.valueToTree(this.getIpProtocol()));
                        if (this.getCidrIp() != null) {
                            obj.set("cidrIp", om.valueToTree(this.getCidrIp()));
                        }
                        if (this.getCidrIpv6() != null) {
                            obj.set("cidrIpv6", om.valueToTree(this.getCidrIpv6()));
                        }
                        if (this.getDescription() != null) {
                            obj.set("description", om.valueToTree(this.getDescription()));
                        }
                        if (this.getFromPort() != null) {
                            obj.set("fromPort", om.valueToTree(this.getFromPort()));
                        }
                        if (this.getSourcePrefixListId() != null) {
                            obj.set("sourcePrefixListId", om.valueToTree(this.getSourcePrefixListId()));
                        }
                        if (this.getSourceSecurityGroupId() != null) {
                            obj.set("sourceSecurityGroupId", om.valueToTree(this.getSourceSecurityGroupId()));
                        }
                        if (this.getSourceSecurityGroupName() != null) {
                            obj.set("sourceSecurityGroupName", om.valueToTree(this.getSourceSecurityGroupName()));
                        }
                        if (this.getSourceSecurityGroupOwnerId() != null) {
                            obj.set("sourceSecurityGroupOwnerId", om.valueToTree(this.getSourceSecurityGroupOwnerId()));
                        }
                        if (this.getToPort() != null) {
                            obj.set("toPort", om.valueToTree(this.getToPort()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSecurityGroup.IngressProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.IpProtocol`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getIpProtocol() {
                return this.jsiiGet("ipProtocol", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.CidrIp`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getCidrIp() {
                return this.jsiiGet("cidrIp", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.CidrIpv6`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getCidrIpv6() {
                return this.jsiiGet("cidrIpv6", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.Description`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getDescription() {
                return this.jsiiGet("description", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.FromPort`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Number getFromPort() {
                return this.jsiiGet("fromPort", java.lang.Number.class);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.SourcePrefixListId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-securitygroup-ingress-sourceprefixlistid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getSourcePrefixListId() {
                return this.jsiiGet("sourcePrefixListId", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getSourceSecurityGroupId() {
                return this.jsiiGet("sourceSecurityGroupId", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getSourceSecurityGroupName() {
                return this.jsiiGet("sourceSecurityGroupName", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupOwnerId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getSourceSecurityGroupOwnerId() {
                return this.jsiiGet("sourceSecurityGroupOwnerId", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.ToPort`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Number getToPort() {
                return this.jsiiGet("toPort", java.lang.Number.class);
            }
        }
    }
}
