package software.amazon.awscdk.services.ec2;

/**
 * Construction properties for an InterfaceVpcEndpoint.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.2 (build e881f16)", date = "2019-07-19T19:06:47.599Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InterfaceVpcEndpointProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ec2.InterfaceVpcEndpointOptions {
    /**
     * The VPC network in which the interface endpoint will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * @return a {@link Builder} of {@link InterfaceVpcEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link InterfaceVpcEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.ec2.IVpc _vpc;
        private software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService _service;
        @javax.annotation.Nullable
        private java.lang.Boolean _privateDnsEnabled;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.SubnetSelection _subnets;

        /**
         * Sets the value of Vpc
         * @param value The VPC network in which the interface endpoint will be used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withVpc(final software.amazon.awscdk.services.ec2.IVpc value) {
            this._vpc = java.util.Objects.requireNonNull(value, "vpc is required");
            return this;
        }
        /**
         * Sets the value of Service
         * @param value The service to use for this interface VPC endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withService(final software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService value) {
            this._service = java.util.Objects.requireNonNull(value, "service is required");
            return this;
        }
        /**
         * Sets the value of PrivateDnsEnabled
         * @param value Whether to associate a private hosted zone with the specified VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPrivateDnsEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._privateDnsEnabled = value;
            return this;
        }
        /**
         * Sets the value of Subnets
         * @param value The subnets in which to create an endpoint network interface.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withSubnets(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.SubnetSelection value) {
            this._subnets = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InterfaceVpcEndpointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public InterfaceVpcEndpointProps build() {
            return new InterfaceVpcEndpointProps() {
                private final software.amazon.awscdk.services.ec2.IVpc $vpc = java.util.Objects.requireNonNull(_vpc, "vpc is required");
                private final software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService $service = java.util.Objects.requireNonNull(_service, "service is required");
                @javax.annotation.Nullable
                private final java.lang.Boolean $privateDnsEnabled = _privateDnsEnabled;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.SubnetSelection $subnets = _subnets;

                @Override
                public software.amazon.awscdk.services.ec2.IVpc getVpc() {
                    return this.$vpc;
                }

                @Override
                public software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService getService() {
                    return this.$service;
                }

                @Override
                public java.lang.Boolean getPrivateDnsEnabled() {
                    return this.$privateDnsEnabled;
                }

                @Override
                public software.amazon.awscdk.services.ec2.SubnetSelection getSubnets() {
                    return this.$subnets;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("vpc", om.valueToTree(this.getVpc()));
                    obj.set("service", om.valueToTree(this.getService()));
                    if (this.getPrivateDnsEnabled() != null) {
                        obj.set("privateDnsEnabled", om.valueToTree(this.getPrivateDnsEnabled()));
                    }
                    if (this.getSubnets() != null) {
                        obj.set("subnets", om.valueToTree(this.getSubnets()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.InterfaceVpcEndpointProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The VPC network in which the interface endpoint will be used.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
        }

        /**
         * The service to use for this interface VPC endpoint.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService getService() {
            return this.jsiiGet("service", software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService.class);
        }

        /**
         * Whether to associate a private hosted zone with the specified VPC.
         * 
         * This
         * allows you to make requests to the service using its default DNS hostname.
         * 
         * Default: true
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getPrivateDnsEnabled() {
            return this.jsiiGet("privateDnsEnabled", java.lang.Boolean.class);
        }

        /**
         * The subnets in which to create an endpoint network interface.
         * 
         * At most one
         * per availability zone.
         * 
         * Default: private subnets
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.SubnetSelection getSubnets() {
            return this.jsiiGet("subnets", software.amazon.awscdk.services.ec2.SubnetSelection.class);
        }
    }
}
