/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.ec2.;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.IVpnConnection;
import software.amazon.awscdk.services.ec2.VpnConnectionProps;
import software.amazon.awscdk.services.ec2.VpnTunnelOption;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.VpnConnection")
public class VpnConnection
extends Resource
implements IVpnConnection {
    protected VpnConnection(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VpnConnection(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public VpnConnection(@NotNull Construct scope, @NotNull String id, @NotNull VpnConnectionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static Metric metricAll(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)JsiiObject.jsiiStaticCall(VpnConnection.class, (String)"metricAll", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @NotNull
    public static Metric metricAll(@NotNull String metricName) {
        return (Metric)JsiiObject.jsiiStaticCall(VpnConnection.class, (String)"metricAll", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @NotNull
    public static Metric metricAllTunnelDataIn(@Nullable MetricOptions props) {
        return (Metric)JsiiObject.jsiiStaticCall(VpnConnection.class, (String)"metricAllTunnelDataIn", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public static Metric metricAllTunnelDataIn() {
        return (Metric)JsiiObject.jsiiStaticCall(VpnConnection.class, (String)"metricAllTunnelDataIn", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public static Metric metricAllTunnelDataOut(@Nullable MetricOptions props) {
        return (Metric)JsiiObject.jsiiStaticCall(VpnConnection.class, (String)"metricAllTunnelDataOut", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public static Metric metricAllTunnelDataOut() {
        return (Metric)JsiiObject.jsiiStaticCall(VpnConnection.class, (String)"metricAllTunnelDataOut", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public static Metric metricAllTunnelState(@Nullable MetricOptions props) {
        return (Metric)JsiiObject.jsiiStaticCall(VpnConnection.class, (String)"metricAllTunnelState", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public static Metric metricAllTunnelState() {
        return (Metric)JsiiObject.jsiiStaticCall(VpnConnection.class, (String)"metricAllTunnelState", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @Override
    @NotNull
    public Metric metricTunnelDataIn(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricTunnelDataIn", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricTunnelDataIn() {
        return (Metric)Kernel.call((Object)this, (String)"metricTunnelDataIn", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricTunnelDataOut(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricTunnelDataOut", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricTunnelDataOut() {
        return (Metric)Kernel.call((Object)this, (String)"metricTunnelDataOut", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricTunnelState(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricTunnelState", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricTunnelState() {
        return (Metric)Kernel.call((Object)this, (String)"metricTunnelState", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Number getCustomerGatewayAsn() {
        return (Number)Kernel.get((Object)this, (String)"customerGatewayAsn", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @NotNull
    public String getCustomerGatewayId() {
        return (String)Kernel.get((Object)this, (String)"customerGatewayId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getCustomerGatewayIp() {
        return (String)Kernel.get((Object)this, (String)"customerGatewayIp", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getVpnId() {
        return (String)Kernel.get((Object)this, (String)"vpnId", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<VpnConnection> {
        private final Construct scope;
        private final String id;
        private final VpnConnectionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new VpnConnectionProps.Builder();
        }

        public Builder ip(String ip) {
            this.props.ip(ip);
            return this;
        }

        public Builder asn(Number asn) {
            this.props.asn(asn);
            return this;
        }

        public Builder staticRoutes(List<String> staticRoutes) {
            this.props.staticRoutes(staticRoutes);
            return this;
        }

        public Builder tunnelOptions(List<? extends VpnTunnelOption> tunnelOptions) {
            this.props.tunnelOptions(tunnelOptions);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public VpnConnection build() {
            return new VpnConnection(this.scope, this.id, this.props.build());
        }
    }
}

